/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;

public class FolderLock {
    public static boolean debug = false;
    private File folder;
    private File file;
    private FileLock lock;
    private int count = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FolderLock(File f) {
        while (!f.isDirectory()) {
            f = f.getAbsoluteFile().getParentFile();
        }
        try {
            this.folder = f.getCanonicalFile();
        }
        catch (IOException ex) {
            this.folder = f;
        }
        this.file = new File(f, ".lock");
        if (!this.file.exists()) {
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(this.file);
            }
            catch (FileNotFoundException ex) {
                System.err.println("cannot create lock file " + this.file + ": " + ex);
            }
            finally {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public File getFolder() {
        return this.folder;
    }

    public synchronized boolean lock() {
        if (this.count > 0) {
            ++this.count;
            return true;
        }
        try {
            RandomAccessFile ra = new RandomAccessFile(this.file, "rw");
            this.lock = ra.getChannel().lock();
            ++this.count;
            if (debug) {
                System.out.println("%%% got folder lock " + this.file);
            }
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public synchronized void releaseLock() {
        block6: {
            if (this.count <= 0) {
                return;
            }
            --this.count;
            if (this.count > 0) {
                return;
            }
            if (this.lock != null) {
                try {
                    this.lock.release();
                    this.lock.channel().close();
                    this.lock = null;
                    if (debug) {
                        System.out.println("%%% released folder lock " + this.file);
                    }
                }
                catch (IOException ex) {
                    if (!debug) break block6;
                    System.out.println("%%% released folder lock " + this.file + " failed: " + ex);
                }
            }
        }
    }
}

