/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.io;

import com.mandelsoft.io.AbstractFile;
import com.mandelsoft.io.AbstractFileSupport;
import com.mandelsoft.util.Utils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;

public class URLAbstractFile
extends AbstractFileSupport {
    private Proxy proxy;
    private URL url;
    private URLConnection connection;

    public URLAbstractFile(Proxy proxy, URL url) {
        this(proxy, url, 0L);
    }

    public URLAbstractFile(Proxy proxy, URL url, long lastModified) {
        super(lastModified);
        this.proxy = proxy;
        this.url = url;
    }

    public boolean isFile() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URLConnection getConnection() {
        if (this.connection == null && this.url != null) {
            try {
                this.connection = this.proxy == null ? this.url.openConnection() : this.url.openConnection(this.proxy);
                if (this.connection != null) {
                    this.lastModified = this.connection.getLastModified();
                }
            }
            catch (IOException ex) {
                System.err.println("cannot open connection " + this.url);
            }
        }
        try {
            URLConnection uRLConnection = this.connection;
            return uRLConnection;
        }
        finally {
            this.connection = null;
        }
    }

    protected long _getLastModified() {
        this.connection = this.getConnection();
        return this.lastModified;
    }

    public InputStream getInputStream() throws IOException {
        return this.getConnection().getInputStream();
    }

    public AbstractFile getParent() {
        try {
            return new URLAbstractFile(this.getProxy(), Utils.parentURL(this.getURL()));
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    public AbstractFile getSub(String name) {
        try {
            return new URLAbstractFile(this.getProxy(), Utils.subURL(this.getURL(), name));
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    public URL getURL() {
        return this.url;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public File getFile() {
        throw new UnsupportedOperationException("Not supported.");
    }

    public String getPath() {
        return this.url.getPath();
    }

    public String getName() {
        return new File(this.url.getPath()).getName();
    }

    public boolean lock() {
        throw new UnsupportedOperationException("Not supported.");
    }

    public boolean tryLock() {
        throw new UnsupportedOperationException("Not supported.");
    }

    public void releaseLock() throws IOException {
        throw new UnsupportedOperationException("Not supported.");
    }

    public String toString() {
        return this.url.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        URLAbstractFile other = (URLAbstractFile)obj;
        return this.url == other.url || this.url != null && this.url.equals(other.url);
    }

    public int hashCode() {
        int hash = 7;
        hash = 17 * hash + (this.url != null ? this.url.hashCode() : 0);
        return hash;
    }
}

