/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand;

import com.mandelsoft.mand.MandelImageDBContext;
import com.mandelsoft.mand.MandelName;
import java.io.File;

public final class AbsoluteMandelName {
    private MandelImageDBContext context;
    private String sectionName;
    private AbsoluteMandelName parent;

    AbsoluteMandelName(MandelImageDBContext context, String sectionName, AbsoluteMandelName parent) {
        this.context = context;
        this.sectionName = sectionName;
        this.parent = parent;
    }

    public String toString() {
        return this.context.getMandelName(this).getName();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbsoluteMandelName other = (AbsoluteMandelName)obj;
        if (!(this.context == other.context || this.context != null && this.context.equals(other.context))) {
            return false;
        }
        if (this.sectionName == null ? other.sectionName != null : !this.sectionName.equals(other.sectionName)) {
            return false;
        }
        return this.parent == other.parent || this.parent != null && this.parent.equals(other.parent);
    }

    public int hashCode() {
        int hash = 7;
        hash = 53 * hash + (this.context != null ? this.context.hashCode() : 0);
        hash = 53 * hash + (this.sectionName != null ? this.sectionName.hashCode() : 0);
        hash = 53 * hash + (this.parent != null ? this.parent.hashCode() : 0);
        return hash;
    }

    public static AbsoluteMandelName createAbsoluteMandelName(MandelName name, MandelImageDBContext context) {
        int ix;
        AbsoluteMandelName amn = null;
        String n = name.getName();
        while (n.length() > 0 && (ix = n.indexOf(64)) > 0) {
            String label;
            String section = n.substring(0, ix);
            int is = n.indexOf(126);
            if (is > 0) {
                label = n.substring(ix + 1, is);
                n = n.substring(is + 1);
            } else {
                label = n.substring(ix + 1);
                n = "";
            }
            MandelImageDBContext ctx = context.getContext(label);
            if (ctx == null) {
                throw new IllegalArgumentException("illegal mandel name: unknown label " + label);
            }
            amn = new AbsoluteMandelName(ctx, section, amn);
        }
        if (n.length() > 0) {
            amn = new AbsoluteMandelName(context, n, amn);
        }
        return amn;
    }

    private static void evaluate(StringBuilder sb, AbsoluteMandelName amn, MandelImageDBContext context, boolean local) {
        if (amn.parent != null) {
            AbsoluteMandelName.evaluate(sb, amn.parent, context, false);
            sb.append('~');
        }
        sb.append(amn.sectionName);
        MandelImageDBContext ctx = amn.context;
        if (ctx == context) {
            if (!local) {
                throw new IllegalArgumentException("illegal absolute mandel name: intermediate usage of outer mandel image db");
            }
        } else {
            String label = context.getLabel(ctx);
            if (label == null) {
                throw new IllegalArgumentException("illegal absolute mandel name: intermediate image db not part of outer mandel image db");
            }
            sb.append('@');
            sb.append(label);
        }
    }

    public static MandelName getMandelName(AbsoluteMandelName amn, MandelImageDBContext context) {
        StringBuilder sb = new StringBuilder();
        AbsoluteMandelName.evaluate(sb, amn, context, true);
        return MandelName.create(sb.toString());
    }

    public static void main(String[] args) {
        MandelImageDBContext local = new MandelImageDBContext(new File("."));
        MandelImageDBContext tmp = new MandelImageDBContext(new File("root"));
        local.addContext(tmp, "root");
        tmp = new MandelImageDBContext(new File("ctx1"));
        local.addContext(tmp, "ctx1");
        tmp = new MandelImageDBContext(new File("ctx2"));
        local.addContext(tmp, "ctx2");
        MandelName n = MandelName.create("abc@ctx1~efg@ctx2~abc");
        System.out.println("mandel name: " + n);
        AbsoluteMandelName amn = AbsoluteMandelName.createAbsoluteMandelName(n, local);
        System.out.println("back mapper: " + AbsoluteMandelName.getMandelName(amn, local));
    }
}

