/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand;

import com.mandelsoft.io.AbstractFile;
import com.mandelsoft.mand.ColormapName;
import com.mandelsoft.mand.MandelConstants;
import com.mandelsoft.mand.MandelData;
import com.mandelsoft.mand.MandelInfo;
import com.mandelsoft.mand.MandelName;
import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.Settings;
import com.mandelsoft.mand.cm.Colormap;
import com.mandelsoft.mand.cm.ColormapModel;
import com.mandelsoft.mand.image.MandelAreaImage;
import com.mandelsoft.mand.image.MandelImage;
import com.mandelsoft.mand.mapping.Mapper;
import com.mandelsoft.mand.scan.FilteredMandelScanner;
import com.mandelsoft.mand.scan.MandelFolder;
import com.mandelsoft.mand.scan.MandelHandle;
import com.mandelsoft.mand.scan.MandelScanner;
import com.mandelsoft.mand.scan.MandelScannerCache;
import com.mandelsoft.mand.scan.MandelScannerProxy;
import com.mandelsoft.mand.scan.MandelScannerUtils;
import com.mandelsoft.mand.scan.PathMandelScanner;
import com.mandelsoft.mand.util.ColorList;
import com.mandelsoft.mand.util.ColormapList;
import com.mandelsoft.mand.util.DeltaMandelList;
import com.mandelsoft.mand.util.FileColorList;
import com.mandelsoft.mand.util.FileMandelList;
import com.mandelsoft.mand.util.FileMandelListFolderTree;
import com.mandelsoft.mand.util.FileTagList;
import com.mandelsoft.mand.util.MandUtils;
import com.mandelsoft.mand.util.MandelList;
import com.mandelsoft.mand.util.MandelListFolderTree;
import com.mandelsoft.mand.util.MemoryMandelListFolderTree;
import com.mandelsoft.mand.util.ScannerColormapList;
import com.mandelsoft.mand.util.TagList;
import com.mandelsoft.mand.util.UniqueArrayMandelList;
import com.mandelsoft.util.Utils;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Environment0
implements MandelConstants {
    public static boolean debug = false;
    private boolean readonly;
    private MandelImage.Factory fac;
    private Settings settings;
    private String copyright;
    private PathMandelScanner all;
    private MandelScanner imagedata;
    private MandelScanner raster;
    private MandelScanner info;
    private MandelScanner prioinfo;
    private MandelScanner meta;
    private MandelScanner rasterimage;
    private MandelScanner autoimagedata;
    private MandelScanner autometa;
    private MandelScanner colormaps;
    private MandelScanner newraster;
    private QualifiedMandelName initialName;
    private File initialFile;
    private ColorList colors;
    private TagList tags;
    private Colormap defcolormap;
    private MandelListFolderTree memory;
    private MandelList favorites;
    private MandelListFolderTree tfavorites;
    private MandelList todos;
    private MandelListFolderTree ttodos;
    private MandelList newrasters;
    private MandelList areas;
    private MandelList seenrasters;
    private MandelList unseenrasters;
    private MandelList variants;
    private MandelList leafs;
    private MandelList pending;
    private ColormapList colormaplist;
    private List<MandelListFolderTree> userlists;
    private boolean autoRescan = true;
    private Proxy proxy = null;
    private MandelScannerCache scannercache;

    public Environment0(String tool, String[] args) {
        this(tool, args, new File("."));
    }

    public Environment0(String[] args) {
        this(args, new File("."));
    }

    public Environment0(String[] args, File dir) {
        this(null, args, dir);
    }

    public Environment0(String tool, String[] args, File dir) {
        String path = null;
        String cpath = null;
        String npath = null;
        if (args == null || args.length < 1) {
            this.initialName = new QualifiedMandelName(MandelName.ROOT);
        } else {
            File f = new File(args[0]);
            if (f.exists() && !f.isDirectory()) {
                this.initialFile = f;
            } else {
                this.initialName = QualifiedMandelName.create(f);
            }
        }
        this.fac = new MandelImage.Factory();
        try {
            int ix;
            this.settings = Settings.getSettings(dir);
            this.autoRescan = this.settings.getSwitch("autorescan", true);
            String p = this.settings.getProperty("proxy");
            if (p != null && (ix = p.indexOf(":")) > 0) {
                String host = p.substring(0, ix);
                int port = Integer.parseInt(p.substring(ix + 1));
                this.proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, port));
            }
            path = this.settings.getProperty("path");
            cpath = this.settings.getProperty("path.colormap");
            npath = this.settings.getProperty("path.raster.save");
            if (tool != null) {
                p = this.settings.getProperty(tool + "." + "path");
                if (p != null) {
                    path = path + ";" + p;
                }
                if ((p = this.settings.getProperty(tool + "." + "path.colormap")) != null) {
                    cpath = cpath + ";" + p;
                }
                if ((p = this.settings.getProperty(tool + "." + "path.raster.save")) != null) {
                    npath = p;
                }
            }
        }
        catch (IOException ex) {
            System.err.println("cannot read mandel settings");
        }
        this.scannercache = new MandelScannerCache(this.proxy);
        this.all = new PathMandelScanner(path, MandelScanner.ALL, this.settings.isLocal(), this.scannercache);
        this.imagedata = new FilteredMandelScanner(this.all, MandelScanner.HAS_IMAGEDATA);
        this.autoimagedata = new AutoScanner(this.imagedata);
        this.raster = new FilteredMandelScanner(this.all, MandelScanner.RASTER);
        this.info = new FilteredMandelScanner(this.all, MandelScanner.INFO);
        this.meta = new FilteredMandelScanner(this.all, MandelScanner.HAS_INFO);
        this.autometa = new AutoScanner(this.meta);
        this.rasterimage = new FilteredMandelScanner(this.all, MandelScanner.RASTERIMAGE);
        this.colormaps = new PathMandelScanner(cpath, MandelScanner.COLORMAP, this.settings.isLocal(), this.scannercache);
        this.prioinfo = new PathMandelScanner(this.settings.getProperty("path.info.prio"), MandelScanner.INFO, this.settings.isLocal(), this.scannercache);
        this.newraster = new PathMandelScanner(npath, MandelScanner.RASTER, this.settings.isLocal(), this.scannercache);
        this.ttodos = this.createMandelListFolderTree("todo");
        this.todos = this.ttodos.getRoot().getMandelList();
        System.out.println("seen areas");
        this.seenrasters = this.createMandelList("seen");
        System.out.println("new");
        this.newrasters = new NewRasterList();
        if (this.seenrasters != null) {
            System.out.println("unseen");
            this.unseenrasters = new DeltaMandelList(this.autoimagedata, this.seenrasters);
        }
        System.out.println("common");
        this.commonSetup();
    }

    public Environment0(String tool, String[] args, URL dir) {
        String path = null;
        String cpath = null;
        this.readonly = true;
        this.initialName = args == null || args.length < 1 ? new QualifiedMandelName(MandelName.ROOT) : QualifiedMandelName.create(dir.getPath());
        this.fac = new MandelImage.Factory();
        try {
            int ix;
            this.settings = Settings.getSettings(AbstractFile.Factory.create(null, dir));
            this.autoRescan = this.settings.getSwitch("autorescan", true);
            String p = this.settings.getProperty("proxy");
            if (!Utils.isEmpty(p) && (ix = p.indexOf(":")) > 0) {
                String host = p.substring(0, ix);
                int port = Integer.parseInt(p.substring(ix + 1));
                this.proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, port));
            }
            path = this.settings.getProperty("path");
            cpath = this.settings.getProperty("path.colormap");
            if (tool != null) {
                p = this.settings.getProperty(tool + "." + "path");
                if (p != null) {
                    path = path + ";" + p;
                }
                if ((p = this.settings.getProperty(tool + "." + "path.colormap")) != null) {
                    cpath = cpath + ";" + p;
                }
            }
        }
        catch (IOException ex) {
            System.err.println("cannot read mandel settings");
        }
        this.scannercache = new MandelScannerCache(this.proxy);
        this.all = new PathMandelScanner(path, MandelScanner.ALL, this.settings.isLocal(), this.scannercache);
        this.imagedata = new FilteredMandelScanner(this.all, MandelScanner.HAS_IMAGEDATA);
        this.autoimagedata = new AutoScanner(this.imagedata);
        this.raster = new FilteredMandelScanner(this.all, MandelScanner.RASTER);
        this.info = new FilteredMandelScanner(this.all, MandelScanner.INFO);
        this.meta = new FilteredMandelScanner(this.all, MandelScanner.HAS_INFO);
        this.autometa = new AutoScanner(this.meta);
        this.rasterimage = new FilteredMandelScanner(this.all, MandelScanner.RASTERIMAGE);
        this.colormaps = new PathMandelScanner(cpath, MandelScanner.COLORMAP, this.settings.isLocal(), this.scannercache);
        this.prioinfo = new PathMandelScanner(this.settings.getProperty("path.info.prio"), MandelScanner.INFO, this.settings.isLocal(), this.scannercache);
        this.commonSetup();
    }

    public String getCopyright(MandelInfo info) {
        return this.getCopyright(info.getCreator(), info.getSite());
    }

    public String getCopyright(String creator, String site) {
        String c = creator;
        if (Utils.isEmpty(c)) {
            c = site;
        }
        c = Utils.isEmpty(c) ? this.copyright : "by " + c;
        return c;
    }

    protected final void commonSetup() {
        this.copyright = this.settings.getProperty("copyright");
        if (this.copyright != null && this.copyright.equals("")) {
            this.copyright = this.getCopyright(this.settings.getProperty("username"), this.settings.getProperty("sitename"));
        }
        System.out.println("variants");
        this.variants = new VariantImageList();
        System.out.println("leafs");
        this.leafs = new LeafImageList();
        System.out.println("pending");
        this.pending = new PendingImageList();
        this.areas = this.createMandelList("areas");
        this.colors = this.createColorList("colors");
        this.tags = this.createTagList("tags");
        this.tfavorites = this.createMandelListFolderTree("favorites");
        this.favorites = this.tfavorites.getRoot().getMandelList();
        this.memory = new MemoryMandelListFolderTree("memory");
        this.colormaplist = new ScannerColormapList(this.getColormapScanner());
        String cmname = this.settings.getProperty("colormap.default");
        System.out.println("default colormap property: " + cmname);
        if (cmname != null && this.colormaplist != null) {
            try {
                this.defcolormap = this.colormaplist.get(new ColormapName(cmname));
                if (this.defcolormap == null) {
                    System.err.println("colormap " + cmname + " not found");
                }
            }
            catch (IOException io) {
                System.err.println("cannot read colormap " + cmname);
            }
        } else {
            System.out.println("no default colormap");
        }
        this.userlists = new ArrayList<MandelListFolderTree>();
        this.addUserLists(this.settings.getProperty("path.lists"));
    }

    private void addUserLists(String path) {
        if (path != null) {
            HashSet<String> elements = new HashSet<String>();
            System.out.println("found userlists: " + path);
            StringTokenizer t = new StringTokenizer(path, ";");
            while (t.hasMoreTokens()) {
                String p = t.nextToken().trim();
                if (p.equals("") || elements.contains(p)) continue;
                elements.add(p);
                this.userlists.add(this.createMandelListFolderTreeFor(p));
            }
        } else {
            System.out.println("no userlists found");
        }
    }

    public AbstractFile createMandelFile(String path) {
        return AbstractFile.Factory.create(path, this.proxy, this.settings.isLocal());
    }

    public final MandelList createMandelList(String prop) {
        String path = this.settings.getProperty(prop);
        if (Utils.isEmpty(path)) {
            return null;
        }
        AbstractFile mf = this.createMandelFile(path);
        return new FileMandelList(mf);
    }

    public final MandelListFolderTree createMandelListFolderTree(String prop) {
        String path = this.settings.getProperty(prop);
        if (Utils.isEmpty(path)) {
            return null;
        }
        return this.createMandelListFolderTreeFor(path);
    }

    public final MandelListFolderTree createMandelListFolderTreeFor(String path) {
        try {
            AbstractFile mf = this.createMandelFile(path);
            return new FileMandelListFolderTree(mf);
        }
        catch (Exception ex) {
            System.err.println("cannot get folder tree " + path + ": " + ex);
            return null;
        }
    }

    public final ColorList createColorList(String prop) {
        String path = this.settings.getProperty(prop);
        Object list = null;
        if (Utils.isEmpty(path)) {
            return null;
        }
        AbstractFile f = AbstractFile.Factory.create(path, this.proxy, this.settings.isLocal());
        return new FileColorList(f);
    }

    public final TagList createTagList(String prop) {
        String path = this.settings.getProperty(prop);
        Object list = null;
        if (Utils.isEmpty(path)) {
            return null;
        }
        AbstractFile f = AbstractFile.Factory.create(path, this.proxy, this.settings.isLocal());
        return new FileTagList(f);
    }

    public boolean isReadonly(String label) {
        if (label == null) {
            return this.isReadonly();
        }
        return true;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public boolean isAutoRescan() {
        return this.autoRescan;
    }

    public void setAutoRescan(boolean b) {
        this.autoRescan = b;
    }

    public void refresh(MandelList list) {
        boolean save = this.autoRescan;
        this.autoRescan = true;
        list.refresh(false);
        this.autoRescan = save;
    }

    public void autoRescan() {
        if (this.isAutoRescan()) {
            this.rescan();
        }
    }

    public void autoRescan(boolean verbose) {
        if (this.isAutoRescan()) {
            this.rescan(verbose);
        }
    }

    public void rescan() {
        this.rescan(false);
    }

    public void rescan(boolean verbose) {
        System.out.println("RESCAN FileSystem");
        this.all.rescan(verbose);
    }

    public String getCopyright() {
        return this.copyright;
    }

    public QualifiedMandelName getInitialName() {
        return this.initialName;
    }

    public File getInitialFile() {
        return this.initialFile;
    }

    public ColorList getColors() {
        return this.colors;
    }

    public TagList getTags() {
        return this.tags;
    }

    public Colormap getDefaultColormap() {
        return this.defcolormap;
    }

    public MandelListFolderTree getFavorites() {
        return this.tfavorites;
    }

    public MandelListFolderTree getMemory() {
        return this.memory;
    }

    public MandelList getMainFavorites() {
        return this.favorites;
    }

    public MandelListFolderTree getTodos() {
        return this.ttodos;
    }

    public MandelList getMainTodos() {
        return this.todos;
    }

    public MandelList getNewRasters() {
        return this.newrasters;
    }

    public MandelList getAreas() {
        return this.areas;
    }

    public MandelList getSeenRasters() {
        return this.seenrasters;
    }

    public MandelList getUnseenRasters() {
        return this.unseenrasters;
    }

    public MandelList getVariants() {
        return this.variants;
    }

    public MandelList getLeafs() {
        return this.leafs;
    }

    public MandelList getPending() {
        return this.pending;
    }

    public List<MandelListFolderTree> getUserLists() {
        return Collections.unmodifiableList(this.userlists);
    }

    public ColormapList getColormaps() {
        return this.colormaplist;
    }

    public MandelScanner getAllScanner() {
        return this.all;
    }

    public MandelScanner getColormapScanner() {
        return this.colormaps;
    }

    public MandelScanner getNewRasterScanner() {
        return this.newraster;
    }

    public MandelScanner getInfoScanner() {
        return this.info;
    }

    public MandelScanner getPrioInfoScanner() {
        return this.prioinfo;
    }

    public MandelScanner getMetaScanner() {
        return this.meta;
    }

    public MandelScanner getAutoMetaScanner() {
        return this.autometa;
    }

    public MandelScanner getImageDataScanner() {
        return this.imagedata;
    }

    public MandelScanner getAutoImageDataScanner() {
        return this.autoimagedata;
    }

    public MandelScanner getRasterImageScanner() {
        return this.rasterimage;
    }

    public MandelScanner getRasterScanner() {
        return this.raster;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public String getProperty(String name) {
        return this.settings.getProperty(name);
    }

    public MandelImage.Factory getFactory() {
        return this.fac;
    }

    public Set<MandelName> getSubNames(MandelName n, MandelScanner scan) {
        HashSet<MandelName> set = new HashSet<MandelName>();
        for (MandelName s = n.sub(); s != null; s = s.next()) {
            if (scan.getMandelHandles(s).isEmpty()) continue;
            set.add(s);
        }
        return set;
    }

    public boolean hasSubNames(MandelName n, MandelScanner scan) {
        for (MandelName s = n.sub(); s != null; s = s.next()) {
            if (scan.getMandelHandles(s).isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean hasSubNames(MandelName n, MandelScanner scan, MandelScanner.Filter f) {
        for (MandelName s = n.sub(); s != null; s = s.next()) {
            Set<MandelHandle> set = scan.getMandelHandles(s);
            if (!MandelScannerUtils.hasAtLeastOne(set, f)) continue;
            return true;
        }
        return false;
    }

    public MandelHandle getMandelImageData(MandelName name) {
        QualifiedMandelName qn = new QualifiedMandelName(name);
        MandelHandle h = this.getImageDataScanner().getMandelData(qn);
        if (h == null) {
            h = this.getImageDataScanner().getMandelData(name);
        }
        return h;
    }

    public MandelHandle getMandelImageData(QualifiedMandelName name) {
        return this.getImageDataScanner().getMandelData(name);
    }

    public MandelAreaImage getMandelImage(MandelName name) throws IOException {
        return this.getMandelImage(name, ColormapModel.ResizeMode.RESIZE_PROPORTIONAL, null);
    }

    public MandelAreaImage getMandelImage(MandelName name, ColormapModel cm) throws IOException {
        return this.getMandelImage(name, cm, null);
    }

    public MandelAreaImage getMandelImage(MandelName name, ColormapModel.ResizeMode mode, Colormap cm) throws IOException {
        return this.getMandelImage(name, mode, cm, null);
    }

    public MandelAreaImage getMandelImage(MandelName name, ColormapModel cm, Mapper m) throws IOException {
        return this.getMandelImage(name, cm.getResizeMode(), cm.getColormap(), m);
    }

    public MandelAreaImage getMandelImage(MandelName name, ColormapModel.ResizeMode mode, Colormap cm, Mapper m) throws IOException {
        return this.getMandelImage(name, mode, cm, m, null);
    }

    public MandelAreaImage getMandelImage(MandelName name, ColormapModel.ResizeMode mode, Colormap cm, Mapper m, FileInfo info) throws IOException {
        MandelHandle h = this.getMandelImageData(name);
        if (h == null) {
            System.err.println("no image data found for " + name);
            return null;
        }
        return this.getMandelImage(h, mode, cm, m, info);
    }

    public MandelAreaImage getMandelImage(QualifiedMandelName name) throws IOException {
        return this.getMandelImage(name, ColormapModel.ResizeMode.RESIZE_PROPORTIONAL, null);
    }

    public MandelAreaImage getMandelImage(QualifiedMandelName name, ColormapModel cm) throws IOException {
        return this.getMandelImage(name, cm, null);
    }

    public MandelAreaImage getMandelImage(QualifiedMandelName name, ColormapModel.ResizeMode mode, Colormap cm) throws IOException {
        return this.getMandelImage(name, mode, cm, null);
    }

    public MandelAreaImage getMandelImage(QualifiedMandelName name, ColormapModel cm, Mapper m) throws IOException {
        return this.getMandelImage(name, cm == null ? ColormapModel.ResizeMode.RESIZE_PROPORTIONAL : cm.getResizeMode(), cm == null ? null : cm.getColormap(), m);
    }

    public MandelAreaImage getMandelImage(QualifiedMandelName name, ColormapModel.ResizeMode mode, Colormap cm, Mapper m) throws IOException {
        return this.getMandelImage(name, mode, cm, m, null);
    }

    public MandelAreaImage getMandelImage(QualifiedMandelName name, ColormapModel.ResizeMode mode, Colormap cm, Mapper m, FileInfo info) throws IOException {
        MandelHandle h = this.getMandelImageData(name);
        if (h == null) {
            System.err.println("no image data found for " + name);
            return null;
        }
        return this.getMandelImage(h, mode, cm, m, info);
    }

    public MandelAreaImage getMandelImage(MandelHandle h, ColormapModel.ResizeMode mode, Colormap cm, Mapper m, FileInfo info) throws IOException {
        MandelData md = h.getData();
        return this.getMandelImage((QualifiedMandelName)h.getName(), md, mode, cm, m, info);
    }

    public MandelAreaImage getMandelImage(QualifiedMandelName name, MandelData md, ColormapModel.ResizeMode mode, Colormap cm, Mapper m, FileInfo info) throws IOException {
        MandelImage img;
        if (info != null) {
            info.setColormap(md.getColormap());
        }
        if ((img = this.getFactory().getImage(md, mode, cm, m)) != null) {
            return new MandelAreaImage(name, img);
        }
        return null;
    }

    public boolean handleRasterSeen(AbstractFile f) {
        String n = this.getProperty("path.raster.save");
        String s = this.getProperty("path.raster.seen");
        String v = this.getProperty("path.variant.seen");
        if (f == null || this.isReadonly()) {
            return false;
        }
        QualifiedMandelName mn = QualifiedMandelName.create(f);
        if (this.unseenrasters != null && this.unseenrasters.contains(mn)) {
            if (debug) {
                System.out.println(mn + " set to seen: " + f);
            }
            this.unseenrasters.remove(mn);
            try {
                this.unseenrasters.save();
            }
            catch (IOException ex) {
                System.err.println("cannot write seen: " + ex);
            }
            this.seenModified();
        }
        if (!Utils.isEmpty(mn.getQualifier()) && !Utils.isEmpty(v)) {
            s = v;
        }
        if (Utils.isEmpty(s)) {
            return false;
        }
        if (Utils.isEmpty(n)) {
            return false;
        }
        File root = null;
        if (f.isFile()) {
            File store;
            try {
                root = f.getFile().getParentFile().getCanonicalFile();
            }
            catch (IOException ex) {
                System.err.println("cannot eval " + f);
                return false;
            }
            StringTokenizer t = new StringTokenizer(n, ";:");
            boolean found = false;
            while (t.hasMoreTokens()) {
                try {
                    File save = new File(t.nextToken()).getCanonicalFile();
                    if (!save.equals(root)) continue;
                    found = true;
                    break;
                }
                catch (IOException ex) {
                }
            }
            if (!found) {
                System.err.println("not in save path");
                return false;
            }
            if (debug) {
                System.out.println("relocation candidate");
            }
            try {
                store = new File(s).getCanonicalFile();
            }
            catch (IOException ex) {
                return false;
            }
            if (!store.equals(root) && f.isFile()) {
                File nf = new File(store, f.getName());
                File of = f.getFile();
                try {
                    System.out.println("relocate file " + of + " to " + store);
                    MandelFolder mf = MandelFolder.getMandelFolder(store);
                    if (mf.renameTo(of, nf)) {
                        if (of.exists() && nf.exists()) {
                            System.out.println("*** delete " + of);
                            of.delete();
                        }
                        return true;
                    }
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    protected File _getBackup(String prop) {
        File backup = null;
        String p = this.getProperty(prop);
        if (Utils.isEmpty(p)) {
            p = this.getProperty("path.backup");
        }
        if (!Utils.isEmpty(p)) {
            backup = new File(p);
            backup.mkdirs();
            if (debug) {
                System.out.println("using backup folder " + backup);
            }
        }
        return backup;
    }

    public File getInfoBackup() {
        return this._getBackup("path.info.backup");
    }

    public File getRasterBackup() {
        return this._getBackup("path.raster.backup");
    }

    public File getRasterImageBackup() {
        return this._getBackup("path.rasterimage.backup");
    }

    public boolean backupFile(AbstractFile f, File backup) {
        if (backup != null && f.isFile()) {
            File n = new File(backup, f.getName());
            if (debug) {
                System.out.println("saving " + f);
            }
            try {
                if (!MandelFolder.Util.renameTo(f.getFile(), n)) {
                    MandelFolder.Util.delete(n);
                    return MandelFolder.Util.renameTo(f.getFile(), n);
                }
            }
            catch (IOException io) {
                System.err.println("cannot save " + f + ": " + io);
            }
            return true;
        }
        return false;
    }

    public boolean backupInfoFile(AbstractFile f) {
        return this.backupFile(f, this.getInfoBackup());
    }

    public boolean backupRasterFile(AbstractFile f) {
        return this.backupFile(f, this.getRasterBackup());
    }

    public boolean backupRasterImageFile(AbstractFile f) {
        return this.backupFile(f, this.getRasterImageBackup());
    }

    public boolean isCleanupInfo() {
        return Utils.parseBoolean(this.getProperty("cleanup.info"), true);
    }

    public boolean isCleanupRaster() {
        return Utils.parseBoolean(this.getProperty("cleanup.raster"), true);
    }

    public boolean isCleanupRasterImage() {
        return Utils.parseBoolean(this.getProperty("cleanup.rasterimage"), false);
    }

    protected File getFolder(AbstractFile mf, String prop) {
        String v;
        File d;
        File file = d = mf != null && mf.isFile() ? mf.getFile() : null;
        if (d != null && d.exists() && d.isFile()) {
            d = d.getParentFile();
        }
        if (Utils.isEmpty(v = this.getProperty(prop))) {
            v = this.getProperty("path.save");
        }
        if (Utils.isEmpty(v)) {
            return d;
        }
        d = new File(v);
        d.mkdirs();
        return d;
    }

    public File getInfoFolder(AbstractFile d) {
        return this.getFolder(d, "path.info.save");
    }

    public File getRasterFolder(AbstractFile d) {
        return this.getFolder(d, "path.raster.save");
    }

    public File getRasterImageFolder(AbstractFile d) {
        QualifiedMandelName mn = QualifiedMandelName.create(d);
        if (!Utils.isEmpty(mn.getQualifier()) && !Utils.isEmpty(this.settings.getProperty("path.variant.save"))) {
            return this.getFolder(d, "path.variant.save");
        }
        return this.getFolder(d, "path.rasterimage.save");
    }

    public File getImageFolder(AbstractFile d) {
        return this.getFolder(d, "path.image.save");
    }

    public File mapToRasterFile(AbstractFile f) {
        return MandUtils.mapFile(f, ".mr", this.getRasterFolder(f));
    }

    public File mapToInfoFile(AbstractFile f) {
        return MandUtils.mapFile(f, ".md", this.getInfoFolder(f));
    }

    public File mapToRasterImageFile(AbstractFile f) {
        return MandUtils.mapFile(f, ".mi", this.getRasterImageFolder(f));
    }

    public File mapToImageFile(AbstractFile f) {
        return MandUtils.mapFile(f, ".mpng", this.getImageFolder(f));
    }

    protected void seenModified() {
    }

    public static void main(String[] args) {
        Environment0 env = new Environment0(null);
    }

    private class AutoScanner
    extends MandelScannerProxy {
        public AutoScanner(MandelScanner s) {
            super(s);
        }

        public void rescan(boolean verbose) {
            if (Environment0.this.isAutoRescan()) {
                super.rescan(verbose);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class ScannerBasedList
    extends UniqueArrayMandelList {
        ScannerBasedList() {
            this._refresh();
        }

        protected abstract MandelScanner getScanner();

        @Override
        public void refresh(boolean soft) {
            this.clear();
            if (!soft) {
                this.getScanner().rescan(false);
            }
            this._refresh();
        }

        protected void _addAll(Set<QualifiedMandelName> set) {
            this.addAll(set);
        }

        private void _refresh() {
            for (MandelName n : this.getScanner().getMandelNames()) {
                this._addAll(this.getScanner().getQualifiedMandelNames(n));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PendingImageList
    extends ScannerBasedList {
        private PendingImageList() {
        }

        @Override
        protected MandelScanner getScanner() {
            return Environment0.this.getImageDataScanner();
        }

        @Override
        protected void _addAll(Set<QualifiedMandelName> set) {
            if (!set.isEmpty()) {
                boolean add = false;
                QualifiedMandelName qn = set.iterator().next();
                MandelName mn = qn.getMandelName();
                MandelScanner all = Environment0.this.getAllScanner();
                Set<MandelName> sub = MandUtils.getSubNames(mn, all);
                for (MandelName s : sub) {
                    Set<MandelHandle> subs = all.getMandelHandles(s);
                    if (MandelScannerUtils.hasImageData(subs)) continue;
                    add = true;
                    break;
                }
                if (add) {
                    for (QualifiedMandelName n : set) {
                        if (n.getQualifier() != null) continue;
                        this.add(n);
                        add = false;
                        break;
                    }
                    if (add) {
                        this.add(qn);
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LeafImageList
    extends ScannerBasedList {
        private LeafImageList() {
        }

        @Override
        protected MandelScanner getScanner() {
            return Environment0.this.getImageDataScanner();
        }

        @Override
        protected void _addAll(Set<QualifiedMandelName> set) {
            MandelScanner all;
            MandelName mn;
            if (!set.isEmpty() && !MandUtils.hasSubNames(mn = set.iterator().next().getMandelName(), all = Environment0.this.getAllScanner())) {
                for (QualifiedMandelName n : set) {
                    this.add(n);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class VariantImageList
    extends ScannerBasedList {
        private VariantImageList() {
        }

        @Override
        protected MandelScanner getScanner() {
            return Environment0.this.getImageDataScanner();
        }

        @Override
        protected void _addAll(Set<QualifiedMandelName> set) {
            for (QualifiedMandelName n : set) {
                if (n.getQualifier() == null) continue;
                this.add(n);
            }
        }
    }

    private class NewRasterList
    extends ScannerBasedList {
        private NewRasterList() {
        }

        protected MandelScanner getScanner() {
            return Environment0.this.getNewRasterScanner();
        }
    }

    public static class FileInfo {
        private Colormap cm;

        public Colormap getColormap() {
            return this.cm;
        }

        public void setColormap(Colormap cm) {
            this.cm = cm;
        }
    }
}

