/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand;

import com.mandelsoft.mand.util.MandArith;
import java.math.BigDecimal;

public class MandelAreaSpec
extends MandArith {
    private BigDecimal xm;
    private BigDecimal ym;
    private BigDecimal dx;
    private BigDecimal dy;
    private BigDecimal x0;
    private BigDecimal x1;
    private BigDecimal y0;
    private BigDecimal y1;

    public MandelAreaSpec() {
    }

    public MandelAreaSpec(BigDecimal xm, BigDecimal ym, BigDecimal dx, BigDecimal dy) {
        this.xm = xm;
        this.ym = ym;
        this.dx = dx;
        this.dy = dy;
    }

    public MandelAreaSpec(MandelAreaSpec spec) {
        this(spec.xm, spec.ym, spec.dx, spec.dy);
    }

    public String getMessage() {
        if (this.dy.compareTo(BigDecimal.ZERO) == 0) {
            return "dy is zero";
        }
        if (this.dx.compareTo(BigDecimal.ZERO) == 0) {
            return "dx is zero";
        }
        return null;
    }

    public MandelAreaSpec getAreaSpec() {
        return this;
    }

    public void setSpec(MandelAreaSpec i) {
        this.setXM(i.getXM());
        this.setYM(i.getYM());
        this.setDX(i.getDX());
        this.setDY(i.getDY());
    }

    private void clearAlt() {
        this.y1 = null;
        this.y0 = null;
        this.x1 = null;
        this.x0 = null;
    }

    private void setAlt() {
        if (this.x0 == null) {
            this.x0 = MandelAreaSpec.sub(this.getXM(), MandelAreaSpec.div(this.getDX(), 2.0));
            this.x1 = MandelAreaSpec.add(this.getXM(), MandelAreaSpec.div(this.getDX(), 2.0));
            this.y0 = MandelAreaSpec.sub(this.getYM(), MandelAreaSpec.div(this.getDY(), 2.0));
            this.y1 = MandelAreaSpec.add(this.getYM(), MandelAreaSpec.div(this.getDY(), 2.0));
        }
    }

    public boolean containsY(BigDecimal y) {
        this.setAlt();
        return y.compareTo(this.y0) >= 0 && y.compareTo(this.y1) < 0;
    }

    public boolean containsX(BigDecimal x) {
        this.setAlt();
        return x.compareTo(this.x0) >= 0 && x.compareTo(this.x1) < 0;
    }

    public boolean contains(BigDecimal x, BigDecimal y) {
        return this.containsX(x) && this.containsY(y);
    }

    public BigDecimal getDX() {
        return this.dx;
    }

    public BigDecimal getDY() {
        return this.dy;
    }

    public BigDecimal getXM() {
        return this.xm;
    }

    public BigDecimal getXMax() {
        this.setAlt();
        return this.x1;
    }

    public BigDecimal getXMin() {
        this.setAlt();
        return this.x0;
    }

    public BigDecimal getYM() {
        return this.ym;
    }

    public BigDecimal getYMax() {
        this.setAlt();
        return this.y1;
    }

    public BigDecimal getYMin() {
        this.setAlt();
        return this.y0;
    }

    public void setDX(BigDecimal dx) {
        this.clearAlt();
        this.dx = dx;
    }

    public void setDX(double dx) {
        this.setDX(BigDecimal.valueOf(dx));
    }

    public void setDY(BigDecimal dy) {
        this.clearAlt();
        this.dy = dy;
    }

    public void setDY(double dy) {
        this.setDY(BigDecimal.valueOf(dy));
    }

    public void setXM(BigDecimal xm) {
        this.clearAlt();
        this.xm = xm;
    }

    public void setXM(double xm) {
        this.setXM(BigDecimal.valueOf(xm));
    }

    public void setYM(BigDecimal ym) {
        this.clearAlt();
        this.ym = ym;
    }

    public void setYM(double ym) {
        this.setYM(BigDecimal.valueOf(ym));
    }

    public boolean isSameArea(MandelAreaSpec o) {
        return this.getXM().equals(o.getXM()) && this.getYM().equals(o.getYM()) && this.getDX().equals(o.getDX()) && this.getDY().equals(o.getDY());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MandelAreaSpec other = (MandelAreaSpec)obj;
        if (!(this.xm == other.xm || this.xm != null && this.xm.equals(other.xm))) {
            return false;
        }
        if (!(this.ym == other.ym || this.ym != null && this.ym.equals(other.ym))) {
            return false;
        }
        if (!(this.dx == other.dx || this.dx != null && this.dx.equals(other.dx))) {
            return false;
        }
        return this.dy == other.dy || this.dy != null && this.dy.equals(other.dy);
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + (this.xm != null ? this.xm.hashCode() : 0);
        hash = 97 * hash + (this.ym != null ? this.ym.hashCode() : 0);
        hash = 97 * hash + (this.dx != null ? this.dx.hashCode() : 0);
        hash = 97 * hash + (this.dy != null ? this.dy.hashCode() : 0);
        return hash;
    }
}

