/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand;

import com.mandelsoft.io.AbstractFile;
import com.mandelsoft.mand.IllegalConfigurationException;
import com.mandelsoft.mand.MandelImageDB;
import com.mandelsoft.mand.MandelImageDBContext;
import com.mandelsoft.util.Utils;
import java.net.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MandelImageDBFactory {
    private Map<AbstractFile, MandelImageDBContext> cache;
    private Map<AbstractFile, MandelImageDBContext> aliases;
    private String tool;

    public MandelImageDBFactory(String tool) {
        this.tool = tool;
        this.cache = new HashMap<AbstractFile, MandelImageDBContext>();
        this.aliases = new HashMap<AbstractFile, MandelImageDBContext>();
    }

    public String getTool() {
        return this.tool;
    }

    public void addAlias(MandelImageDBContext ctx, AbstractFile f) {
        this.aliases.put(f, ctx);
    }

    public void put(AbstractFile root, MandelImageDBContext ctx) {
        this.cache.put(root, ctx);
    }

    public MandelImageDBContext get(AbstractFile root) throws IllegalConfigurationException {
        MandelImageDBContext ctx = this._get(root, new Stack<AbstractFile>());
        ctx.complete();
        return ctx;
    }

    private MandelImageDBContext _get(AbstractFile root, Stack<AbstractFile> stack) throws IllegalConfigurationException {
        MandelImageDBContext ctx = this.cache.get(root);
        if (ctx == null) {
            ctx = this.aliases.get(root);
        }
        if (ctx == null) {
            ctx = this.create(root, stack);
        }
        return ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MandelImageDBContext create(AbstractFile root, Stack<AbstractFile> stack) throws IllegalConfigurationException {
        if (stack.contains(root)) {
            throw new IllegalArgumentException("cycle in nested dbs: " + root);
        }
        stack.push(root);
        try {
            String path;
            StringTokenizer t;
            String aliases;
            MandelImageDB db = null;
            db = root.isFile() ? new MandelImageDB(this, root.getFile()) : new MandelImageDB(this, root);
            MandelImageDBContext ctx = new MandelImageDBContext(root, db);
            Proxy proxy = root.getProxy();
            if (proxy == null) {
                proxy = db.getProxy();
            }
            if (!Utils.isEmpty(aliases = db.getProperty("aliases"))) {
                System.out.println("found aliases: " + aliases);
                t = new StringTokenizer(aliases, ";");
                while (t.hasMoreTokens()) {
                    String a = t.nextToken().trim();
                    AbstractFile alias = AbstractFile.Factory.create(a, proxy, false);
                    this.addAlias(ctx, alias);
                }
            }
            if (!Utils.isEmpty(path = db.getProperty("path.base"))) {
                System.out.println("found nested dbs: " + path);
                t = new StringTokenizer(path, ";");
                while (t.hasMoreTokens()) {
                    String p = t.nextToken().trim();
                    if (p.equals("")) continue;
                    String l = db.getProperty("db.location." + p);
                    if (!Utils.isEmpty(l)) {
                        AbstractFile sub = AbstractFile.Factory.create(l, proxy, true);
                        System.out.println("  location: " + l + " proxy: " + proxy);
                        MandelImageDBContext nested = this._get(sub, stack);
                        ctx.addContext(nested, p);
                        continue;
                    }
                    throw new IllegalConfigurationException(root + ": location missing for label " + p);
                }
            }
            this.put(root, ctx);
            MandelImageDBContext mandelImageDBContext = ctx;
            return mandelImageDBContext;
        }
        finally {
            stack.pop();
        }
    }
}

