/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand;

import com.mandelsoft.mand.MandelAreaSpec;
import java.math.BigDecimal;

public class MandelSpec
extends MandelAreaSpec {
    private int rx;
    private int ry;
    private int limitit;

    public MandelSpec() {
    }

    public MandelSpec(double xm, double ym, double dx, double dy, int rx, int ry, int limitit) {
        this(BigDecimal.valueOf(xm), BigDecimal.valueOf(ym), BigDecimal.valueOf(dx), BigDecimal.valueOf(dy), rx, ry, limitit);
    }

    public MandelSpec(BigDecimal xm, BigDecimal ym, BigDecimal dx, BigDecimal dy, int rx, int ry, int limitit) {
        super(xm, ym, dx, dy);
        this.rx = rx;
        this.ry = ry;
        this.limitit = limitit;
    }

    public MandelSpec(MandelSpec mi) {
        this(mi.getXM(), mi.getYM(), mi.getDX(), mi.getDY(), mi.rx, mi.ry, mi.limitit);
    }

    public boolean valid() {
        return this.getMessage() == null;
    }

    public String getMessage() {
        if (this.rx == 0) {
            return "rx is zero";
        }
        if (this.ry == 0) {
            return "ry is zero";
        }
        return super.getMessage();
    }

    public MandelSpec getSpec() {
        return this;
    }

    public MandelAreaSpec getAreaSpec() {
        return new MandelAreaSpec(this);
    }

    public int getRX() {
        return this.rx;
    }

    public int getRY() {
        return this.ry;
    }

    public int getLimitIt() {
        return this.limitit;
    }

    public void setSpec(MandelSpec i) {
        super.setSpec(i);
        this.setRX(i.getRX());
        this.setRY(i.getRY());
        this.setLimitIt(i.getLimitIt());
    }

    public void setRX(int rx) {
        this.rx = rx;
    }

    public void setRY(int ry) {
        this.ry = ry;
    }

    public void setLimitIt(int limitit) {
        this.limitit = limitit;
    }

    public boolean isSameSpec(MandelSpec o) {
        return super.isSameArea(o) && this.getRX() == o.getRX() && this.getRY() == o.getRY() && this.getLimitIt() == o.getLimitIt();
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        MandelSpec other = (MandelSpec)obj;
        if (this.rx != other.rx) {
            return false;
        }
        if (this.ry != other.ry) {
            return false;
        }
        return this.limitit == other.limitit;
    }

    public int hashCode() {
        int hash = 3;
        hash = 29 * hash + super.hashCode();
        hash = 29 * hash + this.rx;
        hash = 29 * hash + this.ry;
        hash = 29 * hash + this.limitit;
        return hash;
    }
}

