/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand;

import com.mandelsoft.io.AbstractFile;
import com.mandelsoft.mand.ElementName;
import com.mandelsoft.mand.MandelFileName;
import com.mandelsoft.mand.MandelName;
import com.mandelsoft.util.Utils;
import java.io.File;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QualifiedMandelName
implements ElementName<QualifiedMandelName> {
    public static final QualifiedMandelName ROOT = new QualifiedMandelName(MandelName.ROOT);
    private MandelName name;
    private String qualifier;
    private String label;
    private static int failed = 0;

    public QualifiedMandelName(MandelName name) {
        this(name, null);
    }

    public QualifiedMandelName(MandelName name, String qualifier) {
        this(name, qualifier, null);
    }

    public QualifiedMandelName(MandelName name, String qualifier, String label) {
        if (label == null) {
            if (qualifier == null) {
                label = name.getLabel();
            } else {
                int ix = qualifier.indexOf(64);
                if (ix > 0) {
                    label = qualifier.substring(ix + 1);
                    qualifier = qualifier.substring(0, ix);
                }
            }
        }
        this.name = name;
        this.qualifier = qualifier;
        this.label = label;
        if (qualifier != null && qualifier.indexOf(64) >= 0) {
            throw new IllegalArgumentException("illegal qualifier: " + qualifier);
        }
        if (label != null && label.indexOf(64) >= 0) {
            throw new IllegalArgumentException("illegal label: " + label);
        }
    }

    @Override
    public String getName() {
        String base;
        if (this.name.isRemoteName() && Utils.equals(this.name.getLabel(), this.label)) {
            base = this.name.getName();
            int ix = base.lastIndexOf(64);
            base = base.substring(0, ix);
        } else {
            base = this.name.getName();
        }
        return base + (this.qualifier == null ? "" : "-" + this.qualifier) + (this.label == null ? "" : "@" + this.label);
    }

    public MandelName getMandelName() {
        return this.name;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public boolean isRoot() {
        return this.name.isRoot();
    }

    public QualifiedMandelName getBaseName() {
        if (this.qualifier == null) {
            return this;
        }
        return new QualifiedMandelName(this.name);
    }

    public QualifiedMandelName get(String qualifier, boolean preserveLocation) {
        return new QualifiedMandelName(this.name, qualifier, preserveLocation ? this.name.getLabel() : null);
    }

    public QualifiedMandelName get(MandelName name, boolean preserveLocation) {
        return new QualifiedMandelName(name, this.qualifier, preserveLocation ? name.getLabel() : null);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QualifiedMandelName other = (QualifiedMandelName)obj;
        if (!(this.name == other.name || this.name != null && this.name.equals(other.name))) {
            return false;
        }
        if (this.qualifier == null ? other.qualifier != null : !this.qualifier.equals(other.qualifier)) {
            return false;
        }
        return !(this.label == null ? other.label != null : !this.label.equals(other.label));
    }

    public int hashCode() {
        int hash = 3;
        hash = 17 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 17 * hash + (this.qualifier != null ? this.qualifier.hashCode() : 0);
        hash = 17 * hash + (this.label != null ? this.label.hashCode() : 0);
        return hash;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public int compareTo(QualifiedMandelName o) {
        int c = this.name.compareTo(o.getMandelName());
        if (c == 0) {
            if (this.qualifier == null) {
                if (o.qualifier != null) {
                    c = -1;
                }
            } else {
                c = o.qualifier == null ? 1 : this.qualifier.compareTo(o.qualifier);
            }
        }
        return c;
    }

    public static QualifiedMandelName create(AbstractFile f) {
        return QualifiedMandelName.qn(MandelFileName.create(f));
    }

    public static QualifiedMandelName create(File f) {
        return QualifiedMandelName.qn(MandelFileName.create(f));
    }

    public static QualifiedMandelName create(String n) {
        return QualifiedMandelName.qn(MandelFileName.create(n));
    }

    private static QualifiedMandelName qn(MandelFileName mfn) {
        return mfn == null ? null : mfn.getQualifiedName();
    }

    public static QualifiedMandelName _create(String n) {
        QualifiedMandelName qn = null;
        String base = n;
        String suffix = null;
        String qualifier = null;
        String qlabel = null;
        String label = null;
        try {
            int ix = base.lastIndexOf(46);
            if (ix >= 0) {
                suffix = base.substring(ix);
                base = base.substring(0, ix);
            }
            if ((ix = base.indexOf(45)) >= 0) {
                qualifier = base.substring(ix + 1);
                base = base.substring(0, ix);
                ix = qualifier.indexOf(64);
                if (ix >= 0) {
                    qlabel = qualifier.substring(ix);
                    label = qlabel.substring(1);
                    qualifier = qualifier.substring(0, ix);
                    if (!MandelName.isRemoteName(base) && !MandelName.isRoot(base)) {
                        base = base + qlabel;
                    }
                }
            }
            MandelName mn = new MandelName(base);
            qn = new QualifiedMandelName(mn, qualifier, label);
        }
        catch (IllegalArgumentException e) {
            qn = null;
        }
        return qn;
    }

    private static boolean check(String arg, String mn, String qualifier, String label) {
        try {
            QualifiedMandelName qn = QualifiedMandelName._create(arg);
            if (qn != null) {
                if (!Utils.equals(qn.getMandelName(), new MandelName(mn))) {
                    System.out.println(arg + " -> " + qn + " (" + qn.getMandelName() + "/" + qn.getQualifier() + "/" + qn.getLabel() + ") (FAILED mn) expected " + mn + "/" + qualifier + "/" + label);
                    ++failed;
                    return false;
                }
                if (!Utils.equals(qn.getQualifier(), qualifier)) {
                    System.out.println(arg + " -> " + qn + " (" + qn.getMandelName() + "/" + qn.getQualifier() + "/" + qn.getLabel() + ") (FAILED qualifier) expected " + mn + "/" + qualifier + "/" + label);
                    ++failed;
                    return false;
                }
                if (!Utils.equals(qn.getLabel(), label)) {
                    System.out.println(arg + " -> " + qn + " (" + qn.getMandelName() + "/" + qn.getQualifier() + "/" + qn.getLabel() + ") (FAILED label) expected " + mn + "/" + qualifier + "/" + label);
                    ++failed;
                    return false;
                }
                System.out.println(arg + " -> " + qn + " (" + qn.getMandelName() + "/" + qn.getQualifier() + "/" + qn.getLabel() + ") (OK)");
                return true;
            }
            if (mn != null) {
                ++failed;
                System.out.println(arg + " -> <null> (FAILED) expected " + mn + "/" + qualifier + "/" + label);
            } else {
                System.out.println(arg + " -> <null> (OK)");
            }
            return mn == null;
        }
        catch (IllegalArgumentException ex) {
            if (mn != null) {
                ++failed;
                System.out.println(arg + " -> <illegal> (FAILED) expected " + mn + "/" + qualifier + "/" + label + " (" + ex.getMessage() + ")");
            } else {
                System.out.println(arg + " -> <illegal> (OK)");
            }
            return mn == null;
        }
    }

    public static int test() {
        System.out.println("starting QualifiedMandelName tests...");
        failed = 0;
        QualifiedMandelName.check("0", "0", null, null);
        QualifiedMandelName.check("ab", "ab", null, null);
        QualifiedMandelName.check("0-qual", "0", "qual", null);
        QualifiedMandelName.check("ab-qual", "ab", "qual", null);
        QualifiedMandelName.check("0-qual@label", "0", "qual", "label");
        QualifiedMandelName.check("ab@label-qual", "ab@label", "qual", null);
        QualifiedMandelName.check("ab-qual@label", "ab@label", "qual", "label");
        QualifiedMandelName.check("ab@other-qual@label", "ab@other", "qual", "label");
        System.out.println("failed: " + failed);
        return failed;
    }

    public static void main(String[] args) {
        QualifiedMandelName.test();
    }
}

