/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.calc;

import com.mandelsoft.mand.MandIter;
import com.mandelsoft.mand.MandelInfo;
import com.mandelsoft.mand.MandelSpec;
import com.mandelsoft.mand.PixelIterator;

public abstract class CalculationContext
extends MandelSpec {
    private int sx;
    private int sy;
    private int nx;
    private int ny;
    private int minit;
    private int maxit;
    private long numit;
    private long mtime;
    private long ccnt;
    private long mcnt;
    private PixelIterator iter;

    public CalculationContext() {
    }

    public CalculationContext(MandelSpec spec) {
        this(spec, 0, 0, spec.getRX(), spec.getRY());
    }

    public CalculationContext(MandelSpec spec, int sx, int sy, int nx, int ny) {
        this();
        this.setSpec(spec);
        this.sx = sx;
        this.sy = sy;
        this.nx = nx;
        this.ny = ny;
    }

    public int getSX() {
        return this.sx;
    }

    public int getSY() {
        return this.sy;
    }

    public int getNX() {
        return this.nx;
    }

    public int getNY() {
        return this.ny;
    }

    public int getMinIt() {
        return this.minit;
    }

    public int getMaxIt() {
        return this.maxit;
    }

    public long getNumIt() {
        return this.numit;
    }

    public long getMTime() {
        return this.mtime;
    }

    public long getCCnt() {
        return this.ccnt;
    }

    public long getMCnt() {
        return this.mcnt;
    }

    public PixelIterator getPixelIterator() {
        if (this.iter == null) {
            this.iter = MandIter.createPixelIterator(this.getXMin(), this.getYMax(), this.getDX(), this.getDY(), this.getRX(), this.getRY(), this.getLimitIt());
        }
        return this.iter;
    }

    public void setInitialInfo(MandelInfo mi) {
        this.minit = mi.getMinIt();
        this.maxit = mi.getMaxIt();
    }

    public void setSX(int sx) {
        this.resetData();
        this.sx = sx;
    }

    public void setSY(int sy) {
        this.resetData();
        this.sy = sy;
    }

    public void setNX(int nx) {
        this.resetData();
        this.nx = nx;
    }

    public void setNY(int ny) {
        this.resetData();
        this.ny = ny;
    }

    public void setMinIt(int minit) {
        this.minit = minit;
    }

    public void setMaxIt(int maxit) {
        this.maxit = maxit;
    }

    public void setNumIt(long numit) {
        this.numit = numit;
    }

    public void setMTime(long mtime) {
        this.mtime = mtime;
    }

    public void setCCnt(long ccnt) {
        this.ccnt = ccnt;
    }

    public void setMCnt(long mcnt) {
        this.mcnt = mcnt;
    }

    public void addMCnt(int n) {
        this.mcnt += (long)n;
    }

    public void incMCnt() {
        ++this.mcnt;
    }

    public void addNumIt(int n) {
        this.numit += (long)n;
    }

    public void incNumIt() {
        ++this.numit;
    }

    public int incorporateIteration(int x, int y, int i) {
        int it;
        ++this.ccnt;
        if (i > this.getLimitIt()) {
            it = 0;
            this.setDataRel(x, y, 0);
            ++this.mcnt;
            --i;
        } else {
            it = i;
            this.setDataRel(x, y, it);
        }
        if (i < this.minit) {
            this.minit = i;
        }
        if (i > this.maxit) {
            this.maxit = i;
        }
        this.numit += (long)i;
        return it;
    }

    public void setPixelIterator(PixelIterator i) {
        this.iter = i;
    }

    public boolean isSameSpec(CalculationContext o) {
        return this.getSX() == o.getSX() && this.getSY() == o.getSY() && this.getNX() == o.getNX() && this.getNY() == o.getNY() && this.isSameSpec(this.getSpec());
    }

    public int getDataAbs(int x, int y) {
        return this.getDataRel(x - this.sx, y - this.sy);
    }

    public void setInfoTo(MandelInfo mi) {
        mi.setMinIt(this.minit);
        mi.setMaxIt(this.maxit);
        mi.setNumIt(this.numit);
        mi.setMCnt(this.mcnt);
        mi.setMCCnt(this.ccnt);
        mi.setTime((int)(this.mtime / 1000L));
    }

    public abstract int getDataRel(int var1, int var2);

    public abstract void setDataRel(int var1, int var2, int var3);

    protected abstract void resetData();

    public abstract void createData();
}

