/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.image;

import com.mandelsoft.mand.MandelException;
import com.mandelsoft.mand.MandelRaster;
import com.mandelsoft.mand.image.ColorMapper;
import java.awt.Color;

public class RasterColorMapper {
    private ColorMapper mapper;
    private MandelRaster mraster;
    private int[][] raster;

    public RasterColorMapper(ColorMapper mapper, MandelRaster mr) {
        if (mr == null) {
            throw new MandelException("no raster set");
        }
        this.mapper = mapper;
        this.mraster = mr;
        this.raster = mr.getRaster();
    }

    public int getColormapIndex(int x, int y) {
        return this.mapper.mapColormapIndex(this.raster[y][x]);
    }

    public Color getPixelColor(int x, int y) {
        return this.mapper.mapIterationValue(this.raster[y][x]);
    }

    public int getPixelRGB(int x, int y) {
        return this.getPixelColor(x, y).getRGB();
    }

    public Object getPixelDataElements(int x, int y) {
        int it = this.raster[y][x];
        Object de = this.mapper.mapIterationValueToDataElements(this.raster[y][x]);
        return de;
    }
}

