/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.movie;

import com.mandelsoft.mand.Environment;
import com.mandelsoft.mand.IllegalConfigurationException;
import com.mandelsoft.mand.MandelData;
import com.mandelsoft.mand.MandelName;
import com.mandelsoft.mand.cm.Colormap;
import com.mandelsoft.mand.image.MandelImage;
import com.mandelsoft.mand.movie.CompoundMovieDecoration;
import com.mandelsoft.mand.movie.MovieDecoration;
import com.mandelsoft.mand.movie.SimpleMovieDecoration;
import com.mandelsoft.mand.movie.VerticalListMovieDecoration;
import com.mandelsoft.mand.scan.MandelHandle;
import com.mandelsoft.mand.scan.MandelScanner;
import com.mandelsoft.mand.tool.Decoration;
import com.mandelsoft.mand.tools.Command;
import com.mandelsoft.mand.util.MandUtils;
import com.xuggle.mediatool.IMediaWriter;
import com.xuggle.mediatool.ToolFactory;
import com.xuggle.xuggler.ICodec;
import com.xuggle.xuggler.IRational;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class MovieMaker {
    private static final int GAP = 5000;
    private static final int FRAME_RATE = 25;
    private static final int MILLISECONDS_PER_FRAME = 40;
    private static final int ALPHA_TIME = 2000;
    private static final double ALPHA_DELTA = 5.1;
    private static String outputFilename = "zoom.mp4";
    private static double scale = 1.0;

    public static MandelImage getImage(MandelScanner scanner, MandelImage.Factory f, MandelName n) {
        MandelHandle h = scanner.getMandelData(n);
        if (h == null) {
            return null;
        }
        try {
            MandelData md = h.getData();
            MandelData pure = new MandelData(md.getInfo());
            pure.setRaster(md.getRaster());
            MandelImage image = f.getImage(pure);
            return image;
        }
        catch (IOException ex) {
            System.out.println("cannt read " + h.getFile() + ": " + ex);
            return null;
        }
    }

    public static void main(String[] args) {
        long time;
        try {
            outputFilename = new File(".").getCanonicalFile().getName() + ".mp4";
            System.out.println("OUT: " + outputFilename);
        }
        catch (IOException ex) {
            Command.Error("cannot determine directory name");
        }
        Environment env = null;
        try {
            env = new Environment(args);
        }
        catch (IllegalConfigurationException ex) {
            System.out.println("cannot initial image base: " + ex);
            System.exit(1);
        }
        Decoration decoration = new Decoration();
        decoration.setShowDecoration(true);
        decoration.setDecoration(env.getCopyright());
        Decoration mag = new Decoration("magnification");
        mag.setShowDecoration(true);
        mag.setFont("Times Roman Bold-20");
        Decoration url = new Decoration("url");
        url.setHAlign(-1);
        url.setFont("Times Roman-15");
        String u = env.getProperty("homepage");
        if (u != null) {
            url.setDecoration(u);
            url.setShowDecoration(true);
        }
        MandelScanner scanner = env.getImageDataScanner();
        Colormap cm = env.getDefaultColormap();
        MandelImage.Factory f = new MandelImage.Factory(cm);
        MandelName name = MandelName.ROOT;
        MandelImage image = MovieMaker.getImage(scanner, f, name);
        MovieWriter mw = new MovieWriter(25, (int)((double)image.getImage().getWidth() * scale), (int)((double)image.getImage().getHeight() * scale), outputFilename);
        CompoundMovieDecoration d = new CompoundMovieDecoration();
        d.addMovieDecoration(new SimpleMovieDecoration(decoration, 0L, 1000L, 4000L, 4000L));
        VerticalListMovieDecoration v = new VerticalListMovieDecoration(40, 0L, 500L, 4000L, 4000L);
        v.addDecoration(MovieMaker.createTitleLine("The Beauty"));
        v.addDecoration(MovieMaker.createTitleLine("of Chaos"));
        d.addMovieDecoration(v);
        SimpleMovieDecoration mmag = new SimpleMovieDecoration(mag, 9000L, 1000L, Long.MAX_VALUE, 1666L);
        d.addMovieDecoration(mmag);
        mw.setDecoration(d);
        double alpha = 255.0;
        BufferedImage im = image.getImage();
        for (time = 0L; time < 5000L; time += 40L) {
            mw.encodeVideo(time, im);
        }
        while (image != null) {
            im = image.getImage();
            mag.setDecoration("10^-" + MandUtils.getMagnification(image.getInfo()));
            mw.encodeVideo(time, im);
            time += 40L;
            image = MovieMaker.getImage(scanner, f, name = name.sub('z'));
            if (image != null) continue;
            long end = time + 5000L;
            mmag.setShowTime(time - mmag.getStart() - mmag.getFadeInTime());
            d.addMovieDecoration(new SimpleMovieDecoration(url, time, 1666L, 5000L, 0L));
            while (time < end) {
                mw.encodeVideo(time, im);
                time += 40L;
            }
        }
        mw.close();
    }

    public static Decoration createTitleLine(String txt) {
        Decoration t = new Decoration(txt);
        t.setHAlign(0);
        t.setVAlign(0);
        t.setHInset(80);
        t.setVInset(-5);
        t.setFontSize(45.0f);
        t.setColor(new Color(119, 119, 0));
        t.setShowDecoration(true);
        return t;
    }

    public static BufferedImage convertToType(BufferedImage sourceImage, int targetType) {
        BufferedImage image;
        if (sourceImage.getType() == targetType) {
            image = sourceImage;
        } else {
            image = new BufferedImage(sourceImage.getWidth(), sourceImage.getHeight(), targetType);
            image.getGraphics().drawImage(sourceImage, 0, 0, null);
        }
        return image;
    }

    private static class MovieWriter {
        IMediaWriter writer;
        double fps;
        MovieDecoration deco;

        public MovieWriter(int fps, int width, int height, String outputFilename) {
            this.fps = fps;
            this.writer = ToolFactory.makeWriter((String)outputFilename);
            this.writer.addVideoStream(0, 0, ICodec.ID.CODEC_ID_MPEG4, IRational.make((int)fps, (int)1), width, height);
        }

        public void setDecoration(MovieDecoration deco) {
            this.deco = deco;
        }

        public void encodeVideo(long time, BufferedImage im) {
            BufferedImage bgr = MovieMaker.convertToType(im, 5);
            if (this.deco != null && this.deco.isActive(time)) {
                if (bgr == im) {
                    bgr = new BufferedImage(im.getWidth(), im.getHeight(), 5);
                    bgr.getGraphics().drawImage(im, 0, 0, null);
                }
                Graphics g = bgr.getGraphics();
                this.deco.paintDecoration(time, g, bgr.getWidth(), bgr.getHeight());
            }
            this.writer.encodeVideo(0, bgr, time, TimeUnit.MILLISECONDS);
        }

        public void close() {
            this.writer.close();
        }
    }
}

