/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.srv;

import com.mandelsoft.util.Queue;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestBuffer<T> {
    private Requests requests = new Requests();
    private Done done = new Done();
    private boolean log;

    private void log(String m) {
        if (this.log) {
            System.out.println(m);
        }
    }

    public synchronized Requests getRequestView() {
        return this.requests;
    }

    public synchronized Done getDoneView() {
        return this.done;
    }

    protected synchronized void donotify() {
        this.notify();
    }

    public synchronized void syncEmpty() throws InterruptedException {
        while (!this.requests.isEmpty()) {
            this.wait();
        }
    }

    public synchronized T getNextAction() throws InterruptedException {
        this.log("get next action");
        while (true) {
            this.log("  check done");
            Object e = this.done.testAndPull();
            if (e != null) {
                return e;
            }
            this.log("  check requests");
            if (this.requests.isEmpty()) {
                return null;
            }
            this.log("  wait for next action");
            this.wait();
        }
    }

    public synchronized T testAndGetDone() {
        this.log("test done");
        Object e = this.done.testAndPull();
        this.log(e == null ? "nothing done" : "found done ");
        return e;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Done
    extends Queue<T> {
        private Done() {
        }

        @Override
        public void put(T e) {
            super.put(e);
            RequestBuffer.this.donotify();
        }

        @Override
        public boolean putAll(Collection<? extends T> c) {
            boolean e = super.putAll(c);
            if (!this.isEmpty()) {
                RequestBuffer.this.donotify();
            }
            return e;
        }

        @Override
        public void putTop(T e) {
            super.putTop(e);
            RequestBuffer.this.donotify();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Requests
    extends Queue<T> {
        private Requests() {
        }

        @Override
        public T pull() throws InterruptedException {
            Object e = super.pull();
            if (this.isEmpty()) {
                RequestBuffer.this.donotify();
            }
            return e;
        }

        @Override
        public boolean remove(Object o) {
            boolean e = super.remove(o);
            if (this.isEmpty()) {
                RequestBuffer.this.donotify();
            }
            return e;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            boolean e = super.removeAll(c);
            if (this.isEmpty()) {
                RequestBuffer.this.donotify();
            }
            return e;
        }

        @Override
        public T testAndPull() {
            Object e = super.testAndPull();
            if (this.isEmpty()) {
                RequestBuffer.this.donotify();
            }
            return e;
        }
    }
}

