/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool;

import com.mandelsoft.mand.MandelName;
import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.cm.ColormapSourceFactory;
import com.mandelsoft.mand.image.MandelImage;
import com.mandelsoft.mand.scan.ElementHandle;
import com.mandelsoft.mand.scan.MandelHandle;
import com.mandelsoft.mand.scan.MandelScanner;
import com.mandelsoft.mand.tool.MandelFolderTransferable;
import com.mandelsoft.mand.tool.MandelListTableModel;
import com.mandelsoft.mand.tool.MandelTransferable;
import com.mandelsoft.mand.tool.thumb.AsyncThumbnailFactory;
import com.mandelsoft.mand.tool.thumb.ImageChangeListener;
import com.mandelsoft.mand.tool.thumb.ThumbnailFactory;
import com.mandelsoft.swing.DnDTableModel;
import com.mandelsoft.util.DateTime;
import java.awt.Dimension;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DropMode;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMandelListTableModel
extends AbstractTableModel
implements MandelListTableModel {
    public static boolean debug = false;
    protected List<Action> actions;
    private AsyncThumbnailFactory factory;
    private boolean modifiable;
    private boolean showlocation;
    private int[] columnMapping = m_local;
    public static final int NAME = 0;
    public static final int QUALIFIER = 1;
    public static final int TYPE = 2;
    public static final int LOCATION = 3;
    public static final int TIME = 4;
    private static final int[] m_local = new int[]{0, 1, 2, 4};
    private static final int[] m_located = new int[]{0, 1, 3, 2, 4};

    protected AbstractMandelListTableModel() {
        this.factory = new AsyncThumbnailFactory(new ThumbnailFactory.Client(){

            public boolean usesThumbnail(QualifiedMandelName name) {
                return AbstractMandelListTableModel.this.getList().contains(name);
            }

            public MandelScanner getMandelScanner() {
                return AbstractMandelListTableModel.this.getMandelScanner();
            }
        });
    }

    public boolean isShowLocation() {
        return this.showlocation;
    }

    public void setShowLocation(boolean showlocation) {
        boolean old = this.showlocation;
        this.showlocation = showlocation;
        this.columnMapping = showlocation ? m_local : m_located;
        if (old != showlocation) {
            this.fireTableStructureChanged();
        }
    }

    public void removeImageChangeListener(ImageChangeListener l) {
        this.factory.removeImageChangeListener(l);
    }

    public void addImageChangeListener(ImageChangeListener l) {
        this.factory.addImageChangeListener(l);
    }

    @Override
    public void setModifiable(boolean m) {
        this.modifiable = m;
    }

    public void setColormapSourceFactory(ColormapSourceFactory colmapfac) {
        this.factory.setColormapSourceFactory(colmapfac);
    }

    public ColormapSourceFactory getColormapSourceFactory() {
        return this.factory.getColormapSourceFactory();
    }

    public void setFactory(MandelImage.Factory factory) {
        this.factory.setFactory(factory);
    }

    @Override
    public boolean isModifiable() {
        return this.modifiable;
    }

    @Override
    public void addAction(Action a) {
        if (this.actions == null) {
            this.actions = new ArrayList<Action>();
        }
        this.actions.add(a);
    }

    @Override
    public void removeAction(Action a) {
        if (this.actions != null) {
            this.actions.remove(a);
        }
    }

    @Override
    public List<Action> getActions() {
        return this.actions;
    }

    protected void checkModifiable() {
        if (!this.isModifiable()) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public void refresh() {
        this.refresh(false);
    }

    @Override
    public BufferedImage getThumbnail(int index, Dimension max) {
        QualifiedMandelName n = this.getQualifiedName(index);
        return this.factory.getThumbnail(n, max);
    }

    @Override
    public BufferedImage getThumbnail(QualifiedMandelName n, Dimension max) {
        return this.factory.getThumbnail(n, max);
    }

    protected void cleanupThumbnail(QualifiedMandelName name) {
        this.factory.remove(name);
    }

    @Override
    public MandelName getName(int index) {
        QualifiedMandelName n = this.getQualifiedName(index);
        return n == null ? null : n.getMandelName();
    }

    @Override
    public String getQualifier(int index) {
        QualifiedMandelName n = this.getQualifiedName(index);
        return n == null ? null : n.getQualifier();
    }

    public String getLocation(int index) {
        QualifiedMandelName n = this.getQualifiedName(index);
        return n == null ? null : n.getLabel();
    }

    @Override
    public QualifiedMandelName getQualifiedName(int index) {
        return (QualifiedMandelName)this.getList().get(index);
    }

    @Override
    public MandelHandle getMandelHandle(int index) {
        return this.getMandelScanner().getMandelHandle((QualifiedMandelName)this.getList().get(index));
    }

    @Override
    public MandelHandle getMandelData(int index) throws IOException {
        return this.getMandelScanner().getMandelData((QualifiedMandelName)this.getList().get(index));
    }

    @Override
    public int getRowCount() {
        return this.getList().size();
    }

    @Override
    public int getColumnCount() {
        return this.columnMapping.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (this.columnMapping[columnIndex]) {
            case 0: {
                return this.getName(rowIndex);
            }
            case 1: {
                String q = this.getQualifier(rowIndex);
                if (q == null) {
                    return "";
                }
                return q;
            }
            case 3: {
                String q = this.getLocation(rowIndex);
                if (q == null) {
                    return "";
                }
                return q;
            }
            case 2: {
                ElementHandle h = this.getMandelScanner() == null ? null : this.getMandelScanner().getMandelHandle((QualifiedMandelName)this.getList().get(rowIndex));
                return h == null ? "Not found" : h.getHeader().getTypeDesc();
            }
            case 4: {
                long t;
                ElementHandle h = this.getMandelScanner() == null ? null : this.getMandelScanner().getMandelHandle((QualifiedMandelName)this.getList().get(rowIndex));
                long l = t = h == null ? 0L : h.getFile().getLastModified();
                if (t == 0L) {
                    return null;
                }
                return new DateTime(t);
            }
        }
        return null;
    }

    @Override
    public String getColumnName(int column) {
        switch (this.columnMapping[column]) {
            case 0: {
                return "Name";
            }
            case 1: {
                return "Variant";
            }
            case 2: {
                return "Description";
            }
            case 3: {
                return "Location";
            }
            case 4: {
                return "Time Modified";
            }
        }
        return null;
    }

    public Class getColumnClass(int column) {
        switch (this.columnMapping[column]) {
            case 0: {
                return MandelName.class;
            }
            case 1: {
                return String.class;
            }
            case 3: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 4: {
                return DateTime.class;
            }
        }
        return null;
    }

    @Override
    public DropMode getDropMode() {
        return DropMode.INSERT_ROWS;
    }

    @Override
    public int getSourceActions() {
        return 3;
    }

    @Override
    public Transferable createTransferable(DnDTableModel.DragLocation loc) {
        int[] indices = loc.getSelectedRows();
        QualifiedMandelName[] names = new QualifiedMandelName[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            names[i] = this.getQualifiedName(indices[i]);
        }
        return new MandelTransferable(this.getList(), names);
    }

    @Override
    public void exportDone(Transferable data, int action) {
        if (debug) {
            System.out.println("action = " + action + "/" + 2);
        }
        MandelTransferable trans = (MandelTransferable)data;
        QualifiedMandelName[] names = trans.getNames();
        if (action == 2) {
            if (debug) {
                System.out.println("  remove moved items");
            }
            for (int i = names.length - 1; i >= 0; --i) {
                this.remove(names[i]);
            }
        }
    }

    @Override
    public boolean canImport(DnDTableModel.TransferSupport info) {
        if (this.isModifiable()) {
            Transferable t = info.getTransferable();
            if (info.isDataFlavorSupported(MandelTransferable.mandelFlavor)) {
                try {
                    MandelTransferable trans;
                    if (t.isDataFlavorSupported(MandelFolderTransferable.folderFlavor)) {
                        if (debug) {
                            System.out.println("enforce copy");
                        }
                        info.setDropAction(1);
                    }
                    if ((trans = (MandelTransferable)t.getTransferData(MandelTransferable.mandelFlavor)).getSource() == this.getList()) {
                        if (debug) {
                            System.out.println("drop to self");
                        }
                        info.setDropAction(1);
                    }
                    return true;
                }
                catch (UnsupportedFlavorException ex) {
                    return false;
                }
                catch (IOException ex) {
                    Logger.getLogger(AbstractMandelListTableModel.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (info.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                try {
                    String data = (String)info.getTransferable().getTransferData(DataFlavor.stringFlavor);
                    if (QualifiedMandelName.create(data) != null) {
                        return true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    @Override
    public boolean importData(DnDTableModel.TransferSupport info) {
        if (!info.isDrop()) {
            return false;
        }
        DnDTableModel.DropLocation dl = info.getDropLocation();
        boolean insert = dl.isInsertRow() || dl.isInsertColumn();
        Transferable t = info.getTransferable();
        try {
            MandelTransferable trans = (MandelTransferable)t.getTransferData(MandelTransferable.mandelFlavor);
            if (t.isDataFlavorSupported(MandelFolderTransferable.folderFlavor)) {
                if (debug) {
                    System.out.println("enforce copy");
                }
                info.setDropAction(1);
            }
            if (trans.getSource() == this.getList()) {
                if (debug) {
                    System.out.println("drop to self");
                }
                return false;
            }
            QualifiedMandelName[] data = trans.getNames();
            for (int i = 0; i < data.length; ++i) {
                this.add(data[i]);
            }
        }
        catch (Exception e) {
            try {
                String name = (String)t.getTransferData(DataFlavor.stringFlavor);
                QualifiedMandelName mn = QualifiedMandelName.create(name);
                if (mn == null) {
                    return false;
                }
                this.add(mn);
            }
            catch (Exception ex) {
                return false;
            }
        }
        return true;
    }

    protected class ClearAction
    extends AbstractAction {
        public ClearAction() {
            super("Clear");
        }

        public void actionPerformed(ActionEvent e) {
            AbstractMandelListTableModel.this.clear();
        }
    }
}

