/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class Decoration {
    protected static final int DEFAULT_INSET = 10;
    public static final int ALIGN_CENTER = 0;
    public static final int ALIGN_LEFT = -1;
    public static final int ALIGN_RIGHT = 1;
    public static final int ALIGN_TOP = -1;
    public static final int ALIGN_BOTTOM = 1;
    private static String[] fontnames = new String[]{"Brush Script MT-18", "Forte-16", "Rage Italic-16", "Chiller-18", "Script MT Bold-18", "Times New Roman-ITALIC-16"};
    protected int h_inset = 10;
    protected int v_inset = 10;
    protected int h_align = 1;
    protected int v_align = 1;
    protected String decoration = "by Uwe Kr\u00fcger";
    protected int dw;
    protected int dh;
    private Font font;
    private float size;
    private Color color = Color.WHITE;
    private boolean showDecoration;

    public static Font getAnnotationFont(Graphics g) {
        Font font = null;
        for (String name : fontnames) {
            font = Font.decode(name);
            if (font == null) continue;
            System.out.println("found font " + name);
            break;
        }
        if (font == null) {
            font = g.getFont().deriveFont(2, 16.0f);
        }
        return font;
    }

    public Decoration() {
    }

    public Decoration(String txt) {
        this.decoration = txt;
    }

    public void reset() {
        this.dh = 0;
        this.dw = 0;
    }

    public int getHAlign() {
        return this.h_align;
    }

    public void setHAlign(int h_align) {
        this.h_align = h_align;
    }

    public int getHInset() {
        return this.h_inset;
    }

    public void setHInset(int h_inset) {
        this.h_inset = h_inset;
    }

    public int getVAlign() {
        return this.v_align;
    }

    public void setVAlign(int v_align) {
        this.v_align = v_align;
    }

    public int getVInset() {
        return this.v_inset;
    }

    public void setVInset(int v_inset) {
        this.v_inset = v_inset;
    }

    public void setDecoration(String s) {
        if (s == null || this.decoration == null || !s.equals(this.decoration)) {
            this.decoration = s;
            this.reset();
        }
    }

    public String getDecoration() {
        return this.decoration;
    }

    public void setShowDecoration(boolean showDecoration) {
        this.showDecoration = showDecoration;
    }

    public boolean showDecoration() {
        return this.showDecoration && this.color.getTransparency() != 0;
    }

    public void setAlpha(int a) {
        this.color = new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), a);
    }

    public void setFontSize(float s) {
        if (this.font != null) {
            this.font = this.font.deriveFont(s);
        }
        this.size = s;
        this.reset();
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public void setFont(Font f) {
        this.font = f;
        this.size = f.getSize();
    }

    public void setFont(String f) {
        this.font = Font.decode(f);
    }

    public Font getFont() {
        return this.font;
    }

    protected int getX(int w, int h, int dw, int dh) {
        switch (this.h_align) {
            case -1: {
                return this.h_inset;
            }
            case 1: {
                return w - this.h_inset - dw;
            }
            case 0: {
                return (w - dw) / 2 + this.h_inset;
            }
        }
        throw new IllegalArgumentException("illegal horizontal alignment");
    }

    protected int getY(int w, int h, int dw, int dh) {
        switch (this.v_align) {
            case -1: {
                return this.v_inset + dh;
            }
            case 1: {
                return h - this.v_inset;
            }
            case 0: {
                System.out.println("h=" + h + ",dh=" + dh + ", inset=" + this.v_inset);
                return (h + dh) / 2 + this.v_inset;
            }
        }
        throw new IllegalArgumentException("illegal vertical alignment");
    }

    protected void draw(Graphics g, int w, int h, int dw, int dh) {
        int dx = this.getX(w, h, dw, dh);
        int dy = this.getY(w, h, dw, dh);
        g.drawString(this.decoration, dx, dy);
    }

    public void paintDecoration(Graphics g, int w, int h) {
        if (this.decoration != null) {
            this.prepare(g);
            this.setup(g);
            this.draw(g, w, h, this.dw, this.dh);
        }
    }

    public void setup(Graphics g) {
        this.prepare(g);
        g.setColor(this.color);
        g.setFont(this.font);
    }

    public void prepare(Graphics g) {
        if (this.dw == 0) {
            if (this.font == null) {
                this.font = Decoration.getAnnotationFont(g);
                if (this.size != 0.0f) {
                    this.font = this.font.deriveFont(this.size);
                } else {
                    this.size = this.font.getSize();
                }
            }
            FontMetrics metrics = g.getFontMetrics(this.font);
            this.dh = metrics.getAscent();
            this.dw = metrics.stringWidth(this.decoration);
        }
    }

    public String toString() {
        return "" + this.decoration + "(" + this.showDecoration() + ")";
    }
}

