/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool;

import com.mandelsoft.io.AbstractFile;
import com.mandelsoft.mand.ColormapName;
import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.cm.Colormap;
import com.mandelsoft.mand.scan.ColormapHandle;
import com.mandelsoft.mand.tool.ColormapListModel;
import com.mandelsoft.mand.tool.ColormapTransferable;
import com.mandelsoft.mand.tool.MandelTransferable;
import com.mandelsoft.mand.util.ColormapList;
import com.mandelsoft.swing.DnDTableModel;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import javax.swing.DropMode;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;

public class DefaultColormapListModel
extends AbstractTableModel
implements ColormapListModel {
    public static boolean debug = false;
    private ColormapList maps;
    private boolean modifiable;

    public DefaultColormapListModel(ColormapList list) {
        this.maps = list;
    }

    public void setModifiable(boolean m) {
        this.modifiable = m;
    }

    public boolean isModifiable() {
        return this.modifiable;
    }

    public ColormapList getList() {
        return this.maps;
    }

    public void refresh() {
        this.maps.refresh();
        this.fireTableDataChanged();
    }

    public boolean add(ColormapName name, Colormap cm) {
        if (this.maps.add(name, cm)) {
            this.fireTableDataChanged();
            return true;
        }
        return false;
    }

    public boolean add(ColormapName name, Colormap cm, ColormapHandle h) {
        if (this.maps.add(name, cm, h)) {
            this.fireTableDataChanged();
            return true;
        }
        return false;
    }

    public boolean remove(int index) {
        if (this.maps.remove(index) != null) {
            this.fireTableDataChanged();
            return true;
        }
        return false;
    }

    public boolean remove(ColormapName name) {
        if (this.maps.remove(name)) {
            this.fireTableDataChanged();
            return true;
        }
        return false;
    }

    public AbstractFile getFile(int index) throws IOException {
        return this.getColormapHandle(index).getFile();
    }

    public ColormapHandle getColormapHandle(int index) throws IOException {
        return this.maps.getColormapHandle(index);
    }

    public ColormapName getName(int index) {
        return this.maps.getName(index);
    }

    public Colormap getColormap(int index) throws IOException {
        return this.maps.get(index);
    }

    public int getRowCount() {
        return this.maps.size();
    }

    public int getColumnCount() {
        return 3;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.getName(rowIndex);
            }
            case 1: {
                try {
                    Colormap cm = this.getColormap(rowIndex);
                    if (cm == null) {
                        return 0;
                    }
                    return cm.getSize();
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
            case 2: {
                try {
                    ColormapHandle h = this.getColormapHandle(rowIndex);
                    if (h.getFile() == null) {
                        return "memory";
                    }
                    return "file";
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Name";
            }
            case 1: {
                return "Size";
            }
            case 2: {
                return "Type";
            }
        }
        return null;
    }

    public Class getColumnClass(int column) {
        switch (column) {
            case 0: {
                return ColormapName.class;
            }
            case 1: {
                return Integer.class;
            }
            case 2: {
                return String.class;
            }
        }
        return null;
    }

    public void addTableModelListener(TableModelListener l) {
        super.addTableModelListener(l);
    }

    public void removeTableModelListener(TableModelListener l) {
        super.removeTableModelListener(l);
    }

    public DropMode getDropMode() {
        return DropMode.INSERT_ROWS;
    }

    public int getSourceActions() {
        return 3;
    }

    public Transferable createTransferable(DnDTableModel.DragLocation loc) {
        int[] indices = loc.getSelectedRows();
        ColormapTransferable.ColormapInfo[] names = new ColormapTransferable.ColormapInfo[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            try {
                names[i] = new ColormapTransferable.ColormapInfo(this.getName(indices[i]), this.getColormap(indices[i]), this.getColormapHandle(indices[i]));
                continue;
            }
            catch (IOException io) {
                // empty catch block
            }
        }
        return new ColormapTransferable(this.getList(), names);
    }

    public void exportDone(Transferable data, int action) {
        ColormapTransferable trans;
        if (debug) {
            System.out.println("action = " + action + "/" + 2);
        }
        if ((trans = (ColormapTransferable)data).getSource() != this.getList()) {
            ColormapTransferable.ColormapInfo[] names = trans.getColormaps();
            if (action == 2) {
                for (int i = names.length - 1; i >= 0; --i) {
                    this.remove(names[i].getName());
                }
            }
        }
    }

    public boolean canImport(DnDTableModel.TransferSupport info) {
        if (this.isModifiable()) {
            if (info.isDataFlavorSupported(MandelTransferable.mandelFlavor)) {
                return true;
            }
            if (info.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                try {
                    String data = (String)info.getTransferable().getTransferData(DataFlavor.stringFlavor);
                    if (QualifiedMandelName.create(data) != null) {
                        return true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    public boolean importData(DnDTableModel.TransferSupport info) {
        if (!info.isDrop()) {
            return false;
        }
        DnDTableModel.DropLocation dl = info.getDropLocation();
        boolean insert = dl.isInsertRow() || dl.isInsertColumn();
        Transferable t = info.getTransferable();
        try {
            ColormapTransferable trans = (ColormapTransferable)t.getTransferData(ColormapTransferable.colormapFlavor);
            if (trans.getSource() == this.getList()) {
                if (debug) {
                    System.out.println("drop to self");
                }
                return false;
            }
            ColormapTransferable.ColormapInfo[] data = trans.getColormaps();
            for (int i = 0; i < data.length; ++i) {
                this.add(data[i].getName(), data[i].getColormap(), data[i].getColormapHandle());
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

