/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool;

import com.mandelsoft.io.AbstractFile;
import com.mandelsoft.mand.ColormapName;
import com.mandelsoft.mand.MandelData;
import com.mandelsoft.mand.MandelInfo;
import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.cm.Colormap;
import com.mandelsoft.mand.cm.ColormapModel;
import com.mandelsoft.mand.image.MandelImage;
import com.mandelsoft.mand.scan.MandelFolder;
import com.mandelsoft.mand.scan.MandelScanner;
import com.mandelsoft.mand.scan.MandelScannerListenerAdapter;
import com.mandelsoft.mand.tool.ColormapListModel;
import com.mandelsoft.mand.tool.ControlDialog;
import com.mandelsoft.mand.tool.ImageBaseModel;
import com.mandelsoft.mand.tool.MandelImagePanel;
import com.mandelsoft.mand.tool.MandelVariantModel;
import com.mandelsoft.mand.tool.MandelWindowAccess;
import com.mandelsoft.mand.tool.PictureSavePanel;
import com.mandelsoft.mand.tool.ToolEnvironment;
import com.mandelsoft.mand.tool.cm.ColormapDialog;
import com.mandelsoft.mand.tool.mapper.MapperControl;
import com.mandelsoft.mand.tool.mapper.MapperPanel;
import com.mandelsoft.swing.ActionPanel;
import com.mandelsoft.swing.BooleanAttribute;
import com.mandelsoft.swing.BufferedComponent;
import com.mandelsoft.swing.BufferedFrame;
import com.mandelsoft.swing.FilePanel;
import com.mandelsoft.swing.GBCPanel;
import com.mandelsoft.swing.IntegerField;
import com.mandelsoft.swing.ScaleAdapter;
import com.mandelsoft.swing.ScaleEvent;
import com.mandelsoft.swing.ScaleEventListener;
import com.mandelsoft.swing.TablePanel;
import com.mandelsoft.swing.TableSelection;
import com.mandelsoft.util.Utils;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.imageio.ImageIO;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class ImageControl
extends ControlDialog {
    private static final boolean debug = false;
    private ChangeListener listener;
    private ImageControlPanel image;
    private MappingPanel mapping;
    private ColormapsPanel colormaps;
    private DisplayPanel display;
    private PicturePanel picture;

    public ImageControl(MandelWindowAccess owner) {
        super(owner, "Image Control");
    }

    protected void setup() {
        this.listener = new ImageListener();
        this.getMandelWindowAccess().getMandelImagePane().addChangeListener(this.listener);
        this.image = new ImageControlPanel();
        this.addTab("Image", this.image);
        this.colormaps = new ColormapsPanel();
        this.addTab("Colormaps", this.colormaps);
        this.mapping = new MappingPanel();
        this.addTab("Mapping", this.mapping);
        if (!this.getEnvironment().isReadonly()) {
            this.picture = new PicturePanel();
            this.addTab("Picture", this.picture);
            this.addTab("Data", new DataPanel());
        }
        this.display = new DisplayPanel();
        this.addTab("Display", this.display);
        this.addTab("Imagebase", new ImagebasePanel());
    }

    private void updateState(MandelData md) {
        this.image.updateState();
        this.mapping.updateState();
        if (this.picture != null) {
            this.picture.updateState();
        }
    }

    private class ImagebasePanel
    extends GBCPanel {
        private IntegerField all;
        private IntegerField available;
        private IntegerField rasters;
        private IntegerField modifiableImages;
        private IntegerField requests;
        private IntegerField variants;
        private IntegerField others;
        private IntegerField colormaps;
        private IntegerField unseen;
        private IntegerField unseenRefine;
        private IntegerField refineRequests;
        private boolean shown;
        private boolean refreshPending = true;
        private EnvUpdateHandler listener;

        public ImagebasePanel() {
            int row = 0;
            int first = 0;
            this.listener = new EnvUpdateHandler();
            ToolEnvironment env = ImageControl.this.getEnvironment();
            this.addConst("Site name", env.getProperty("sitename"), row++);
            this.addConst("Site owner", env.getProperty("username"), row++);
            first = row;
            this.all = this.addField("Areas", row++);
            this.available = this.addField("Available areas", row++);
            this.rasters = this.addField("Raster images", row++);
            this.modifiableImages = this.addField("Modifiable images", row++);
            this.requests = this.addField("Pending requests", row++);
            this.others = this.addField("Others", row++);
            this.variants = this.addField("Variants", row++);
            this.colormaps = this.addField("Colormaps", row++);
            row = first;
            if (!env.isReadonly()) {
                if (env.getUnseenRasters() != null) {
                    this.unseen = this.addField("Unseen areas", 1, row++);
                }
                if (env.getUnseenRefinements() != null) {
                    this.unseenRefine = this.addField("Unseen refinements", 1, row++);
                }
                if (env.getRefinementRequests() != null) {
                    this.refineRequests = this.addField("Refinement requests", 1, row++);
                }
            }
        }

        protected void panelBound() {
            super.panelBound();
            ToolEnvironment env = ImageControl.this.getEnvironment();
            this.addComponentListener(this.listener);
            env.getImagebaseModel().addChangeListener(this.listener);
        }

        protected void panelUnbound() {
            System.out.println("unregister listener for image base");
            ToolEnvironment env = ImageControl.this.getEnvironment();
            this.removeComponentListener(this.listener);
            env.getImagebaseModel().removeChangeListener(this.listener);
            super.panelUnbound();
        }

        private IntegerField addField(String label, int row) {
            return this.addField(label, 0, row);
        }

        private IntegerField addField(String label, int col, int row) {
            JLabel c = new JLabel(label);
            this.add((Component)c, this.GBC(col * 2 + 0, row).setAnchor(17).setRightInset(10).setLeftInset(10));
            IntegerField b = new IntegerField();
            b.setColumns(12);
            b.setEditable(false);
            b.setValue(0);
            c.setLabelFor(b);
            this.add((Component)b, this.GBC(col * 2 + 1, row).setAnchor(13).setRightInset(10));
            return b;
        }

        private JTextField addConst(String label, String text, int row) {
            JLabel c = new JLabel(label);
            this.add((Component)c, this.GBC(0, row).setAnchor(17).setRightInset(10).setLeftInset(10));
            JTextField b = new JTextField();
            b.setColumns(38);
            b.setEditable(false);
            b.setText(text);
            c.setLabelFor(b);
            this.add((Component)b, this.GBC(1, row, 3, 1).setAnchor(13).setRightInset(10));
            return b;
        }

        private void update(IntegerField f, int v) {
            if (f != null && f.getValue().intValue() != v) {
                f.setValue(v);
            }
        }

        private void update() {
            ImageBaseModel model = ImageControl.this.getEnvironment().getImagebaseModel();
            this.update(this.colormaps, model.getColormaps());
            this.update(this.all, model.getAllAreas());
            this.update(this.available, model.getAvailableImages());
            this.update(this.modifiableImages, model.getModifiableImages());
            this.update(this.rasters, model.getRasters());
            this.update(this.requests, model.getRequests());
            this.update(this.variants, model.getVariants());
            this.update(this.others, model.getOthers());
            this.update(this.unseen, model.getUnseenAreas());
            this.update(this.unseenRefine, model.getUnseenRefinements());
            this.update(this.refineRequests, model.getRefinementRequests());
            this.refreshPending = false;
        }

        private class EnvUpdateHandler
        extends ComponentAdapter
        implements com.mandelsoft.util.ChangeListener {
            private EnvUpdateHandler() {
            }

            public void componentShown(ComponentEvent e) {
                ImagebasePanel.this.shown = true;
                if (ImagebasePanel.this.refreshPending) {
                    ImagebasePanel.this.update();
                }
            }

            public void componentHidden(ComponentEvent e) {
                ImagebasePanel.this.shown = false;
            }

            public void stateChanged(com.mandelsoft.util.ChangeEvent e) {
                if (ImagebasePanel.this.shown) {
                    System.out.println("image base view updated");
                    ImagebasePanel.this.update();
                } else {
                    System.out.println("cache image base view update");
                    ImagebasePanel.this.refreshPending = true;
                }
            }
        }
    }

    private class DisplayPanel
    extends ActionPanel {
        private JCheckBox decoration;
        private JCheckBox fullareanames;
        private JCheckBox tooltip;
        private JComboBox tooltipmode;
        private JComboBox selection;
        private JComboBox proportion;
        private JCheckBox parent_colormap;
        private JCheckBox autoshow_info;
        private JCheckBox automark_keyarea;
        private JCheckBox automark_fork;
        private JCheckBox automark_parent;

        DisplayPanel() {
            int row = 0;
            MandelImagePanel mp = ImageControl.this.getMandelWindowAccess().getMandelImagePane();
            this.decoration = this.createCheckbox(row++, mp.getDecorationModel());
            this.fullareanames = this.createCheckbox(row++, mp.getFullAreaNamesModel());
            this.parent_colormap = this.createCheckbox(row++, mp.getParentColormapModel());
            this.autoshow_info = this.createCheckbox(row++, mp.getAutoShowInfoModel());
            this.automark_keyarea = this.createCheckbox(row++, mp.getAutoMarkKeyAreaModel());
            this.automark_fork = this.createCheckbox(row++, mp.getAutoMarkForkModel());
            this.automark_parent = this.createCheckbox(row++, mp.getAutoMarkParentModel());
            this.tooltip = this.createCheckbox(row++, mp.getPixelToolTipModel());
            this.tooltipmode = this.createCombobox(row++, "Tooltip Mode", mp.getToolTipSelectionModel());
            if (!ImageControl.this.getMandelWindowAccess().getEnvironment().isReadonly()) {
                this.selection = this.createCombobox(row++, "Sub Area Selection", mp.getAreaSelectorModel());
                this.selection.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        BufferedComponent.RectangleSelector s = ImageControl.this.getMandelWindowAccess().getMandelImagePane().getImagePane().getRectangleSelector();
                        if (s != null) {
                            DisplayPanel.this.proportion.setEnabled(s instanceof BufferedComponent.ProportionalRectangleSelector);
                        }
                    }
                });
                this.proportion = this.createCombobox(row++, "Selection Proportion", mp.getProportionSelectionModel());
            }
        }

        private JCheckBox createCheckbox(int row, BooleanAttribute attr) {
            return this.createCheckbox(row, attr.getLabel(), attr);
        }

        private JCheckBox createCheckbox(int row, String label, ButtonModel model) {
            JLabel c = new JLabel(label);
            this.addContent(c, this.GBC(0, row).setAnchor(17));
            JCheckBox b = new JCheckBox();
            b.setModel(model);
            c.setLabelFor(b);
            this.addContent(b, this.GBC(1, row).setAnchor(10));
            return b;
        }

        private JComboBox createCombobox(int row, String label, ComboBoxModel model) {
            JLabel c = new JLabel(label);
            this.addContent(c, this.GBC(0, row).setAnchor(17).setRightInset(5));
            JComboBox b = new JComboBox();
            b.setModel(model);
            c.setLabelFor(b);
            this.addContent(b, this.GBC(1, row).setFill(2));
            return b;
        }
    }

    private class MappingPanel
    extends ActionPanel {
        private JComboBox resizemode;
        private MapperPanel mapper;

        public MappingPanel() {
            int row = 0;
            JLabel c = new JLabel("Colormap resize mode");
            this.addContent(c, this.GBC(0, row).setAnchor(17));
            this.resizemode = new JComboBox<ColormapModel.ResizeMode>(ColormapModel.ResizeMode.values());
            this.resizemode.setRenderer(new DefaultListCellRenderer(){

                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    this.setText(((ColormapModel.ResizeMode)((Object)value)).getName());
                    return this;
                }
            });
            this.resizemode.setEditable(false);
            this.resizemode.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JComboBox cb = (JComboBox)e.getSource();
                    ImageControl.this.getMandelWindowAccess().getColormapModel().setResizeMode((ColormapModel.ResizeMode)((Object)cb.getSelectedItem()));
                }
            });
            this.updateState();
            this.addContent(this.resizemode, this.GBC(1, row++).setFill(2).setInsets(5));
            this.mapper = new MapperPanel(ImageControl.this.getMandelWindowAccess().getMapperModel());
            this.addContent(this.mapper, this.GBC(0, row++, 2, 1).setLayout(1, 11).setWeight(100.0, 100.0));
            this.addButton("Remap", new RemapAction());
        }

        public void updateState() {
            if (ImageControl.this.getMandelWindowAccess().getColormapModel().getResizeMode() != null) {
                this.resizemode.setSelectedItem((Object)ImageControl.this.getMandelWindowAccess().getColormapModel().getResizeMode());
            }
        }

        private class RemapAction
        implements ActionListener {
            private RemapAction() {
            }

            public void actionPerformed(ActionEvent e) {
                ImageControl.this.getMandelWindowAccess().getMandelImage().setMapper(ImageControl.this.getMandelWindowAccess().getColormapModel().getResizeMode(), MappingPanel.this.mapper.getMapperModel().getMapper());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ColormapsPanel
    extends TablePanel<ColormapListModel> {
        private FilePanel filename;
        private ColormapListModel model;

        public ColormapsPanel() {
            this.model = ImageControl.this.getEnvironment().getColormapListModel();
            this.setModel(this.model);
            this.addActionListener(new ActivateAction());
            JLabel c = new JLabel("s");
            FontMetrics m = c.getFontMetrics(c.getFont());
            TableColumn col = this.getTable().getColumnModel().getColumn(1);
            col.setPreferredWidth(m.charWidth('W') * 10);
            col.setMaxWidth(m.charWidth('W') * 10);
            col = this.getTable().getColumnModel().getColumn(2);
            col.setPreferredWidth(m.charWidth('W') * 6);
            col.setMaxWidth(m.charWidth('W') * 6);
            DefaultTableCellRenderer r = new DefaultTableCellRenderer();
            r.setHorizontalAlignment(0);
            col.setCellRenderer(r);
            this.filename = new FilePanel("Colormap File", "", new FileNameExtensionFilter("Colormaps", "cm"), this.getWindow());
            this.filename.setEnableChooser(!ImageControl.this.getEnvironment().isReadonly());
            this.addContent(this.filename, this.GBC(0, 2));
            this.addButton("Refresh", new RefreshAction());
            this.addButton("Memorize", new MemorizeAction());
            this.addButton("Remove", new RemoveAction());
            if (!ImageControl.this.getEnvironment().isReadonly()) {
                this.addButton("Save", new SaveAction());
            }
            this.addButton("Load", new LoadAction());
            if (!ImageControl.this.getEnvironment().isReadonly()) {
                this.addButton("Delete", new DeleteAction());
            }
            this.addButton("Show", new ShowAction());
        }

        @Override
        protected void setSelection(TableSelection sel) {
            try {
                AbstractFile file = ((ColormapListModel)this.getModel()).getFile(sel.getLeadSelection());
                if (file == null) {
                    this.filename.setFilename(((ColormapListModel)this.getModel()).getName(sel.getLeadSelection()).getName());
                } else {
                    this.filename.setFilename(file.toString());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private class ShowAction
        implements ActionListener {
            private ShowAction() {
            }

            public void actionPerformed(ActionEvent e) {
                block7: {
                    if (Utils.isEmpty(ColormapsPanel.this.filename.getFilename())) {
                        return;
                    }
                    try {
                        AbstractFile mf = ImageControl.this.getMandelWindowAccess().getEnvironment().createMandelFile(ColormapsPanel.this.filename.getFilename());
                        MandelData md = new MandelData(mf);
                        if (md.getColormap() != null) {
                            this.show(md.getColormap());
                        }
                    }
                    catch (IOException ex) {
                        if (ColormapsPanel.this.getSelectedIndex() >= 0) {
                            try {
                                this.show(((ColormapListModel)ColormapsPanel.this.getModel()).getColormap(ColormapsPanel.this.getSelectedIndex()));
                                ex = null;
                            }
                            catch (IOException ex1) {
                                ex = ex1;
                            }
                        }
                        if (ex == null) break block7;
                        JOptionPane.showMessageDialog(ColormapsPanel.this.getOwner(), "Cannot read colormap: " + ex.toString(), "Colormap IO", 2);
                    }
                }
            }

            private void show(Colormap cm) {
                ColormapDialog d = new ColormapDialog(ImageControl.this.getMandelWindowAccess(), ColormapsPanel.this.filename.getFilename(), cm, false);
                d.setDefaultCloseOperation(2);
                d.setVisible(true);
            }
        }

        private class RemoveAction
        implements ActionListener {
            private RemoveAction() {
            }

            public void actionPerformed(ActionEvent e) {
                int index = ColormapsPanel.this.getSelectedIndex();
                if (index < 0) {
                    return;
                }
                if (!((ColormapListModel)ColormapsPanel.this.getModel()).remove(index)) {
                    JOptionPane.showMessageDialog(ColormapsPanel.this.getOwner(), "colormap cannot be removed from list", "Colormap List", 2);
                }
            }
        }

        private class MemorizeAction
        implements ActionListener {
            private MemorizeAction() {
            }

            public void actionPerformed(ActionEvent e) {
                if (Utils.isEmpty(ColormapsPanel.this.filename.getFilename())) {
                    return;
                }
                Colormap cm = ImageControl.this.getMandelWindowAccess().getMandelData().getColormap();
                if (cm != null) {
                    cm = new Colormap(cm);
                    this.add(this.extract(ColormapsPanel.this.filename), cm);
                }
            }

            private void add(String name, Colormap cm) {
                ColormapListModel m = (ColormapListModel)ColormapsPanel.this.getModel();
                int suf = 0;
                String eff = name;
                while (!m.add(new ColormapName(eff), cm)) {
                    eff = name + "." + ++suf;
                }
            }

            private String extract(FilePanel filename) {
                String n = new File(filename.getFilename()).getName();
                if (n.endsWith(".cm")) {
                    n = n.substring(0, n.length() - ".cm".length());
                }
                return n;
            }
        }

        private class DeleteAction
        implements ActionListener {
            private DeleteAction() {
            }

            public void actionPerformed(ActionEvent e) {
                if (Utils.isEmpty(ColormapsPanel.this.filename.getFilename())) {
                    return;
                }
                File f = new File(ColormapsPanel.this.filename.getFilename());
                if (!f.exists()) {
                    ImageControl.this.mandelError("File does not exist.");
                    return;
                }
                if (!ImageControl.this.deleteFileDialog(f)) {
                    return;
                }
                try {
                    MandelFolder.Util.delete(f);
                    if (f.exists()) {
                        ImageControl.this.mandelError("Cannot delete " + f + ".");
                        return;
                    }
                }
                catch (IOException ex) {
                    ImageControl.this.mandelError("Cannot delete " + f + ": " + ex);
                    return;
                }
                ((ColormapListModel)ColormapsPanel.this.getModel()).refresh();
            }
        }

        private class LoadAction
        implements ActionListener {
            private LoadAction() {
            }

            public void actionPerformed(ActionEvent e) {
                if (Utils.isEmpty(ColormapsPanel.this.filename.getFilename())) {
                    return;
                }
                try {
                    AbstractFile mf = ImageControl.this.getMandelWindowAccess().getEnvironment().createMandelFile(ColormapsPanel.this.filename.getFilename());
                    MandelData md = new MandelData(mf);
                    if (md.getColormap() != null) {
                        ImageControl.this.getMandelWindowAccess().getColormapModel().setColormap(md.getColormap());
                    }
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(ColormapsPanel.this.getOwner(), "Cannot read colormap: " + ex.toString(), "Colormap IO", 2);
                }
            }
        }

        private class SaveAction
        implements ActionListener {
            private SaveAction() {
            }

            public void actionPerformed(ActionEvent e) {
                if (Utils.isEmpty(ColormapsPanel.this.filename.getFilename())) {
                    return;
                }
                Colormap cm = ImageControl.this.getMandelWindowAccess().getMandelData().getColormap();
                if (cm != null) {
                    MandelData d = new MandelData(cm);
                    File f = new File(ColormapsPanel.this.filename.getFilename());
                    if (f.exists() && !ImageControl.this.overwriteFileDialog(f)) {
                        return;
                    }
                    try {
                        d.write(f);
                        MandelFolder.Util.add(f);
                        ((ColormapListModel)ColormapsPanel.this.getModel()).refresh();
                    }
                    catch (IOException ex) {
                        JOptionPane.showMessageDialog(ColormapsPanel.this.getOwner(), "Cannot write colormap: " + ex.toString(), "Colormap IO", 2);
                    }
                }
            }
        }

        private class ActivateAction
        implements ActionListener {
            private ActivateAction() {
            }

            public void actionPerformed(ActionEvent e) {
                int index = ColormapsPanel.this.getSelectedIndex();
                if (index < 0) {
                    return;
                }
                try {
                    Colormap cm = ((ColormapListModel)ColormapsPanel.this.getModel()).getColormap(index);
                    if (cm != null) {
                        ImageControl.this.getMandelWindowAccess().getColormapModel().setColormap(new Colormap(cm));
                    }
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(ColormapsPanel.this.getOwner(), "Cannot get colormap: " + ex.toString(), "Colormap IO", 2);
                }
            }
        }

        private class RefreshAction
        implements ActionListener {
            private RefreshAction() {
            }

            public void actionPerformed(ActionEvent e) {
                ((ColormapListModel)ColormapsPanel.this.getModel()).refresh();
            }
        }
    }

    private class DataPanel
    extends ActionPanel {
        private FilePanel datafile;

        public DataPanel() {
            ToolEnvironment env = ImageControl.this.getEnvironment();
            String n = env.getProperty("path.bitmap.save");
            this.datafile = new FilePanel("Data file", "", (JFrame)this.getOwner());
            if (n != null) {
                n = n + "/mandeldata";
                this.datafile.setFilename(n);
            }
            this.addContent(this.datafile, this.GBC(0, 0, 2, 1).setLayout(1, 11).setWeight(100.0, 100.0).setInsets(10, 10, 10, 10));
            this.addButton("Add", new AddAction(), "Add mandel coordinates to data file");
        }

        private class AddAction
        implements ActionListener {
            private AddAction() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent e) {
                if (Utils.isEmpty(DataPanel.this.datafile.getFilename())) {
                    return;
                }
                BufferedImage im = ImageControl.this.getMandelWindowAccess().getMandelImage().getImage();
                if (im != null) {
                    String name = DataPanel.this.datafile.getFilename();
                    File f = new File(name);
                    if (f.exists() && !ImageControl.this.overwriteFileDialog(f)) {
                        return;
                    }
                    try {
                        boolean h = !f.exists();
                        PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(f, true)));
                        try {
                            MandelInfo mi = ImageControl.this.getMandelWindowAccess().getMandelData().getInfo();
                            if (h) {
                                pw.printf("%-20s  %30s %30s %20s %20s %7s %7s\n", "Name", "XM", "YM", "DX", "DY", "MinIt", "MaxIt");
                            }
                            pw.printf("%-20s: %30s %30s %20s %20s %7s %7s\n", ImageControl.this.getMandelWindowAccess().getQualifiedName(), mi.getXM(), mi.getYM(), mi.getDX(), mi.getDY(), mi.getMinIt(), mi.getMaxIt());
                        }
                        finally {
                            pw.close();
                        }
                    }
                    catch (IOException ex) {
                        JOptionPane.showMessageDialog(DataPanel.this.getOwner(), "Cannot write data: " + ex.toString(), "Data IO", 2);
                    }
                }
            }
        }
    }

    private class PicturePanel
    extends PictureSavePanel {
        public PicturePanel() {
            this.addButton("Save", new SaveImageAction(), "Save picture file");
            this.addButton("Clear", new PictureSavePanel.ClearAction(this), "Clear file name");
            this.addButton("Path", new PathAction(), "Generate picture path name");
            this.addButton("Name", new NameAction(), "Generate picture file name");
        }

        public MandelWindowAccess getMandelWindowAccess() {
            return ImageControl.this.getMandelWindowAccess();
        }

        private class NameAction
        extends PathAction {
            private NameAction() {
            }

            public void actionPerformed(ActionEvent e) {
                String old = PicturePanel.this.imagefile.getFilename();
                if (Utils.isEmpty(old)) {
                    super.actionPerformed(e);
                } else {
                    ToolEnvironment env = PicturePanel.this.getEnvironment();
                    QualifiedMandelName mn = PicturePanel.this.getMandelWindowAccess().getQualifiedName();
                    String n = new File(old).getParent();
                    n = n != null && n.length() > 0 ? n + "/" + mn.toString() : mn.toString();
                    PicturePanel.this.imagefile.setFilename(n);
                }
            }
        }

        private class PathAction
        implements ActionListener {
            private PathAction() {
            }

            public void actionPerformed(ActionEvent e) {
                ToolEnvironment env = PicturePanel.this.getEnvironment();
                QualifiedMandelName mn = PicturePanel.this.getMandelWindowAccess().getQualifiedName();
                String n = env.getProperty("path.bitmap.save");
                n = n != null && n.length() > 0 ? n + "/" + mn.toString() : mn.toString();
                PicturePanel.this.imagefile.setFilename(n);
            }
        }

        private class SaveImageAction
        implements ActionListener {
            private SaveImageAction() {
            }

            public void actionPerformed(ActionEvent e) {
                BufferedImage tmp = null;
                Graphics g = null;
                if (Utils.isEmpty(PicturePanel.this.imagefile.getFilename())) {
                    return;
                }
                BufferedImage im = PicturePanel.this.getMandelWindowAccess().getMandelImage().getImage();
                if (im != null) {
                    File f;
                    int w;
                    String name = PicturePanel.this.imagefile.getFilename();
                    String fmt = (String)PicturePanel.this.formats.getSelectedItem();
                    try {
                        w = PicturePanel.this.width.getValue().intValue();
                    }
                    catch (Exception ex) {
                        w = 0;
                    }
                    if (w != 0) {
                        int h = w * im.getHeight() / im.getWidth();
                        tmp = new BufferedImage(w, h, 1);
                        g = tmp.getGraphics();
                        g.drawImage(im, 0, 0, w, h, null);
                        im = tmp;
                    }
                    if (PicturePanel.this.decorationButton.isSelected()) {
                        if (tmp == null) {
                            tmp = new BufferedImage(im.getWidth(), im.getHeight(), 1);
                            g = tmp.getGraphics();
                            g.drawImage(im, 0, 0, null);
                            im = tmp;
                        }
                        if (g == null) {
                            g = im.getGraphics();
                        }
                        PicturePanel.this.getMandelWindowAccess().getMandelImagePane().paintDecoration(g, im.getWidth(), im.getHeight());
                    }
                    if (!name.endsWith("." + fmt)) {
                        name = name + "." + fmt;
                    }
                    if ((f = new File(name)).exists() && !ImageControl.this.overwriteFileDialog(f)) {
                        return;
                    }
                    if (!f.getParentFile().exists()) {
                        JOptionPane.showMessageDialog(PicturePanel.this.getOwner(), "Cannot write image: directory not found", "Image IO", 2);
                    } else {
                        try {
                            ImageIO.write((RenderedImage)im, (String)PicturePanel.this.formats.getSelectedItem(), f);
                        }
                        catch (Exception ex) {
                            JOptionPane.showMessageDialog(PicturePanel.this.getOwner(), "Cannot write image: " + ex.toString(), "Image IO", 2);
                        }
                    }
                }
            }
        }
    }

    private class ImageControlPanel
    extends ActionPanel
    implements Updatable {
        private MandelVariantModel vmodel;
        private JComboBox variants;
        private IntegerField colmapsize;
        private IntegerField scale;
        private MapperControl mapper;
        private JTextField mappingtype;
        private boolean adjusting;
        private UpdateHandler listener;

        public ImageControlPanel() {
            int row = 0;
            this.listener = new UpdateHandler(this);
            JLabel c = new JLabel("Variants");
            this.vmodel = new MandelVariantModel(ImageControl.this.getEnvironment().getImageDataScanner());
            this.addContent(c, this.GBC(0, row).setAnchor(17));
            this.variants = new JComboBox(this.vmodel);
            this.variants.setEditable(false);
            this.addContent(this.variants, this.GBC(1, row++).setFill(2).setTopInset(5));
            this.vmodel.addChangeListener(new VariantListener());
            c = new JLabel("Current colormap size");
            this.addContent(c, this.GBC(0, row).setAnchor(17));
            this.colmapsize = new IntegerField();
            this.colmapsize.setColumns(10);
            this.colmapsize.setMinimumNumber(100);
            this.colmapsize.setEditable(false);
            this.colmapsize.addPropertyChangeListener("value", new ResizeListener());
            this.addContent(this.colmapsize, this.GBC(1, row++).setInsets(5));
            c = new JLabel("Scaling (%)");
            this.addContent(c, this.GBC(0, row).setAnchor(17).setInsets(0, 0, 5, 0));
            this.scale = new IntegerField();
            this.scale.setColumns(10);
            this.scale.setEditable(false);
            ScaleListener sl = new ScaleListener();
            this.scale.addPropertyChangeListener("value", sl);
            this.addContent(this.scale, this.GBC(1, row++).setInsets(0, 5, 5, 5));
            ImageControl.this.getMandelWindowAccess().getMandelImagePane().getImagePane().addScaleEventListener(sl);
            c = new JLabel("Mapping type");
            this.addContent(c, this.GBC(0, row).setAnchor(17).setInsets(0, 0, 5, 0));
            this.mappingtype = new JTextField();
            this.mappingtype.setColumns(10);
            this.mappingtype.setEditable(false);
            this.mappingtype.setHorizontalAlignment(4);
            this.addContent(this.mappingtype, this.GBC(1, row++).setInsets(5));
            this.mapper = new MapperControl((GBCPanel)this.getContentPane(), 0, row++);
            this.mapper.addChangeListener(new RemapListener());
        }

        protected void panelBound() {
            super.panelBound();
            ImageControl.this.getEnvironment().getImageDataScanner().addMandelScannerListener(this.listener);
        }

        protected void panelUnbound() {
            System.out.println("unregister scanner listener for variants");
            ImageControl.this.getEnvironment().getImageDataScanner().removeMandelScannerListener(this.listener);
            super.panelUnbound();
        }

        public void updateState() {
            boolean editable = false;
            MandelWindowAccess acc2 = ImageControl.this.getMandelWindowAccess();
            this.adjusting = true;
            MandelImage image = acc2.getMandelImage();
            if (image != null) {
                editable = image.getRasterData() != null && image.getMapper() != null;
            }
            int s = acc2.getColormapModel().getSize();
            this.colmapsize.setValue(s);
            this.colmapsize.setEditable(editable);
            MandelImage img = acc2.getMandelImage();
            if (img != null) {
                this.mapper.setMapper(img.getMapper());
                this.mapper.setEditable(editable);
                if (img.getMapping() != null) {
                    this.mappingtype.setText(img.getMapping().getType());
                } else {
                    this.mappingtype.setText("none");
                }
            } else {
                this.mappingtype.setText("none");
            }
            this.scale.setValue(Math.round(acc2.getMandelImagePane().getImagePane().getScale() * 100.0));
            this.scale.setEditable(editable);
            this.vmodel.refresh(acc2.getQualifiedName(), acc2.getMandelData().getOrigHeader());
            this.adjusting = false;
        }

        private class VariantListener
        implements ChangeListener {
            private VariantListener() {
            }

            public void stateChanged(ChangeEvent e) {
                if (!ImageControlPanel.this.adjusting) {
                    ImageControlPanel.this.adjusting = true;
                    ImageControl.this.getMandelWindowAccess().getMandelImagePane().setImage(ImageControlPanel.this.vmodel.getVariantHandle());
                    ImageControlPanel.this.adjusting = false;
                }
            }
        }

        private class RemapListener
        implements ChangeListener {
            private RemapListener() {
            }

            public void stateChanged(ChangeEvent e) {
                if (!ImageControlPanel.this.adjusting) {
                    ImageControlPanel.this.adjusting = true;
                    ImageControl.this.getMandelWindowAccess().getMandelImage().setMapper(ImageControl.this.getMandelWindowAccess().getColormapModel().getResizeMode(), ImageControlPanel.this.mapper.getMapperModel().getMapper());
                    ImageControlPanel.this.adjusting = false;
                }
            }
        }

        private class ScaleListener
        extends ScaleAdapter
        implements PropertyChangeListener,
        ScaleEventListener {
            private ScaleListener() {
            }

            public void propertyChange(PropertyChangeEvent evt) {
                if (!ImageControlPanel.this.adjusting) {
                    double s = ((Integer)evt.getNewValue()).intValue();
                    if (s <= 0.0) {
                        s = 1.0;
                    }
                    ((BufferedFrame)((Object)ImageControl.this.getMandelWindowAccess())).getImagePane().setScale(s / 100.0);
                }
            }

            public void componentScaled(ScaleEvent e) {
                ImageControlPanel.this.adjusting = true;
                ImageControlPanel.this.scale.setValue(Math.round(e.getScaleX() * 100.0));
                ImageControlPanel.this.adjusting = false;
            }
        }

        private class ResizeListener
        implements PropertyChangeListener {
            private ResizeListener() {
            }

            public void propertyChange(PropertyChangeEvent evt) {
                if (!ImageControlPanel.this.adjusting) {
                    ImageControl.this.getMandelWindowAccess().getMandelImage().resizeColormap(ImageControl.this.getMandelWindowAccess().getColormapModel().getResizeMode(), ImageControlPanel.this.colmapsize.getValue().intValue());
                }
            }
        }
    }

    private static class UpdateHandler
    extends MandelScannerListenerAdapter {
        private Updatable upd;

        public UpdateHandler(Updatable upd) {
            this.upd = upd;
        }

        public void scannerChanged(MandelScanner s) {
            this.upd.updateState();
        }
    }

    private static interface Updatable {
        public void updateState();
    }

    private class ImageListener
    implements ChangeListener {
        private ImageListener() {
        }

        public void stateChanged(ChangeEvent e) {
            ImageControl.this.updateState(((MandelImagePanel)e.getSource()).getMandelData());
        }
    }
}

