/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool;

import com.mandelsoft.mand.Environment;
import com.mandelsoft.mand.IllegalConfigurationException;
import com.mandelsoft.mand.MandelData;
import com.mandelsoft.mand.MandelName;
import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.cm.ColormapModel;
import com.mandelsoft.mand.image.MandelAreaImage;
import com.mandelsoft.mand.image.MandelImage;
import com.mandelsoft.mand.tool.History;
import com.mandelsoft.mand.tool.MandelImagePanel;
import com.mandelsoft.mand.tool.MandelWindowAccess;
import com.mandelsoft.mand.tool.ToolEnvironment;
import com.mandelsoft.mand.tool.mapper.MapperModel;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.SplashScreen;
import java.awt.Window;
import java.io.IOException;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class MandelImageFrame
extends JFrame
implements MandelWindowAccess {
    public static boolean debug = false;
    private MandelImagePanel panel;

    public MandelImageFrame(ToolEnvironment env, MandelAreaImage img) throws IOException {
        this.setup(new MandelImagePanel(env, img));
    }

    public MandelImageFrame(ToolEnvironment env, MandelAreaImage img, int maxx) throws IOException {
        this.setup(new MandelImagePanel(env, img, maxx));
    }

    private void setup(MandelImagePanel panel) {
        this.panel = panel;
        this.add(panel);
        this.pack();
        this.setVisible(true);
        this.loadFrameIcon();
    }

    public ColormapModel getColormapModel() {
        return this.panel.getColormapModel();
    }

    public ToolEnvironment getEnvironment() {
        return this.panel.getEnvironment();
    }

    public Window getMandelWindow() {
        return this;
    }

    public MandelData getMandelData() {
        return this.panel.getMandelData();
    }

    public MandelImage getMandelImage() {
        return this.panel.getMandelImage();
    }

    public MandelName getMandelName() {
        return this.panel.getMandelName();
    }

    public MapperModel getMapperModel() {
        return this.panel.getMapperModel();
    }

    public QualifiedMandelName getQualifiedName() {
        return this.panel.getQualifiedName();
    }

    public MandelImagePanel getMandelImagePane() {
        return this.panel;
    }

    public History getHistory() {
        return this.panel.getHistory();
    }

    private void loadFrameIcon() {
        URL imgUrl = null;
        ImageIcon imgIcon = null;
        imgUrl = MandelImageFrame.class.getResource("resc/mand.gif");
        imgIcon = new ImageIcon(imgUrl);
        Image img = imgIcon.getImage();
        this.setIconImage(img);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            ToolEnvironment env;
            SplashScreen sp = SplashScreen.getSplashScreen();
            try {
                sp.setImageURL(Environment.class.getResource("resc/splash.png"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            ToolEnvironment toolEnvironment = env = new ToolEnvironment(args);
            synchronized (toolEnvironment) {
                try {
                    MandelImageFrame.createWindow(env);
                }
                catch (IllegalArgumentException ia) {
                    System.out.println("illegal mandel name");
                }
            }
        }
        catch (IllegalConfigurationException ex) {
            System.out.println("illegal config: " + ex);
        }
    }

    static void createWindow(final ToolEnvironment env) {
        EventQueue.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ToolEnvironment toolEnvironment = env;
                synchronized (toolEnvironment) {
                    try {
                        MandelAreaImage img = env.getMandelImage(env.getInitialName());
                        MandelImageFrame frame = new MandelImageFrame(env, img);
                        frame.setDefaultCloseOperation(3);
                        frame.setVisible(true);
                    }
                    catch (IOException io) {
                        System.out.println("cannot read image");
                    }
                }
            }
        });
    }
}

