/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool;

import com.mandelsoft.io.AbstractFile;
import com.mandelsoft.io.FileAbstractFile;
import com.mandelsoft.mand.Environment;
import com.mandelsoft.mand.Environment1;
import com.mandelsoft.mand.IllegalConfigurationException;
import com.mandelsoft.mand.MandelData;
import com.mandelsoft.mand.MandelInfo;
import com.mandelsoft.mand.MandelName;
import com.mandelsoft.mand.MandelRaster;
import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.cm.Colormap;
import com.mandelsoft.mand.cm.ColormapModel;
import com.mandelsoft.mand.cm.ColormapSource;
import com.mandelsoft.mand.image.ImageListener;
import com.mandelsoft.mand.image.MandelAreaImage;
import com.mandelsoft.mand.image.MandelImage;
import com.mandelsoft.mand.scan.ElementHandle;
import com.mandelsoft.mand.scan.MandelFolder;
import com.mandelsoft.mand.scan.MandelHandle;
import com.mandelsoft.mand.scan.MandelScanner;
import com.mandelsoft.mand.scan.MandelScannerListener;
import com.mandelsoft.mand.scan.MandelScannerListenerAdapter;
import com.mandelsoft.mand.tool.AboutBox;
import com.mandelsoft.mand.tool.ComposedMandelListFolderTreeModel;
import com.mandelsoft.mand.tool.Decoration;
import com.mandelsoft.mand.tool.DefaultMandelListFolderTreeModel;
import com.mandelsoft.mand.tool.DefaultMandelListListModel;
import com.mandelsoft.mand.tool.GotoDialog;
import com.mandelsoft.mand.tool.History;
import com.mandelsoft.mand.tool.ImageControl;
import com.mandelsoft.mand.tool.IterationPathDialog;
import com.mandelsoft.mand.tool.JuliaDialog;
import com.mandelsoft.mand.tool.LinkListener;
import com.mandelsoft.mand.tool.MandelAreaCreationDialog;
import com.mandelsoft.mand.tool.MandelAreaViewDialog;
import com.mandelsoft.mand.tool.MandelBrowserDialog;
import com.mandelsoft.mand.tool.MandelImageAreaDialog;
import com.mandelsoft.mand.tool.MandelImageRecalcDialog;
import com.mandelsoft.mand.tool.MandelListDialog;
import com.mandelsoft.mand.tool.MandelListFolderTreeModel;
import com.mandelsoft.mand.tool.MandelListGaleryDialog;
import com.mandelsoft.mand.tool.MandelListMenu;
import com.mandelsoft.mand.tool.MandelListModel;
import com.mandelsoft.mand.tool.MandelListModelMenu;
import com.mandelsoft.mand.tool.MandelListTableModel;
import com.mandelsoft.mand.tool.MandelListsDialog;
import com.mandelsoft.mand.tool.MandelNameSelector;
import com.mandelsoft.mand.tool.MandelSubAreaCreationDialog;
import com.mandelsoft.mand.tool.MandelVariationCreationDialog;
import com.mandelsoft.mand.tool.MandelWindowAccess;
import com.mandelsoft.mand.tool.ToolEnvironment;
import com.mandelsoft.mand.tool.ToolUtils;
import com.mandelsoft.mand.tool.cm.ColormapDialog;
import com.mandelsoft.mand.tool.mapper.MapperModel;
import com.mandelsoft.mand.tool.slideshow.DefaultSlideShowModel;
import com.mandelsoft.mand.tool.slideshow.SlideShowDestination;
import com.mandelsoft.mand.tool.slideshow.SlideShowModel;
import com.mandelsoft.mand.tool.slideshow.SlideShowSourceAdapter;
import com.mandelsoft.mand.util.ArrayMandelList;
import com.mandelsoft.mand.util.CachedUpstreamColormapSource;
import com.mandelsoft.mand.util.MandArith;
import com.mandelsoft.mand.util.MandUtils;
import com.mandelsoft.mand.util.MandelColormapCache;
import com.mandelsoft.mand.util.MandelList;
import com.mandelsoft.mand.util.MemoryMandelListFolderTree;
import com.mandelsoft.swing.AbstractListDataListener;
import com.mandelsoft.swing.BooleanAttribute;
import com.mandelsoft.swing.BufferedComponent;
import com.mandelsoft.swing.ChangeListenerSupport;
import com.mandelsoft.swing.Corner;
import com.mandelsoft.swing.Dimensions;
import com.mandelsoft.swing.GBCPanel;
import com.mandelsoft.swing.OptionalAction;
import com.mandelsoft.swing.ProportionProvider;
import com.mandelsoft.swing.RectanglePoint;
import com.mandelsoft.swing.RenderedComponent;
import com.mandelsoft.swing.RenewStateListener;
import com.mandelsoft.swing.ScaleAdapter;
import com.mandelsoft.swing.ScaleEvent;
import com.mandelsoft.swing.UpdatableAction;
import com.mandelsoft.swing.UpdatableJMenu;
import com.mandelsoft.swing.UpdatableJMenuItem;
import com.mandelsoft.swing.UpdatableJPopupMenu;
import com.mandelsoft.swing.WindowControlAction;
import com.mandelsoft.util.ChangeEvent;
import com.mandelsoft.util.Utils;
import com.mandelsoft.util.upd.BooleanUpdateCondition;
import com.mandelsoft.util.upd.UpdatableObject;
import com.mandelsoft.util.upd.UpdateContext;
import com.mandelsoft.util.upd.UpdateReason;
import com.mandelsoft.util.upd.UpdateSource;
import com.mandelsoft.util.upd.UpdateSourceSupport;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.BevelBorder;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;

public class MandelImagePanel
extends GBCPanel
implements MandelWindowAccess,
UpdateSource {
    public static boolean debug = false;
    public static boolean debugHL = false;
    public static boolean iterPathActive = false;
    private static BasicStroke dashed = new BasicStroke(1.0f, 1, 1, 10.0f, new float[]{4.0f, 4.0f}, 0.0f);
    private static BasicStroke favorite = new BasicStroke(2.0f, 1, 1);
    private AreaProportionProvider imagepropprov = new AreaProportionProvider();
    private AreaProportionProvider creatpropprov = new CreationDialogProportionProvider();
    private Buffer buffer;
    private double filterscale = 1.0;
    private double maxx = 0.0;
    private ToolEnvironment env;
    private boolean showSubMode;
    private ChangeListenerSupport listeners = new ChangeListenerSupport();
    private ExplicitHighlight lastname;
    private Mark marked;
    private ExplicitHighlights explicitHighlights;
    private QualifiedMandelName name;
    private MandelListMenu subareas;
    private MandelListModelMenu links;
    private JMenu linkhist;
    private JPopupMenu linkhistpopup;
    private LinkListener linkListener;
    private MandelListModel keyareas;
    private MandelListModelMenu keyareasmenu;
    private MandelListModelMenu keyareaspopupmenu;
    private MandelImage image;
    private MapperModel mappermodel;
    private ColormapModel colormapmodel;
    private Colormap defcolormap;
    private Environment1.FileInfo fileinfo;
    private History history;
    private MandelSubAreaCreationDialog create;
    private ColormapDialog colormapDialog;
    private ImageControl imageDialog;
    private MandelListsDialog listsDialog;
    private JuliaDialog juliaDialog;
    private IterationPathDialog iterDialog;
    private ImageListener imageListener;
    private List<ListModifierMenu> listModifiers;
    private Action parentAction;
    private Action areaUpAction;
    private Action forkAction;
    private Action showSubAction;
    private Action hideSubAction;
    private Action refreshSubAction;
    private Action showColormapAction;
    private Action showMetaAction;
    private Action variationAction;
    private Action linksGaleryAction;
    private Action keyareasGaleryAction;
    private Action zoomGaleryAction;
    private Action cloneAction;
    private Action gotoAction;
    private Action saveAction;
    private Action areaCMSaveAction;
    private Action areaCMDeleteAction;
    private Action areaCMAction;
    private Action showListsControlAction;
    private Action showJuliaAction;
    private Action showIterationPathAction;
    private Action areaDownAction;
    private int highlight_mode = 1;
    private static final int H_NONE = 0;
    private static final int H_FAVORITES = 1;
    private static final int H_UNSEEN = 2;
    private static final int H_LAST = 3;
    private JScrollPane scrollpane;
    private MandelAreaImage initialImage;
    private boolean partial;
    private SlideShowModel slideshowmodel;
    private AreaSelectionModel selector;
    private ProportionSelectionModel proportion;
    private ToolTipSelectionModel tooltip;
    private BooleanAttribute parentcolormap;
    private BooleanAttribute fullareanames;
    private BooleanAttribute automark_parent;
    private BooleanAttribute automark_keyarea;
    private BooleanAttribute automark_fork;
    private BooleanAttribute autoshow_info;
    private ExplicitHighlight highlighted;
    private Timer highlight_timer;
    private boolean highlight_active;
    private Rotator rotator;
    private MandelScannerListener msl;
    private UpdateSourceSupport uss = new UpdateSourceSupport();
    private JMenu listmenu = new JMenu("List Shortcuts");
    private MandelListFolderTreeModel browserModel;
    private MandelListFolderTreeModel memoryModel;
    private boolean busy;
    private Cursor origcursor;
    private BufferedComponent.VisibleRectFilter subareafilter = new BufferedComponent.VisibleRectFilter(){

        public boolean match(BufferedComponent.VisibleRect r) {
            return r.getName() != null;
        }
    };
    private boolean inupdate;
    private InfoPopup infoPopup = new InfoPopup();
    private List<RenewStateListener> rnlisteners = new ArrayList<RenewStateListener>();

    private int count(MandelName mn, MandelScanner s) {
        int cnt = 0;
        for (MandelName n : s.getMandelNames()) {
            if (!mn.isHigher(n)) continue;
            ++cnt;
        }
        return cnt;
    }

    public MandelImagePanel(ToolEnvironment env, MandelAreaImage img) throws IOException {
        this(env, img, 0);
    }

    public MandelImagePanel(ToolEnvironment env, MandelAreaImage img, int maxx) throws IOException {
        this.env = env;
        this.maxx = maxx;
        this.subareas = new MandelListMenu(this);
        this.subareas.setSorted(true);
        this.subareas.setUseShortnames(true);
        this.links = new MandelListModelMenu("Links", this, null);
        this.linkhist = new JMenu("Parent Links");
        this.linkhistpopup = new JPopupMenu("Parent Links");
        this.links.setSorted(true);
        this.linkListener = new EnvListener();
        this.keyareas = new DefaultMandelListListModel(new ArrayMandelList(), env.getAllScanner());
        this.keyareas.setModifiable(true);
        this.highlighted = new ExplicitHighlight("highlighted", true);
        this.lastname = new ExplicitHighlight("lastshown");
        this.marked = new Mark(env);
        this.explicitHighlights = new ExplicitHighlights();
        this.explicitHighlights.add(this.highlighted);
        this.explicitHighlights.add(this.marked);
        this.explicitHighlights.add(this.lastname);
        this.slideshowmodel = new DefaultSlideShowModel(new SlideShowDestination(){

            public QualifiedMandelName getCurrentQualifiedMandelName() {
                return MandelImagePanel.this.getQualifiedMandelName();
            }

            public boolean show(QualifiedMandelName name) {
                return MandelImagePanel.this.setImage(name);
            }

            public boolean show(MandelName name) {
                return MandelImagePanel.this.setImage(name);
            }

            public void setHighLight(QualifiedMandelName name) {
                MandelImagePanel.this.setHighLight(name);
            }

            public Window getWindow() {
                return MandelImagePanel.this.getWindow();
            }
        });
        this.highlight_timer = new Timer(5000, new HighlightHandler());
        this.selector = new AreaSelectionModel();
        this.proportion = new ProportionSelectionModel();
        this.tooltip = new ToolTipSelectionModel();
        this.parentcolormap = new ConfiguredBooleanAttribute(this, "upstream-colormap", "Use upstream colormap as default", true);
        this.autoshow_info = new ConfiguredBooleanAttribute((JComponent)this, "show-info-popup", "Show info popup at image switch");
        this.automark_fork = new ConfiguredBooleanAttribute((JComponent)this, "automark-fork", "Auto Mark for Fork Navigation");
        this.automark_keyarea = new ConfiguredBooleanAttribute(this, "automark-keyarea", "Auto Mark for Key Area Navigation", true);
        this.automark_parent = new ConfiguredBooleanAttribute((JComponent)this, "automark-parent", "Auto Mark for Parent Navigation");
        this.fullareanames = new ConfiguredBooleanAttribute((JComponent)this, "full-areanames", "Show Full Sub Area Names"){

            protected void afterStateChange() {
                System.out.println("full " + this.isSet());
                Iterator<BufferedComponent.VisibleRect> i = MandelImagePanel.this.buffer.getRects();
                while (i.hasNext()) {
                    BufferedComponent.VisibleRect r = i.next();
                    String l = MandelImagePanel.this.getLabel(MandelName.create(r.getName()));
                    if (l == null) continue;
                    r.setLabel(l);
                }
            }
        };
        this.buffer = new Buffer(this.filter(img.getImage()));
        this.buffer.setShowDecoration(env.getCopyright() != null);
        this.buffer.setDecoration(env.getCopyright(img.getInfo()));
        this.buffer.setBorder(null);
        this.buffer.getDecorationModel().setLabel("Show Subarea Names");
        this.buffer.getPixelToolTipModel().setLabel("Pixel Tooltip");
        this.scrollpane = new JScrollPane(this.buffer);
        this.scrollpane.setBorder(null);
        this.scrollpane.getViewport().addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                JViewport vp = MandelImagePanel.this.scrollpane.getViewport();
                if (vp != null) {
                    if (debug) {
                        System.out.println("PREF:" + MandelImagePanel.this.buffer.getPreferredSize());
                    }
                    if (debug) {
                        System.out.println("VP: " + vp.getViewPosition());
                    }
                    if (debug) {
                        System.out.println("VP: " + vp.getExtentSize());
                    }
                    MandelImagePanel.this.partial = !MandelImagePanel.this.buffer.getPreferredSize().equals(vp.getExtentSize());
                } else {
                    MandelImagePanel.this.partial = false;
                }
            }
        });
        this.add((Component)this.scrollpane, this.GBC(0, 0, 1));
        this.setBorder(null);
        this.initialImage = img;
        this.buffer.setLimitWindowSize(true);
    }

    protected void panelBound() {
        MandelAreaImage img = this.initialImage;
        this.initialImage = null;
        super.panelBound();
        MandelImagePanel frame = this;
        Colormap cm = this.env.getDefaultColormap();
        this.history = new History(this.env.getImageDataScanner());
        this.mappermodel = new MapperModel();
        this.colormapmodel = new ColormapModel(cm);
        this.colormapmodel.addChangeListener(new ColModelChangeListener());
        this.rotator = new Rotator(this.colormapmodel);
        this.imageListener = new MandelFrameImageListner();
        this.create = new MandelSubAreaCreationDialog(frame, "Mandel Sub Area Creation");
        this.colormapDialog = new ColormapDialog(frame, "Main Colormap", this.colormapmodel);
        this.imageDialog = new ImageControl(frame);
        this.listsDialog = new MandelListsDialog(frame);
        this.listsDialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                MandelImagePanel.this.showListsControlAction.setEnabled(true);
            }
        });
        this.juliaDialog = new JuliaDialog(frame, 300, 300);
        this.juliaDialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                MandelImagePanel.this.showJuliaAction.setEnabled(true);
            }
        });
        this.iterDialog = new IterationPathDialog(frame, 300, 300);
        this.iterDialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                MandelImagePanel.this.showIterationPathAction.setEnabled(true);
            }
        });
        SelectAreaListener arealistener = new SelectAreaListener();
        this.buffer.setSelectInvisible(true);
        this.buffer.addRectEventListener(arealistener);
        this.buffer.addRectModifiedEventListener(arealistener);
        if (!this.isReadonly()) {
            this.selector.setSelectedItem(this.selector.getElementAt(0));
            this.proportion.setSelectedItem(this.proportion.getElementAt(0));
        }
        this.buffer.addScaleEventListener(new ScaleAdapter(){

            public void componentScaled(ScaleEvent e) {
                MandelImagePanel.this.setTitle();
                if (debug) {
                    System.out.println("buf: " + MandelImagePanel.this.getImagePane().getPreferredSize());
                }
                if (debug) {
                    System.out.println("VP: " + MandelImagePanel.this.getScrollPane().getViewport().getExtentSize());
                }
            }
        });
        this.create.addCreationListener(new SubAreaListener());
        this.parentAction = new ParentAction();
        this.areaUpAction = new AreaUpAction();
        this.forkAction = new ForkAction();
        this.showSubAction = new ShowSubAction();
        this.hideSubAction = new HideSubAction();
        this.refreshSubAction = new RefreshSubAction();
        this.showColormapAction = new ShowColormapAction(this.colormapDialog);
        if (!this.isReadonly()) {
            this.variationAction = new VariationAction();
        }
        this.showMetaAction = new ShowMetaAction();
        this.linksGaleryAction = new LinksGaleryAction();
        this.keyareasGaleryAction = new KeyAreasGaleryAction();
        this.zoomGaleryAction = new ZoomGaleryAction();
        this.cloneAction = new CloneAction();
        this.gotoAction = new GotoAction();
        if (!this.isReadonly()) {
            this.saveAction = new SaveAction();
            this.areaCMSaveAction = new AreaCMSaveAction();
            this.areaCMDeleteAction = new AreaCMDeleteAction();
        }
        this.areaCMAction = new AreaCMAction();
        this.showListsControlAction = new ShowListsControlAction();
        this.showJuliaAction = new ShowJuliaAction();
        this.showIterationPathAction = new ShowIterationPathAction();
        this.areaDownAction = new AreaDownAction();
        this.buffer.addActionListener(this.parentAction, Corner.BOTTOM_LEFT);
        this.buffer.addActionListener(this.showSubAction, Corner.BOTTOM_RIGHT);
        this.buffer.addActionListener(this.hideSubAction, Corner.BOTTOM_RIGHT);
        this.buffer.addActionListener(this.showColormapAction, Corner.TOP_RIGHT);
        this.buffer.addActionListener(this.showMetaAction, Corner.TOP_LEFT);
        this.buffer.addActionListener(this.areaDownAction, RectanglePoint.MIDDLE_BOTTOM);
        this.buffer.addActionListener(new LinksAction(), RectanglePoint.MIDDLE_LEFT);
        this.buffer.addActionListener(new KeyAreasAction(), RectanglePoint.MIDDLE_RIGHT);
        this.buffer.getContentPane().addMouseMotionListener(new PixelListener());
        this.buffer.setInheritsPopupMenu(true);
        this.scrollpane.setInheritsPopupMenu(true);
        this.hideSubAction.setEnabled(false);
        this.refreshSubAction.setEnabled(false);
        this.setupMenu();
        this.getWindow().addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent e) {
                if (debug) {
                    System.out.println("FRAME closed");
                }
                MandelImagePanel.this.clear();
            }
        });
        this.buffer.setScaleMode(true);
        this.setImageData(img, false);
        this.msl = new MandelScannerListenerAdapter(){

            public void addMandelFile(MandelScanner s, MandelHandle h) {
                this.handle(h);
            }

            public void removeMandelFile(MandelScanner s, MandelHandle h) {
                this.handle(h);
            }

            public void scannerChanged(MandelScanner s) {
                this.handle(null);
            }

            private void handle(MandelHandle h) {
                boolean doit = false;
                if (h == null) {
                    doit = true;
                } else {
                    QualifiedMandelName qn = (QualifiedMandelName)h.getName();
                    if (qn != null && qn.getMandelName().getParentName() != null && qn.getMandelName().getParentName().equals(MandelImagePanel.this.getMandelName())) {
                        doit = true;
                    }
                }
                if (doit) {
                    System.out.println("*** do update sub rects");
                    MandelImagePanel.this._updateSubRects(false);
                }
            }
        };
        this.getEnvironment().getAllScanner().addMandelScannerListener(this.msl);
        this.getEnvironment().addLinkListener(this.linkListener);
    }

    protected void panelUnbound() {
        super.panelUnbound();
        for (ListModifierMenu m : this.listModifiers) {
            m.cleanupModel();
        }
        if (this.msl != null) {
            this.getEnvironment().getAllScanner().removeMandelScannerListener(this.msl);
        }
        this.getEnvironment().removeLinkListener(this.linkListener);
        this.cancel();
    }

    public void addUpdatableObject(UpdatableObject o) {
        this.uss.addUpdatableObject(o);
    }

    public void removeUpdatableObject(UpdatableObject o) {
        this.uss.removeUpdatableObject(o);
    }

    protected void updateObjects() {
        UpdateContext ctx = new UpdateContext(this);
        this.uss.updateObjects(ctx);
    }

    protected void updateObjects(String prop, Object value) {
        UpdateContext ctx = new UpdateContext((UpdateSource)this, new UpdateReason.Factory(this).setProperty(prop, value));
        this.uss.updateObjects(ctx);
    }

    public void cancel() {
        this.slideshowmodel.cancel();
        if (this.rotator != null) {
            this.rotator.cancel();
        }
    }

    public void setImageDecoration(String s) {
        this.buffer.setDecoration(s);
    }

    public BooleanAttribute getSelectInvisibleModel() {
        return this.buffer.getSelectInvisibleModel();
    }

    public BooleanAttribute getDecorationModel() {
        return this.buffer.getDecorationModel();
    }

    public BooleanAttribute getPixelToolTipModel() {
        return this.buffer.getPixelToolTipModel();
    }

    public BooleanAttribute getParentColormapModel() {
        return this.parentcolormap;
    }

    public BooleanAttribute getFullAreaNamesModel() {
        return this.fullareanames;
    }

    public BooleanAttribute getAutoShowInfoModel() {
        return this.autoshow_info;
    }

    public BooleanAttribute getAutoMarkForkModel() {
        return this.automark_fork;
    }

    public BooleanAttribute getAutoMarkKeyAreaModel() {
        return this.automark_keyarea;
    }

    public BooleanAttribute getAutoMarkParentModel() {
        return this.automark_parent;
    }

    public ComboBoxModel getAreaSelectorModel() {
        return this.selector;
    }

    public ProportionSelectionModel getProportionSelectionModel() {
        return this.proportion;
    }

    public ToolTipSelectionModel getToolTipSelectionModel() {
        return this.tooltip;
    }

    public SlideShowModel getSlideShowModel() {
        return this.slideshowmodel;
    }

    public BufferedComponent getImagePane() {
        return this.buffer;
    }

    public JScrollPane getScrollPane() {
        return this.scrollpane;
    }

    public boolean isPartial() {
        return this.partial;
    }

    public void setInitialSize() {
        Dimension id = this.buffer.getPreferredSize();
        Dimension sd = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension d = new Dimension(id);
        Insets insets = this.getInsets();
        if (debug) {
            System.out.println("bufsize:" + id);
        }
        if (debug) {
            System.out.println("scrsize:" + sd);
        }
        Dimensions.mod.add(d, insets.left + insets.right, insets.top + insets.bottom);
        Dimensions.mod.sub(sd, 5.0, 25.0);
        Dimensions.mod.limit(d, sd);
        if (debug) {
            System.out.println("ressize:" + d);
        }
        this.setPreferredSize(d);
    }

    public MandelImagePanel getMandelImagePane() {
        return this;
    }

    public void paintDecoration(Graphics g, int w, int h) {
        this.getDecoration().paintDecoration(g, w, h);
    }

    public Decoration getDecoration() {
        return this.buffer.getDecoration();
    }

    public Window getMandelWindow() {
        return this.getWindow();
    }

    private void clear() {
        if (this.image != null) {
            this.image.removeImageListener(this.imageListener);
            this.image = null;
        }
        if (this.browserModel != null) {
            this.browserModel.clear();
            this.browserModel = null;
        }
        this.cancel();
    }

    public boolean isReadonly() {
        return this.getEnvironment().isReadonly();
    }

    public int getMaxFrame() {
        return (int)this.maxx;
    }

    private void addListModifierMenu(ListModifierMenu m) {
        if (m.isValid()) {
            this.listModifiers.add(m);
            this.listmenu.add(m);
        }
    }

    public void addListShortcut(String name, MandelListModel model) {
        this.addListModifierMenu(new DynListModifierMenu(name, model));
    }

    public boolean hasListShortcut(MandelListModel model) {
        return this.hasListShortcut(model.getList());
    }

    public boolean hasListShortcut(MandelList l) {
        for (ListModifierMenu m : this.listModifiers) {
            if (m.getMandelModel().getList() != l) continue;
            return true;
        }
        return false;
    }

    public void removeListShortcut(MandelListModel model) {
        this.removeListShortcut(model.getList());
    }

    public void removeListShortcut(MandelList l) {
        for (ListModifierMenu m : this.listModifiers) {
            if (m.getMandelModel().getList() != l) continue;
            this.listModifiers.remove(m);
            this.listmenu.remove(m);
            break;
        }
    }

    private void setupMenu() {
        UpdatableJPopupMenu menu = new UpdatableJPopupMenu();
        this.addUpdatableObject(menu);
        menu.setBorder(new BevelBorder(0));
        this.listModifiers = new ArrayList<ListModifierMenu>();
        this.addListModifierMenu(new ListModifierMenu("Favorites", this.getEnvironment().getFavoritesModel()));
        this.addListModifierMenu(new ListModifierMenu("Todos", this.getEnvironment().getTodosModel()));
        this.addListModifierMenu(new ListModifierMenu("Key Areas", this.getEnvironment().getAreasModel()));
        this.addListModifierMenu(new LoadableListModifier("Memory", this.getEnvironment().getMemoryModel()));
        String shortcuts = this.env.getProperty("shortcuts.lists");
        System.out.println("default shortcuts: " + shortcuts);
        if (!Utils.isEmpty(shortcuts)) {
            StringTokenizer t = new StringTokenizer(shortcuts, ";");
            while (t.hasMoreTokens()) {
                String p = t.nextToken();
                MandelListTableModel m = this.env.getMandelListModel(p);
                if (m == null) continue;
                int ix = p.lastIndexOf(47);
                if (ix >= 0) {
                    p = p.substring(ix + 1);
                }
                this.addListShortcut(p, m);
            }
        }
        UpdatableJMenu mark = new UpdatableJMenu("Mark");
        this.addMarkAction(mark, new GotoMarkAction());
        mark.add(new JMenuItem(new SetMarkAction()));
        this.addMarkAction(mark, new CommonAncestorAction());
        this.addMarkAction(mark, this.areaDownAction);
        this.addMarkAction(mark, new KeyAreaDownAction());
        this.addMarkAction(mark, new ForkAreaDownAction());
        this.addMarkAction(mark, new MemorizeMarkAction());
        if (!this.isReadonly()) {
            this.addMarkAction(mark, new LinkFromMarkAction());
            this.addMarkAction(mark, new UnlinkFromMarkAction());
        }
        this.addMarkAction(mark, new SwapMarkAction());
        this.addMarkAction(mark, new ClearMarkAction());
        mark.add(new MandelListModelMenu("Previous", this, this.marked.previous));
        JMenu highlight = new JMenu("Sub area highlight");
        ButtonGroup group = new ButtonGroup();
        JMenuItem it = new JRadioButtonMenuItem(new NoHighlightAction());
        group.add(it);
        highlight.add(it);
        it = new JRadioButtonMenuItem(new FavoritesHighlightAction());
        it.setSelected(true);
        group.add(it);
        highlight.add(it);
        if (!this.isReadonly()) {
            it = new JRadioButtonMenuItem(new UnseenHighlightAction());
            group.add(it);
            highlight.add(it);
        }
        it = new JRadioButtonMenuItem(new LastHighlightAction());
        group.add(it);
        highlight.add(it);
        UpdatableJMenu subarea = new UpdatableJMenu("Sub areas");
        it = new JMenuItem(this.showSubAction);
        subarea.add(it);
        it = new JMenuItem(this.refreshSubAction);
        subarea.add(it);
        it = new JMenuItem(this.hideSubAction);
        subarea.add(it);
        subarea.add(this.subareas);
        menu.add(this.listmenu);
        menu.add(mark);
        menu.add(highlight);
        menu.add(subarea);
        menu.addSeparator();
        it = new JMenuItem(this.showColormapAction);
        menu.add(it);
        menu.add(this.rotator.createMenu());
        it = new JMenuItem(new WindowControlAction<ImageControl>(this.getWindow(), "Image Control", this.imageDialog));
        menu.add(it);
        menu.addSeparator();
        it = new JMenuItem(this.showMetaAction);
        menu.add(it);
        JMenu galerymenu = new JMenu("Galeries");
        galerymenu.add(this.linksGaleryAction);
        galerymenu.add(this.keyareasGaleryAction);
        galerymenu.add(this.zoomGaleryAction);
        menu.add(galerymenu);
        menu.add(this.links);
        menu.add(this.linkhist);
        this.keyareasmenu = new MandelListModelMenu("Key Areas", this, this.keyareas);
        menu.add(this.keyareasmenu);
        MandelListMenu.SelectAction selectAction = new MandelListMenu.SelectAction(){

            public void selectArea(MandelWindowAccess access, QualifiedMandelName name) {
                if (MandelImagePanel.this.automark_keyarea.isSet()) {
                    MandelImagePanel.this.setAutoMark();
                }
            }
        };
        this.keyareasmenu.addSelectAction(selectAction);
        this.keyareaspopupmenu = new MandelListModelMenu("Key Areas", this, this.keyareas);
        this.keyareaspopupmenu.addSelectAction(selectAction);
        it = new UpdatableJMenuItem(this.areaUpAction);
        menu.add(it);
        it = new UpdatableJMenuItem(this.forkAction);
        menu.add(it);
        it = new UpdatableJMenuItem(this.parentAction);
        menu.add(it);
        if (!this.isReadonly()) {
            it = new JMenuItem(this.variationAction);
            menu.add(it);
            RecalcAction ra = new RecalcAction();
            ra.setCleanupWindow(true);
            this.addRenewStateListener(ra);
            it = new JMenuItem(ra);
            menu.add(it);
        }
        menu.add(this.getEnvironment().getListActions().createMenu((Component)this, new MandelNameSelector(){

            public QualifiedMandelName getSelectedMandelName() {
                return MandelImagePanel.this.getQualifiedMandelName();
            }
        }));
        menu.addSeparator();
        it = new JMenuItem(this.showListsControlAction);
        menu.add(it);
        it = new JMenuItem(new ShowBrowserAction());
        menu.add(it);
        menu.add(this.gotoAction);
        menu.addSeparator();
        menu.add(this.showJuliaAction);
        if (iterPathActive) {
            menu.add(this.showIterationPathAction);
        }
        menu.add(this.slideshowmodel.createMenu((Component)this, new SlideShowSourceAdapter(new MainSlideShowOneMode(), new MainSlideShowTwoMode())));
        menu.add(this.cloneAction);
        UpdatableJMenu submenu = new UpdatableJMenu("Area Colormap");
        menu.add(submenu);
        if (!this.isReadonly()) {
            menu.add(this.saveAction);
            submenu.add(new UpdatableJMenuItem(this.areaCMSaveAction));
            submenu.add(new UpdatableJMenuItem(this.areaCMDeleteAction));
        }
        submenu.add(new UpdatableJMenuItem(this.areaCMAction));
        it = new UpdatableJMenuItem(new HomeAction());
        menu.add(it);
        it = new JMenuItem(this.env.getToolControlAction());
        menu.add(it);
        menu.add(new JPopupMenu.Separator());
        it = new JMenuItem(new AboutAction());
        menu.add(it);
        if (this.getWindow() instanceof JFrame) {
            it = new JMenuItem("Close");
            it.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MandelImagePanel.this.getWindow().dispose();
                }
            });
            menu.add(it);
        }
        this.setComponentPopupMenu(menu);
    }

    private void addMarkAction(JMenu menu, Action action) {
        action.setEnabled(false);
        UpdatableJMenuItem it = new UpdatableJMenuItem(action);
        menu.add(it);
    }

    public MandelListFolderTreeModel getMandelBrowserModel() {
        if (this.browserModel == null) {
            this.memoryModel = new DefaultMandelListFolderTreeModel(new MemoryMandelListFolderTree("memory"), this.env.getAllScanner());
            this.memoryModel.setModifiable(true);
            this.browserModel = this.getEnvironment().getMandelListFolderTreeModel();
            ComposedMandelListFolderTreeModel local = new ComposedMandelListFolderTreeModel("list", null);
            local.setModifiable(!this.getEnvironment().isReadonly());
            local.addFolderTreeModel(this.browserModel, "general");
            local.addListModel((MandelListTableModel)this.getHistory(), "history", false);
            local.addFolderTreeModel(this.memoryModel, "window memory");
            this.browserModel = local;
        }
        return this.browserModel;
    }

    public History getHistory() {
        return this.history;
    }

    public MandelWindowAccess getFrameAccess() {
        return this;
    }

    public ToolEnvironment getEnvironment() {
        return this.env;
    }

    public MandelName getMandelName() {
        return this.name.getMandelName();
    }

    public QualifiedMandelName getQualifiedMandelName() {
        return this.name;
    }

    public QualifiedMandelName getQualifiedName() {
        return this.name;
    }

    public MandelData getMandelData() {
        return this.image == null ? null : this.image.getMandelData();
    }

    public MandelImage getMandelImage() {
        return this.image;
    }

    public MandelInfo getMandelInfo() {
        return this.image == null ? null : this.image.getMandelData().getInfo();
    }

    public MapperModel getMapperModel() {
        return this.mappermodel;
    }

    public ColormapModel getColormapModel() {
        return this.colormapmodel;
    }

    public boolean hasColormap() {
        return this.image.getColormap() != null;
    }

    private void setTitle() {
        Window w;
        String scale = "";
        if ((double)Math.round(this.getImagePane().getScale() * 100.0) != 100.0) {
            scale = " [" + Math.round(this.getImagePane().getScale() * 100.0) + "%]";
        }
        if ((w = this.getWindow()) instanceof Frame) {
            ((Frame)w).setTitle("Mandel Image " + this.name + scale);
        }
    }

    private void setHighLight(QualifiedMandelName name) {
        this.highlighted.setQualifiedName(name);
        if (name != null) {
            this.showSubRect(name, true);
        }
    }

    private void setImage(BufferedImage image) {
        if (debug) {
            System.out.println("image to buffer");
        }
        image = this.filter(image);
        this.buffer.setImage(image);
        this.buffer.setScale(1.0);
        if (debug) {
            System.out.println("image buffer set");
        }
    }

    private void updateKeyAreas() {
        System.out.println("update upstream key areas");
        MandelList list = this.getEnvironment().getAreas();
        this.keyareas.clear();
        if (!this.name.isRoot()) {
            MandelName loop = this.name.getMandelName().getParentName();
            while (!loop.isRoot()) {
                QualifiedMandelName n = new QualifiedMandelName(loop);
                if (list.contains(n)) {
                    this.keyareas.add(n);
                    System.out.println("  found " + n);
                }
                loop = loop.getParentName();
            }
        }
        this.keyareasGaleryAction.setEnabled(!this.keyareas.getList().isEmpty());
    }

    private void updateLinks() {
        MandelListModel m = this.getEnvironment().getLinkModel(this.name.getMandelName());
        this.linksGaleryAction.setEnabled(m != null && !m.getList().isEmpty());
        this.links.setMandelListModel(m);
        MandelName loop = this.name.getMandelName();
        boolean found = false;
        boolean parent = false;
        this.linkhist.removeAll();
        this.linkhist.setEnabled(false);
        this.linkhistpopup.removeAll();
        this.linkhistpopup.setEnabled(false);
        while (!loop.isRoot()) {
            m = this.getEnvironment().getLinkModel(loop);
            if (m != null && m.getList().size() > 0) {
                if (parent) {
                    System.out.println("found parent links for " + loop);
                    this.linkhist.add(new MandelListModelMenu(loop.getName(), this, m));
                    found = true;
                    this.linkhist.setEnabled(true);
                }
                this.linkhistpopup.add(new MandelListModelMenu(loop.getName(), this, m));
                this.linkhistpopup.setEnabled(true);
            }
            loop = loop.getParentName();
            parent = true;
        }
        if (!found) {
            System.out.println("no parent links found");
        }
    }

    private void setImageData(MandelAreaImage img, boolean showlast) {
        QualifiedMandelName name = img.getName();
        System.out.println("setup image for file =" + img.getMandelData().getFile());
        this.stopHighLight();
        if (this.image != null) {
            img.removeImageListener(this.imageListener);
            this.buffer.setToolTipHandler(null);
        }
        this.lastname.setEnabled(showlast);
        this.lastname.setQualifiedName(this.name);
        if (this.highlight_mode == 3) {
            this.highlighted.setName(this.lastname);
        }
        this.name = name;
        this.image = img;
        if (img.getRasterData() != null) {
            this.buffer.setToolTipHandler(this.tooltip.getToolTipHandler());
        }
        if (!this.hasColormap()) {
            this.showColormapAction.setEnabled(false);
        } else {
            this.showColormapAction.setEnabled(true);
        }
        img.addImageListener(this.imageListener);
        this.imageListener.stateChanged(null);
        if (!this.isPartial()) {
            this.setInitialSize();
        }
        this.history.add(name);
        this.updateLinks();
        this.updateKeyAreas();
        this.infoPopup.setData(img.getInfo(), name);
        this.updateSubRects();
        this.updateObjects("area", name);
        if (this.autoshow_info.isSet()) {
            this.showInfoPopup();
        }
        if (this.env.handleRasterSeen(img.getMandelData().getFile())) {
            MandelHandle h = this.env.getAutoImageDataScanner().getMandelHandle(name);
            if (h != null) {
                img.getMandelData().setFile(h.getFile());
            } else {
                System.out.println("*** no raster file found for " + name + " after relocate");
            }
        }
        this.buffer.setDecoration(this.env.getCopyright(img.getInfo()));
        this.setTitle();
        this.fireRenewState();
        this.fireChangeEvent();
        if (debug) {
            System.out.println("image setup done");
        }
    }

    protected BufferedImage filter(BufferedImage image) {
        if (this.maxx > 0.0) {
            this.filterscale = this.maxx / (double)image.getWidth();
            double y = this.maxx * (double)image.getHeight() / (double)image.getWidth();
            if ((double)image.getWidth() > this.maxx) {
                BufferedImage n = new BufferedImage((int)this.maxx, (int)y, 1);
                Graphics2D g = n.createGraphics();
                g.drawImage(image, 0, 0, (int)this.maxx, (int)y, null);
                image = n;
            }
        } else {
            this.filterscale = 1.0;
        }
        return image;
    }

    private Colormap getDefColormap() {
        if (this.defcolormap == null) {
            return this.colormapmodel.getColormap();
        }
        return this.defcolormap;
    }

    public MandelAreaImage getMandelImage(MandelName name) throws IOException {
        this.fileinfo = new Environment1.FileInfo();
        MandelAreaImage im = this.env.getMandelImage(name, this.colormapmodel.getResizeMode(), this.createColormapSource(name, this.fileinfo), this.mappermodel.getMapper(), this.fileinfo);
        return im;
    }

    public MandelAreaImage getMandelImage(QualifiedMandelName name) throws IOException {
        this.fileinfo = new Environment1.FileInfo();
        MandelAreaImage im = this.env.getMandelImage(name, this.colormapmodel.getResizeMode(), this.createColormapSource(name.getMandelName(), this.fileinfo), this.mappermodel.getMapper(), this.fileinfo);
        return im;
    }

    public MandelAreaImage getMandelImage(MandelHandle h) throws IOException {
        this.fileinfo = new Environment1.FileInfo();
        MandelAreaImage im = this.env.getMandelImage(h, this.colormapmodel.getResizeMode(), this.createColormapSource(((QualifiedMandelName)h.getName()).getMandelName(), this.fileinfo), this.mappermodel.getMapper(), this.fileinfo);
        return im;
    }

    public synchronized MandelColormapCache getColormapCache() {
        return this.getEnvironment().getColormapCache();
    }

    private ColormapSource createColormapSource(MandelName n, Environment1.FileInfo fileinfo) {
        if (this.parentcolormap.isSet()) {
            return new PanelColormapSource(n, fileinfo);
        }
        return this.getDefColormap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setImage(ImageFactory fac, boolean showlast) {
        try {
            this.setBusy(true);
            Colormap def = this.defcolormap;
            MandelAreaImage img = fac.getMandelImage();
            if (img == null) {
                if (debug) {
                    System.out.println(fac + " not found -> rescan");
                }
                this.env.rescan();
                img = fac.getMandelImage();
            }
            if (img != null) {
                if (debug) {
                    System.out.println("got image for " + fac);
                }
                this.setImage(img.getImage());
                this.setImageData(img, showlast);
                if (this.fileinfo.getColormap() == null) {
                    if (debug) {
                        System.out.println("-> finally preserving default colormap " + def.getSize());
                    }
                    this.defcolormap = def;
                } else if (debug) {
                    System.out.println("-> finally keeping current colormap");
                }
                boolean bl = true;
                return bl;
            }
            this.mandelInfo("No image for " + fac + " found.");
        }
        catch (IOException ex) {
            this.mandelError("cannot load " + this.name, ex);
        }
        finally {
            this.setBusy(false);
        }
        return false;
    }

    public boolean setImage(MandelName name) {
        return this.setImage(name, false);
    }

    public boolean setImage(MandelName name, boolean showlast) {
        return this.setImage(new MandelNameImageFactory(name), showlast);
    }

    public boolean setImage(QualifiedMandelName name) {
        return this.setImage(name, false);
    }

    public boolean setImage(QualifiedMandelName name, boolean showlast) {
        return this.setImage(new QualifiedMandelNameImageFactory(name), showlast);
    }

    public boolean setImage(MandelHandle h) {
        return this.setImage(h, false);
    }

    public boolean setImage(MandelHandle h, boolean showlast) {
        return this.setImage(new MandelHandleImageFactory(h), showlast);
    }

    private JComponent getCC() {
        return this.getImagePane().getContentPane();
    }

    protected void setBusy(boolean b) {
        if (b != this.busy) {
            if (b) {
                if (debug) {
                    System.out.println("-------------------------------------------------");
                }
                if (debug) {
                    System.out.println("set busy");
                }
                this.origcursor = this.getImagePane().getCursor();
                this.getImagePane().setCursor(Cursor.getPredefinedCursor(3));
            } else {
                if (debug) {
                    System.out.println("orig cursor");
                }
                this.getImagePane().setCursor(this.origcursor);
            }
        }
        this.busy = b;
    }

    public void addChangeListener(ChangeListener h) {
        this.listeners.addChangeListener(h);
    }

    public void removeChangeListener(ChangeListener h) {
        this.listeners.removeChangeListener(h);
    }

    protected void fireChangeEvent() {
        this.listeners.fireChangeEvent(this);
    }

    public void showColormap() {
        this.showColormapAction.setEnabled(false);
    }

    public void hideColormap() {
        this.showColormapAction.setEnabled(true);
    }

    public boolean subAreasShown() {
        return this.hideSubAction.isEnabled();
    }

    private String getLabel(MandelName n) {
        if (n == null) {
            return null;
        }
        if (this.fullareanames.isSet() || !n.getParentName().equals(this.getMandelName())) {
            return n.getName();
        }
        return n.getSubAreaName();
    }

    private void updateSubRects() {
        this._updateSubRects(true);
    }

    public void updateSubRects(MandelName name, boolean vis) {
        this._updateSubRects(true, name, vis);
    }

    private void _updateSubRects(boolean rescan) {
        this.getImagePane().discardAllRects(this.subareafilter);
        this.subareas.clear();
        this._updateSubRects(rescan, this.getMandelName(), this.subAreasShown());
    }

    private void _updateSubRects(boolean rescan, MandelName name, boolean vis) {
        MandelScanner scanner = this.env.getAutoMetaScanner();
        ExplicitHighlights.Handler highlights = this.explicitHighlights.createHandler();
        if (rescan) {
            scanner.rescan(false);
        }
        Set<MandelName> subs = MandUtils.getSubNames(name, scanner);
        if (debug) {
            System.out.println("**** found " + subs.size() + " sub areas");
        }
        for (MandelName n : subs) {
            if (this.showSubRect(n, vis)) {
                highlights.handleAlreadyShown(n);
            }
            this.subareas.add(new QualifiedMandelName(n));
        }
        highlights.show();
    }

    private boolean showSubRect(MandelName n, boolean vis) {
        MandelHandle h = this.env.getMetaScanner().getMandelInfo(n);
        return this.showSubRect(h, vis);
    }

    private boolean showSubRect(QualifiedMandelName n, boolean vis) {
        MandelHandle h = this.env.getMetaScanner().getMandelInfo(n);
        return this.showSubRect(h, vis);
    }

    private boolean showSubRect(MandelHandle h, boolean vis) {
        MandelData data;
        if (h == null) {
            return false;
        }
        MandelName n = ((QualifiedMandelName)h.getName()).getMandelName();
        try {
            data = h.getInfo();
        }
        catch (IOException ex) {
            data = null;
        }
        if (debug) {
            System.out.println("  found " + n + ": " + h.getHeader().getTypeDesc() + ": " + data);
        }
        BufferedComponent.VisibleRect rect = this.getImagePane().getRect(n.getName());
        if (data == null) {
            if (rect != null) {
                rect.discard();
            }
        } else {
            boolean ht;
            MandelInfo info = data.getInfo();
            boolean bl = ht = this.highlighted.isActive() && this.highlight(n);
            if (rect == null) {
                rect = this.getImagePane().createRect(n.getName(), this.getLabel(n), info);
            }
            this.updateRect(rect, info);
            rect.setVisible(ht || vis);
            if (ht) {
                this.highlight_active = true;
                this.highlight_timer.restart();
            }
            if (!h.getHeader().hasImageData()) {
                rect.setStroke(dashed);
            } else if (this.highlight(n)) {
                rect.setStroke(favorite);
            } else {
                rect.setStroke(null);
            }
            rect.setFixed(true);
            return ht || vis;
        }
        return false;
    }

    public void showSubRects() {
        this.showSubAction.setEnabled(false);
        this.hideSubAction.setEnabled(true);
        this.refreshSubAction.setEnabled(true);
        this.showSubMode = true;
        this.updateSubRects();
    }

    public void hideSubRects() {
        this.showSubAction.setEnabled(true);
        this.hideSubAction.setEnabled(false);
        this.refreshSubAction.setEnabled(false);
        this.showSubMode = false;
        this.getImagePane().hideAllRects();
    }

    public String findSubName(Point p) {
        BufferedComponent.VisibleRect r = this.getImagePane().findRect(p, true, true);
        if (r != null) {
            return r.getName();
        }
        return null;
    }

    private boolean highlight(MandelName n) {
        if (this.highlighted.isActive() && this.highlighted.getMandelName().equals(n)) {
            return true;
        }
        switch (this.highlight_mode) {
            case 1: {
                return MandUtils.isAbove(n, this.getEnvironment().getFavorites().getRoot());
            }
            case 2: {
                return MandUtils.isAbove(n, this.getEnvironment().getUnseenRastersModel().getList());
            }
        }
        return false;
    }

    public void setMark() {
        this.setMark(this.getQualifiedMandelName());
    }

    public void setMark(QualifiedMandelName n) {
        if (n == null) {
            this.clearMark();
        } else {
            this.marked.setQualifiedName(n);
            if (this.marked.isActive()) {
                this.updateSubRects();
            }
            this.updateObjects("mark", this.marked.getQualifiedName());
        }
    }

    public void setAutoMark() {
        if (!this.marked.isSet() || !this.getMandelName().isAbove(this.marked.getMandelName())) {
            this.setMark();
        }
    }

    public QualifiedMandelName getMark() {
        return this.marked.getQualifiedName();
    }

    public void clearMark() {
        if (!this.marked.isSet()) {
            return;
        }
        boolean was_active = this.marked.isActive();
        this.marked.clear();
        if (was_active) {
            this.updateSubRects();
        }
        this.updateObjects("mark", this.marked.getQualifiedName());
    }

    public MandelName getAreaMarker(MandelName n) {
        MandelList list = this.getEnvironment().getAreas();
        if (list != null) {
            while (!n.isRoot()) {
                if (list.get(n = n.getParentName()) == null) continue;
                return n;
            }
        }
        return null;
    }

    public MandelName getNextAreaMarker(QualifiedMandelName n) {
        if (n == null) {
            return null;
        }
        return this.getNextAreaMarker(n.getMandelName());
    }

    public MandelName getNextAreaMarker(MandelName n) {
        if (n == null) {
            return null;
        }
        if (!this.getMandelName().isHigher(n)) {
            return null;
        }
        MandelName next = this.getMandelName();
        MandelList list = this.getEnvironment().getAreas();
        while (!(next = next.sub(n)).equals(n) && list.get(next) == null) {
        }
        return next;
    }

    private MandelName getNextForkMarker(MandelName n) {
        if (this.getMark() == null) {
            return null;
        }
        MandelName name = this.getMark().getMandelName();
        while (!n.equals(name) && (n = n.sub(name)) != null) {
            Set<MandelName> set = MandUtils.getSubNames(n, this.env.getAllScanner());
            if (set == null || set.size() <= 1) continue;
            return n;
        }
        return null;
    }

    public MandelName getFork(MandelName n) {
        MandelList list = this.getEnvironment().getAreas();
        if (list != null) {
            while (!n.isRoot()) {
                Set<MandelName> set = MandUtils.getSubNames(n = n.getParentName(), this.env.getAllScanner());
                if (set == null || set.size() <= 1) continue;
                return n;
            }
        }
        return null;
    }

    private void mandelError(String msg) {
        JOptionPane.showMessageDialog(this, msg, "Error", 0);
    }

    private void mandelError(String msg, Exception ex) {
        JOptionPane.showMessageDialog(this, msg + ": " + ex, "Error", 0);
    }

    private void mandelInfo(String msg) {
        JOptionPane.showMessageDialog(this, msg, "Info", 1);
    }

    public synchronized void updateInfo(MandelInfo info, Rectangle rect) {
        if (this.getMandelInfo() == null) {
            return;
        }
        ToolUtils.updateInfo(info, rect, this.getMandelInfo(), this.filterscale);
    }

    public synchronized void updateRect(BufferedComponent.VisibleRect rect, MandelInfo info) {
        if (this.inupdate || this.getMandelInfo() == null) {
            return;
        }
        ToolUtils.updateRect(info, rect, this.getMandelInfo(), this.filterscale);
    }

    public void showInfoPopup() {
        JViewport vp = this.scrollpane.getViewport();
        Rectangle vr = vp.getViewRect();
        int w = vr.width / 2;
        Dimension d = this.infoPopup.getPreferredSize();
        Point dst = new Point(w - d.width / 2, 0);
        this.infoPopup.showAt(this, dst);
    }

    private void stopHighLight() {
        if (this.highlight_active) {
            this.highlight_timer.stop();
        }
        this.highlight_active = false;
        this.highlighted.clear();
    }

    public void addRenewStateListener(RenewStateListener l) {
        this.rnlisteners.add(l);
    }

    public void removeRenewStateListener(RenewStateListener l) {
        this.rnlisteners.remove(l);
    }

    protected void fireRenewState() {
        for (RenewStateListener l : this.rnlisteners) {
            try {
                l.renewState(this.getWindow());
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            ToolEnvironment env;
            ToolEnvironment toolEnvironment = env = new ToolEnvironment(args);
            synchronized (toolEnvironment) {
                try {
                    MandelImagePanel.createWindow(env);
                }
                catch (IllegalArgumentException ia) {
                    System.out.println("illegal mandel name");
                }
            }
        }
        catch (IllegalConfigurationException ex) {
            System.out.println("illegal config: " + ex);
        }
    }

    static void createWindow(final ToolEnvironment env) {
        EventQueue.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ToolEnvironment toolEnvironment = env;
                synchronized (toolEnvironment) {
                    try {
                        MandelAreaImage img = env.getMandelImage(env.getInitialName());
                        TestFrame testFrame = new TestFrame(env, img);
                    }
                    catch (IOException io) {
                        System.out.println("cannot read image");
                    }
                }
            }
        });
    }

    private static class TestFrame
    extends JFrame
    implements MandelWindowAccess {
        MandelImagePanel panel;

        public TestFrame(ToolEnvironment env, MandelAreaImage img) throws IOException {
            this.panel = new MandelImagePanel(env, img);
            this.add(this.panel);
            this.pack();
            this.setDefaultCloseOperation(3);
            this.setVisible(true);
        }

        public ColormapModel getColormapModel() {
            return this.panel.getColormapModel();
        }

        public ToolEnvironment getEnvironment() {
            return this.panel.getEnvironment();
        }

        public Window getMandelWindow() {
            return this;
        }

        public MandelData getMandelData() {
            return this.panel.getMandelData();
        }

        public MandelImage getMandelImage() {
            return this.panel.getMandelImage();
        }

        public MandelName getMandelName() {
            return this.panel.getMandelName();
        }

        public MapperModel getMapperModel() {
            return this.panel.getMapperModel();
        }

        public QualifiedMandelName getQualifiedName() {
            return this.panel.getQualifiedName();
        }

        public MandelImagePanel getMandelImagePane() {
            return this.panel;
        }

        public History getHistory() {
            return this.panel.getHistory();
        }
    }

    private static class Rotator
    extends Timer
    implements ActionListener {
        private ColormapModel model;
        private Colormap orig;
        private boolean active;
        private boolean updating;
        private Action rotate = new RotateAction();
        private Action stop = new StopAction();
        private ChangeListener listener = new StopListener();

        public Rotator(ColormapModel model) {
            super(100, null);
            this.addActionListener(this);
            this.model = model;
            this.setActive(false);
        }

        public JMenu createMenu() {
            JMenu menu = new JMenu("Rotate Colors");
            menu.add(new JMenuItem(this.rotate));
            menu.add(new JMenuItem(this.stop));
            return menu;
        }

        private void setActive(boolean b) {
            this.active = b;
            this.rotate.setEnabled(!b);
            this.stop.setEnabled(b);
        }

        public void rotate() {
            if (!this.active) {
                this.setActive(true);
                this.orig = this.model.getColormap();
                this.model.setColormap(new Colormap(this.orig));
                this.model.addChangeListener(this.listener);
                this.start();
            }
        }

        public void cancel() {
            this.cancel(true);
        }

        private void cancel(boolean reset) {
            if (this.active) {
                this.setActive(false);
                this.stop();
                this.model.removeChangeListener(this.listener);
                if (reset) {
                    this.model.setColormap(this.orig);
                }
            }
        }

        public void actionPerformed(ActionEvent e) {
            Colormap cm = this.model.getColormap();
            this.updating = true;
            cm.startModification();
            Color old = cm.getColor(1);
            for (int i = 2; i < cm.getSize(); ++i) {
                cm.setColor(i - 1, cm.getColor(i));
            }
            cm.setColor(cm.getSize() - 1, old);
            cm.endModification();
            this.updating = false;
            this.start();
        }

        private class StopAction
        extends AbstractAction {
            public StopAction() {
                super("Stop");
            }

            public void actionPerformed(ActionEvent e) {
                Rotator.this.cancel();
            }
        }

        private class RotateAction
        extends AbstractAction {
            public RotateAction() {
                super("Rotate");
            }

            public void actionPerformed(ActionEvent e) {
                Rotator.this.rotate();
            }
        }

        private class StopListener
        implements ChangeListener {
            private StopListener() {
            }

            public void stateChanged(javax.swing.event.ChangeEvent e) {
                if (!Rotator.this.updating) {
                    Rotator.this.cancel(false);
                }
            }
        }
    }

    private class HighlightHandler
    implements ActionListener {
        private HighlightHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            if (MandelImagePanel.this.highlight_active) {
                MandelImagePanel.this.stopHighLight();
                MandelImagePanel.this.updateSubRects();
            }
        }
    }

    public class PixelListener
    extends MouseAdapter {
        public void mouseMoved(MouseEvent e) {
            int w;
            JViewport vp = MandelImagePanel.this.scrollpane.getViewport();
            Rectangle vr = vp.getViewRect();
            int px = e.getX() - vr.x;
            int py = e.getY() - vr.y;
            if (py < 20 && Math.abs((w = vr.width / 2) - px) < 120) {
                if (debug) {
                    JRootPane rp = SwingUtilities.getRootPane(e.getComponent());
                    Point rpp = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), rp);
                    System.out.println(":" + e.getX() + "," + e.getY() + ":" + vp.getViewRect() + "--- " + rpp.x + "," + rpp.y);
                }
                if (!MandelImagePanel.this.infoPopup.isActive()) {
                    MandelImagePanel.this.showInfoPopup();
                }
            }
            px = (int)((double)MandelImagePanel.this.buffer.translateX(e) / MandelImagePanel.this.filterscale);
            py = (int)((double)MandelImagePanel.this.buffer.translateY(e) / MandelImagePanel.this.filterscale);
            if (e.isAltDown() && (MandelImagePanel.this.juliaDialog.isVisible() || MandelImagePanel.this.iterDialog.isVisible())) {
                MandelInfo parent = MandelImagePanel.this.getMandelInfo();
                BigDecimal x = MandArith.sub(parent.getXM(), MandArith.div(parent.getDX(), 2.0));
                BigDecimal y = MandArith.add(parent.getYM(), MandArith.div(parent.getDY(), 2.0));
                BigDecimal jx = MandArith.add(x, MandArith.div(MandArith.mul(parent.getDX(), px), (double)parent.getRX()));
                BigDecimal jy = MandArith.sub(y, MandArith.div(MandArith.mul(parent.getDY(), py), (double)parent.getRY()));
                if (MandelImagePanel.this.juliaDialog.isVisible()) {
                    MandelImagePanel.this.juliaDialog.update(jx.doubleValue(), jy.doubleValue());
                }
                if (MandelImagePanel.this.iterDialog.isVisible()) {
                    MandelImagePanel.this.iterDialog.update(parent.getLimitIt(), jx.doubleValue(), jy.doubleValue());
                }
            }
            try {
                if (MandelImagePanel.this.hasColormap()) {
                    MandelImagePanel.this.colormapDialog.hightLight(MandelImagePanel.this.getMandelImage().getColormapIndex(px, py));
                }
            }
            catch (UnsupportedOperationException ex) {
                // empty catch block
            }
        }
    }

    public class InfoPopup
    extends RenderedComponent {
        private JLayeredPane active;
        private JTextField info;
        private JTextField magn;
        private JTextField min;
        private JTextField max;
        private JTextField time;
        private Timer timer = new Timer(2000, new HideHandler());
        private QualifiedMandelName name;

        public InfoPopup() {
            JPanel effective = new JPanel();
            FlowLayout l = (FlowLayout)effective.getLayout();
            l.setHgap(5);
            l.setVgap(5);
            effective.add(new JLabel("Info: "));
            this.info = this.createField();
            effective.add(this.info);
            effective.add(new JLabel("Magn: "));
            this.magn = this.createField();
            effective.add(this.magn);
            effective.add(new JLabel("Min: "));
            this.min = this.createField();
            effective.add(this.min);
            effective.add(new JLabel("Max: "));
            this.max = this.createField();
            effective.add(this.max);
            effective.add(new JLabel("Time: "));
            this.time = this.createField();
            effective.add(this.time);
            effective.validate();
            this.setEffectiveComponent(effective);
            this.setOpaque(false);
            this.addMouseListener(new MouseListener());
        }

        private JTextField createField() {
            JTextField f = new JTextField("");
            f.setEditable(false);
            f.setBorder(null);
            return f;
        }

        public boolean isActive() {
            return this.active != null;
        }

        public void setData(MandelInfo i, QualifiedMandelName name) {
            int m = MandUtils.getMagnification(i);
            this.setMagnification(m);
            this.setInfo(name);
            this.setMin(i.getMinIt());
            this.setMax(i.getMaxIt());
            this.setTime(i.getTime());
        }

        public void setInfo(QualifiedMandelName name) {
            this.name = name;
            this.updateInfo();
        }

        private void updateInfo() {
            String info = MandelAreaViewDialog.getInfoString(MandelImagePanel.this.getEnvironment(), this.name);
            int ic = MandelImagePanel.this.count(this.name.getMandelName(), MandelImagePanel.this.getEnvironment().getImageDataScanner());
            if (!info.isEmpty()) {
                info = info + ", ";
            }
            info = ic == 1 ? info + "" + ic + " sub area" : info + "" + ic + " sub areas";
            this.setInfo(info);
            this.validate();
        }

        public void setInfo(String v) {
            if (v == null || v.length() == 0) {
                v = "     ";
            }
            this.info.setText(v);
        }

        public void setMagnification(int v) {
            this.magn.setText("1e" + v);
        }

        public void setMin(int v) {
            this.min.setText("" + v);
        }

        public void setMax(int v) {
            this.max.setText("" + v);
        }

        public void setTime(long t) {
            this.time.setText(MandelImageAreaDialog.formatTime(t));
        }

        public void showAt(Component c, Point p) {
            this.timer.start();
            this.updateInfo();
            JRootPane rp = SwingUtilities.getRootPane(c);
            Point rpp = SwingUtilities.convertPoint(c, p, rp);
            Dimension d = this.getPreferredSize();
            this.setVisible(true);
            this.setBounds(rpp.x, rpp.y, (int)d.getWidth(), (int)d.getHeight());
            if (debug) {
                System.out.println("show " + this.getBounds());
            }
            this.active = rp.getLayeredPane();
            this.active.add((Component)this, JLayeredPane.PALETTE_LAYER + 1);
            rp.repaint();
        }

        private void _hide() {
            if (debug) {
                System.out.println("disable popup");
            }
            this.timer.stop();
            this.setVisible(false);
            if (this.active != null) {
                this.active.remove(this);
            }
            this.active = null;
        }

        private class HideHandler
        implements ActionListener {
            private HideHandler() {
            }

            public void actionPerformed(ActionEvent e) {
                InfoPopup.this._hide();
            }
        }

        private class MouseListener
        extends MouseAdapter {
            private MouseListener() {
            }

            public void mouseEntered(MouseEvent e) {
                InfoPopup.this.timer.stop();
            }

            public void mouseExited(MouseEvent e) {
                InfoPopup.this.timer.restart();
            }
        }
    }

    public class SubAreaListener
    implements MandelAreaCreationDialog.MandelAreaListener {
        public void areaActionPerformed(MandelAreaCreationDialog.MandelAreaEvent e) {
            if (debug) {
                System.out.println("sub area event " + e.getId());
            }
            MandelName name = e.getName();
            if (e.getId() == 3) {
                MandelImagePanel.this.updateSubRects();
            }
            if (e.getId() == 1) {
                MandelInfo info = e.getInfo();
                BufferedComponent.VisibleRect rect = e.getRect();
                if (debug) {
                    try {
                        System.out.println("area selected name=" + name + ", info=" + info + ",rect=" + rect + " prop=" + rect.getWidth() / rect.getHeight());
                    }
                    catch (RuntimeException ex) {
                        // empty catch block
                    }
                }
                if (name != null && info != null && rect != null && !MandelImagePanel.this.subAreasShown()) {
                    System.out.println("*** keep rect");
                    ((MandelSubAreaCreationDialog)e.getSource()).setRectHandled();
                    rect.setName(name.getName());
                    rect.setLabel(MandelImagePanel.this.getLabel(name));
                    rect.setOwner(new MandelInfo(info));
                    rect.setFixed(true);
                    rect.activate();
                }
            }
            if (e.getId() == 2) {
                BufferedComponent.VisibleRect rect = e.getRect();
                if (rect != null) {
                    if (debug) {
                        System.out.println("discard rect");
                    }
                    rect.discard();
                }
                MandelImagePanel.this.updateSubRects();
            }
        }
    }

    public class SelectAreaListener
    implements BufferedComponent.RectEventListener,
    BufferedComponent.RectModifiedEventListener {
        private MandelHandle getMandelInfo(String n) {
            MandelHandle data = null;
            MandelName name = MandelName.create(n);
            if (name != null) {
                data = MandelImagePanel.this.env.getImageDataScanner().getMandelInfo(name);
                if (data == null) {
                    data = MandelImagePanel.this.env.getMetaScanner().getMandelInfo(name);
                }
                if (data == null) {
                    MandelImagePanel.this.env.rescan();
                    data = MandelImagePanel.this.env.getMetaScanner().getMandelInfo(name);
                }
                if (data == null) {
                    MandelImagePanel.this.mandelError("cannot find mandel data for area " + name);
                }
            }
            return data;
        }

        private void updateDialog(BufferedComponent.VisibleRect rect, MandelHandle data, boolean created) {
            if (created) {
                MandelImagePanel.this.create.setRect(null);
                if (data != null) {
                    MandelImagePanel.this.create.setAutoMode(false);
                    MandelImagePanel.this.create.setFilename(data.getFile().getPath(), false);
                } else {
                    MandelImagePanel.this.create.setAutoMode(true);
                    MandelImagePanel.this.create.setFilename(null, true);
                }
            }
            MandelImagePanel.this.inupdate = true;
            rect.setVisible(true);
            MandelImagePanel.this.create.setRect(rect);
            MandelImagePanel.this.create.setVisible(true);
            MandelImagePanel.this.inupdate = false;
        }

        public void buttonClicked(BufferedComponent.RectEvent e) {
            MandelHandle data;
            BufferedComponent.VisibleRect rect = e.getRect();
            String n = rect.getName();
            if (e.getButton() == 1 && e.getClickCount() == 2) {
                MandelName name;
                if (e.isControlDown() && !MandelImagePanel.this.isReadonly()) {
                    if (!Utils.isEmpty(n) && rect.getOwner() != null && (data = this.getMandelInfo(n)) != null) {
                        if (!data.getHeader().isInfo()) {
                            MandelImagePanel.this.mandelError("area " + n + " already proccesed");
                            return;
                        }
                        rect.setFixed(false);
                        this.updateDialog(rect, data, true);
                    }
                } else if (e.isShiftDown()) {
                    MandelHandle data2;
                    if (!Utils.isEmpty(n) && rect.getOwner() != null && (data2 = this.getMandelInfo(n)) != null) {
                        try {
                            MandelImageAreaDialog v = new MandelImageAreaDialog(MandelImagePanel.this.getFrameAccess(), "Mandel Image Meta Information", (QualifiedMandelName)data2.getName(), data2.getInfo());
                            v.setDefaultCloseOperation(2);
                            v.setVisible(true);
                        }
                        catch (IOException ex) {
                            System.err.println("*** cannot read " + data2.getFile() + ": " + ex);
                        }
                    }
                } else if (!Utils.isEmpty(n) && rect.getOwner() != null && (name = MandelName.create(n)) != null) {
                    MandelImagePanel.this.setImage(name);
                }
            }
            if (e.getButton() == 1 && e.getClickCount() == 1 && e.isAltDown()) {
                if (debug) {
                    System.out.println("show sub sub " + n);
                }
                if (!Utils.isEmpty(n) && rect.getOwner() != null && (data = this.getMandelInfo(n)) != null) {
                    MandelImagePanel.this.showSubRect((QualifiedMandelName)data.getName(), true);
                    MandelImagePanel.this.updateSubRects(((QualifiedMandelName)data.getName()).getMandelName(), true);
                }
                MandelImagePanel.this.repaint();
            }
        }

        public synchronized void rectModified(BufferedComponent.RectModifiedEvent e) {
            boolean created;
            MandelInfo info;
            BufferedComponent.VisibleRect rect = e.getRect();
            if (e.getAction() == 1) {
                if (debug) {
                    System.out.println("rect created " + rect + " prop=" + (double)rect.getWidth() / (double)rect.getHeight());
                }
                info = new MandelInfo(MandelImagePanel.this.getMandelInfo());
                info.setKeywords(new HashSet<String>());
                rect.setOwner(info);
                created = true;
            } else {
                info = (MandelInfo)rect.getOwner();
                created = false;
            }
            if (info != null) {
                MandelImagePanel.this.updateInfo(info, rect._getRect());
                ProportionProvider p = MandelImagePanel.this.proportion.getProportionProvider();
                if (p != MandelImagePanel.this.imagepropprov) {
                    if (!created) {
                        MandelInfo dia = MandelImagePanel.this.create.getInfo();
                        info.setRX(dia.getRX());
                        info.setRY(dia.getRY());
                        System.out.println("" + dia.getRX() + "/" + dia.getRY());
                    }
                    if ((double)info.getRX() / (double)info.getRY() != p.getProportion()) {
                        info.setRY((int)((double)info.getRX() / p.getProportion()));
                    }
                }
                this.updateDialog(rect, null, created);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GotoAction
    extends WindowControlAction<GotoDialog> {
        public GotoAction() {
            super(MandelImagePanel.this.getMandelWindow(), "Goto", new GotoDialog(MandelImagePanel.this));
        }
    }

    private class AboutAction
    extends AbstractAction {
        public AboutAction() {
            super("About");
        }

        public void actionPerformed(ActionEvent e) {
            new AboutBox(MandelImagePanel.this.getWindow()).setVisible(true);
        }
    }

    private class VariationAction
    extends AbstractAction {
        public VariationAction() {
            super("Variation");
        }

        public void actionPerformed(ActionEvent e) {
            MandelVariationCreationDialog f = new MandelVariationCreationDialog(MandelImagePanel.this.getFrameAccess(), "Variation for " + MandelImagePanel.this.getMandelName());
            f.setVisible(true);
        }
    }

    private class OpenListShortcutAction
    extends AbstractListAction {
        private String name;

        public OpenListShortcutAction(MandelListTableModel model, String name) {
            super(model, "Open List");
            this.name = name;
        }

        public void actionPerformed(ActionEvent e) {
            new MandelListDialog(MandelImagePanel.this.getFrameAccess(), this.name, (MandelListTableModel)this.getModel());
        }
    }

    private class RemoveListShortcutAction
    extends AbstractListAction {
        public RemoveListShortcutAction(MandelListModel model) {
            super(model, "Remove Shortcut");
        }

        public void actionPerformed(ActionEvent e) {
            MandelImagePanel.this.removeListShortcut(this.getModel());
        }
    }

    private class RemoveListEntryAction
    extends AbstractListAction {
        public RemoveListEntryAction(MandelListModel model) {
            super(model, "Remove");
        }

        public void actionPerformed(ActionEvent e) {
            this.getModel().remove(MandelImagePanel.this.name);
        }
    }

    private class AddListEntryAction
    extends AbstractListAction {
        public AddListEntryAction(MandelListModel model) {
            super(model, "Add");
        }

        public void actionPerformed(ActionEvent e) {
            this.getModel().add(MandelImagePanel.this.name);
        }
    }

    private abstract class AbstractListAction
    extends AbstractAction {
        private MandelListModel model;

        public AbstractListAction(MandelListModel model, String cmd) {
            super(cmd);
            this.model = model;
        }

        public MandelListModel getModel() {
            return this.model;
        }
    }

    private class HomeAction
    extends UpdatableAction {
        public HomeAction() {
            super("Home");
        }

        public void actionPerformed(ActionEvent e) {
            MandelImagePanel.this.setImage(MandelName.ROOT);
        }

        public void updateObject(UpdateContext ctx) {
            this.setEnabled(!MandelImagePanel.this.getMandelName().isRoot());
        }
    }

    private class AreaCMAction
    extends UpdatableAction {
        private MandelName name;

        public AreaCMAction() {
            super("Upstream");
        }

        public void actionPerformed(ActionEvent e) {
            MandelImagePanel.this.setImage(this.name);
        }

        public void updateObject(UpdateContext ctx) {
            boolean b = false;
            MandelName n = MandelImagePanel.this.getMandelName();
            do {
                Set<MandelHandle> set;
                if ((set = MandelImagePanel.this.env.getAreaColormapScanner().getMandelHandles(n)) != null) {
                    for (MandelHandle mh : set) {
                        if (!mh.getHeader().isAreaColormap()) continue;
                        b = true;
                        break;
                    }
                }
                if (b) continue;
                n = n.getParentName();
            } while (!b && n != null);
            this.setEnabled(b);
            if (b) {
                this.name = n;
                this.putValue("Name", n.getName());
            } else {
                this.putValue("Name", "upstream");
            }
        }
    }

    private class AreaCMDeleteAction
    extends UpdatableAction {
        public AreaCMDeleteAction() {
            super("Delete");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            ToolEnvironment env = MandelImagePanel.this.getEnvironment();
            ElementHandle h = null;
            Set<MandelHandle> set = env.getAreaColormapScanner().getMandelHandles(MandelImagePanel.this.getMandelName());
            if (set != null) {
                for (MandelHandle mh : set) {
                    if (!mh.getHeader().isAreaColormap()) continue;
                    h = mh;
                    break;
                }
            }
            if (h != null) {
                env.startUpdate();
                try {
                    if (h.getFile().isFile()) {
                        MandelFolder.Util.delete(h.getFile().getFile());
                        MandelImagePanel.this.getEnvironment().getColormapCache().remove(MandelImagePanel.this.getMandelName());
                        MandelImagePanel.this.updateObjects("areacm", MandelImagePanel.this.getMandelName());
                    }
                }
                catch (IOException io) {
                    MandelImagePanel.this.mandelError("Area colormap " + h.getFile() + "cannot be deleted", io);
                }
                finally {
                    env.finishUpdate();
                }
            }
        }

        public void updateObject(UpdateContext ctx) {
            boolean b = false;
            Set<MandelHandle> set = MandelImagePanel.this.env.getAreaColormapScanner().getMandelHandles(MandelImagePanel.this.getMandelName());
            if (set != null) {
                for (MandelHandle mh : set) {
                    if (!mh.getHeader().isAreaColormap()) continue;
                    b = true;
                    break;
                }
            }
            this.setEnabled(b);
        }
    }

    private class AreaCMSaveAction
    extends UpdatableAction {
        public AreaCMSaveAction() {
            super("Save");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            ToolEnvironment env = MandelImagePanel.this.getEnvironment();
            MandelImage img = MandelImagePanel.this.getMandelImage();
            MandelData d = img.getMandelData();
            AbstractFile f = d.getFile();
            MandelData mc = new MandelData(d.getInfo());
            mc.setColormap(ColormapModel.ResizeMode.RESIZE_LOCK_COLORS, d.getColormap());
            String n = f.getName();
            int ix = n.lastIndexOf(46);
            long lm = f.getLastModified();
            File save = env.mapToAreaColormapFile(f);
            mc.setFile(new FileAbstractFile(save));
            env.startUpdate();
            try {
                mc.setTemporary(false);
                mc.write();
                MandelImagePanel.this.getEnvironment().getColormapCache().add(MandelImagePanel.this.getQualifiedName(), new Colormap(mc.getColormap()));
                MandelImagePanel.this.updateObjects("areacm", MandelImagePanel.this.getMandelName());
            }
            catch (IOException io) {
                MandelImagePanel.this.mandelError("Area colormap cannot be saved", io);
            }
            finally {
                env.finishUpdate();
            }
        }

        public void updateObject(UpdateContext ctx) {
            System.out.println(ctx.getReason().getReason() + ": " + MandelImagePanel.this.getMandelData().isModified());
            this.setEnabled(MandelImagePanel.this.getMandelData().isModified());
        }
    }

    private class SaveAction
    extends AbstractAction {
        public SaveAction() {
            super("Save");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            ToolEnvironment env = MandelImagePanel.this.getEnvironment();
            MandelImage img = MandelImagePanel.this.getMandelImage();
            MandelData d = img.getMandelData();
            AbstractFile f = d.getFile();
            String n = f.getName();
            int ix = n.lastIndexOf(46);
            long lm = f.getLastModified();
            File save = env.mapToRasterImageFile(f);
            d.setFile(new FileAbstractFile(save));
            env.startUpdate();
            try {
                d.setTemporary(false);
                d.getInfo().setImageCreationTime(System.currentTimeMillis());
                d.write();
                if (!d.getFile().equals(f) && !MandelImagePanel.this.getEnvironment().backupRasterFile(f) && MandelImagePanel.this.getEnvironment().isCleanupRaster() && f.isFile()) {
                    MandelFolder.Util.delete(f.getFile());
                }
                MandelImagePanel.this.getEnvironment().getColormapCache().add(MandelImagePanel.this.getQualifiedName(), new Colormap(d.getColormap()));
            }
            catch (IOException io) {
                MandelImagePanel.this.mandelError("Image cannot be saved", io);
            }
            finally {
                env.finishUpdate();
            }
        }
    }

    private class CloneAction
    extends AbstractAction {
        public CloneAction() {
            super("New Window");
        }

        public void actionPerformed(ActionEvent e) {
            try {
                MandelAreaImage img = MandelImagePanel.this.getMandelImage(MandelImagePanel.this.getQualifiedName());
                if (img != null) {
                    MandelImagePanel.this.getEnvironment().createMandelImageFrame(img, (int)MandelImagePanel.this.maxx);
                } else {
                    MandelImagePanel.this.mandelError("Image " + MandelImagePanel.this.getQualifiedName() + " not found");
                }
            }
            catch (IOException ex) {
                MandelImagePanel.this.mandelError("Image cannot be loaded", ex);
            }
        }
    }

    private class ShowBrowserAction
    extends AbstractAction {
        public ShowBrowserAction() {
            super("List Browser");
        }

        public void actionPerformed(ActionEvent e) {
            MandelBrowserDialog b = new MandelBrowserDialog(MandelImagePanel.this.getFrameAccess(), MandelImagePanel.this.getMandelBrowserModel());
            b.setVisible(true);
        }
    }

    private class ShowIterationPathAction
    extends AbstractAction {
        public ShowIterationPathAction() {
            super("Show Iteration Path");
        }

        public void actionPerformed(ActionEvent e) {
            if (!MandelImagePanel.this.iterDialog.isVisible()) {
                MandelImagePanel.this.iterDialog.setVisible(true);
                MandelImagePanel.this.iterDialog.update(MandelImagePanel.this.getMandelInfo().getLimitIt(), 1.0, 1.0);
                this.setEnabled(false);
            }
        }
    }

    private class ShowJuliaAction
    extends AbstractAction {
        public ShowJuliaAction() {
            super("Show Julia");
        }

        public void actionPerformed(ActionEvent e) {
            if (!MandelImagePanel.this.juliaDialog.isVisible()) {
                MandelImagePanel.this.juliaDialog.setVisible(true);
                MandelImagePanel.this.juliaDialog.update(1.0, 1.0);
                this.setEnabled(false);
            }
        }
    }

    private class ShowListsControlAction
    extends AbstractAction {
        public ShowListsControlAction() {
            super("Lists");
        }

        public void actionPerformed(ActionEvent e) {
            if (!MandelImagePanel.this.listsDialog.isVisible()) {
                MandelImagePanel.this.listsDialog.setVisible(true);
                this.setEnabled(false);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ShowColormapAction
    extends WindowControlAction<ColormapDialog> {
        public ShowColormapAction(ColormapDialog cm) {
            super(MandelImagePanel.this.getWindow(), "Colormap", cm);
        }
    }

    private class ShowMetaAction
    extends AbstractAction {
        public ShowMetaAction() {
            super("Image Meta Data");
        }

        public void actionPerformed(ActionEvent e) {
            QualifiedMandelName name = MandelImagePanel.this.getQualifiedMandelName();
            MandelData data = MandelImagePanel.this.getMandelData();
            MandelImageAreaDialog v = new MandelImageAreaDialog(MandelImagePanel.this.getFrameAccess(), "Mandel Image Meta Information", name, data);
            v.setDefaultCloseOperation(2);
            v.setVisible(true);
        }
    }

    private class HideSubAction
    extends AbstractAction {
        public HideSubAction() {
            super("Hide Sub Areas");
        }

        public void actionPerformed(ActionEvent e) {
            MandelImagePanel.this.hideSubRects();
        }
    }

    private class RefreshSubAction
    extends AbstractAction {
        public RefreshSubAction() {
            super("Refresh Sub Areas");
        }

        public void actionPerformed(ActionEvent e) {
            MandelImagePanel.this.updateSubRects();
        }
    }

    private class ShowSubAction
    extends AbstractAction {
        public ShowSubAction() {
            super("Show Sub Areas");
        }

        public void actionPerformed(ActionEvent e) {
            MandelImagePanel.this.showSubRects();
        }
    }

    private class ForkAction
    extends UpdatableAction {
        public ForkAction() {
            super("Last Fork");
        }

        public void actionPerformed(ActionEvent e) {
            MandelName n;
            MandelList list = MandelImagePanel.this.getEnvironment().getAreas();
            if (list != null && (n = MandelImagePanel.this.getFork(MandelImagePanel.this.getMandelName())) != null) {
                if (MandelImagePanel.this.automark_fork.isSet()) {
                    MandelImagePanel.this.setAutoMark();
                }
                MandelImagePanel.this.setImage(n);
            }
        }

        public void updateObject(UpdateContext ctx) {
            this.setEnabled(MandelImagePanel.this.getFork(MandelImagePanel.this.getMandelName()) != null);
        }
    }

    private class KeyAreasAction
    extends AbstractAction {
        public KeyAreasAction() {
            super("KeyAreas");
        }

        public void actionPerformed(ActionEvent e) {
            if (MandelImagePanel.this.keyareaspopupmenu.isEnabled()) {
                BufferedComponent.RectPointEvent re = ((BufferedComponent.RectangleActionEvent)e).getRectanglePointEvent();
                JPopupMenu m = MandelImagePanel.this.keyareaspopupmenu.getPopupMenu();
                m.show(MandelImagePanel.this, re.getX(), re.getY());
            }
        }
    }

    private class LinksAction
    extends AbstractAction {
        public LinksAction() {
            super("Links");
        }

        public void actionPerformed(ActionEvent e) {
            JPopupMenu m = MandelImagePanel.this.linkhistpopup;
            if (m.isEnabled()) {
                BufferedComponent.RectPointEvent re = ((BufferedComponent.RectangleActionEvent)e).getRectanglePointEvent();
                m.show(MandelImagePanel.this, re.getX(), re.getY());
            }
        }
    }

    private class ZoomGaleryAction
    extends AbstractAction {
        public ZoomGaleryAction() {
            super("Zoom");
        }

        public void actionPerformed(ActionEvent e) {
            ArrayMandelList ml = new ArrayMandelList();
            MandelName n = MandelImagePanel.this.getMandelName();
            ml.add(MandelImagePanel.this.getQualifiedName());
            while (!n.isRoot()) {
                n = n.getParentName();
                ml.add(0, new QualifiedMandelName(n));
            }
            String title = "Zoom Galery for " + MandelImagePanel.this.getMandelName() + " (" + Utils.sizeString(ml.size(), "entry") + ")";
            System.out.println(title);
            new MandelListGaleryDialog(MandelImagePanel.this.getFrameAccess(), ml, title);
        }
    }

    private class KeyAreasGaleryAction
    extends AbstractAction {
        public KeyAreasGaleryAction() {
            super("Key areas");
        }

        public void actionPerformed(ActionEvent e) {
            MandelListModel m = MandelImagePanel.this.keyareas;
            if (m != null && !m.getList().isEmpty()) {
                ArrayMandelList ml = new ArrayMandelList(m.getList());
                String title = "Key Areas Galery for " + MandelImagePanel.this.getMandelName() + " (" + Utils.sizeString(ml.size(), "entry") + ")";
                System.out.println(title);
                new MandelListGaleryDialog(MandelImagePanel.this.getFrameAccess(), ml, title);
            }
        }
    }

    private class LinksGaleryAction
    extends AbstractAction {
        public LinksGaleryAction() {
            super("Links");
        }

        public void actionPerformed(ActionEvent e) {
            MandelListModel m = MandelImagePanel.this.getEnvironment().getLinkModel(MandelImagePanel.this.getMandelName());
            if (m != null && !m.getList().isEmpty()) {
                ArrayMandelList ml = new ArrayMandelList(m.getList());
                String title = "Links Galery for " + MandelImagePanel.this.getMandelName() + " (" + Utils.sizeString(ml.size(), "entry") + ")";
                System.out.println(title);
                new MandelListGaleryDialog(MandelImagePanel.this.getFrameAccess(), ml, title);
            }
        }
    }

    private class AreaDownAction
    extends AboveMarkAction {
        public AreaDownAction() {
            super("Down");
        }

        protected void markActionPerformed(ActionEvent e) {
            QualifiedMandelName name = MandelImagePanel.this.getMark();
            MandelName n = MandelImagePanel.this.getMandelName();
            if ((n = n.sub(name.getMandelName())) != null) {
                MandelImagePanel.this.setImage(n);
            }
        }
    }

    private class KeyAreaDownAction
    extends AboveMarkAction {
        public KeyAreaDownAction() {
            super("Key Area Down");
        }

        protected void markActionPerformed(ActionEvent e) {
            MandelName n;
            MandelList list = MandelImagePanel.this.getEnvironment().getAreas();
            QualifiedMandelName name = MandelImagePanel.this.getMark();
            if (list != null && name != null && (n = MandelImagePanel.this.getNextAreaMarker(name.getMandelName())) != null) {
                MandelImagePanel.this.setImage(n);
            }
        }
    }

    private class ForkAreaDownAction
    extends AboveMarkAction {
        public ForkAreaDownAction() {
            super("Fork Area Down");
        }

        protected void markActionPerformed(ActionEvent e) {
            MandelName n = MandelImagePanel.this.getNextForkMarker(MandelImagePanel.this.getMandelName());
            if (n != null) {
                MandelImagePanel.this.setImage(n);
            }
        }
    }

    private abstract class AboveMarkAction
    extends MarkActionBase {
        public AboveMarkAction(String name) {
            super(name);
        }

        protected boolean isPossible() {
            return super.isPossible() && MandelImagePanel.this.getMandelName().isHigher(MandelImagePanel.this.getMark().getMandelName());
        }

        protected boolean isPossible(UpdateContext ctx) {
            UpdateCondition c = ctx.getEntry(UpdateCondition.class);
            if (c == null) {
                c = ctx.setEntry(UpdateCondition.class, new UpdateCondition());
            }
            return c.isTrue();
        }

        private class UpdateCondition
        extends BooleanUpdateCondition {
            public UpdateCondition() {
                super(AboveMarkAction.this.isPossible());
            }
        }
    }

    private class AreaUpAction
    extends OptionalAction {
        public AreaUpAction() {
            super("Key Area");
        }

        public void actionPerformed(ActionEvent e) {
            MandelName n;
            MandelList list = MandelImagePanel.this.getEnvironment().getAreas();
            if (list != null && (n = MandelImagePanel.this.getAreaMarker(MandelImagePanel.this.getMandelName())) != null) {
                if (MandelImagePanel.this.automark_keyarea.isSet()) {
                    MandelImagePanel.this.setAutoMark();
                }
                MandelImagePanel.this.setImage(n);
            }
        }

        protected boolean isPossible() {
            return MandelImagePanel.this.getAreaMarker(MandelImagePanel.this.getMandelName()) != null;
        }
    }

    private class CommonAncestorAction
    extends MarkActionBase {
        public CommonAncestorAction() {
            super("Common Ancestor");
        }

        protected void markActionPerformed(ActionEvent e) {
            MandelName n = MandelImagePanel.this.getMandelName();
            while (!n.isAbove(MandelImagePanel.this.marked.getMandelName())) {
                n = n.getParentName();
            }
            MandelImagePanel.this.setImage(n, true);
        }

        protected boolean isPossible() {
            return super.isPossible() && !MandelImagePanel.this.getMandelName().isAbove(MandelImagePanel.this.marked.getMandelName());
        }
    }

    private class UnlinkFromMarkAction
    extends MarkActionBase {
        public UnlinkFromMarkAction() {
            super("Unlink from");
        }

        protected void markActionPerformed(ActionEvent e) {
            MandelImagePanel.this.getEnvironment().removeLink(MandelImagePanel.this.marked.getMandelName(), MandelImagePanel.this.getMandelName());
        }
    }

    private class LinkFromMarkAction
    extends MarkActionBase {
        public LinkFromMarkAction() {
            super("Link from");
        }

        protected void markActionPerformed(ActionEvent e) {
            MandelImagePanel.this.getEnvironment().addLink(MandelImagePanel.this.marked.getMandelName(), MandelImagePanel.this.getMandelName());
        }
    }

    private class MemorizeMarkAction
    extends MarkActionBase {
        public MemorizeMarkAction() {
            super("Memorize");
        }

        protected void markActionPerformed(ActionEvent e) {
            MandelImagePanel.this.getEnvironment().getMemoryModel().add(MandelImagePanel.this.marked.getQualifiedName());
        }
    }

    private class GotoMarkAction
    extends MarkActionBase {
        public GotoMarkAction() {
            super("Jump");
        }

        protected void markActionPerformed(ActionEvent e) {
            MandelImagePanel.this.setImage(MandelImagePanel.this.marked.getQualifiedName());
        }

        public void updateObject(UpdateContext ctx) {
            super.updateObject(ctx);
            this.putValue("Name", MandelImagePanel.this.marked.isSet() ? MandelImagePanel.this.marked.getQualifiedName().toString() : "Jump");
        }
    }

    private class ClearMarkAction
    extends MarkActionBase {
        public ClearMarkAction() {
            super("Clear");
        }

        protected void markActionPerformed(ActionEvent e) {
            MandelImagePanel.this.clearMark();
        }
    }

    private class SwapMarkAction
    extends MarkActionBase {
        public SwapMarkAction() {
            super("Swap");
        }

        protected void markActionPerformed(ActionEvent e) {
            QualifiedMandelName old = MandelImagePanel.this.getQualifiedMandelName();
            MandelImagePanel.this.setImage(MandelImagePanel.this.marked.getQualifiedName());
            MandelImagePanel.this.setMark(old);
        }
    }

    private class SetMarkAction
    extends AbstractAction {
        public SetMarkAction() {
            super("Set");
        }

        public void actionPerformed(ActionEvent e) {
            MandelImagePanel.this.setMark(MandelImagePanel.this.getQualifiedMandelName());
        }
    }

    private abstract class MarkActionBase
    extends OptionalAction {
        public MarkActionBase(String name) {
            super(name);
        }

        protected boolean isPossible() {
            return MandelImagePanel.this.getMark() != null;
        }

        public void actionPerformed(ActionEvent e) {
            if (MandelImagePanel.this.marked.isSet()) {
                this.markActionPerformed(e);
            }
        }

        protected abstract void markActionPerformed(ActionEvent var1);
    }

    private class ParentAction
    extends UpdatableAction {
        public ParentAction() {
            super("Parent");
        }

        public void actionPerformed(ActionEvent e) {
            if (!MandelImagePanel.this.getMandelName().isRoot()) {
                if (MandelImagePanel.this.automark_parent.isSet()) {
                    MandelImagePanel.this.setAutoMark();
                }
                MandelImagePanel.this.setImage(MandelImagePanel.this.getMandelName().getParentName());
            }
        }

        public void updateObject(UpdateContext ctx) {
            this.setEnabled(!MandelImagePanel.this.getMandelName().isRoot());
        }
    }

    private class Creator
    implements WindowControlAction.WindowCreator {
        private Creator() {
        }

        public Window createWindow(Window owner) {
            return new MandelImageRecalcDialog(MandelImagePanel.this.getFrameAccess(), "Refinement Request", MandelImagePanel.this.getQualifiedMandelName(), MandelImagePanel.this.getMandelData());
        }
    }

    private class RecalcAction
    extends WindowControlAction {
        public RecalcAction() {
            super(MandelImagePanel.this.getWindow(), "Refine", new Creator());
        }
    }

    private class LastHighlightAction
    extends AbstractAction {
        public LastHighlightAction() {
            super("Last Area");
        }

        public void actionPerformed(ActionEvent e) {
            MandelImagePanel.this.highlight_mode = 3;
            MandelImagePanel.this.updateSubRects();
            if (debug) {
                System.out.println("Last highlight");
            }
        }
    }

    private class UnseenHighlightAction
    extends AbstractAction {
        public UnseenHighlightAction() {
            super("Unseen");
        }

        public void actionPerformed(ActionEvent e) {
            MandelImagePanel.this.highlight_mode = 2;
            MandelImagePanel.this.updateSubRects();
            if (debug) {
                System.out.println("Unseen highlight");
            }
        }
    }

    private class FavoritesHighlightAction
    extends AbstractAction {
        public FavoritesHighlightAction() {
            super("Favorites");
        }

        public void actionPerformed(ActionEvent e) {
            MandelImagePanel.this.highlight_mode = 1;
            MandelImagePanel.this.updateSubRects();
            if (debug) {
                System.out.println("Favorites highlight");
            }
        }
    }

    private class NoHighlightAction
    extends AbstractAction {
        public NoHighlightAction() {
            super("None");
        }

        public void actionPerformed(ActionEvent e) {
            MandelImagePanel.this.highlight_mode = 0;
            MandelImagePanel.this.updateSubRects();
            if (debug) {
                System.out.println("No highlight");
            }
        }
    }

    public final class ExplicitHighlights {
        private List<ExplicitHighlight> list = new ArrayList<ExplicitHighlight>();

        public void add(ExplicitHighlight hl) {
            if (!this.list.contains(hl)) {
                this.list.add(hl);
            }
        }

        public void remove(ExplicitHighlight hl) {
            this.list.remove(hl);
        }

        public Handler createHandler() {
            return new Handler();
        }

        public final class Handler {
            private List<ExplicitHighlight> list = new ArrayList<ExplicitHighlight>();

            private Handler() {
                for (ExplicitHighlight h : ExplicitHighlights.this.list) {
                    if (h.isActive() && !this.contains(h.getQualifiedName())) {
                        if (debugHL) {
                            System.out.println("-- add " + h);
                        }
                        this.list.add(h);
                        continue;
                    }
                    if (!debugHL) continue;
                    System.out.println("-- ignore " + h);
                }
            }

            public boolean contains(QualifiedMandelName n) {
                if (n == null) {
                    return false;
                }
                return this.contains(n.getMandelName());
            }

            public boolean contains(MandelName n) {
                if (n != null) {
                    for (ExplicitHighlight h : this.list) {
                        if (!h.getQualifiedName().getMandelName().equals(n)) continue;
                        return true;
                    }
                }
                return false;
            }

            public void handleAlreadyShown(QualifiedMandelName n) {
                if (n == null) {
                    return;
                }
                this.handleAlreadyShown(n.getMandelName());
            }

            public void handleAlreadyShown(MandelName n) {
                if (n == null) {
                    return;
                }
                ListIterator<ExplicitHighlight> i = this.list.listIterator();
                while (i.hasNext()) {
                    ExplicitHighlight h = i.next();
                    if (!h.getQualifiedName().getMandelName().equals(n)) continue;
                    if (debugHL) {
                        System.out.println("-- remove already seen " + h);
                    }
                    i.remove();
                }
            }

            public void show() {
                for (ExplicitHighlight h : this.list) {
                    if (debugHL) {
                        System.out.println("-- show " + h);
                    }
                    MandelImagePanel.this.showSubRect(h.getQualifiedName(), true);
                }
            }
        }
    }

    public class ExplicitHighlight {
        private String id;
        private QualifiedMandelName name;
        private boolean enabled;

        public ExplicitHighlight(String id, boolean enabled) {
            this.id = id;
            this.enabled = enabled;
        }

        public ExplicitHighlight(String id) {
            this(id, false);
        }

        public boolean isActive() {
            return this.enabled && this.name != null && MandelImagePanel.this.getMandelName().isHigher(this.getMandelName());
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public MandelName getMandelName() {
            if (this.name == null) {
                return null;
            }
            return this.name.getMandelName();
        }

        public QualifiedMandelName getQualifiedName() {
            return this.name;
        }

        public void setQualifiedName(QualifiedMandelName name) {
            this.name = name;
        }

        public void setName(ExplicitHighlight hl) {
            this.setQualifiedName(hl.getQualifiedName());
        }

        public boolean isSet() {
            return this.name != null;
        }

        public void clear() {
            this.name = null;
        }

        public String toString() {
            return "ExplicitHighlight{id=" + this.id + "; name=" + this.name + "; enabled=" + this.enabled + "; active=" + this.isActive() + '}';
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MandelHandleImageFactory
    extends ImageFactory<MandelHandle> {
        public MandelHandleImageFactory(MandelHandle arg) {
            super(arg);
        }

        @Override
        public MandelAreaImage getMandelImage() throws IOException {
            return MandelImagePanel.this.getMandelImage((MandelHandle)this.arg);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class QualifiedMandelNameImageFactory
    extends ImageFactory<QualifiedMandelName> {
        public QualifiedMandelNameImageFactory(QualifiedMandelName arg) {
            super(arg);
        }

        @Override
        public MandelAreaImage getMandelImage() throws IOException {
            return MandelImagePanel.this.getMandelImage((QualifiedMandelName)this.arg);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MandelNameImageFactory
    extends ImageFactory<MandelName> {
        public MandelNameImageFactory(MandelName arg) {
            super(arg);
        }

        @Override
        public MandelAreaImage getMandelImage() throws IOException {
            return MandelImagePanel.this.getMandelImage((MandelName)this.arg);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class ImageFactory<T> {
        protected T arg;

        public ImageFactory(T arg) {
            this.arg = arg;
        }

        abstract MandelAreaImage getMandelImage() throws IOException;

        public String toString() {
            return this.arg.toString();
        }
    }

    private class PanelColormapSource
    extends CachedUpstreamColormapSource {
        private Environment1.FileInfo fileinfo;

        public PanelColormapSource(MandelName n, Environment1.FileInfo fileinfo) {
            super(n, MandelImagePanel.this.getEnvironment().getAreaColormapScanner(), MandelImagePanel.this.getColormapCache());
            this.fileinfo = fileinfo;
        }

        protected Colormap optimizedLoad(MandelHandle h) {
            if (!h.getHeader().isAreaColormap() && MandelImagePanel.this.getMandelName() != null && MandelImagePanel.this.getMandelName().isAbove(this.getBasename()) && ((QualifiedMandelName)h.getName()).getMandelName().isAbove(MandelImagePanel.this.getMandelName())) {
                System.out.println("new area is downstream");
                return MandelImagePanel.this.getDefColormap();
            }
            return super.optimizedLoad(h);
        }

        protected void colormapFound(MandelHandle h, Colormap cm) {
            if (cm != MandelImagePanel.this.getDefColormap()) {
                super.colormapFound(h, cm);
                if (this.fileinfo != null) {
                    this.fileinfo.setColormap(cm);
                }
            }
        }

        public Colormap getColormap() {
            Colormap cm = super.getColormap();
            if (cm == null) {
                cm = MandelImagePanel.this.getDefColormap();
            }
            return cm;
        }
    }

    private class MainSlideShowTwoMode
    extends SlideShowSourceAdapter.TwoModeAdapter {
        private MainSlideShowTwoMode() {
        }

        public QualifiedMandelName getFirstName(SlideShowModel model) {
            return MandelImagePanel.this.getQualifiedMandelName();
        }

        public QualifiedMandelName getSecondName(SlideShowModel model) {
            return MandelImagePanel.this.getMark();
        }
    }

    private class MainSlideShowOneMode
    extends SlideShowSourceAdapter.OneModeAdapter {
        private MainSlideShowOneMode() {
        }

        public QualifiedMandelName getSingleName(SlideShowModel model) {
            return MandelImagePanel.this.getQualifiedMandelName();
        }
    }

    private class MandelFrameImageListner
    implements ImageListener {
        private MandelFrameImageListner() {
        }

        public void stateToBeChanged(ChangeEvent e) {
            if (debug) {
                System.out.println("image to be changed...");
            }
            MandelImagePanel.this.getImagePane().hideAllRects();
        }

        public void stateChanged(ChangeEvent e) {
            if (debug) {
                System.out.println("image changed...");
            }
            if (MandelImagePanel.this.image.getColormap() != null) {
                if (debug) {
                    System.out.println("  setting image and default colormap");
                }
                MandelImagePanel.this.colormapmodel.setColormap(MandelImagePanel.this.defcolormap = MandelImagePanel.this.image.getColormap());
            }
            MandelImagePanel.this.colormapmodel.setModifiable(MandelImagePanel.this.image.getRasterData() != null);
            if (MandelImagePanel.this.image.getImage() != MandelImagePanel.this.buffer.getImage()) {
                if (debug) {
                    System.out.println("  set changed image to buffer");
                }
                BufferedImage tmp = MandelImagePanel.this.filter(MandelImagePanel.this.image.getImage());
                BufferedImage cur = MandelImagePanel.this.buffer.getImage();
                if (cur.getWidth() == tmp.getWidth() && cur.getHeight() == tmp.getHeight()) {
                    cur.getGraphics().drawImage(tmp, 0, 0, null);
                } else {
                    MandelImagePanel.this.buffer.setImage(tmp);
                    MandelImagePanel.this._updateSubRects(false, MandelImagePanel.this.getMandelName(), MandelImagePanel.this.subAreasShown());
                }
            }
            if (MandelImagePanel.this.subAreasShown()) {
                if (debug) {
                    System.out.println("  show areas");
                }
                MandelImagePanel.this.getImagePane().showAllRects();
            }
            MandelImagePanel.this.fireChangeEvent();
            MandelImagePanel.this.getImagePane().repaint();
        }
    }

    private class ColModelChangeListener
    implements ChangeListener {
        private ColModelChangeListener() {
        }

        public void stateChanged(javax.swing.event.ChangeEvent e) {
            boolean mod2 = MandelImagePanel.this.getMandelData().isModified();
            if (MandelImagePanel.this.colormapmodel.getColormap() != MandelImagePanel.this.image.getColormap()) {
                MandelImagePanel.this.image.setColormap(MandelImagePanel.this.colormapmodel.getResizeMode(), MandelImagePanel.this.colormapmodel.getColormap());
            }
            if (debug) {
                System.out.println("setting default colormap to actual colormap");
            }
            MandelImagePanel.this.defcolormap = MandelImagePanel.this.colormapmodel.getColormap();
            if (!mod2) {
                MandelImagePanel.this.updateObjects("colormap", MandelImagePanel.this.colormapmodel.getColormap());
            }
        }
    }

    private class Buffer
    extends BufferedComponent {
        private Decoration decoration;

        public Buffer(BufferedImage image) {
            super(image);
            this.decoration = new Decoration();
        }

        public void setDecoration(String s) {
            this.decoration.setDecoration(s);
        }

        public Decoration getDecoration() {
            return this.decoration;
        }

        public void setShowDecoration(boolean showDecoration) {
            this.decoration.setShowDecoration(showDecoration);
        }

        protected void paintChildren(Graphics g) {
            super.paintChildren(g);
            if (this.decoration.showDecoration()) {
                this.decoration.paintDecoration(g, this.getWidth(), this.getHeight());
            }
        }
    }

    private class ConfiguredBooleanAttribute
    extends BooleanAttribute {
        public ConfiguredBooleanAttribute(JComponent component, String property, String label, boolean b) {
            super(component, property, label, b);
            this.configure();
        }

        public ConfiguredBooleanAttribute(JComponent component, String property, boolean b) {
            super(component, property, b);
            this.configure();
        }

        public ConfiguredBooleanAttribute(JComponent component, String property, String label) {
            super(component, property, label);
            this.configure();
        }

        public ConfiguredBooleanAttribute(JComponent component, String property) {
            super(component, property);
            this.configure();
        }

        private void configure() {
            this.setState(MandelImagePanel.this.getEnvironment().getToolSwitch("config." + this.getPropertyName(), this.isSet()));
        }
    }

    public class Mark
    extends ExplicitHighlight {
        private DefaultMandelListListModel previous;

        public Mark(Environment env) {
            super("marked", true);
            this.previous = new DefaultMandelListListModel(new ArrayMandelList(), env.getAllScanner());
            this.previous.setModifiable(true);
            this.previous.setDuplicates(true);
        }

        public void setQualifiedName(QualifiedMandelName name) {
            QualifiedMandelName mn = name.getBaseName();
            int size = this.previous.getSize();
            super.setQualifiedName(name);
            if (size == 0 || !this.previous.getElementAt(0).equals(mn)) {
                this.previous.add(0, mn);
                if (size >= 20) {
                    this.previous.remove(20);
                }
            }
        }
    }

    public class EnvListener
    implements LinkListener {
        private void update(MandelName n) {
            if (MandelImagePanel.this.getMandelName().equals(n)) {
                MandelImagePanel.this.updateLinks();
            }
        }

        public void linkAdded(MandelName src, MandelName dst) {
            this.update(src);
            this.update(dst);
        }

        public void linkRemoved(MandelName src, MandelName dst) {
            this.update(src);
            this.update(dst);
        }
    }

    public class LoadableListModifier
    extends ListModifierMenu {
        private MandelListModelMenu load;

        public LoadableListModifier(String name, MandelListTableModel model) {
            super(name, model);
        }

        public void cleanupModel() {
            if (this.load != null) {
                this.load.setMandelListModel(null);
            }
        }

        protected void addItems() {
            if (!this.isValid()) {
                return;
            }
            super.addItems();
            this.load = new MandelListModelMenu(MandelImagePanel.this, this.getMandelModel());
            this.add(this.load);
        }
    }

    public class DynListModifierMenu
    extends ListModifierMenu {
        public DynListModifierMenu(String name, MandelListModel model) {
            super(name, model);
        }

        protected void addItems() {
            if (!this.isValid()) {
                return;
            }
            super.addItems();
            this.add(new RemoveListShortcutAction(this.getMandelModel()));
        }
    }

    public class ListModifierMenu
    extends JMenu {
        private MandelListModel model;

        public ListModifierMenu(String name, MandelListModel model) {
            super(name);
            this.model = model;
            if (this.isValid()) {
                this.addItems();
            }
        }

        public void cleanupModel() {
        }

        public MandelListModel getMandelModel() {
            return this.model;
        }

        protected void addItems() {
            if (this.model != null && this.model.isModifiable()) {
                MandelListModel m = this.getMandelModel();
                JMenuItem it = new JMenuItem(new AddListEntryAction(m));
                this.add(it);
                it = new JMenuItem(new RemoveListEntryAction(m));
                this.add(it);
                if (m instanceof MandelListTableModel) {
                    this.add(new OpenListShortcutAction((MandelListTableModel)m, this.getText()));
                }
            }
        }

        public boolean isValid() {
            return this.model != null && this.model.isModifiable();
        }
    }

    public class ToolTipSelectionModel
    extends DefaultComboBoxModel {
        private MandelToolTipHandlerWrapper wrapper = new MandelToolTipHandlerWrapper();

        public ToolTipSelectionModel() {
            this.addListDataListener(new AbstractListDataListener(){

                public void contentsChanged(ListDataEvent e) {
                    if (debug) {
                        System.out.println("select ToolTip " + ToolTipSelectionModel.this.getSelectedItem());
                    }
                    ToolTipSelectionModel.this.wrapper.setToolTipHandler(ToolTipSelectionModel.this.getActualToolTipHandler());
                }
            });
            ToolTipFlavor def = new ToolTipFlavor("PIXELINFO", "Pixel Info", new PixelInfoToolTipHandler());
            this.addElement(def);
            this.addElement(new ToolTipFlavor("SUBAREANAME", "SubArea Name", new SubAreaToolTipHandler()));
        }

        private BufferedComponent.ToolTipHandler getActualToolTipHandler() {
            if (this.getSelectedItem() == null) {
                return null;
            }
            return ((ToolTipFlavor)this.getSelectedItem()).getToolTipHandler();
        }

        public String getSelectedItemId() {
            if (this.getSelectedItem() == null) {
                return null;
            }
            return ((ToolTipFlavor)this.getSelectedItem()).getId();
        }

        public boolean setSelectedItemId(String id) {
            int size = this.getSize();
            for (int i = 0; i < size; ++i) {
                ToolTipFlavor item = (ToolTipFlavor)this.getElementAt(i);
                if (!item.getId().equals(id)) continue;
                System.out.println("select tool tip mode " + id);
                this.setSelectedItem(item);
                return true;
            }
            return false;
        }

        public BufferedComponent.ToolTipHandler getToolTipHandler() {
            return this.wrapper;
        }

        private class MandelToolTipHandlerWrapper
        implements BufferedComponent.ToolTipHandler {
            private BufferedComponent.ToolTipHandler actual;

            private MandelToolTipHandlerWrapper() {
            }

            public void setToolTipHandler(BufferedComponent.ToolTipHandler h) {
                this.actual = h;
            }

            public String getToolTipText(MouseEvent event) {
                return this.actual == null ? null : this.actual.getToolTipText(event);
            }
        }

        private class ToolTipFlavor {
            private String name;
            private String id;
            private BufferedComponent.ToolTipHandler handler;

            ToolTipFlavor(String id, String name, BufferedComponent.ToolTipHandler handler) {
                this.id = id;
                this.name = name;
                this.handler = handler;
            }

            public String getName() {
                return this.name;
            }

            public String getId() {
                return this.id;
            }

            public BufferedComponent.ToolTipHandler getToolTipHandler() {
                return this.handler;
            }

            public String toString() {
                return this.getName();
            }
        }
    }

    public class SubAreaToolTipHandler
    implements BufferedComponent.ToolTipHandler {
        private MandelName last;
        private String text;

        public String getToolTipText(MouseEvent event) {
            String sub = MandelImagePanel.this.findSubName(event.getPoint());
            if (sub != null) {
                MandelName mn = QualifiedMandelName.create(sub).getMandelName();
                this.text = sub;
                if (mn != null && !mn.equals(this.last)) {
                    int ic = MandelImagePanel.this.count(mn, MandelImagePanel.this.getEnvironment().getImageDataScanner());
                    if (MandelImagePanel.this.getEnvironment().isReadonly()) {
                        this.text = ic == 1 ? sub + " (" + ic + " sub area)" : sub + " (" + ic + " sub areas)";
                    } else {
                        int ir = MandelImagePanel.this.count(mn, MandelImagePanel.this.getEnvironment().getInfoScanner());
                        this.text = ic == 1 ? sub + " (" + ic + " sub area, " + ir + " pending)" : sub + " (" + ic + " sub areas, " + ir + " pending)";
                    }
                }
            } else {
                this.last = null;
                this.text = null;
            }
            return this.text;
        }
    }

    public class PixelInfoToolTipHandler
    implements BufferedComponent.ToolTipHandler {
        public String getToolTipText(MouseEvent event) {
            Point p = new Point((int)((double)event.getY() / MandelImagePanel.this.filterscale), (int)((double)event.getX() / MandelImagePanel.this.filterscale));
            MandelRaster r = MandelImagePanel.this.image.getRasterData();
            int d = r.getRaster()[(int)p.getX()][(int)p.getY()];
            return "(" + event.getX() + "," + event.getY() + "): " + d;
        }
    }

    public class ProportionSelectionModel
    extends DefaultComboBoxModel {
        public ProportionSelectionModel() {
            this.addElement(new Proportion("Image Proportion", MandelImagePanel.this.imagepropprov));
            this.addElement(new Proportion("3:2", new ProportionProvider.Proportion(1.5)));
            this.addElement(new Proportion("10:7", new ProportionProvider.Proportion(1.4285714285714286)));
            this.addElement(new Proportion("4:3", new ProportionProvider.Proportion(1.3333333333333333)));
            this.addElement(new Proportion("1:1", new ProportionProvider.Proportion(1.0)));
            this.addElement(new Proportion("Creation Dialog Proportion", MandelImagePanel.this.creatpropprov));
            this.setSelectedItem(null);
            this.addListDataListener(new AbstractListDataListener(){

                public void contentsChanged(ListDataEvent e) {
                    if (debug) {
                        System.out.println("select PROPORTION " + ProportionSelectionModel.this.getSelectedItem());
                    }
                    if (!MandelImagePanel.this.isReadonly()) {
                        MandelImagePanel.this.selector.setProportionProvider(ProportionSelectionModel.this.getProportionProvider());
                    }
                }
            });
        }

        public ProportionProvider getProportionProvider() {
            if (this.getSelectedItem() == null) {
                return null;
            }
            return ((Proportion)this.getSelectedItem()).getProportionProvider();
        }

        private class Proportion {
            private String name;
            private ProportionProvider provider;

            Proportion(String name, ProportionProvider provider) {
                this.name = name;
                this.provider = provider;
            }

            public String getName() {
                return this.name;
            }

            public ProportionProvider getProportionProvider() {
                return this.provider;
            }

            public String toString() {
                return this.getName();
            }
        }
    }

    private class CreationDialogProportionProvider
    extends AreaProportionProvider {
        private CreationDialogProportionProvider() {
        }

        public double getProportion() {
            MandelInfo info;
            double d = 0.0;
            if (MandelImagePanel.this.create != null && MandelImagePanel.this.create.isVisible() && (info = MandelImagePanel.this.create.getInfo()) != null) {
                d = MandUtils.getProportion(info.getRX(), info.getRY(), MandelImagePanel.this.getMandelInfo());
            }
            if (d == 0.0) {
                d = super.getProportion();
            }
            return d;
        }
    }

    private class AreaProportionProvider
    implements ProportionProvider {
        private AreaProportionProvider() {
        }

        public double getProportion() {
            MandelInfo info = MandelImagePanel.this.getMandelInfo();
            double d = MandUtils.div(info.getDY(), info.getDX()).doubleValue() * (double)info.getRX() / (double)info.getRY() * (double)info.getRX() / (double)info.getRY();
            if (debug) {
                System.out.println("proportion is " + d);
            }
            return d;
        }
    }

    private class AreaSelectionModel
    extends DefaultComboBoxModel {
        public AreaSelectionModel() {
            this.addElement(new Selector("Centered Proportional", new BufferedComponent.CenteredProportionalRectangleSelector(MandelImagePanel.this.imagepropprov)));
            this.addElement(new Selector("Proportional", new BufferedComponent.ProportionalRectangleSelector(MandelImagePanel.this.imagepropprov)));
            this.setSelectedItem(null);
            this.addListDataListener(new AbstractListDataListener(){

                public void contentsChanged(ListDataEvent e) {
                    if (debug) {
                        System.out.println("select SELECTOR " + AreaSelectionModel.this.getSelectedItem());
                    }
                    if (!MandelImagePanel.this.isReadonly()) {
                        MandelImagePanel.this.buffer.setRectangleSelector(AreaSelectionModel.this.getRectangleSelector());
                        AreaSelectionModel.this.setProportionProvider(MandelImagePanel.this.proportion.getProportionProvider());
                    }
                }
            });
        }

        public BufferedComponent.RectangleSelector getRectangleSelector() {
            if (this.getSelectedItem() == null) {
                return null;
            }
            return ((Selector)this.getSelectedItem()).getSelector();
        }

        public void setProportionProvider(ProportionProvider d) {
            BufferedComponent.RectangleSelector s;
            if (d != null && (s = this.getRectangleSelector()) instanceof BufferedComponent.ProportionalRectangleSelector) {
                BufferedComponent.ProportionalRectangleSelector p = (BufferedComponent.ProportionalRectangleSelector)s;
                p.setProportionProvider(d);
            }
        }

        private class Selector {
            private String name;
            private BufferedComponent.RectangleSelector sel;

            Selector(String name, BufferedComponent.RectangleSelector sel) {
                this.name = name;
                this.sel = sel;
                sel.setStroke(dashed);
            }

            public String getName() {
                return this.name;
            }

            public BufferedComponent.RectangleSelector getSelector() {
                return this.sel;
            }

            public String toString() {
                return this.getName();
            }
        }
    }
}

