/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool;

import com.mandelsoft.mand.MandelData;
import com.mandelsoft.mand.MandelFileName;
import com.mandelsoft.mand.MandelInfo;
import com.mandelsoft.mand.MandelName;
import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.tool.MandelAreaViewDialog;
import com.mandelsoft.mand.tool.MandelImageAreaDialog;
import com.mandelsoft.mand.tool.MandelWindowAccess;
import com.mandelsoft.util.Utils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.plaf.basic.BasicBorders;

public class MandelImageRecalcDialog
extends MandelImageAreaDialog {
    public MandelImageRecalcDialog(MandelWindowAccess owner, String title, QualifiedMandelName name, MandelData data) {
        super(owner, title, owner.getEnvironment().mapToInfoFile(data.getFile()).getPath(), name, new MandelInfo().copyFrom(data.getInfo()), true);
    }

    protected MandelAreaViewDialog.MandelAreaView createView(QualifiedMandelName name, Object info, boolean change, boolean readonly) {
        return new RecalcView(name, (MandelInfo)info, readonly);
    }

    protected class RecalcView
    extends MandelImageAreaDialog.View {
        public RecalcView(QualifiedMandelName name, MandelInfo info, boolean readonly) {
            super(name, info, readonly);
            this.filename.setEditable(true);
            this.filename.setBorder(BasicBorders.getTextFieldBorder());
            this.limitfield.setEditable(true);
            this.limitfield.setBorder(BasicBorders.getTextFieldBorder());
        }

        protected void setupButtons() {
            this.createButton("Save", null, new SaveAction());
            this.createButton("Delete", null, new DeleteAction());
            super.setupButtons();
        }

        private class DeleteAction
        implements ActionListener {
            private DeleteAction() {
            }

            public void actionPerformed(ActionEvent e) {
                if (Utils.isEmpty(RecalcView.this.filename.getText())) {
                    return;
                }
                File f = new File(RecalcView.this.filename.getText());
                MandelName name = MandelName.create(f);
                if (name == null) {
                    MandelImageRecalcDialog.this.mandelError(f.getName() + " is no valid mandel area name.");
                    return;
                }
                if (!f.exists()) {
                    MandelImageRecalcDialog.this.mandelError("File does not exist.");
                    return;
                }
                if (!MandelImageRecalcDialog.this.deleteFileDialog(f)) {
                    return;
                }
                f.delete();
                if (f.exists()) {
                    MandelImageRecalcDialog.this.mandelError("Cannot delete " + f + ".");
                    return;
                }
            }
        }

        private class SaveAction
        implements ActionListener {
            private SaveAction() {
            }

            public void actionPerformed(ActionEvent e) {
                if (Utils.isEmpty(RecalcView.this.filename.getText())) {
                    return;
                }
                MandelInfo info = RecalcView.this.getInfo();
                MandelData md = new MandelData(info);
                File f = new File(RecalcView.this.filename.getText());
                MandelFileName name = MandelFileName.create(f);
                if (name == null) {
                    MandelImageRecalcDialog.this.mandelError(f.getName() + " is no valid mandel area name.");
                    return;
                }
                if (f.exists() && !MandelImageRecalcDialog.this.overwriteFileDialog(f)) {
                    return;
                }
                try {
                    md.write(f);
                    if (name.getQualifiedName().equals(RecalcView.this.qname)) {
                        System.out.println("add to refinement list");
                        MandelImageRecalcDialog.this.getEnvironment().getUnseenRefinements().addRefinement(RecalcView.this.qname);
                    }
                    System.out.println("close refinement");
                    MandelImageRecalcDialog.this.getDialog().setVisible(false);
                }
                catch (IOException ex) {
                    MandelImageRecalcDialog.this.mandelError("Cannot write mandel info file", ex);
                }
            }
        }
    }
}

