/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool;

import com.mandelsoft.mand.image.MandelImage;
import com.mandelsoft.mand.tool.MandelDialog;
import com.mandelsoft.mand.tool.MandelImagePanel;
import com.mandelsoft.mand.tool.MandelListFolderGaleryPanel;
import com.mandelsoft.mand.tool.MandelListFolderListModel;
import com.mandelsoft.mand.tool.MandelListFolderTreeModel;
import com.mandelsoft.mand.tool.MandelWindowAccess;
import com.mandelsoft.mand.util.CachedUpstreamColormapSourceFactory;
import com.mandelsoft.mand.util.MandelListFolder;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class MandelListFolderGaleryDialog
extends MandelDialog {
    private MandelListFolderListModel model;
    private Listener listener;

    public MandelListFolderGaleryDialog(MandelWindowAccess owner, MandelListFolderTreeModel tmodel, MandelListFolder folder) {
        super(owner);
        this.model = new MandelListFolderListModel(tmodel, owner.getEnvironment().getImageDataScanner());
        if (folder != null) {
            this.model.setActiveFolder(folder);
        }
        this.setTitle(this.model.getActivePathName());
        this.listener = new Listener();
        this.model.addPropertyChangeListener("activeName", this.listener);
        this.model.setModifiable(!owner.getEnvironment().isReadonly());
        MandelImage.Factory factory = new MandelImage.Factory(owner.getColormapModel());
        this.model.setFactory(factory);
        MandelImagePanel mp = owner.getMandelImagePane();
        if (mp != null && mp.getParentColormapModel().isSet()) {
            this.model.setColormapSourceFactory(new CachedUpstreamColormapSourceFactory(this.model.getMandelScanner(), owner.getColormapModel(), owner.getEnvironment().getColormapCache()));
        }
        MandelListFolderGaleryPanel p = new MandelListFolderGaleryPanel(this.model);
        this.add(p);
        this.pack();
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        int w = this.getWidth();
        int h = this.getHeight();
        if ((double)w > d.getWidth() - 20.0) {
            w = (int)d.getWidth() - 20;
            h += 30;
        } else {
            w = w < 100 ? 100 : (w += 30);
        }
        h = (double)h > d.getHeight() - 20.0 ? (int)d.getHeight() - 20 : (h < 100 ? 100 : (h += 30));
        this.setSize(w, h);
        this.setDefaultCloseOperation(2);
        this.setResizable(true);
        this.setVisible(true);
    }

    public void dispose() {
        System.out.println("close galery");
        this.model.setModel(null);
        super.dispose();
    }

    private class Listener
    implements PropertyChangeListener {
        private Listener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            System.out.println("path name changed: " + MandelListFolderGaleryDialog.this.model.getActivePathName());
            MandelListFolderGaleryDialog.this.setTitle(MandelListFolderGaleryDialog.this.model.getActivePathName());
        }
    }
}

