/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool;

import com.mandelsoft.mand.tool.MandelGaleryPanel;
import com.mandelsoft.mand.tool.MandelListFolderListModel;
import com.mandelsoft.mand.tool.MandelListFolderPanel;
import com.mandelsoft.mand.tool.MandelListFolderTreeModel;
import com.mandelsoft.mand.tool.MandelListFolderTreeModelSupport;
import com.mandelsoft.mand.tool.ctx.MandelContextMenuHandler;
import com.mandelsoft.mand.tool.ctx.MandelListFolderContextMenuHandler;
import com.mandelsoft.mand.util.MandelList;
import com.mandelsoft.mand.util.MandelListFolder;
import com.mandelsoft.swing.DnDJList;
import com.mandelsoft.swing.Selection;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MandelListFolderGaleryPanel
extends MandelGaleryPanel<MandelListFolder, MandelListFolderListModel> {
    private ContextHandler contextHandler;

    public MandelListFolderGaleryPanel(MandelListFolderListModel model) {
        this(model, 1, new Dimension(100, 100));
    }

    public MandelListFolderGaleryPanel(MandelListFolderListModel model, int rows, Dimension d) {
        super(model, rows, d);
        this.list.addMouseListener(new Listener());
        this.contextHandler = new ContextHandler();
        this.setContextMenuHandler(this.contextHandler);
    }

    @Override
    protected void panelUnbound() {
        super.panelUnbound();
        System.out.println("cleanup folder galery");
        ((MandelListFolderListModel)this.getModel()).setModel(null);
    }

    @Override
    protected String getLabel(MandelListFolder elem) {
        return elem.getName();
    }

    @Override
    protected Icon getIcon(MandelListFolder elem) {
        if (elem.getMandelList() == null) {
            return MandelListFolderPanel.folderIcon;
        }
        if (elem.isLeaf()) {
            return MandelListFolderPanel.listIcon;
        }
        return MandelListFolderPanel.folderlistIcon;
    }

    @Override
    public boolean isModifiable() {
        return ((MandelListFolderListModel)this.getModel()).isModifiable();
    }

    @Override
    public void setModifiable(boolean modifiable) {
        this.handleModifiable(modifiable);
        ((MandelListFolderListModel)this.getModel()).setModifiable(modifiable);
    }

    public MandelListFolderTreeModel getFolderTreeModel() {
        return ((MandelListFolderListModel)this.getModel()).getFolderTreeModel();
    }

    private class ContextHandler
    extends MandelListFolderContextMenuHandler
    implements DnDJList.ContextMenuHandler {
        private Action backAction = new BackAction();

        private ContextHandler() {
        }

        public MandelListFolderTreeModel getModel() {
            return MandelListFolderGaleryPanel.this.getFolderTreeModel();
        }

        public MandelList getSelectedMandelList() {
            return this.getSelectedItem().getMandelList();
        }

        public void handleContextMenu(JComponent comp, MouseEvent evt, Selection sel) {
            int index = sel.getLeadSelection();
            MandelListFolderListModel model = (MandelListFolderListModel)MandelListFolderGaleryPanel.this.getModel();
            MandelListFolder folder = index >= 0 ? (MandelListFolder)model.getElementAt(index) : model.getActiveFolder();
            TreePath p = MandelListFolderTreeModelSupport.getPathToRoot(folder);
            this.handleContextMenu(comp, evt, p);
        }

        protected JPopupMenu createContextMenu(TreePath p) {
            JPopupMenu menu = super.createContextMenu(p);
            MandelListFolderListModel model = (MandelListFolderListModel)MandelListFolderGaleryPanel.this.getModel();
            if (model.getActiveFolder().getParent() != null) {
                if (menu != null) {
                    menu.addSeparator();
                } else {
                    menu = new JPopupMenu();
                }
                menu.add(this.backAction);
            }
            return menu;
        }

        private class BackAction
        extends MandelContextMenuHandler.ContextAction {
            public BackAction() {
                super(ContextHandler.this, "Parent");
            }

            public void actionPerformed(ActionEvent e) {
                MandelListFolderListModel model = (MandelListFolderListModel)MandelListFolderGaleryPanel.this.getModel();
                MandelListFolder parent = model.getActiveFolder().getParent();
                if (parent != null) {
                    model.setActiveFolder(parent);
                }
            }
        }
    }

    private class Listener
    extends MouseAdapter {
        private Listener() {
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() < 2) {
                return;
            }
            MandelListFolder sel = (MandelListFolder)MandelListFolderGaleryPanel.this.list.getSelectedValue();
            if (sel == null || sel.isLeaf()) {
                return;
            }
            ((MandelListFolderListModel)MandelListFolderGaleryPanel.this.getModel()).setActiveFolder(sel);
        }
    }
}

