/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool;

import com.mandelsoft.mand.MandelName;
import com.mandelsoft.mand.image.MandelImage;
import com.mandelsoft.mand.tool.AbstractMandelListListModel;
import com.mandelsoft.mand.tool.DefaultMandelListListModel;
import com.mandelsoft.mand.tool.MandelDialog;
import com.mandelsoft.mand.tool.MandelImagePanel;
import com.mandelsoft.mand.tool.MandelListFolderListModel;
import com.mandelsoft.mand.tool.MandelListFolderTreeModel;
import com.mandelsoft.mand.tool.MandelListFolderTreeModelListener;
import com.mandelsoft.mand.tool.MandelListFolderTreeModelSupport;
import com.mandelsoft.mand.tool.MandelListGaleryPanel;
import com.mandelsoft.mand.tool.MandelListProxyListModelForTable;
import com.mandelsoft.mand.tool.MandelListTableModel;
import com.mandelsoft.mand.tool.MandelWindowAccess;
import com.mandelsoft.mand.tool.ToolEnvironment;
import com.mandelsoft.mand.util.CachedUpstreamColormapSourceFactory;
import com.mandelsoft.mand.util.MandelList;
import com.mandelsoft.mand.util.MandelListFolder;
import com.mandelsoft.swing.AbstractTreeModelListener;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.event.TreeModelEvent;

public class MandelListGaleryDialog
extends MandelDialog {
    private MandelListProxyListModelForTable pmodel;
    private AbstractMandelListListModel model;
    private Listener listener;
    private MandelListFolderTreeModel fmodel;
    private MandelListFolder folder;
    private FListener flistener;
    private MandelListGaleryPanel galery;

    public MandelListGaleryDialog(MandelWindowAccess owner, MandelListFolderTreeModel fmodel, MandelListFolder f) {
        this(owner, fmodel.getMandelListModel(f), f.getPath());
        this.fmodel = fmodel;
        this.folder = f;
        this.flistener = new FListener();
        fmodel.addTreeModelListener(this.flistener);
    }

    public MandelListGaleryDialog(MandelWindowAccess owner, MandelListTableModel tmodel, String name) {
        this(owner, new MandelListProxyListModelForTable(tmodel), name);
        this.pmodel = (MandelListProxyListModelForTable)this.model;
        this.pmodel.setModifiable(!owner.getEnvironment().isReadonly());
    }

    public MandelListGaleryDialog(MandelWindowAccess owner, MandelList tmplist, String name) {
        this(owner, new DefaultMandelListListModel(tmplist, owner.getEnvironment().getImageDataScanner()), name);
    }

    public MandelListGaleryDialog(MandelWindowAccess owner, AbstractMandelListListModel lmodel, String name) {
        super(owner, name);
        this.model = lmodel;
        MandelImage.Factory factory = new MandelImage.Factory(owner.getColormapModel());
        this.model.setFactory(factory);
        MandelImagePanel mp = owner.getMandelImagePane();
        if (mp != null && mp.getParentColormapModel().isSet()) {
            this.model.setColormapSourceFactory(new CachedUpstreamColormapSourceFactory(this.model.getMandelScanner(), mp.getColormapModel(), owner.getEnvironment().getColormapCache()));
            System.out.println("-> galery with upstream colormap");
        } else {
            System.out.println("-> galery with main colormap");
        }
        this.galery = new MandelListGaleryPanel(this.model);
        if (owner.getMandelImagePane() != null) {
            this.galery.setMaxFrame(owner.getMandelImagePane().getMaxFrame());
        }
        this.add(this.galery);
        this.pack();
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        int w = this.getWidth();
        int h = this.getHeight();
        if ((double)w > d.getWidth() - 20.0) {
            w = (int)d.getWidth() - 20;
            h += 30;
        } else {
            w = w < 100 ? 100 : (w += 30);
        }
        h = (double)h > d.getHeight() - 20.0 ? (int)d.getHeight() - 20 : (h < 100 ? 100 : (h += 30));
        this.setSize(w, h);
        this.setDefaultCloseOperation(2);
        this.setResizable(true);
        this.setVisible(true);
        this.listener = new Listener();
        owner.getEnvironment().addEnvironmentListener(this.listener);
        owner.getEnvironment().getMandelListFolderTreeModel().addMandelListFolderTreeModelListener(this.listener);
    }

    public void dispose() {
        System.out.println("close galery");
        if (this.pmodel != null) {
            this.pmodel.setModel(null);
        }
        this.getEnvironment().getMandelListFolderTreeModel().removeMandelListFolderTreeModelListener(this.listener);
        this.getEnvironment().removeEnvironmentListener(this.listener);
        if (this.fmodel != null) {
            this.fmodel.removeTreeModelListener(this.flistener);
        }
        super.dispose();
    }

    public void setRootName(MandelName rootName) {
        this.galery.setRootName(rootName);
    }

    public MandelName getRootName() {
        return this.galery.getRootName();
    }

    private class FListener
    extends AbstractTreeModelListener {
        private FListener() {
        }

        public void treeNodesChanged(TreeModelEvent e) {
            if (MandelListFolderListModel.getParentPath(e, MandelListFolderTreeModelSupport.getPathToRoot(MandelListGaleryDialog.this.folder)) != null) {
                MandelListGaleryDialog.this.setTitle(MandelListGaleryDialog.this.folder.getPath());
            }
        }
    }

    private class Listener
    extends ToolEnvironment.ListenerAdapter
    implements MandelListFolderTreeModelListener {
        private Listener() {
        }

        public void mandelListDeleted(MandelList list) {
            if (list == MandelListGaleryDialog.this.model.getList()) {
                MandelListGaleryDialog.this.dispose();
            }
        }

        public void foldersDeleted(TreeModelEvent e) {
            Object[] children = e.getChildren();
            if (children == null) {
                this.handle((MandelListFolder)e.getTreePath().getLastPathComponent());
            } else {
                for (Object o : children) {
                    this.handle((MandelListFolder)o);
                }
            }
        }

        protected void handle(MandelListFolder f) {
            if (MandelListGaleryDialog.this.model != null && MandelListGaleryDialog.this.model.getList() != null && f != null && f.containsTransitively(MandelListGaleryDialog.this.model.getList())) {
                MandelListGaleryDialog.this.dispose();
            }
        }
    }
}

