/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool;

import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.tool.MandelWindowAccess;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MandelListMenu
extends JMenu {
    private MandelWindowAccess access;
    private List<Entry> list;
    private boolean shortnames;
    private boolean sorted;
    private List<SelectAction> actions;

    public MandelListMenu(MandelWindowAccess access) {
        this("Load", access);
    }

    public MandelListMenu(String name, MandelWindowAccess access) {
        super(name);
        this.access = access;
        this.list = new ArrayList<Entry>();
        this.actions = new ArrayList<SelectAction>();
        this.setEnabled(false);
    }

    public void addSelectAction(SelectAction a) {
        if (!this.actions.contains(a)) {
            this.actions.add(a);
        }
    }

    public boolean removeSelectAction(SelectAction a) {
        return this.actions.remove(a);
    }

    public void setUseShortnames(boolean shortnames) {
        this.shortnames = shortnames;
    }

    public void setSorted(boolean sorted) {
        this.sorted = sorted;
    }

    protected Entry lookup(QualifiedMandelName n) {
        for (Entry e : this.list) {
            if (!e.name.equals(n)) continue;
            return e;
        }
        return null;
    }

    protected Entry lookup(QualifiedMandelName n, Collection<Entry> skip) {
        for (Entry e : this.list) {
            if (!e.name.equals(n) || skip != null && skip.contains(e)) continue;
            return e;
        }
        return null;
    }

    protected Entry createEntry(QualifiedMandelName n) {
        return new Entry(n);
    }

    public void clear() {
        ListIterator<Entry> i = this.entries();
        while (i.hasNext()) {
            this.remove(i.next(), i);
        }
        this.setEnabled(false);
    }

    protected void add(Entry e) {
        int idx = 0;
        if (this.sorted) {
            ListIterator<Entry> i = this.entries();
            while (i.hasNext()) {
                Entry s = i.next();
                if (s.name.compareTo(e.name) >= 0) {
                    this.list.add(idx, e);
                    super.add((Component)e, idx);
                    idx = -1;
                    break;
                }
                ++idx;
            }
        }
        if (idx >= 0) {
            this.list.add(e);
            super.add(e);
        }
        this.setEnabled(true);
    }

    public void add(QualifiedMandelName n) {
        Entry e = this.lookup(n);
        if (e == null) {
            e = this.createEntry(n);
            this.add(e);
        }
    }

    public void remove(QualifiedMandelName n) {
        Entry entry = this.lookup(n);
        if (entry != null) {
            this.remove(entry, null);
            if (this.list.isEmpty()) {
                this.setEnabled(false);
            }
        }
    }

    protected void remove(Entry e, ListIterator<Entry> i) {
        if (i != null) {
            i.remove();
        } else {
            this.list.remove(e);
        }
        super.remove(e);
        if (this.list.isEmpty()) {
            this.setEnabled(false);
        }
    }

    protected ListIterator<Entry> entries() {
        return this.list.listIterator();
    }

    protected class Entry
    extends JMenuItem
    implements ActionListener {
        QualifiedMandelName name;

        public Entry(QualifiedMandelName name) {
            String txt;
            this.name = name;
            if (MandelListMenu.this.shortnames) {
                txt = name.getMandelName().getSubAreaName();
                if (name.getQualifier() != null) {
                    txt = txt + "-" + name.getQualifier();
                }
            } else {
                txt = name.toString();
            }
            this.setText(txt);
            this.setName(txt);
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent e) {
            QualifiedMandelName sel = this.name;
            if (sel == null) {
                return;
            }
            for (SelectAction a : MandelListMenu.this.actions) {
                a.selectArea(MandelListMenu.this.access, sel);
            }
            MandelListMenu.this.access.getMandelImagePane().setBusy(true);
            if (MandelListMenu.this.access.getMandelImagePane().setImage(sel)) {
                this.handleLoaded(sel);
            } else {
                JOptionPane.showMessageDialog(MandelListMenu.this.access.getMandelWindow(), "Cannot load image: " + sel, "Mandel IO", 2);
            }
            MandelListMenu.this.access.getMandelImagePane().setBusy(false);
        }

        protected void handleLoaded(QualifiedMandelName name) {
        }
    }

    public static interface SelectAction {
        public void selectArea(MandelWindowAccess var1, QualifiedMandelName var2);
    }
}

