/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool;

import com.mandelsoft.mand.MandelData;
import com.mandelsoft.mand.MandelName;
import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.scan.MandelHandle;
import com.mandelsoft.mand.tool.MandelImageAreaDialog;
import com.mandelsoft.mand.tool.MandelImagePanel;
import com.mandelsoft.mand.tool.MandelListGaleryDialog;
import com.mandelsoft.mand.tool.MandelListModelSource;
import com.mandelsoft.mand.tool.MandelListSelector;
import com.mandelsoft.mand.tool.MandelListTableModel;
import com.mandelsoft.mand.tool.MandelNameSelector;
import com.mandelsoft.mand.tool.MandelWindowAccess;
import com.mandelsoft.mand.tool.MandelWindowAccessSource;
import com.mandelsoft.mand.tool.ToolEnvironment;
import com.mandelsoft.mand.tool.ctx.MandelListContextMenuHandler;
import com.mandelsoft.mand.util.MandelList;
import com.mandelsoft.swing.DnDJTable;
import com.mandelsoft.swing.MenuButton;
import com.mandelsoft.swing.TablePanel;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JViewport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MandelListPanel
extends TablePanel<MandelListTableModel>
implements MandelWindowAccessSource,
MandelNameSelector,
MandelListSelector,
MandelListModelSource {
    private boolean modifiable;
    private MandelName rootName;
    private JButton removeButton;
    private JButton addButton;
    private GaleryAction galery;
    private Set<JButton> buttons;

    public MandelListPanel() {
        this.setup(null);
        this.handleModifiable(this.modifiable);
    }

    public MandelListPanel(String header, MandelListTableModel model, ActionListener action) {
        super(header, model, null);
        this.setup(action);
        this.modifiable = model.isModifiable();
        this.handleModifiable(this.modifiable);
    }

    public MandelListPanel(boolean modifiable) {
        this.setup(null);
        this.modifiable = modifiable;
        this.handleModifiable(modifiable);
    }

    public MandelListPanel(String header, MandelListTableModel model, ActionListener action, boolean modifiable) {
        super(header, model, null);
        this.setup(action);
        this.modifiable = modifiable;
        this.handleModifiable(modifiable);
    }

    public MandelListPanel(String header, MandelListTableModel model, boolean modifiable) {
        super(header, model);
        this.setup(null);
        this.modifiable = modifiable;
        this.handleModifiable(modifiable);
    }

    @Override
    public MandelWindowAccess getMandelWindowAccess() {
        return MandelWindowAccess.Access.getMandelWindowAccess(this);
    }

    @Override
    protected JTable createTable() {
        return new DnDJTable();
    }

    protected void setup(ActionListener action) {
        if (action == null) {
            action = new LoadAction();
        }
        this.addActionListener(action);
        this.addButton("Refresh", new RefreshAction());
        this.addButton("Load", action);
        this.addButton("Prev", new PrevAction(action));
        this.addButton("Next", new NextAction(action));
        this.removeButton = this.addButton("Remove", new RemoveAction());
        this.addButton = this.addButton("Add", new AddAction());
        this.galery = new GaleryAction();
        this.addButton("Galery", this.galery);
        this.setupActions();
        this.setContextMenuHandler(new ContextHandler());
    }

    @Override
    protected void panelBound() {
        super.panelBound();
        MandelImagePanel mp = this.getMandelWindowAccess().getMandelImagePane();
        if (mp != null) {
            JPopupMenu showmenu = mp.getSlideShowModel().createPopupMenu((Component)this, true);
            MenuButton show = new MenuButton(showmenu);
            this.addButton(show);
        }
    }

    public MandelName getRootName() {
        return this.rootName;
    }

    public void setRootName(MandelName rootName) {
        this.rootName = rootName;
    }

    @Override
    public QualifiedMandelName getSelectedMandelName() {
        int index = this.getSelectedIndex();
        return index >= 0 ? ((MandelListTableModel)this.getModel()).getQualifiedName(index) : null;
    }

    @Override
    public MandelList getSelectedMandelList() {
        return ((MandelListTableModel)this.getModel()).getList();
    }

    public boolean isModifiable() {
        return this.modifiable;
    }

    public void setModifiable(boolean modifiable) {
        if (modifiable != this.modifiable) {
            this.modifiable = modifiable;
            this.handleModifiable(this.modifiable);
            this.firePropertyChange("modifiable", !modifiable, modifiable);
        }
    }

    protected void handleModifiable(boolean modifiable) {
        if (this.removeButton != null) {
            this.removeButton.setEnabled(modifiable);
            this.removeButton.setVisible(modifiable);
        }
        if (this.addButton != null) {
            this.addButton.setEnabled(modifiable);
            this.addButton.setVisible(modifiable);
        }
        ((MandelListTableModel)this.getModel()).setModifiable(modifiable);
        this.setFillsViewportHeight(modifiable);
    }

    @Override
    public void setModel(MandelListTableModel model) {
        super.setModel(model);
        this.setModifiable(((MandelListTableModel)this.getModel()).isModifiable());
        this.setupActions();
        this.invalidate();
        this.validate();
    }

    private void setupActions() {
        if (this.buttons == null) {
            this.buttons = new HashSet<JButton>();
        }
        for (JButton b : this.buttons) {
            this.removeButton(b);
        }
        List<Action> actions = ((MandelListTableModel)this.getModel()).getActions();
        if (actions != null) {
            for (Action a : actions) {
                JButton b = new JButton(a);
                this.addButton(b);
                this.buttons.add(b);
            }
        }
    }

    public void scrollToVisible(int rowIndex, int vColIndex) {
        JTable table = this.getTable();
        if (!(table.getParent() instanceof JViewport)) {
            return;
        }
        JViewport viewport = (JViewport)table.getParent();
        Rectangle rect = table.getCellRect(rowIndex, vColIndex, true);
        Point pt = viewport.getViewPosition();
        rect.setLocation(rect.x - pt.x, rect.y - pt.y);
        viewport.scrollRectToVisible(rect);
    }

    private class ContextHandler
    extends MandelListContextMenuHandler
    implements TablePanel.ContextMenuHandler {
        private Action rootAction = new RootAction();

        private ContextHandler() {
        }

        protected JPopupMenu createListContextMenu(JPopupMenu menu) {
            if ((menu = super.createListContextMenu(menu)) == null) {
                menu = new JPopupMenu();
            }
            JMenuItem it = new JMenuItem("Galery");
            it.addActionListener(MandelListPanel.this.galery);
            menu.add(it);
            if (MandelListPanel.this.rootName != null) {
                menu.add(new JMenuItem(this.rootAction));
            }
            return menu;
        }

        private class RootAction
        extends MandelListContextMenuHandler.LoadImageAction {
            public RootAction() {
                super(ContextHandler.this, "Load Root Image");
            }

            public QualifiedMandelName getSelectedItem() {
                return new QualifiedMandelName(MandelListPanel.this.rootName);
            }
        }
    }

    private class AddAction
    implements ActionListener {
        private AddAction() {
        }

        public void actionPerformed(ActionEvent e) {
            MandelWindowAccess w = MandelListPanel.this.getMandelWindowAccess();
            if (w != null) {
                ((MandelListTableModel)MandelListPanel.this.getModel()).add(w.getQualifiedName());
            }
        }
    }

    private class RemoveAction
    implements ActionListener {
        private RemoveAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (MandelListPanel.this.getSelectedMandelName() == null) {
                return;
            }
            ((MandelListTableModel)MandelListPanel.this.getModel()).remove(MandelListPanel.this.getSelectedMandelName());
            try {
                ((MandelListTableModel)MandelListPanel.this.getModel()).getList().save();
            }
            catch (IOException io) {
                JOptionPane.showMessageDialog(MandelListPanel.this.getWindow(), "Cannot save list file: " + io, "Mandel IO", 2);
            }
        }
    }

    private class PrevAction
    extends SelectListener {
        public PrevAction(ActionListener load) {
            super(load);
        }

        protected int getIndex(int index) {
            if (index < 0) {
                index = MandelListPanel.this.getTable().getRowCount();
            }
            return index - 1;
        }
    }

    private class NextAction
    extends SelectListener {
        public NextAction(ActionListener load) {
            super(load);
        }

        protected int getIndex(int index) {
            if (++index >= MandelListPanel.this.getTable().getRowCount()) {
                index = 0;
            }
            return index;
        }
    }

    private class SelectListener
    implements ActionListener {
        private ActionListener slave;

        public SelectListener(ActionListener slave) {
            this.slave = slave;
        }

        protected int getIndex(int index) {
            return index;
        }

        public void actionPerformed(ActionEvent e) {
            int index = MandelListPanel.this.getTable().getSelectionModel().getLeadSelectionIndex();
            if ((index = this.getIndex(index)) >= 0 && index < MandelListPanel.this.getTable().getRowCount()) {
                System.out.println("select " + index);
                MandelListPanel.this.getTable().getSelectionModel().setSelectionInterval(index, index);
                MandelListPanel.this.scrollToVisible(index, 0);
                this.slave.actionPerformed(e);
            }
        }
    }

    protected class LoadAction
    implements ActionListener {
        protected LoadAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            try {
                QualifiedMandelName name = MandelListPanel.this.getSelectedMandelName();
                if (name != null) {
                    MandelListPanel.this.setBusy(true);
                    MandelHandle found = ((MandelListTableModel)MandelListPanel.this.getModel()).getMandelData(MandelListPanel.this.getSelectedIndex());
                    if (found == null) {
                    } else if (found.getHeader().hasImageData()) {
                        if (MandelListPanel.this.getMandelWindowAccess().getMandelImagePane().setImage(found)) {
                            this.handleLoaded(name);
                        } else {
                            JOptionPane.showMessageDialog(MandelListPanel.this.getWindow(), "Cannot load image: " + name, "Mandel IO", 2);
                        }
                    } else {
                        MandelData data = found.getInfo();
                        MandelImageAreaDialog v = new MandelImageAreaDialog(MandelListPanel.this.getMandelWindowAccess(), "Mandel Image Meta Information", name, data);
                        v.setDefaultCloseOperation(2);
                        v.setVisible(true);
                    }
                }
            }
            catch (IOException ex) {
                MandelListPanel.this.Error("Mandel Meta Data", "cannot load mandel data");
            }
            finally {
                MandelListPanel.this.setBusy(false);
            }
        }

        protected void handleLoaded(QualifiedMandelName name) {
        }
    }

    private class RefreshAction
    implements ActionListener {
        private RefreshAction() {
        }

        public void actionPerformed(ActionEvent e) {
            MandelWindowAccess w = MandelListPanel.this.getMandelWindowAccess();
            if (w == null) {
                ((MandelListTableModel)MandelListPanel.this.getModel()).refresh();
            } else {
                ToolEnvironment env = w.getEnvironment();
                System.out.println("*** initiate refresh " + MandelListPanel.this.getModel());
                ((MandelListTableModel)MandelListPanel.this.getModel()).refresh(env);
            }
        }
    }

    private class GaleryAction
    implements ActionListener {
        private GaleryAction() {
        }

        public void actionPerformed(ActionEvent e) {
            MandelWindowAccess w = MandelListPanel.this.getMandelWindowAccess();
            MandelListGaleryDialog d = new MandelListGaleryDialog(w, (MandelListTableModel)MandelListPanel.this.getModel(), MandelListPanel.this.getTitle());
            d.setRootName(MandelListPanel.this.getRootName());
        }
    }
}

