/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool;

import com.mandelsoft.mand.Environment;
import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.scan.MandelScanner;
import com.mandelsoft.mand.tool.AbstractMandelListListModel;
import com.mandelsoft.mand.tool.MandelListListModel;
import com.mandelsoft.mand.util.MandelList;
import com.mandelsoft.swing.ProxyModel;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MandelListProxyListModel
extends AbstractMandelListListModel
implements ProxyModel<MandelListListModel> {
    protected MandelListListModel model;
    protected boolean bound;
    private ListDataListener listener = new Listener();

    protected MandelListProxyListModel() {
    }

    protected MandelListProxyListModel(MandelListListModel model) {
        this();
        this.setModel(model);
        this.bind();
    }

    @Override
    public MandelListListModel getModel() {
        return this.model;
    }

    public void setModel(MandelListListModel model) {
        if (model != this.model) {
            if (this.bound && this.model != null) {
                this.model.removeListDataListener(this.listener);
            }
            this.model = model;
            if (this.bound && model != null) {
                model.addListDataListener(this.listener);
            }
            this.fireContentsChanged(this, 0, Integer.MAX_VALUE);
        }
    }

    @Override
    public void bind() {
        if (!this.bound) {
            if (this.model != null) {
                this.model.addListDataListener(this.listener);
            }
            this.bound = true;
        }
    }

    @Override
    public void unbind() {
        if (this.bound) {
            if (this.model != null) {
                this.model.removeListDataListener(this.listener);
            }
            this.bound = false;
        }
    }

    @Override
    public boolean isBound() {
        return this.bound;
    }

    @Override
    public MandelScanner getMandelScanner() {
        return this.model.getMandelScanner();
    }

    @Override
    public boolean isModifiable() {
        return super.isModifiable() && this.model.isModifiable();
    }

    @Override
    public List<Action> getActions() {
        List<Action> actions1 = this.model.getActions();
        List<Action> actions2 = super.getActions();
        if (actions1 != null) {
            if (actions2 != null) {
                ArrayList<Action> r = new ArrayList<Action>();
                if (actions1 != null) {
                    r.addAll(actions1);
                }
                if (actions2 != null) {
                    r.addAll(actions2);
                }
                return r;
            }
            return actions1;
        }
        return actions2;
    }

    @Override
    public void setList(MandelList list) {
        throw new UnsupportedOperationException("list cannot be changed via proxy");
    }

    @Override
    public void setDuplicates(boolean m) {
        throw new UnsupportedOperationException("duplicates cannot be changed via proxy");
    }

    @Override
    public boolean allowDuplicates() {
        return this.model.allowDuplicates();
    }

    @Override
    public void remove(QualifiedMandelName name) {
        this.model.remove(name);
    }

    @Override
    public void refresh(Environment env) {
        this.model.refresh(env);
    }

    @Override
    public void refresh() {
        this.model.refresh();
    }

    @Override
    public void refresh(boolean soft) {
        this.model.refresh(soft);
    }

    @Override
    public MandelList getList() {
        return this.model.getList();
    }

    @Override
    public void clear() {
        this.checkModifiable();
        this.model.clear();
    }

    @Override
    public void addAll(QualifiedMandelName[] names) {
        this.checkModifiable();
        this.model.addAll(names);
    }

    @Override
    public void add(QualifiedMandelName name) {
        this.checkModifiable();
        this.model.add(name);
    }

    @Override
    public void addAll(int index, QualifiedMandelName[] names) {
        this.checkModifiable();
        this.model.addAll(index, names);
    }

    @Override
    public void add(int index, QualifiedMandelName name) {
        this.checkModifiable();
        this.model.add(index, name);
    }

    private class Listener
    implements ListDataListener {
        private Listener() {
        }

        public void intervalAdded(ListDataEvent e) {
            MandelListProxyListModel.this.fireIntervalAdded(MandelListProxyListModel.this, e.getIndex0(), e.getIndex1());
        }

        public void intervalRemoved(ListDataEvent e) {
            MandelListProxyListModel.this.fireIntervalRemoved(MandelListProxyListModel.this, e.getIndex0(), e.getIndex1());
            MandelListProxyListModel.this.cleanupThumbnails();
        }

        public void contentsChanged(ListDataEvent e) {
            MandelListProxyListModel.this.fireContentsChanged(MandelListProxyListModel.this, e.getIndex0(), e.getIndex1());
            MandelListProxyListModel.this.cleanupThumbnails();
        }
    }
}

