/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool;

import com.mandelsoft.io.AbstractFile;
import com.mandelsoft.mand.tool.MandelWindowAccessSource;
import com.mandelsoft.mand.tool.ToolEnvironment;
import com.mandelsoft.swing.ActionPanel;
import com.mandelsoft.swing.FilePanel;
import com.mandelsoft.swing.IntegerField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.imageio.ImageIO;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;

public abstract class PictureSavePanel
extends ActionPanel
implements MandelWindowAccessSource {
    protected JComboBox formats;
    protected JCheckBox decorationButton;
    protected IntegerField width;
    protected FilePanel imagefile;

    public PictureSavePanel() {
        this("Image file");
    }

    public PictureSavePanel(String fileLabel, int fileChooserMode) {
        this(fileLabel);
        this.setFileChooserMode(fileChooserMode);
    }

    public PictureSavePanel(String fileLabel) {
        JLabel c = new JLabel("Image Format");
        this.addContent(c, this.GBC(0, 0).setRightInset(10).setAnchor(13).setWeight(100.0, 100.0));
        String[] fmts = ImageIO.getReaderFileSuffixes();
        this.formats = new JComboBox<String>(fmts);
        this.addContent(this.formats, this.GBC(1, 0).setAnchor(17).setWeight(100.0, 100.0));
        c = new JLabel("Modified Width");
        this.addContent(c, this.GBC(0, 1).setRightInset(10).setAnchor(13).setWeight(100.0, 100.0));
        this.width = new IntegerField(0);
        this.width.setColumns(10);
        this.addContent(this.width, this.GBC(1, 1).setAnchor(17).setWeight(100.0, 100.0));
        c = new JLabel("Show Creator");
        this.addContent(c, this.GBC(0, 2).setRightInset(10).setAnchor(13).setWeight(100.0, 100.0));
        this.decorationButton = new JCheckBox();
        this.decorationButton.setSelected(this.getEnvironment().getCopyright() != null);
        this.decorationButton.setEnabled(!this.decorationButton.isSelected());
        this.addContent(this.decorationButton, this.GBC(1, 2).setAnchor(17).setWeight(100.0, 100.0));
        this.imagefile = new FilePanel(fileLabel, "", (JFrame)this.getOwner());
        this.addContent(this.imagefile, this.GBC(0, 3, 2, 1).setLayout(1, 11).setWeight(100.0, 100.0).setInsets(10, 10, 10, 10));
    }

    void updateState() {
        AbstractFile file = this.getMandelWindowAccess().getMandelData().getFile();
        if (file != null) {
            if (!file.isFile()) {
                this.decorationButton.setSelected(true);
            }
            this.decorationButton.setEnabled(file.isFile());
        }
    }

    protected ToolEnvironment getEnvironment() {
        return this.getMandelWindowAccess().getEnvironment();
    }

    public void setFileChooserMode(int m) {
        this.imagefile.setFileChooserMode(m);
    }

    public class ClearAction
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            PictureSavePanel.this.imagefile.setFilename("");
        }
    }
}

