/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool;

import com.mandelsoft.mand.util.TagList;
import java.io.IOException;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;

public class TagListModel
extends AbstractListModel
implements ComboBoxModel {
    private TagList list;
    private Object selectedObject;
    private boolean autosave;

    public TagListModel(TagList tags) {
        this.list = tags;
        if (this.getSize() > 0) {
            this.selectedObject = this.getElementAt(0);
        }
    }

    public boolean isAutosave() {
        return this.autosave;
    }

    public void setAutosave(boolean austosave) {
        this.autosave = austosave;
    }

    public void setSelectedItem(Object anObject) {
        if (this.selectedObject != null && !this.selectedObject.equals(anObject) || this.selectedObject == null && anObject != null) {
            this.selectedObject = anObject;
            this.fireContentsChanged(this, -1, -1);
        }
    }

    public Object getSelectedItem() {
        return this.selectedObject;
    }

    public int getSize() {
        return this.list.size();
    }

    public Object getElementAt(int index) {
        if (index >= 0 && index < this.list.size()) {
            return this.list.get(index);
        }
        return null;
    }

    public int getIndexOf(Object anObject) {
        return this.list.indexOf(anObject);
    }

    public void addElement(String anObject) {
        if (!this.list.contains(anObject)) {
            this.list.add(anObject);
            this.fireIntervalAdded(this, this.list.size() - 1, this.list.size() - 1);
            if (this.list.size() == 1 && this.selectedObject == null && anObject != null) {
                this.setSelectedItem(anObject);
            }
        }
    }

    public void insertElementAt(String anObject, int index) {
        if (!this.list.contains(anObject)) {
            this.list.add(index, anObject);
            this.fireIntervalAdded(this, index, index);
        }
    }

    public void removeElementAt(int index) {
        if (this.getElementAt(index) == this.selectedObject) {
            if (index == 0) {
                this.setSelectedItem(this.getSize() == 1 ? null : this.getElementAt(index + 1));
            } else {
                this.setSelectedItem(this.getElementAt(index - 1));
            }
        }
        this.list.remove(index);
        this.fireIntervalRemoved(this, index, index);
    }

    public void removeElement(String anObject) {
        int index = this.list.indexOf(anObject);
        if (index != -1) {
            this.removeElementAt(index);
        }
    }

    public void removeAllElements() {
        if (this.list.size() > 0) {
            int firstIndex = 0;
            int lastIndex = this.list.size() - 1;
            this.list.clear();
            this.selectedObject = null;
            this.fireIntervalRemoved(this, firstIndex, lastIndex);
        } else {
            this.selectedObject = null;
        }
    }

    protected void fireContentsChanged(Object source, int index0, int index1) {
        this.save();
        super.fireContentsChanged(source, index0, index1);
    }

    protected void fireIntervalAdded(Object source, int index0, int index1) {
        this.save();
        super.fireIntervalAdded(source, index0, index1);
    }

    protected void fireIntervalRemoved(Object source, int index0, int index1) {
        this.save();
        super.fireIntervalRemoved(source, index0, index1);
    }

    protected void save() {
        if (this.autosave) {
            try {
                this.list.save();
            }
            catch (IOException ex) {
                System.err.println("cannot save tag list " + ex);
            }
        }
    }
}

