/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool.ctx;

import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.tool.MandelWindowAccess;
import com.mandelsoft.mand.tool.ctx.ContextProvider;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JWindow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MandelContextMenuHandler<E, S, M>
implements ContextProvider<E, S, M> {
    private boolean busy;
    private Cursor origcursor;
    private Component contextComponent;
    private S contextSpec;

    @Override
    public abstract M getModel();

    @Override
    public JWindow getWindow() {
        return this._lookupInterface(this.contextComponent, JWindow.class);
    }

    public JDialog getDialog() {
        return this._lookupInterface(this.contextComponent, JDialog.class);
    }

    public MandelWindowAccess getMandelWindowAccess() {
        return MandelWindowAccess.Access.getMandelWindowAccess(this.contextComponent);
    }

    protected int getMaxFrame() {
        MandelWindowAccess access = this.getMandelWindowAccess();
        return access.getMandelImagePane() == null ? 0 : access.getMandelImagePane().getMaxFrame();
    }

    protected void Error(String title, String msg) {
        JOptionPane.showMessageDialog(this.getWindow(), msg, title, 2);
    }

    protected void Info(String title, String msg) {
        JOptionPane.showMessageDialog(this.getWindow(), msg, title, 1);
    }

    public <T> T lookupInterface(Class<T> clazz) {
        return this.lookupInterface(this.getContextComponent(), clazz);
    }

    public <T> T lookupInterface(Component leaf, Class<T> clazz) {
        MandelWindowAccess access;
        T t = this._lookupInterface(leaf, clazz);
        if (t == null && (access = MandelWindowAccess.Access.getMandelWindowAccess(leaf)) != null) {
            if (access.getMandelImagePane() != null) {
                t = this._lookupInterface(access.getMandelImagePane(), clazz);
            }
            if (t == null && access.getMandelWindow() != null) {
                t = this._lookupInterface(access.getMandelWindow(), clazz);
            }
        }
        return t;
    }

    protected void setBusy(boolean b) {
        if (b != this.busy) {
            if (b) {
                System.out.println("-------------------------------------------------");
                System.out.println("set busy");
                this.origcursor = this.contextComponent.getCursor();
                this.contextComponent.setCursor(Cursor.getPredefinedCursor(3));
            } else {
                System.out.println("orig cursor");
                this.contextComponent.setCursor(this.origcursor);
            }
        }
        this.busy = b;
    }

    protected <T> T _lookupInterface(Component leaf, Class<T> clazz) {
        Component c;
        for (c = leaf; c != null && !clazz.isAssignableFrom(c.getClass()); c = c.getParent()) {
        }
        return (T)c;
    }

    public Component getContextComponent() {
        return this.contextComponent;
    }

    @Override
    public S getSelectionSpec() {
        return this.contextSpec;
    }

    @Override
    public abstract E getSelectedItem();

    public void handleContextMenu(JComponent comp, MouseEvent evt, S spec) {
        this.contextComponent = comp;
        this.contextSpec = spec;
        JPopupMenu menu = this.createContextMenu(spec);
        if (menu != null) {
            menu.show(comp, evt.getX(), evt.getY());
        }
    }

    protected abstract JPopupMenu createContextMenu(S var1);

    public abstract class LoadImageContextAction
    extends ContextAction {
        protected LoadImageContextAction(String name) {
            super(name);
        }

        protected void loadImage(QualifiedMandelName sel) {
            if (sel == null) {
                return;
            }
            MandelContextMenuHandler.this.setBusy(true);
            MandelWindowAccess access = MandelContextMenuHandler.this.getMandelWindowAccess();
            if (!access.getMandelImagePane().setImage(sel)) {
                JOptionPane.showMessageDialog(this.getWindow(), "Cannot load image: " + sel, "Mandel IO", 2);
            }
            MandelContextMenuHandler.this.setBusy(false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class ContextAction
    extends com.mandelsoft.mand.tool.ctx.ContextAction<E, S, M> {
        public ContextAction(String name) {
            super(name, MandelContextMenuHandler.this);
        }
    }
}

