/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool.ctx;

import com.mandelsoft.mand.MandelData;
import com.mandelsoft.mand.MandelName;
import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.cm.Colormap;
import com.mandelsoft.mand.cm.ColormapModel;
import com.mandelsoft.mand.scan.MandelHandle;
import com.mandelsoft.mand.scan.MandelScanner;
import com.mandelsoft.mand.scan.MandelScannerUtils;
import com.mandelsoft.mand.tool.MandelImageAreaDialog;
import com.mandelsoft.mand.tool.MandelImagePanel;
import com.mandelsoft.mand.tool.MandelListGaleryDialog;
import com.mandelsoft.mand.tool.MandelListModel;
import com.mandelsoft.mand.tool.MandelListModelMenu;
import com.mandelsoft.mand.tool.MandelListModelSource;
import com.mandelsoft.mand.tool.MandelWindowAccess;
import com.mandelsoft.mand.tool.PictureSaveDialog;
import com.mandelsoft.mand.tool.ToolEnvironment;
import com.mandelsoft.mand.tool.ctx.MandelContextMenuHandler;
import com.mandelsoft.mand.util.ArrayMandelList;
import com.mandelsoft.mand.util.MandelList;
import com.mandelsoft.swing.Selection;
import com.mandelsoft.util.Utils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MandelListContextMenuHandler
extends MandelContextMenuHandler<QualifiedMandelName, Selection, MandelListModel> {
    protected Action addCurrentImageAction = new AddCurrentImageAction();
    protected Action removeCurrentImageAction = new RemoveCurrentImageAction();
    protected Action removeImageAction = new RemoveImageAction();
    protected Action addMemoryAction = new AddMemoryAction();
    protected Action setMarkAction = new SetMarkAction();
    protected Action showMetaAction = new ShowMetaAction();
    protected Action showImageAction = new ShowImageAction();
    protected Action loadImageAction = new LoadImageAction();
    protected Action loadParentAction = new LoadParentAction();
    protected Action loadRegImageAction = new LoadRegImageAction();
    protected Action linkMarkAction = new LinkFromMarkAction();
    protected Action unlinkMarkAction = new UnlinkFromMarkAction();
    protected Action linkCurrentAction = new LinkFromCurrentAction();
    protected Action unlinkCurrentAction = new UnlinkFromCurrentAction();
    protected Action saveImagesAction = new SaveImagesAction();
    protected Action saveSelectedImagesAction = new SaveSelectedImagesAction();
    protected Action galerySelectedAction = new GalerySelectedAction();

    protected boolean isNavToFolder() {
        return true;
    }

    @Override
    public MandelListModel getModel() {
        MandelListModelSource s = this.lookupInterface(MandelListModelSource.class);
        return s == null ? null : s.getModel();
    }

    @Override
    public QualifiedMandelName getSelectedItem() {
        QualifiedMandelName sel = ((Selection)this.getSelectionSpec()).getLeadSelection() < 0 ? null : this.getModel().getQualifiedName(((Selection)this.getSelectionSpec()).getLeadSelection());
        return sel;
    }

    public MandelList getSelectedItems() {
        if (!((Selection)this.getSelectionSpec()).isEmpty()) {
            List<Integer> indices = ((Selection)this.getSelectionSpec()).getSelectedIndices();
            ArrayMandelList list = new ArrayMandelList();
            MandelListModel model = this.getModel();
            for (Integer i : indices) {
                list.add(model.getQualifiedName(i));
            }
            return list;
        }
        return null;
    }

    protected JPopupMenu createLabeledMenu(String text) {
        JPopupMenu menu = new JPopupMenu(text);
        this.addMenuLabel(menu, text, 1);
        return menu;
    }

    protected void addMenuLabel(JPopupMenu menu, String text, int style) {
        JPanel panel = new JPanel();
        JLabel label = new JLabel(text);
        label.setHorizontalTextPosition(0);
        if (style != 0) {
            label.setFont(label.getFont().deriveFont(label.getFont().getStyle() | style));
        }
        panel.add(label);
        menu.add(panel);
    }

    @Override
    protected JPopupMenu createContextMenu(Selection sel) {
        JPopupMenu menu = this.createItemContextMenu(sel);
        if (!((Selection)this.getSelectionSpec()).isEmpty()) {
            menu = this.createSelectionContextMenu(menu);
        }
        return this.createListContextMenu(menu);
    }

    protected JPopupMenu createItemContextMenu(Selection select) {
        JPopupMenu menu;
        QualifiedMandelName sel = null;
        JMenu link = new JMenu("Linking");
        int index = select.getLeadSelection();
        MandelWindowAccess access = this.getMandelWindowAccess();
        MandelImagePanel mp = this.getMandelWindowAccess().getMandelImagePane();
        MandelListModel model = this.getModel();
        if (!(index >= 0 || mp != null || this.getMandelWindowAccess().getQualifiedName() != null && this.getModel().isModifiable())) {
            return null;
        }
        if (index >= 0) {
            sel = model.getQualifiedName(index);
            menu = this.createLabeledMenu(sel.toString());
        } else {
            menu = new JPopupMenu();
        }
        boolean sep = false;
        if (access != null && !access.getEnvironment().isReadonly() && sel != null) {
            if (access.getQualifiedName() != null && !sel.getMandelName().equals(access.getQualifiedName().getMandelName())) {
                link.add(this.linkCurrentAction);
                link.add(this.unlinkCurrentAction);
            }
            if (mp != null && mp.getMark() != null && !sel.getMandelName().equals(mp.getMark().getMandelName())) {
                if (link.getItemCount() > 0) {
                    link.addSeparator();
                }
                link.add(this.linkMarkAction);
                link.add(this.unlinkMarkAction);
            }
        }
        if (model.isModifiable()) {
            if (access.getQualifiedName() != null) {
                sep = true;
                menu.add(this.addCurrentImageAction);
                menu.add(this.removeCurrentImageAction);
            }
            if (index >= 0) {
                if (sep) {
                    menu.addSeparator();
                }
                sep = false;
                menu.add(this.removeImageAction);
            }
        }
        Component comp = this.getContextComponent();
        System.out.println("contextComponent is " + comp);
        if (index >= 0) {
            MandelHandle h = model.getMandelHandle(index);
            if (sep) {
                menu.addSeparator();
            }
            sep = false;
            menu.add(this.showMetaAction);
            if (h != null && h.getHeader().hasImageData()) {
                menu.add(this.showImageAction);
                if (mp != null) {
                    menu.add(this.loadImageAction);
                    if (sel.getQualifier() != null) {
                        menu.add(this.loadRegImageAction);
                    }
                    menu.add(this.setMarkAction);
                    MandelListModel m = mp.getEnvironment().getLinkModel(sel.getMandelName());
                    menu.add(new MandelListModelMenu("Links", mp, m));
                }
            } else {
                menu.add(this.loadParentAction);
            }
            link.setEnabled(link.getItemCount() > 0);
            menu.add(link);
            menu.add(this.addMemoryAction);
            menu.add(access.getEnvironment().getListActions().createMenu(comp, sel));
        }
        if (mp != null) {
            if (sep) {
                menu.addSeparator();
            }
            menu.add(mp.getSlideShowModel().createMenu(comp, sel));
        }
        return menu;
    }

    public static void createMandelImageFrame(Component requester, MandelWindowAccess access, int maxx, QualifiedMandelName sel) {
        try {
            ColormapModel cm = access.getColormapModel();
            if (cm == null) {
                Colormap c = access.getEnvironment().getDefaultColormap();
                if (c != null) {
                    System.out.println("found environment default colormap");
                    cm = new ColormapModel(c);
                }
            } else {
                System.out.println("found access colormap");
            }
            if (maxx == 0) {
                access.getEnvironment().createMandelImageFrame(sel, cm);
            } else {
                access.getEnvironment().createMandelImageFrame(sel, cm, maxx);
            }
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(requester, "Cannot load image: " + sel, "Mandel IO", 2);
        }
    }

    protected JPopupMenu createSelectionContextMenu(JPopupMenu menu) {
        if (menu == null) {
            menu = new JPopupMenu();
        } else {
            menu.addSeparator();
            this.addMenuLabel(menu, "Selection", 2);
        }
        menu.add(new JMenuItem(this.saveSelectedImagesAction));
        menu.add(new JMenuItem(this.galerySelectedAction));
        return menu;
    }

    protected JPopupMenu createListContextMenu(JPopupMenu menu) {
        if (this.getMandelWindowAccess() != null && !this.getMandelWindowAccess().getEnvironment().isReadonly()) {
            if (menu == null) {
                menu = new JPopupMenu();
            } else {
                menu.addSeparator();
                this.addMenuLabel(menu, "List", 2);
            }
            menu.add(new JMenuItem(this.saveImagesAction));
        }
        return menu;
    }

    private class GalerySelectedAction
    extends MandelContextMenuHandler.ContextAction {
        public GalerySelectedAction() {
            super("Show as galery");
        }

        public void actionPerformed(ActionEvent e) {
            MandelList ml = MandelListContextMenuHandler.this.getSelectedItems();
            if (ml != null && ml.size() > 0) {
                String title = "Galery for selected areas (" + Utils.sizeString(ml.size(), "entry") + ")";
                System.out.println(title);
                new MandelListGaleryDialog(MandelListContextMenuHandler.this.getMandelWindowAccess(), ml, title);
            }
        }
    }

    private class SaveSelectedImagesAction
    extends MandelContextMenuHandler.ContextAction {
        public SaveSelectedImagesAction() {
            super("Save images");
        }

        public void actionPerformed(ActionEvent e) {
            MandelList ml = MandelListContextMenuHandler.this.getSelectedItems();
            if (ml != null && ml.size() > 0) {
                String title = "Save Images for selected items (" + Utils.sizeString(ml.size(), "entry") + ")";
                System.out.println(title);
                PictureSaveDialog d = new PictureSaveDialog(MandelListContextMenuHandler.this.getMandelWindowAccess(), title, ml);
                d.setVisible(true);
            }
        }
    }

    private class SaveImagesAction
    extends MandelContextMenuHandler.ContextAction {
        public SaveImagesAction() {
            super("Save images");
        }

        public void actionPerformed(ActionEvent e) {
            String title = "Image Save Dialog";
            JDialog dia = MandelListContextMenuHandler.this.getDialog();
            if (dia != null && dia.getTitle() != null) {
                title = "Save Images for " + dia.getTitle();
            }
            System.out.println(title);
            PictureSaveDialog d = new PictureSaveDialog(MandelListContextMenuHandler.this.getMandelWindowAccess(), title, ((MandelListModel)this.getModel()).getList());
            d.setVisible(true);
        }
    }

    private class UnlinkFromCurrentAction
    extends MandelContextMenuHandler.ContextAction {
        public UnlinkFromCurrentAction() {
            super("Unlink from current");
        }

        public void actionPerformed(ActionEvent e) {
            QualifiedMandelName sel = (QualifiedMandelName)this.getSelectedItem();
            if (sel == null) {
                return;
            }
            MandelWindowAccess access = MandelListContextMenuHandler.this.getMandelWindowAccess();
            MandelName marked = access.getMandelName();
            access.getEnvironment().removeLink(marked, sel.getMandelName());
        }
    }

    private class LinkFromCurrentAction
    extends MandelContextMenuHandler.ContextAction {
        public LinkFromCurrentAction() {
            super("Link from current");
        }

        public void actionPerformed(ActionEvent e) {
            QualifiedMandelName sel = (QualifiedMandelName)this.getSelectedItem();
            if (sel == null) {
                return;
            }
            MandelWindowAccess access = MandelListContextMenuHandler.this.getMandelWindowAccess();
            MandelName marked = access.getMandelName();
            access.getEnvironment().addLink(marked, sel.getMandelName());
        }
    }

    private class UnlinkFromMarkAction
    extends MandelContextMenuHandler.ContextAction {
        public UnlinkFromMarkAction() {
            super("Unlink from mark");
        }

        public void actionPerformed(ActionEvent e) {
            QualifiedMandelName sel = (QualifiedMandelName)this.getSelectedItem();
            if (sel == null) {
                return;
            }
            MandelWindowAccess access = MandelListContextMenuHandler.this.getMandelWindowAccess();
            QualifiedMandelName marked = access.getMandelImagePane().getMark();
            access.getEnvironment().removeLink(marked.getMandelName(), sel.getMandelName());
        }
    }

    private class LinkFromMarkAction
    extends MandelContextMenuHandler.ContextAction {
        public LinkFromMarkAction() {
            super("Link from mark");
        }

        public void actionPerformed(ActionEvent e) {
            QualifiedMandelName sel = (QualifiedMandelName)this.getSelectedItem();
            if (sel == null) {
                return;
            }
            MandelWindowAccess access = MandelListContextMenuHandler.this.getMandelWindowAccess();
            QualifiedMandelName marked = access.getMandelImagePane().getMark();
            access.getEnvironment().addLink(marked.getMandelName(), sel.getMandelName());
        }
    }

    private class ShowMetaAction
    extends MandelContextMenuHandler.ContextAction {
        public ShowMetaAction() {
            super("Show Meta Data");
        }

        public void actionPerformed(ActionEvent e) {
            try {
                MandelHandle found;
                QualifiedMandelName name = (QualifiedMandelName)this.getSelectedItem();
                if (name != null && (found = ((MandelListModel)this.getModel()).getMandelData(((Selection)this.getSelectionSpec()).getLeadSelection())) != null) {
                    MandelData data = found.getInfo();
                    MandelImageAreaDialog v = new MandelImageAreaDialog(MandelListContextMenuHandler.this.getMandelWindowAccess(), "Mandel Image Meta Information", name, data);
                    v.setDefaultCloseOperation(2);
                    v.setVisible(true);
                }
            }
            catch (IOException ex) {
                MandelListContextMenuHandler.this.Error("Mandel Meta Data", "cannot load mandel data");
            }
        }
    }

    private class LoadRegImageAction
    extends MandelContextMenuHandler.ContextAction {
        public LoadRegImageAction() {
            super("Load Standard Variant");
        }

        public void actionPerformed(ActionEvent e) {
            QualifiedMandelName sel = (QualifiedMandelName)this.getSelectedItem();
            if (sel == null) {
                return;
            }
            MandelListContextMenuHandler.this.setBusy(true);
            MandelWindowAccess access = MandelListContextMenuHandler.this.getMandelWindowAccess();
            if (!access.getMandelImagePane().setImage(sel.getMandelName())) {
                JOptionPane.showMessageDialog(this.getWindow(), "Cannot load image: " + sel.getMandelName(), "Mandel IO", 2);
            }
            MandelListContextMenuHandler.this.setBusy(false);
        }
    }

    private class LoadParentAction
    extends LoadImageAction {
        public LoadParentAction() {
            super("Load Parent");
        }

        public QualifiedMandelName getSelectedItem() {
            QualifiedMandelName n = (QualifiedMandelName)super.getSelectedItem();
            MandelWindowAccess access = MandelListContextMenuHandler.this.getMandelWindowAccess();
            ToolEnvironment env = access.getEnvironment();
            MandelScanner scanner = env.getImageDataScanner();
            Set<MandelHandle> set = scanner.getMandelHandles(n);
            while (!MandelScannerUtils.hasImageData(set)) {
                n = new QualifiedMandelName(n.getMandelName().getParentName());
                set = scanner.getMandelHandles(n);
            }
            return n;
        }
    }

    protected class LoadImageAction
    extends MandelContextMenuHandler.LoadImageContextAction {
        protected LoadImageAction(String name) {
            super(name);
        }

        public LoadImageAction() {
            this("Load image");
        }

        public void actionPerformed(ActionEvent e) {
            this.loadImage((QualifiedMandelName)this.getSelectedItem());
        }
    }

    private class ShowImageAction
    extends MandelContextMenuHandler.ContextAction {
        public ShowImageAction() {
            super("Show image");
        }

        public void actionPerformed(ActionEvent e) {
            QualifiedMandelName sel = (QualifiedMandelName)this.getSelectedItem();
            if (sel == null) {
                return;
            }
            MandelListContextMenuHandler.this.setBusy(true);
            MandelWindowAccess access = MandelListContextMenuHandler.this.getMandelWindowAccess();
            System.out.println("access is " + access);
            MandelListContextMenuHandler.createMandelImageFrame(this.getWindow(), access, MandelListContextMenuHandler.this.getMaxFrame(), sel);
            MandelListContextMenuHandler.this.setBusy(false);
        }
    }

    private class SetMarkAction
    extends MandelContextMenuHandler.ContextAction {
        public SetMarkAction() {
            super("Set mark");
        }

        public void actionPerformed(ActionEvent e) {
            QualifiedMandelName sel = (QualifiedMandelName)this.getSelectedItem();
            if (sel == null) {
                return;
            }
            MandelWindowAccess access = MandelListContextMenuHandler.this.getMandelWindowAccess();
            MandelImagePanel mp = access.getMandelImagePane();
            mp.setMark(sel);
        }
    }

    private class AddMemoryAction
    extends MandelContextMenuHandler.ContextAction {
        public AddMemoryAction() {
            super("Add to memory");
        }

        public void actionPerformed(ActionEvent e) {
            QualifiedMandelName sel = (QualifiedMandelName)this.getSelectedItem();
            if (sel == null) {
                return;
            }
            MandelWindowAccess access = MandelListContextMenuHandler.this.getMandelWindowAccess();
            access.getEnvironment().getMemoryModel().add(sel);
        }
    }

    private class RemoveImageAction
    extends MandelContextMenuHandler.ContextAction {
        public RemoveImageAction() {
            super("Remove");
        }

        public void actionPerformed(ActionEvent e) {
            QualifiedMandelName sel = (QualifiedMandelName)this.getSelectedItem();
            if (sel == null) {
                return;
            }
            ((MandelListModel)this.getModel()).remove(sel);
        }
    }

    private class RemoveCurrentImageAction
    extends MandelContextMenuHandler.ContextAction {
        public RemoveCurrentImageAction() {
            super("Remove Current");
        }

        public void actionPerformed(ActionEvent e) {
            MandelWindowAccess access = MandelListContextMenuHandler.this.getMandelWindowAccess();
            QualifiedMandelName name = access.getQualifiedName();
            if (name != null) {
                ((MandelListModel)this.getModel()).remove(name);
            }
        }
    }

    private class AddCurrentImageAction
    extends MandelContextMenuHandler.ContextAction {
        public AddCurrentImageAction() {
            super("Add Current");
        }

        public void actionPerformed(ActionEvent e) {
            MandelWindowAccess access = MandelListContextMenuHandler.this.getMandelWindowAccess();
            QualifiedMandelName name = access.getQualifiedName();
            if (name != null) {
                ((MandelListModel)this.getModel()).add(name);
            }
        }
    }
}

