/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tool.ctx;

import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.tool.MandelImagePanel;
import com.mandelsoft.mand.tool.MandelListFolderGaleryDialog;
import com.mandelsoft.mand.tool.MandelListFolderTreeModel;
import com.mandelsoft.mand.tool.MandelListFolderTreeModelSource;
import com.mandelsoft.mand.tool.MandelListGaleryDialog;
import com.mandelsoft.mand.tool.MandelListSelector;
import com.mandelsoft.mand.tool.MandelListTableModel;
import com.mandelsoft.mand.tool.MandelWindowAccess;
import com.mandelsoft.mand.tool.PictureSaveDialog;
import com.mandelsoft.mand.tool.ctx.DeleteFolderAction;
import com.mandelsoft.mand.tool.ctx.MandelContextMenuHandler;
import com.mandelsoft.mand.tool.ctx.NewFolderAction;
import com.mandelsoft.mand.util.MandelList;
import com.mandelsoft.mand.util.MandelListFolder;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MandelListFolderContextMenuHandler
extends MandelContextMenuHandler<MandelListFolder, TreePath, MandelListFolderTreeModel>
implements MandelListSelector {
    private Action addImageAction = new AddCurrentImageAction();
    private Action removeImageAction = new RemoveCurrentImageAction();
    private Action newFolderAction = new NewFolderAction(this);
    private Action deleteAction = new DeleteFolderAction(this);
    private Action showGaleryAction = new ShowGaleryAction();
    private Action showImageGaleryAction = new ShowImageGaleryAction();
    private Action setThumbnailAction = new SetThumbnailAction();
    private Action loadThumbnailAction = new LoadThumbnailAction();
    private Action clearThumbnailAction = new ClearThumbnailAction();
    private Action addListShortcutAction = new AddListShortcutAction();
    private Action removeListShortcutAction = new RemoveListShortcutAction();
    private Action saveImagesAction = new SaveImagesAction();

    protected boolean folderMetaModifiable(TreePath p) {
        return MandelListFolderTreeModel.Util.folderMetaModifiable(this.getModel(), p);
    }

    protected boolean folderModifiable(TreePath p) {
        return MandelListFolderTreeModel.Util.folderModifiable(this.getModel(), p);
    }

    protected boolean folderContentModifiable(TreePath p) {
        return MandelListFolderTreeModel.Util.folderContentModifiable(this.getModel(), p);
    }

    @Override
    public MandelListFolderTreeModel getModel() {
        MandelListFolderTreeModelSource s = this.lookupInterface(MandelListFolderTreeModelSource.class);
        return s == null ? null : s.getModel();
    }

    @Override
    public MandelListFolder getSelectedItem() {
        if (this.getSelectionSpec() == null) {
            return null;
        }
        return (MandelListFolder)((TreePath)this.getSelectionSpec()).getLastPathComponent();
    }

    @Override
    public MandelList getSelectedMandelList() {
        return this.getSelectedItem().getMandelList();
    }

    @Override
    protected JPopupMenu createContextMenu(TreePath p) {
        if (p == null) {
            return null;
        }
        MandelListFolder folder = this.getSelectedItem();
        MandelWindowAccess acc2 = this.getMandelWindowAccess();
        MandelImagePanel pane = acc2 != null ? acc2.getMandelImagePane() : null;
        MandelListFolderTreeModel m = this.getModel();
        boolean modcont = this.folderContentModifiable(p);
        boolean modmeta = this.folderMetaModifiable(p);
        boolean modfold = this.folderModifiable(p);
        JPopupMenu menu = new JPopupMenu();
        if (modcont && folder.hasMandelList()) {
            menu.add(this.addImageAction);
            menu.add(this.removeImageAction);
            menu.addSeparator();
        }
        if (!folder.isLeaf()) {
            menu.add(this.showGaleryAction);
        }
        if (folder.hasMandelList()) {
            menu.add(this.showImageGaleryAction);
            if (acc2 != null && !acc2.getEnvironment().isReadonly()) {
                menu.add(this.saveImagesAction);
            }
            if (pane != null) {
                menu.add(pane.getSlideShowModel().createMenu(null, this));
                MandelListTableModel mt = m.getMandelListModel(folder);
                if (!pane.hasListShortcut(mt)) {
                    if (mt != null && mt.isModifiable()) {
                        menu.add(this.addListShortcutAction);
                    }
                } else if (mt != null) {
                    menu.add(this.removeListShortcutAction);
                }
            }
        }
        if (modmeta) {
            if (acc2 != null && acc2.getQualifiedName() != null) {
                menu.add(this.setThumbnailAction);
            }
            if (folder.getThumbnailName() != null) {
                menu.add(this.loadThumbnailAction);
                menu.add(this.clearThumbnailAction);
            }
        } else if (folder.getThumbnailName() != null) {
            menu.add(this.loadThumbnailAction);
        }
        if (modfold) {
            menu.addSeparator();
            menu.add(this.newFolderAction);
            if (modmeta) {
                menu.add(this.deleteAction);
            }
        }
        return menu;
    }

    private class SaveImagesAction
    extends AbstractAction {
        public SaveImagesAction() {
            super("Save Images");
        }

        public void actionPerformed(ActionEvent e) {
            MandelListFolder f = MandelListFolderContextMenuHandler.this.getSelectedItem();
            String title = "Save Images for " + f.getPath();
            if (f.hasMandelList()) {
                PictureSaveDialog d = new PictureSaveDialog(MandelListFolderContextMenuHandler.this.getMandelWindowAccess(), title, f.getMandelList());
                d.setVisible(true);
            }
        }
    }

    private class LoadThumbnailAction
    extends MandelContextMenuHandler.LoadImageContextAction {
        protected LoadThumbnailAction(String name) {
            super(name);
        }

        public LoadThumbnailAction() {
            this("Load Thumbnail");
        }

        public void actionPerformed(ActionEvent e) {
            QualifiedMandelName n = ((MandelListFolder)this.getSelectedItem()).getThumbnailName();
            if (n != null) {
                this.loadImage(n);
            }
        }
    }

    private class ClearThumbnailAction
    extends MandelContextMenuHandler.ContextAction {
        public ClearThumbnailAction() {
            super("Clear Thumbnail");
        }

        public void actionPerformed(ActionEvent e) {
            MandelWindowAccess access = MandelListFolderContextMenuHandler.this.getMandelWindowAccess();
            ((MandelListFolderTreeModel)this.getModel()).setThumbnailName((MandelListFolder)this.getSelectedItem(), null);
        }
    }

    private class SetThumbnailAction
    extends MandelContextMenuHandler.ContextAction {
        public SetThumbnailAction() {
            super("Set Thumbnail");
        }

        public void actionPerformed(ActionEvent e) {
            MandelWindowAccess access = MandelListFolderContextMenuHandler.this.getMandelWindowAccess();
            ((MandelListFolderTreeModel)this.getModel()).setThumbnailName((MandelListFolder)this.getSelectedItem(), access.getQualifiedName());
        }
    }

    private class RemoveCurrentImageAction
    extends MandelContextMenuHandler.ContextAction {
        public RemoveCurrentImageAction() {
            super("Remove Current");
        }

        public void actionPerformed(ActionEvent e) {
            MandelWindowAccess access = MandelListFolderContextMenuHandler.this.getMandelWindowAccess();
            QualifiedMandelName name = access.getQualifiedName();
            MandelListTableModel m = ((MandelListFolderTreeModel)this.getModel()).getMandelListModel(this.getSelectedItem());
            if (name != null) {
                m.remove(name);
            }
        }
    }

    private class AddCurrentImageAction
    extends MandelContextMenuHandler.ContextAction {
        public AddCurrentImageAction() {
            super("Add Current");
        }

        public void actionPerformed(ActionEvent e) {
            MandelWindowAccess access = MandelListFolderContextMenuHandler.this.getMandelWindowAccess();
            QualifiedMandelName name = access.getQualifiedName();
            MandelListTableModel m = ((MandelListFolderTreeModel)this.getModel()).getMandelListModel(this.getSelectedItem());
            if (m != null) {
                m.add(name);
            } else {
                JOptionPane.showMessageDialog(this.getWindow(), "Cannot add image", "Mandel List Folder", 0);
            }
        }
    }

    private class RemoveListShortcutAction
    extends MandelContextMenuHandler.ContextAction {
        public RemoveListShortcutAction() {
            super("Remove List Shortcut");
        }

        public void actionPerformed(ActionEvent e) {
            MandelWindowAccess access = MandelListFolderContextMenuHandler.this.getMandelWindowAccess();
            MandelListTableModel m = ((MandelListFolderTreeModel)this.getModel()).getMandelListModel(this.getSelectedItem());
            if (m != null) {
                access.getMandelImagePane().removeListShortcut(m);
            }
        }
    }

    private class AddListShortcutAction
    extends MandelContextMenuHandler.ContextAction {
        public AddListShortcutAction() {
            super("Add List Shortcut");
        }

        public void actionPerformed(ActionEvent e) {
            MandelWindowAccess access = MandelListFolderContextMenuHandler.this.getMandelWindowAccess();
            MandelListTableModel m = ((MandelListFolderTreeModel)this.getModel()).getMandelListModel(this.getSelectedItem());
            if (m != null) {
                access.getMandelImagePane().addListShortcut(((MandelListFolder)this.getSelectedItem()).getName(), m);
            }
        }
    }

    private class ShowImageGaleryAction
    extends MandelContextMenuHandler.ContextAction {
        public ShowImageGaleryAction() {
            super("Image Galery");
        }

        public void actionPerformed(ActionEvent e) {
            MandelWindowAccess access = MandelListFolderContextMenuHandler.this.getMandelWindowAccess();
            new MandelListGaleryDialog(access, ((MandelListFolderTreeModel)this.getModel()).getEffectiveFolderTreeModel(), (MandelListFolder)this.getSelectedItem());
        }
    }

    private class ShowGaleryAction
    extends MandelContextMenuHandler.ContextAction {
        public ShowGaleryAction() {
            super("Folder Galery");
        }

        public void actionPerformed(ActionEvent e) {
            MandelWindowAccess access = MandelListFolderContextMenuHandler.this.getMandelWindowAccess();
            new MandelListFolderGaleryDialog(access, ((MandelListFolderTreeModel)this.getModel()).getEffectiveFolderTreeModel(), (MandelListFolder)this.getSelectedItem());
        }
    }
}

