/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tools;

import com.mandelsoft.io.AbstractFile;
import com.mandelsoft.mand.Environment;
import com.mandelsoft.mand.IllegalConfigurationException;
import com.mandelsoft.mand.MandelData;
import com.mandelsoft.mand.MandelFileName;
import com.mandelsoft.mand.MandelHeader;
import com.mandelsoft.mand.MandelName;
import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.scan.ElementHandle;
import com.mandelsoft.mand.scan.MandelFolder;
import com.mandelsoft.mand.scan.MandelFolderCache;
import com.mandelsoft.mand.scan.MandelHandle;
import com.mandelsoft.mand.scan.MandelScanner;
import com.mandelsoft.mand.scan.MandelScannerUtils;
import com.mandelsoft.mand.tools.Command;
import com.mandelsoft.mand.tools.ExecutionHandler;
import com.mandelsoft.mand.util.MandUtils;
import com.mandelsoft.util.Utils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Copy<E extends ExecutionHandler>
extends Command {
    protected static byte[] buffer = new byte[1024];
    protected int count = 0;
    protected E exec;
    protected Environment src;
    protected Environment dst;
    protected List<FileType> types = new ArrayList<FileType>();
    protected String sp;
    protected String dp;

    protected boolean handleFile(FileType ft, ElementHandle h) {
        return ft.handle(h);
    }

    protected String map(AbstractFile s) {
        MandelFileName n = MandelFileName.create(s);
        MandelName sn = n.getName();
        String eff = sn.getEffective();
        if (!eff.startsWith(this.sp)) {
            return null;
        }
        eff = this.dp + eff.substring(this.sp.length());
        MandelName dn = MandelName.create(eff);
        String fn = n.get(dn, true).getFileName();
        return fn;
    }

    public Copy(Environment src, Environment dst) {
        this.src = src;
        this.dst = dst;
        this.types.add(new InfoType());
        this.types.add(new AreaColmapType());
        this.types.add(new RasterType());
        this.types.add(new RasterImageType());
    }

    protected void additionalSteps() {
    }

    protected void execute() {
        for (FileType t : this.types) {
            t.execute();
        }
        this.additionalSteps();
        this.exec.finish();
    }

    public void copy(MandelName s, MandelName d) {
        if (s.isLocalName() || d.isRemoteName()) {
            throw new IllegalArgumentException("remote name not supported");
        }
        this.sp = s.getEffective();
        this.dp = d.getEffective();
        this.execute();
    }

    public void setExecutionHandler(E h) {
        this.exec = h;
    }

    public static void main(String[] args) {
        try {
            int c;
            boolean vflag = false;
            File src = new File("F://Mandel2");
            File dst = new File("F://Mandel");
            String sn = null;
            Object dn = null;
            for (c = 0; args.length > c && args[c].charAt(0) == '-'; ++c) {
                block6: for (int i = 1; i < args[c].length(); ++i) {
                    char opt = args[c].charAt(i);
                    switch (opt) {
                        case 'v': {
                            vflag = true;
                            continue block6;
                        }
                        default: {
                            Copy.Error("illegal option '" + opt + "'");
                        }
                    }
                }
            }
            if (args.length > c) {
                src = new File(args[c++]);
            }
            if (args.length > c) {
                dst = new File(args[c++]);
            }
            if (args.length > c) {
                sn = args[c++];
            } else {
                Copy.Error("copy: [-v] <srcroot> <dstroot> <srcname>");
            }
            System.out.println("copying from " + src + " to " + dst);
            if (!src.isDirectory()) {
                Copy.Error(src + " is no directory");
            }
            if (!dst.isDirectory()) {
                Copy.Error(dst + " is no directory");
            }
            Environment env_src = new Environment("mandtool", null, src);
            Environment env_dst = new Environment("mandtool", null, dst);
            MandelName s = MandelName.create(sn);
            MandelData sd = MandelScannerUtils.getMandelInfo(env_src.getAllScanner(), s);
            if (sd == null) {
                Copy.Error("source area not found");
            }
            MandelName n = MandUtils.lookupRoot(env_dst.getAllScanner(), sd.getInfo());
            MandelData dd = MandelScannerUtils.getMandelInfo(env_dst.getAllScanner(), n);
            if (dd.getInfo().isSameArea(sd.getInfo())) {
                Copy.Error("already there");
            }
            n = MandUtils.getNextSubName(n, env_dst.getAllScanner());
            System.out.println("target area: " + n);
            Copy<VerboseHandler> a = new Copy<VerboseHandler>(env_src, env_dst);
            if (vflag) {
                a.setExecutionHandler(a.new VerboseHandler());
            } else {
                a.setExecutionHandler(a.new DefaultHandler());
            }
            a.copy(s, n);
            System.out.println("" + a.count + " copied");
        }
        catch (IllegalConfigurationException ex) {
            Command.Error("illegal config: " + ex);
        }
    }

    protected class RasterImageType
    extends FileType {
        RasterImageType() {
            super("raster images", MandelScanner.RASTERIMAGE, Copy.this.src == null ? null : Copy.this.src.getRasterImageScanner(), Copy.this.dst.getRasterImageScanner());
            this.handlePath("path.variant.seen");
            this.handlePath("path.variant.save");
            this.handlePath("path.rasterimage.save");
        }

        protected boolean use(ElementHandle h) {
            return this.use((MandelHandle)h, Copy.this.dst.getRasterImageScanner());
        }

        public void cleanup(ElementHandle h) {
            MandelHandle mh = (MandelHandle)h;
            QualifiedMandelName mn = (QualifiedMandelName)mh.getName();
            for (MandelHandle m : Copy.this.dst.getInfoScanner().getMandelHandles(mn)) {
                System.out.println("  backup request " + m.getFile());
                Copy.this.dst.backupInfoFile(m.getFile());
            }
            for (MandelHandle m : Copy.this.dst.getRasterScanner().getMandelHandles(mn)) {
                System.out.println("  backup raster " + m.getFile());
                Copy.this.exec.backupRasterFile(m.getFile());
            }
            for (MandelHandle m : Copy.this.dst.getAreaColormapScanner().getMandelHandles(mn)) {
                System.out.println("  backup area colormap " + m.getFile());
                Copy.this.exec.backupAreaColormapFile(m.getFile());
            }
        }
    }

    protected class RasterType
    extends FileType {
        RasterType() {
            super("rasters", MandelScanner.RASTER, Copy.this.src == null ? null : Copy.this.src.getRasterScanner(), Copy.this.dst.getRasterScanner());
            this.handlePath("path.variant.seen");
            this.handlePath("path.variant.save");
            this.handlePath("path.raster.seen");
            this.handlePath("path.raster.save");
        }

        public void cleanup(ElementHandle h) {
            QualifiedMandelName mn = (QualifiedMandelName)((MandelHandle)h).getName();
            Set<MandelHandle> set = Copy.this.dst.getInfoScanner().getMandelHandles(mn);
            for (MandelHandle mh : set) {
                System.out.println("  backup request " + mh.getFile());
                Copy.this.exec.backupInfoFile(mh.getFile());
            }
        }
    }

    protected class AreaColmapType
    extends FileType {
        AreaColmapType() {
            super("areacolmaps", MandelScanner.AREACOLMAP, Copy.this.src == null ? null : Copy.this.src.getAreaColormapScanner(), Copy.this.dst.getAreaColormapScanner());
            this.handlePath("path.areacolormap");
            this.handlePath("path.areacolormap.save");
        }

        protected boolean use(ElementHandle h) {
            return this.use((MandelHandle)h, Copy.this.dst.getAreaColormapScanner());
        }
    }

    protected class InfoType
    extends FileType {
        InfoType() {
            super("requests", MandelScanner.INFO, Copy.this.src == null ? null : Copy.this.src.getInfoScanner(), Copy.this.dst.getInfoScanner());
            this.handlePath("path.info.save");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class FileType {
        private String name;
        private Map<AbstractFile, AbstractFile> pathmapping = new HashMap<AbstractFile, AbstractFile>();
        private AbstractFile def;
        private MandelScanner.Filter filter;
        protected MandelScanner srcscan;
        protected MandelScanner dstscan;

        FileType(String name, MandelScanner.Filter filter, MandelScanner srcscan, MandelScanner dstscan) {
            this.name = name;
            this.filter = filter;
            this.srcscan = srcscan;
            this.dstscan = dstscan;
        }

        public boolean match(MandelHeader h) {
            return this.filter.filter(h);
        }

        public boolean match(ElementHandle<?> h) {
            return this.match(h.getHeader());
        }

        protected void handlePath(String prop) {
            String d = Copy.this.dst.getProperty(prop);
            if (!Utils.isEmpty(d)) {
                String s;
                AbstractFile fd = Copy.this.dst.createMandelFile(d);
                if (Copy.this.src != null && !Utils.isEmpty(s = Copy.this.src.getProperty(prop))) {
                    AbstractFile fs = Copy.this.src.createMandelFile(s);
                    this.pathmapping.put(fs, fd);
                }
                this.def = fd;
            }
        }

        public String getName() {
            return this.name;
        }

        public void execute() {
            System.out.println("copying " + this.getName() + "...");
            for (ElementHandle<?> h : this.srcscan.getAllHandles()) {
                if (!this.match(h)) continue;
                Copy.this.handleFile(this, h);
            }
        }

        protected boolean handle(ElementHandle<?> h) {
            AbstractFile mf = h.getFile();
            AbstractFile p = mf.getParent();
            AbstractFile d = this.pathmapping.get(p);
            if (d == null) {
                d = this.def;
            }
            if (d == null) {
                System.out.println("no target for " + mf);
                return false;
            }
            String fn = Copy.this.map(mf);
            if (fn == null) {
                return false;
            }
            Copy.this.exec.copy(h, d.getSub(fn));
            this.cleanup(h);
            ++Copy.this.count;
            return true;
        }

        public void cleanup(ElementHandle<?> h) {
        }

        protected boolean has(ElementHandle<?> h) {
            MandelHandle mh = (MandelHandle)h;
            Set<MandelHandle> set = this.dstscan.getMandelHandles((QualifiedMandelName)mh.getName());
            for (MandelHandle dh : set) {
                if (!this.match(dh)) continue;
                return true;
            }
            return false;
        }

        protected boolean use(ElementHandle<?> h) {
            return this.use((MandelHandle)h, Copy.this.dst.getImageDataScanner());
        }

        protected boolean use(MandelHandle mh, MandelScanner ds) {
            Set<MandelHandle> set = ds.getMandelHandles((QualifiedMandelName)mh.getName());
            if (set.isEmpty()) {
                return true;
            }
            long lm = mh.getFile().getLastModified();
            for (MandelHandle dh : set) {
                if (dh.getFile().getLastModified() < lm) continue;
                return false;
            }
            return true;
        }
    }

    public class DefaultHandler
    extends VerboseHandler {
        protected Set<File> destinations;

        public DefaultHandler() {
            this.destinations = new HashSet<File>();
        }

        public void addDestination(File d) {
            if (!this.destinations.contains(d)) {
                this.destinations.add(d);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void copy(ElementHandle src, AbstractFile dst) {
            File d = dst.getFile();
            AbstractFile s = src.getFile();
            if (d == null) {
                System.out.println("copy to URL not possible: " + dst);
                return;
            }
            super.copy(src, dst);
            this.addDestination(d.getParentFile());
            try {
                BufferedInputStream is = new BufferedInputStream(s.getInputStream());
                try {
                    BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(d));
                    try {
                        int n;
                        while ((n = is.read(buffer)) > 0) {
                            os.write(buffer, 0, n);
                        }
                    }
                    finally {
                        os.close();
                    }
                    d.setLastModified(s.getLastModified());
                }
                finally {
                    is.close();
                }
            }
            catch (IOException io) {
                System.out.println("cannot copy " + s + ": " + io);
                io.printStackTrace(System.err);
            }
        }

        public void backupInfoFile(AbstractFile mf) {
            super.backupInfoFile(mf);
            Copy.this.dst.backupInfoFile(mf);
        }

        public void backupRasterFile(AbstractFile mf) {
            super.backupRasterFile(mf);
            Copy.this.dst.backupRasterFile(mf);
        }

        public void backupAreaColormapFile(AbstractFile mf) {
            super.backupAreaColormapFile(mf);
            Copy.this.dst.backupAreaColormapFile(mf);
        }

        public void updateCaches() {
            for (File f : this.destinations) {
                System.out.println("checking cache " + f);
                if (!MandelFolderCache.isCached(f)) continue;
                try {
                    System.out.println("updating cache in " + f);
                    MandelFolder mf = new MandelFolder(f);
                    mf.recreate();
                }
                catch (IOException io) {
                    System.out.println("  cannot recreate cache for " + f);
                }
            }
        }

        public void finish() {
            this.updateCaches();
        }
    }

    public class VerboseHandler
    implements ExecutionHandler {
        public void copy(ElementHandle src, AbstractFile dst) {
            System.out.println("copying " + src.getFile() + " to " + dst.getFile());
        }

        public void backupInfoFile(AbstractFile mf) {
            System.out.println("backup request " + mf);
        }

        public void backupRasterFile(AbstractFile mf) {
            System.out.println("backup raster " + mf);
        }

        public void backupAreaColormapFile(AbstractFile mf) {
            System.out.println("backup area colormap " + mf);
        }

        public void finish() {
        }
    }
}

