/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.tools;

import com.mandelsoft.io.AbstractFile;
import com.mandelsoft.mand.ColormapName;
import com.mandelsoft.mand.Environment;
import com.mandelsoft.mand.IllegalConfigurationException;
import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.scan.ElementHandle;
import com.mandelsoft.mand.scan.MandelHandle;
import com.mandelsoft.mand.scan.MandelScanner;
import com.mandelsoft.mand.tools.Command;
import com.mandelsoft.mand.tools.Copy;
import com.mandelsoft.mand.tools.ExecutionHandler;
import com.mandelsoft.mand.util.MandelList;
import com.mandelsoft.mand.util.MandelListFolder;
import com.mandelsoft.mand.util.MandelListFolderTree;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sync
extends Copy<SyncHandler> {
    public static final int IMAGES = 1;
    public static final int REQUESTS = 2;
    public static final int VARIANTS = 4;
    public static final int AREACOLMAPS = 8;
    public static final int COLORMAPS = 16;
    public static final int MANDEL = 15;
    public static final int ALL = 31;
    protected int typecodes;
    protected boolean listCopyMode = false;

    public Sync(Environment src, Environment dst) {
        this(src, dst, 31);
    }

    public Sync(Environment src, Environment dst, int types) {
        super(src, dst);
        this.typecodes = types;
        this.types.clear();
        if ((types & 2) != 0) {
            this.types.add(new Copy.InfoType());
        }
        if ((types & 1) != 0) {
            this.types.add(new Copy.AreaColmapType());
            this.types.add(new Copy.RasterType());
            this.types.add(new Copy.RasterImageType());
        }
        if ((types & 0x10) != 0) {
            this.types.add(new ColormapType());
        }
    }

    public void setListCopyMode(boolean listCopyMode) {
        this.listCopyMode = listCopyMode;
    }

    @Override
    protected String map(AbstractFile s) {
        return s.getName();
    }

    @Override
    protected boolean handleFile(Copy.FileType ft, ElementHandle h) {
        boolean v;
        AbstractFile mf = h.getFile();
        if (mf.getName().startsWith("x")) {
            System.out.println("  " + mf);
            v = true;
        } else {
            v = false;
        }
        if ((this.typecodes & 4) == 0 && h.getHeader().hasInfo() && ((MandelHandle)h).getQualifier() != null) {
            return false;
        }
        if (!ft.has(h)) {
            if (ft.use(h)) {
                return ft.handle(h);
            }
            if (v) {
                System.out.println("    skipped");
            }
        } else if (v) {
            System.out.println("    already exists " + mf);
        }
        return false;
    }

    @Override
    protected void additionalSteps() {
        if (((SyncHandler)this.exec).getClass() != VerboseSyncHandler.class) {
            ((SyncHandler)this.exec).syncTree(this.src.getFavorites(), this.dst.getFavorites(), "favorites");
            ((SyncHandler)this.exec).syncTree(this.src.getTodos(), this.dst.getTodos(), "todos");
            ((SyncHandler)this.exec).syncTree(this.src.getLinks(), this.dst.getLinks(), "links");
            ((SyncHandler)this.exec).syncList(this.src.getSeenRasters(), this.dst.getSeenRasters(), "seen");
            ((SyncHandler)this.exec).syncList(this.src.getAreas(), this.dst.getAreas(), "areas");
            for (MandelListFolderTree t : this.src.getUserLists()) {
                if (t.getRoot().getName().equals("news")) continue;
                for (MandelListFolderTree d : this.dst.getUserLists()) {
                    if (!t.getRoot().getName().equals(d.getRoot().getName())) continue;
                    ((SyncHandler)this.exec).syncTree(t, d, t.getRoot().getName());
                }
            }
        }
    }

    protected static int parseTypes(int c, String[] args) {
        int types = 31;
        if (args.length > c) {
            types = args[c].startsWith("-") ? 31 : 0;
            while (args.length > c) {
                String t = args[c++];
                boolean sub = false;
                int type = 0;
                if (t.startsWith("-")) {
                    sub = true;
                    t = t.substring(1);
                } else if (t.startsWith("+")) {
                    sub = false;
                    t = t.substring(1);
                }
                if (t.equals("requests")) {
                    type = 2;
                } else if (t.equals("images")) {
                    type = 1;
                } else if (t.equals("mandel")) {
                    type = 15;
                } else if (t.equals("variants")) {
                    type = 4;
                } else if (t.equals("colormaps")) {
                    type = 16;
                } else if (t.equals("all")) {
                    type = 31;
                } else if (t.equals("none")) {
                    type = 31;
                    sub = true;
                } else {
                    Sync.Error("illegal mode '" + t + "'");
                }
                if (sub) {
                    types &= ~type;
                    continue;
                }
                types |= type;
            }
        }
        return types;
    }

    public static void main(String[] args) {
        try {
            int c;
            boolean vflag = false;
            boolean cflag = false;
            File src = new File("F://Mandel2");
            File dst = new File("F://Mandel");
            for (c = 0; args.length > c && args[c].charAt(0) == '-'; ++c) {
                block7: for (int i = 1; i < args[c].length(); ++i) {
                    char opt = args[c].charAt(i);
                    switch (opt) {
                        case 'v': {
                            vflag = true;
                            continue block7;
                        }
                        case 'c': {
                            cflag = true;
                            continue block7;
                        }
                        default: {
                            Sync.Error("illegal option '" + opt + "'");
                        }
                    }
                }
            }
            if (args.length > c) {
                src = new File(args[c++]);
            }
            if (args.length > c) {
                dst = new File(args[c++]);
            }
            int types = Sync.parseTypes(c, args);
            System.out.println("syncing from " + src + " to " + dst + " (types=" + types + ")");
            if (!src.isDirectory()) {
                Sync.Error(src + " is no directory");
            }
            if (!dst.isDirectory()) {
                Sync.Error(dst + " is no directory");
            }
            Environment env_src = new Environment("mandtool", null, src);
            Environment env_dst = new Environment("mandtool", null, dst);
            Sync a = new Sync(env_src, env_dst, types);
            a.setListCopyMode(cflag);
            if (vflag) {
                a.setExecutionHandler(a.new VerboseSyncHandler());
            } else {
                a.setExecutionHandler(a.new DefaultSyncHandler());
            }
            a.execute();
            System.out.println("" + a.count + " copied");
        }
        catch (IllegalConfigurationException ex) {
            Sync.Error("illegal config: " + ex);
        }
    }

    private class ColormapType
    extends Copy.FileType {
        ColormapType() {
            super("colormaps", MandelScanner.COLORMAP, Sync.this.src == null ? null : Sync.this.src.getColormapScanner(), Sync.this.dst.getColormapScanner());
            this.handlePath("path.colormap.save");
        }

        protected boolean has(ElementHandle h) {
            String n = h.getFile().getName();
            if (n.endsWith(".cm")) {
                n = n.substring(0, n.length() - 3);
            }
            return !this.dstscan.getColormapHandles(new ColormapName(n)).isEmpty();
        }

        protected boolean use(ElementHandle h) {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class VerboseSyncHandler
    extends Copy.VerboseHandler
    implements SyncHandler {
        @Override
        public void syncList(MandelList ml, MandelList dl, String name) {
            System.out.println("syncing list " + name);
        }

        @Override
        public Set<QualifiedMandelName> syncTree(MandelListFolderTree ml, MandelListFolderTree dl, String name) {
            System.out.println("syncing tree " + name);
            return new HashSet<QualifiedMandelName>();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DefaultSyncHandler
    extends Copy.DefaultHandler
    implements SyncHandler {
        @Override
        public void syncList(MandelList ml, MandelList dl, String msg) {
            System.out.println("syncing list " + msg + "...");
            if (dl != null && ml != null) {
                if (Sync.this.listCopyMode) {
                    dl.clear();
                }
                dl.addAll(ml);
                try {
                    dl.save();
                }
                catch (IOException ex) {
                    Command.Warning("cannot write " + msg + ": " + ex);
                }
            }
        }

        @Override
        public Set<QualifiedMandelName> syncTree(MandelListFolderTree ml, MandelListFolderTree dl, String msg) {
            HashSet<QualifiedMandelName> set = new HashSet<QualifiedMandelName>();
            HashSet<QualifiedMandelName> old = new HashSet<QualifiedMandelName>();
            System.out.println("syncing tree " + msg + "...");
            for (QualifiedMandelName q : dl.getRoot().allentries()) {
                old.add(q);
            }
            if (dl != null && ml != null) {
                this.sync(" ", ml.getRoot(), dl.getRoot(), set, old);
                try {
                    dl.save();
                }
                catch (IOException ex) {
                    Command.Warning("cannot write " + msg + ": " + ex);
                }
            }
            return set;
        }

        private void sync(String gap, MandelListFolder s, MandelListFolder d, Set<QualifiedMandelName> set, Set<QualifiedMandelName> old) {
            MandelListFolder n;
            String ngap = gap + "  ";
            System.out.println(gap + "syncing folder " + s.getPath());
            ArrayList<QualifiedMandelName> list = new ArrayList<QualifiedMandelName>();
            MandelList l = s.getMandelList();
            if (!Sync.this.listCopyMode && l != null) {
                for (QualifiedMandelName n2 : l) {
                    list.add(n2);
                    if (old.contains(n2)) continue;
                    set.add(n2);
                    System.out.println(ngap + "adding " + n2);
                }
            }
            if ((l = d.getMandelList()) != null) {
                for (QualifiedMandelName n2 : d.getMandelList()) {
                    if (list.contains(n2)) continue;
                    list.add(n2);
                }
                l.clear();
                l.addAll(list);
            }
            for (MandelListFolder f : s) {
                n = d.getSubFolder(f.getName());
                if (n == null) {
                    n = d.createSubFolder(f.getName());
                }
                this.sync(ngap, f, n, set, old);
            }
            if (Sync.this.listCopyMode) {
                for (MandelListFolder f : d) {
                    n = s.getSubFolder(f.getName());
                    if (n != null) continue;
                    d.remove(f);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface SyncHandler
    extends ExecutionHandler {
        public void syncList(MandelList var1, MandelList var2, String var3);

        public Set<QualifiedMandelName> syncTree(MandelListFolderTree var1, MandelListFolderTree var2, String var3);
    }
}

