/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.util;

import com.mandelsoft.mand.MandelName;
import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.cm.Colormap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MandelColormapCache {
    private int max;
    private List<QualifiedMandelName> list;
    private Map<QualifiedMandelName, Colormap> map;
    private Map<QualifiedMandelName, Colormap> locked;

    public MandelColormapCache(int max) {
        this.max = max;
        this.list = new ArrayList<QualifiedMandelName>();
        this.map = new HashMap<QualifiedMandelName, Colormap>();
        this.locked = new HashMap<QualifiedMandelName, Colormap>();
    }

    public synchronized Colormap get(QualifiedMandelName n) {
        Colormap cm = this.map.get(n);
        if (cm == null) {
            cm = this.locked.get(n);
        }
        return cm;
    }

    public synchronized void remove(QualifiedMandelName n) {
        this.list.remove(n);
        this.map.remove(n);
        this.locked.remove(n);
    }

    public synchronized void remove(MandelName n) {
        ArrayList<QualifiedMandelName> del = new ArrayList<QualifiedMandelName>();
        for (QualifiedMandelName q : this.list) {
            if (!q.getMandelName().equals(n)) continue;
            del.add(q);
        }
        for (QualifiedMandelName q : this.list) {
            this.remove(n);
        }
    }

    public synchronized void unlock(QualifiedMandelName n) {
        if (this.locked.containsKey(n)) {
            Colormap cm = this.locked.get(n);
            this.remove(n);
            this.add(n, cm);
        }
    }

    public synchronized void lock(QualifiedMandelName n, Colormap cm) {
        this.remove(n);
        this.locked.put(n, cm);
    }

    public synchronized void add(QualifiedMandelName n, Colormap cm) {
        if (this.locked.containsKey(n)) {
            this.locked.put(n, cm);
        } else {
            if (!this.map.containsKey(n) && this.list.size() >= this.max) {
                this.map.remove(this.list.get(0));
                this.list.remove(0);
            }
            this.list.remove(n);
            this.list.add(n);
            this.map.put(n, cm);
        }
    }
}

