/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.util;

import com.mandelsoft.mand.ColormapName;
import com.mandelsoft.mand.MandelHeader;
import com.mandelsoft.mand.cm.Colormap;
import com.mandelsoft.mand.scan.ColormapHandle;
import com.mandelsoft.mand.scan.DefaultColormapHandle;
import com.mandelsoft.mand.util.AbstractColormapList;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class MemoryColormapList
extends AbstractColormapList {
    private Map<ColormapName, Colormap> maps = new HashMap<ColormapName, Colormap>();
    private Map<ColormapName, ColormapHandle> files = new HashMap<ColormapName, ColormapHandle>();

    public void refresh() {
    }

    public void save() throws IOException {
    }

    public void clear() {
        super.clear();
        this.maps.clear();
        this.files.clear();
    }

    public Colormap get(ColormapName name) throws IOException {
        return this.maps.get(name);
    }

    public ColormapHandle getColormapHandle(ColormapName name) throws IOException {
        if (this.contains(name)) {
            ColormapHandle h = this.files.get(name);
            if (h == null) {
                h = new DefaultColormapHandle(null, name, new MandelHeader(4));
                this.files.put(name, h);
            }
            return h;
        }
        return null;
    }

    protected boolean _add(ColormapName name, Colormap cm, ColormapHandle h) {
        this.maps.put(name, cm);
        if (h != null) {
            this.files.put(name, h);
        }
        return true;
    }

    protected boolean _remove(ColormapName name) {
        this.maps.remove(name);
        this.files.remove(name);
        return true;
    }
}

