/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.util;

import com.mandelsoft.mand.MandelName;
import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.cm.Colormap;
import com.mandelsoft.mand.cm.ColormapSource;
import com.mandelsoft.mand.scan.MandelHandle;
import com.mandelsoft.mand.scan.MandelScanner;
import com.mandelsoft.mand.util.MandUtils;
import java.io.IOException;

public class UpstreamColormapSource
implements ColormapSource {
    protected static final boolean debug = true;
    private MandelName n;
    private MandelScanner scanner;
    private ColormapSource defaultSource;
    private QualifiedMandelName source;

    public UpstreamColormapSource(MandelName n, MandelScanner scanner, ColormapSource defaultSource) {
        this.n = n;
        this.scanner = scanner;
        this.defaultSource = defaultSource;
    }

    public UpstreamColormapSource(MandelName n, MandelScanner scanner) {
        this(n, scanner, null);
    }

    public Colormap getColormap() {
        Colormap cm = null;
        MandelHandle h = MandUtils.lookupColormap(this.scanner, this.n);
        while (cm == null && h != null) {
            cm = this.optimizedLoad(h);
            if (cm != null) continue;
            try {
                System.out.println("use upstream colormap of " + h.getName());
                cm = h.getData().getColormap();
            }
            catch (IOException ex) {
                h = MandUtils.lookupColormap(this.scanner, ((QualifiedMandelName)h.getName()).getMandelName().getParentName());
            }
        }
        if (cm != null) {
            this.colormapFound(h, cm);
        } else {
            cm = this.defaultSource == null ? null : this.defaultSource.getColormap();
        }
        return cm;
    }

    public MandelName getBasename() {
        return this.n;
    }

    protected Colormap optimizedLoad(MandelHandle h) {
        return null;
    }

    protected void colormapFound(MandelHandle h, Colormap cm) {
        this.source = (QualifiedMandelName)h.getName();
    }

    public QualifiedMandelName getSource() {
        return this.source;
    }
}

