/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.util.lists;

import com.mandelsoft.mand.MandelData;
import com.mandelsoft.mand.MandelInfo;
import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.scan.MandelHandle;
import com.mandelsoft.mand.scan.MandelScanner;
import com.mandelsoft.mand.util.ArrayMandelList;
import com.mandelsoft.mand.util.MandelList;
import com.mandelsoft.mand.util.lists.MandelListFactory;
import java.io.IOException;

public abstract class ScannerBasedMandelListFactory
implements MandelListFactory {
    private MandelScanner scanner;

    protected ScannerBasedMandelListFactory(MandelScanner scanner) {
        this.scanner = scanner;
    }

    public MandelScanner getScanner() {
        return this.scanner;
    }

    public void setScanner(MandelScanner scanner) {
        this.scanner = scanner;
    }

    public MandelList getList() {
        ArrayMandelList list = new ArrayMandelList();
        for (QualifiedMandelName n : this.scanner.getQualifiedMandelNames()) {
            if (!this.acceptType(n) || !this.accept(n)) continue;
            list.add(n);
        }
        return list;
    }

    protected boolean accept(QualifiedMandelName n) {
        return true;
    }

    protected boolean acceptType(QualifiedMandelName n) {
        return true;
    }

    protected boolean hasMandel(QualifiedMandelName n) {
        MandelHandle h = this.getScanner().getMandelInfo(n);
        if (h != null) {
            try {
                MandelData md = h.getInfo();
                MandelInfo mi = md.getInfo();
                long nm = mi.getMCnt();
                long np = mi.getRX() * mi.getRY();
                if ((double)(nm * 100L) / (double)np > 0.1) {
                    return true;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }
}

