/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.swing;

import com.mandelsoft.swing.CornerSideCrossLink;
import com.mandelsoft.swing.RectanglePoint;
import com.mandelsoft.swing.Side;

public class Corner
extends RectanglePoint {
    public static final Corner TOP_LEFT = new Corner("TopLeft", 0, 0, 6);
    public static final Corner TOP_RIGHT = new Corner("TopRight", 1, 0, 7);
    public static final Corner BOTTOM_RIGHT = new Corner("BottomRight", 1, 1, 5);
    public static final Corner BOTTOM_LEFT = new Corner("BottomLeft", 0, 1, 4);
    private Corner opposite;
    private Side leftSide;
    private Side rightSide;
    private int cursor;

    static void setup() {
        TOP_LEFT.setup(BOTTOM_RIGHT, Side.LEFT, Side.TOP);
        TOP_RIGHT.setup(BOTTOM_LEFT, Side.TOP, Side.RIGHT);
        BOTTOM_RIGHT.setup(TOP_LEFT, Side.RIGHT, Side.BOTTOM);
        BOTTOM_LEFT.setup(TOP_RIGHT, Side.BOTTOM, Side.LEFT);
    }

    private Corner(String name, int x, int y, int cursor) {
        super(name, x, y, cursor);
    }

    private void setup(Corner c, Side l, Side r) {
        this.opposite = c;
        this.leftSide = l;
        this.rightSide = r;
    }

    public Corner getOppositeCorner() {
        return this.opposite;
    }

    public Side getLeftSide() {
        return this.leftSide;
    }

    public Side getRightSide() {
        return this.rightSide;
    }

    public String toString() {
        return "Corner " + this.getName();
    }

    static {
        CornerSideCrossLink.setup();
    }
}

