/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.swing;

import com.mandelsoft.swing.GBCPanel;
import com.mandelsoft.util.Utils;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;

public class FilePanel
extends GBCPanel {
    public static final String PROP_FILENAME = "filename";
    private String name;
    private FileFilter filter;
    private JTextField field;
    private JButton select;
    private Window frame;
    private boolean editable;
    private int mode = 0;

    public FilePanel(String name, String def, Window frame) {
        this(name, def, null, frame);
    }

    public FilePanel(String name, String def, FileFilter filter, Window frame) {
        this.frame = frame;
        this.filter = filter;
        this.add((Component)new JLabel(name), this.GBC(0, 0).setWeight(0.0, 0.0).setRightInset(10));
        this.field = new JTextField();
        this.add((Component)this.field, this.GBC(1, 0).setFill(2).setWeight(200.0, 0.0));
        this.field.setText(def);
        this.field.setColumns(30);
        this.field.getDocument().addDocumentListener(new FilenameListener());
        this.select = new JButton("select");
        this.add((Component)this.select, this.GBC(2, 0).setWeight(0.0, 0.0));
        this.select.setMargin(new Insets(0, 0, 0, 0));
        this.select.addActionListener(new FileChooserAction());
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEnableChooser(boolean editable) {
        this.editable = editable;
        this.select.setVisible(editable);
    }

    public String getFilename() {
        return this.field.getText();
    }

    public void setFilename(String name) {
        this.field.setText(name);
    }

    public void setFileChooserMode(int m) {
        this.mode = m;
    }

    private class FileChooserAction
    implements ActionListener {
        private FileChooserAction() {
        }

        public void actionPerformed(ActionEvent e) {
            File f;
            String cur;
            JFileChooser c = new JFileChooser();
            c.setLocale(Locale.UK);
            if (FilePanel.this.filter != null) {
                c.setFileFilter(FilePanel.this.filter);
            }
            if (Utils.isEmpty(cur = FilePanel.this.field.getText())) {
                cur = ".";
            }
            if ((f = new File(cur)).isDirectory()) {
                c.setCurrentDirectory(f);
            } else {
                c.setSelectedFile(f);
            }
            c.setFileSelectionMode(FilePanel.this.mode);
            int result = c.showDialog(FilePanel.this.frame, "select");
            if (result == 0) {
                FilePanel.this.field.setText(c.getSelectedFile().getPath());
            }
        }
    }

    private class FilenameListener
    implements DocumentListener {
        private String old;

        private FilenameListener() {
            this.old = FilePanel.this.field.getText();
        }

        private void change() {
            String f = FilePanel.this.field.getText();
            if (f.equals(this.old)) {
                return;
            }
            FilePanel.this.firePropertyChange(FilePanel.PROP_FILENAME, this.old, FilePanel.this.field.getText());
            this.old = FilePanel.this.field.getText();
        }

        public void insertUpdate(DocumentEvent e) {
            this.change();
        }

        public void removeUpdate(DocumentEvent e) {
            this.change();
        }

        public void changedUpdate(DocumentEvent e) {
            this.change();
        }
    }
}

