/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.swing;

import com.mandelsoft.swing.BevelBorder;
import com.mandelsoft.swing.Dimensions;
import com.mandelsoft.swing.DnDJList;
import com.mandelsoft.swing.GBCPanel;
import com.mandelsoft.swing.ListSelection;
import com.mandelsoft.swing.ProxyModel;
import com.mandelsoft.swing.ThumbnailEvent;
import com.mandelsoft.swing.ThumbnailListModel;
import com.mandelsoft.swing.ThumbnailListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GaleryPanel<E, M extends ThumbnailListModel<E>>
extends GBCPanel {
    static Color backColor = Color.lightGray;
    private int maxframe = 0;
    private Dimension maximage = new Dimension(180, 180);
    private int gap = 40;
    private Dimension item;
    private Renderer renderer;
    protected DnDJList list;
    protected JScrollPane scrollPane;
    private GBCPanel panel;
    private M model;
    private ThumbnailChangeListener thumblistener;
    private boolean busy;
    private Cursor origcursor;
    private DnDJList.ContextMenuHandler ctxmenu;
    private Listener listener;

    public GaleryPanel(M model) {
        this(model, 1, null);
    }

    public GaleryPanel(M model, int rows, Dimension d) {
        if (d != null) {
            this.maximage = d;
        }
        System.out.println("Galery panel for items of size " + Dimensions.toString(d));
        this.thumblistener = new ThumbnailChangeListener();
        this.panel = new GBCPanel(){};
        this.panel.setBackground(backColor);
        this.model = model;
        this.renderer = new Renderer();
        this.list = new DnDJList((ListModel)model);
        this.list.setLayoutOrientation(2);
        this.list.setVisibleRowCount(rows);
        this.list.setCellRenderer(this.renderer);
        this.list.setBackground(backColor);
        this.panel.add((Component)this.list, this.GBC(0, 0).setAnchor(10));
        this.panel.setTransferHandler(this.list.getTransferHandler());
        this.scrollPane = new JScrollPane(this.panel);
        this.setBorder(new BevelBorder(1));
        this.add((Component)this.scrollPane, this.GBC(0, 0, 1).setAnchor(10));
        this.item = this.renderer.getPreferredSize();
        ResizeListener l = new ResizeListener();
        this.addComponentListener(l);
    }

    @Override
    protected void panelBound() {
        System.out.println("galery item size " + Dimensions.toString(this.item));
        super.panelBound();
        if (this.model != null) {
            this.model.addThumbnailListener(this.thumblistener);
            if (this.model instanceof ProxyModel) {
                ((ProxyModel)this.model).bind();
            }
        }
    }

    @Override
    protected void panelUnbound() {
        System.out.println("cleanup galery");
        super.panelUnbound();
        if (this.model != null) {
            if (this.model instanceof ProxyModel) {
                ((ProxyModel)this.model).unbind();
            }
            this.model.removeThumbnailListener(this.thumblistener);
        }
    }

    protected abstract String getLabel(E var1);

    protected abstract Icon getIcon(E var1);

    public int getMaxFrame() {
        return this.maxframe;
    }

    public void setMaxFrame(int maxframe) {
        this.maxframe = maxframe;
    }

    public M getModel() {
        return this.model;
    }

    protected void setBusy(boolean b) {
        if (b != this.busy) {
            if (b) {
                System.out.println("-------------------------------------------------");
                System.out.println("set busy");
                this.origcursor = this.getCursor();
                this.setCursor(Cursor.getPredefinedCursor(3));
            } else {
                System.out.println("orig cursor");
                this.setCursor(this.origcursor);
            }
            this.firePropertyChange("busy", !b, b);
        }
        this.busy = b;
    }

    public synchronized void setContextMenuHandler(DnDJList.ContextMenuHandler h) {
        if (h == null) {
            if (this.ctxmenu != null) {
                this.panel.removeMouseListener(this.listener);
            }
        } else if (this.ctxmenu == null) {
            if (this.listener == null) {
                this.listener = new Listener();
            }
            this.panel.addMouseListener(this.listener);
        }
        this.ctxmenu = h;
        this.list.setContextMenuHandler(h);
    }

    public synchronized DnDJList.ContextMenuHandler getContextMenuHandler() {
        return this.ctxmenu;
    }

    public class Ticker
    extends Timer
    implements ActionListener,
    ChangeListener {
        private Rectangle rect;
        private boolean inupdate;

        public Ticker() {
            super(100, null);
            this.rect = new Rectangle(0, 0, 1, 1);
            this.addActionListener(this);
            GaleryPanel.this.scrollPane.getViewport().addChangeListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            if (!GaleryPanel.this.scrollPane.getHorizontalScrollBar().isVisible()) {
                this.stop();
            }
            Rectangle r = GaleryPanel.this.scrollPane.getViewport().getViewRect();
            int w = (int)GaleryPanel.this.panel.getPreferredSize().getWidth();
            if (r.getX() + r.getWidth() + 1.0 < (double)w) {
                this.setX((int)this.rect.getX() + 1);
                this.inupdate = true;
                try {
                    GaleryPanel.this.list.scrollRectToVisible(this.rect);
                }
                finally {
                    this.inupdate = false;
                }
            } else {
                this.stop();
            }
        }

        public void restart() {
            this.setX(1);
            super.restart();
        }

        public void start() {
            Rectangle r = GaleryPanel.this.scrollPane.getViewport().getViewRect();
            this.setX((int)(r.getWidth() + r.getX()));
            this.setInitialDelay(this.getDelay());
            super.start();
        }

        public void start(int delay) {
            Rectangle r = GaleryPanel.this.scrollPane.getViewport().getViewRect();
            this.setX((int)(r.getWidth() + r.getX()));
            this.setInitialDelay(delay);
            super.start();
        }

        public void stop() {
            System.out.println("stop ticker");
            super.stop();
        }

        private void setX(int x) {
            this.rect.setRect(x, 0.0, 1.0, 1.0);
        }

        public void stateChanged(ChangeEvent e) {
            if (!this.inupdate) {
                this.stop();
            }
        }
    }

    private class Listener
    extends MouseAdapter {
        private Listener() {
        }

        public void mouseReleased(MouseEvent e) {
            this.handlePopup(e);
        }

        public void mousePressed(MouseEvent e) {
            this.handlePopup(e);
        }

        public void handlePopup(MouseEvent e) {
            if (e.isPopupTrigger() && GaleryPanel.this.ctxmenu != null) {
                System.out.println("CTX POPUP at panel");
                GaleryPanel.this.ctxmenu.handleContextMenu(GaleryPanel.this.panel, e, new ListSelection(GaleryPanel.this.list));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ThumbnailChangeListener
    implements ThumbnailListener<E> {
        private ThumbnailChangeListener() {
        }

        @Override
        public void thumbnailChanged(ThumbnailEvent<E> event) {
            GaleryPanel.this.repaint();
        }
    }

    private class ResizeListener
    extends ComponentAdapter
    implements PropertyChangeListener {
        private ResizeListener() {
        }

        public void componentResized(ComponentEvent e) {
            this.adjustList();
        }

        public void propertyChange(PropertyChangeEvent evt) {
            System.out.println("panel prop changed: " + evt.getPropertyName());
            if (evt.getPropertyName().equals("size")) {
                this.adjustList();
            }
        }

        private void adjustList() {
            Dimension n = GaleryPanel.this.getSize();
            int h = (int)(n.getHeight() / GaleryPanel.this.item.getHeight());
            if (h < 1) {
                h = 1;
            }
            if (GaleryPanel.this.list.getVisibleRowCount() != h) {
                GaleryPanel.this.list.setVisibleRowCount(h);
                GaleryPanel.this.list.revalidate();
            }
        }
    }

    public class Renderer
    extends ItemPanel
    implements ListCellRenderer {
        Renderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setData(value);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
                this.panel.setBackground(Color.GRAY);
            }
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ImagePanel
    extends JComponent {
        private E elem;
        private Border border = new BevelBorder(1);

        public ImagePanel() {
            this.setBorder(new BevelBorder(0, 4));
            Insets insets = this.getInsets();
            Dimension s = new Dimension((int)GaleryPanel.this.maximage.getWidth() + insets.right + insets.left + GaleryPanel.this.gap, (int)GaleryPanel.this.maximage.getHeight() + insets.top + insets.bottom + GaleryPanel.this.gap);
            this.setPreferredSize(s);
            this.setBackground(Color.GRAY);
        }

        void setData(E elem) {
            this.elem = elem;
        }

        @Override
        public void paintComponent(Graphics g) {
            Rectangle r = g.getClipBounds();
            if (!r.isEmpty()) {
                Insets insets = this.getInsets();
                g.setColor(this.getBackground());
                g.fillRect(insets.left, insets.top, (int)GaleryPanel.this.maximage.getWidth() + GaleryPanel.this.gap, (int)GaleryPanel.this.maximage.getHeight() + GaleryPanel.this.gap);
                BufferedImage image = GaleryPanel.this.model.getThumbnail(this.elem, GaleryPanel.this.maximage);
                int x = (int)(GaleryPanel.this.maximage.getWidth() - (double)image.getWidth() + (double)GaleryPanel.this.gap) / 2 + insets.left;
                int y = (int)(GaleryPanel.this.maximage.getHeight() - (double)image.getHeight() + (double)GaleryPanel.this.gap) / 2 + insets.top;
                g.drawImage(image, x, y, null);
                Insets binsets = this.border.getBorderInsets(this);
                this.border.paintBorder(this, g, x - binsets.left, y - binsets.top, image.getWidth() + binsets.left + binsets.right, image.getHeight() + binsets.top + binsets.bottom);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ItemPanel
    extends GBCPanel {
        protected JLabel label;
        protected ImagePanel panel;

        ItemPanel() {
            this.panel = new ImagePanel();
            this.add((Component)this.panel, this.GBC(0, 0).setInsets(10, 10, 10, 10));
            this.label = new JLabel();
            this.add((Component)this.label, this.GBC(0, 1).setInsets(0, 10, 10, 10));
        }

        public void setData(E elem) {
            this.label.setText(GaleryPanel.this.getLabel(elem));
            this.label.setIcon(GaleryPanel.this.getIcon(elem));
            this.panel.setData(elem);
        }
    }

    public class TestRenderer
    extends JPanel
    implements ListCellRenderer {
        private JLabel label;

        TestRenderer() {
            super(false);
            this.label = new JLabel();
            this.add(this.label);
            this.validate();
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.label.setText(GaleryPanel.this.getLabel(value));
            this.validate();
            return this;
        }
    }
}

