/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.swing.worker;

import com.mandelsoft.swing.worker.UIExecution;
import com.mandelsoft.swing.worker.UIFunction;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CallbackWorker<T, V, O extends Component>
extends SwingWorker<T, UIExecution<? super O>> {
    private O owner;

    public CallbackWorker(O owner) {
        this.owner = owner;
    }

    protected final void call(UIExecution<? super O> exec) {
        this.publish(exec);
    }

    protected final <R> R call(UIFunction<? super O, R> exec) {
        this.publish(exec);
        return exec.getResult();
    }

    protected final void publishProgress(V ... chunks) {
        this.publish(new IntermediateResultNotification(chunks));
    }

    protected void processProgress(List<V> chunks) {
    }

    @Override
    protected final void process(List<UIExecution<? super O>> chunks) {
        ArrayList list = null;
        for (UIExecution<O> n : chunks) {
            if (n instanceof IntermediateResultNotification) {
                V[] ichunks = ((IntermediateResultNotification)n).getChunks();
                if (ichunks == null) continue;
                if (list == null) {
                    list = new ArrayList();
                }
                for (Object v : ichunks) {
                    list.add(v);
                }
                continue;
            }
            if (list != null) {
                this.processProgress(list);
                list = null;
            }
            n.execute(this.owner);
        }
        if (list != null) {
            this.processProgress(list);
            list = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IntermediateResultNotification<V, O extends Component>
    implements UIExecution<O> {
        private V[] chunks;

        public IntermediateResultNotification(V[] chunks) {
            this.chunks = chunks;
        }

        public V[] getChunks() {
            return this.chunks;
        }

        @Override
        public void execute(O owner) {
        }
    }
}

