/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.util;

import java.math.BigInteger;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;

public class BigIntegerFormat
extends Format {
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        BigInteger d = (BigInteger)obj;
        toAppendTo.append(d.toString());
        return toAppendTo;
    }

    public Object parseObject(String source, ParsePosition pos) {
        int ix = pos.getIndex();
        int len = source.length();
        int sign = 1;
        boolean match = false;
        char c = '\u0000';
        BigInteger n = BigInteger.ZERO;
        if (ix < len && ((c = source.charAt(ix)) == '+' || c == '-')) {
            sign = c == '-' ? -1 : 1;
            ++ix;
        }
        --ix;
        while (++ix < len) {
            c = source.charAt(ix);
            if (Character.isDigit(c)) {
                int d = Character.digit(c, 10);
                n = n.multiply(BigInteger.TEN);
                n = n.add(BigInteger.valueOf(d));
                match = true;
                continue;
            }
            if (match) break;
            pos.setErrorIndex(ix);
            return null;
        }
        if (!match) {
            pos.setErrorIndex(ix);
            return null;
        }
        if (sign < 0) {
            n = n.negate();
        }
        pos.setIndex(ix);
        return n;
    }
}

