/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.util;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class PropertyContainer {
    private PropertyChangeSupport changeSupport;

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null || this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners() {
        if (this.changeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.changeSupport.getPropertyChangeListeners();
    }

    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public synchronized void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (listener == null || this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        if (this.changeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.changeSupport.getPropertyChangeListeners(propertyName);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        PropertyChangeSupport changeSupport = this.changeSupport;
        if (changeSupport == null || oldValue != null && newValue != null && oldValue.equals(newValue)) {
            return;
        }
        changeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        PropertyChangeSupport changeSupport = this.changeSupport;
        if (changeSupport == null || oldValue == newValue) {
            return;
        }
        changeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void firePropertyChange(String propertyName, int oldValue, int newValue) {
        PropertyChangeSupport changeSupport = this.changeSupport;
        if (changeSupport == null || oldValue == newValue) {
            return;
        }
        changeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
        if (this.changeSupport == null || oldValue == newValue) {
            return;
        }
        this.firePropertyChange(propertyName, (Object)oldValue, (Object)newValue);
    }

    public void firePropertyChange(String propertyName, char oldValue, char newValue) {
        if (this.changeSupport == null || oldValue == newValue) {
            return;
        }
        this.firePropertyChange(propertyName, new Character(oldValue), new Character(newValue));
    }

    public void firePropertyChange(String propertyName, short oldValue, short newValue) {
        if (this.changeSupport == null || oldValue == newValue) {
            return;
        }
        this.firePropertyChange(propertyName, (Object)oldValue, (Object)newValue);
    }

    public void firePropertyChange(String propertyName, long oldValue, long newValue) {
        if (this.changeSupport == null || oldValue == newValue) {
            return;
        }
        this.firePropertyChange(propertyName, (Object)oldValue, (Object)newValue);
    }

    public void firePropertyChange(String propertyName, float oldValue, float newValue) {
        if (this.changeSupport == null || oldValue == newValue) {
            return;
        }
        this.firePropertyChange(propertyName, Float.valueOf(oldValue), Float.valueOf(newValue));
    }

    public void firePropertyChange(String propertyName, double oldValue, double newValue) {
        if (this.changeSupport == null || oldValue == newValue) {
            return;
        }
        this.firePropertyChange(propertyName, (Object)oldValue, (Object)newValue);
    }
}

