/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.io;

import com.mandelsoft.util.IntMatrix;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.IntBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

public class MappedIntMatrix
implements IntMatrix {
    private int rx;
    private int ry;
    private IntBuffer buffer;

    public MappedIntMatrix(String path, int rx, int ry) throws IOException {
        this(new File(path), rx, ry);
    }

    public MappedIntMatrix(File file, int rx, int ry) throws IOException {
        int size = rx * ry * 4;
        boolean exists = file.exists();
        if (exists && file.length() != 0L && file.length() != (long)size) {
            throw new IOException(String.format("non-matching file size, expected %d, but found %d", size, file.length()));
        }
        RandomAccessFile rfile = new RandomAccessFile(file, "rw");
        FileChannel channel = rfile.getChannel();
        MappedByteBuffer buffer = channel.map(FileChannel.MapMode.READ_WRITE, 0L, size * 4);
        this.buffer = buffer.asIntBuffer();
        this.rx = rx;
        this.ry = ry;
        rfile.close();
    }

    public MappedIntMatrix(String path, IntMatrix m) throws IOException {
        this(path, m.getRX(), m.getRY());
        IntMatrix.copy(m, this);
    }

    @Override
    public int getData(int x, int y) {
        return this.buffer.get(x + y * this.rx);
    }

    @Override
    public void setData(int x, int y, int val) {
        this.buffer.put(x + y * this.rx, val);
    }

    @Override
    public int getRX() {
        return this.rx;
    }

    @Override
    public int getRY() {
        return this.ry;
    }
}

