/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand;

import com.mandelsoft.io.AbstractFile;
import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.util.FileMandelListListMandelListFolderTree;
import com.mandelsoft.mand.util.LeafNestedMandelListFolder;
import com.mandelsoft.mand.util.MandelListFolder;
import com.mandelsoft.mand.util.MandelListFolderTree;
import com.mandelsoft.mand.util.NestedMandelListFolder;
import com.mandelsoft.util.Utils;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class LinkTree
extends FileMandelListListMandelListFolderTree {
    private static MandelListFolderTree.IO.Modifier modifier = new LinkModifier();

    public LinkTree(AbstractFile f) {
        super("links", f);
    }

    @Override
    public void save() throws IOException {
        if (!this.getFile().isFile()) {
            throw new UnsupportedOperationException("save on URL");
        }
        this.write(new FileOutputStream(this.getFile().getFile()), modifier, this.getFile().getPath());
    }

    @Override
    protected NestedMandelListFolder createNestedFolder(String name) {
        return new Links(name);
    }

    private class Links
    extends LeafNestedMandelListFolder {
        private QualifiedMandelName qname;

        public Links(String name) {
            super(LinkTree.this, name);
            try {
                this.qname = QualifiedMandelName.create(name);
            }
            catch (IllegalArgumentException ia) {
                System.err.println("irgoring illegal mandel name " + name + " for link folder");
            }
        }

        @Override
        public QualifiedMandelName getThumbnailName() {
            return this.qname;
        }

        @Override
        public void setThumbnailName(QualifiedMandelName thumb) {
            if (!Utils.equals(this.qname, thumb)) {
                System.err.println("thumbnail cannot be set for link folder");
            }
        }
    }

    static class LinkModifier
    extends MandelListFolderTree.IO.ModifierAdapter {
        LinkModifier() {
        }

        @Override
        public QualifiedMandelName getThumbnailName(MandelListFolder f) {
            return null;
        }

        @Override
        public void writeHeader(PrintWriter pw) {
            pw.println("#");
            pw.println("# list of inter area links");
            pw.println("#");
        }
    }
}

