/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand;

import com.mandelsoft.mand.MandelData;
import com.mandelsoft.mand.MandelRaster;
import com.mandelsoft.mand.MandelSpec;
import com.mandelsoft.util.Utils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class MandelInfo
extends MandelSpec
implements MandelData.Part {
    private static final int VERSION = 5;
    public static final String ATTR_TITLE = "title";
    public static final String ATTR_RANGE = "merge-range";
    public static final String ATTR_REFREDO = "reference-redo";
    public static final String ATTR_REFCOORD = "reference-coordinates";
    public static final String ATTR_STDREFCOORD = "standard-reference-coordinates";
    public static final String ATTR_REFPIXEL = "reference-pixel";
    public static final String ATTR_REFDEPTH = "reference-depth";
    public static final String ATTR_REDOLASTDEPTH = "redo-last-depth";
    public static final String ATTR_REDONUMBER = "redo-number";
    public static final String ATTR_REFCNT = "reference-count";
    public static final String ATTR_REFCORRUPTED = "reference-corrupted";
    public static final String ATTR_ITERATONMETHOD = "pixel-iteration-method";
    private int version;
    private boolean hidden;
    private int minit;
    private int maxit;
    private long numit;
    private int time;
    private int efftime;
    private long creattime;
    private long calctime;
    private long imgtime;
    private int usedlimit;
    private long mccnt;
    private long mcnt;
    private String name;
    private String location;
    private String creator;
    private String site;
    private Set<String> keywords;
    private Map<String, String> attributes;
    private boolean mcnt_set = false;

    public MandelInfo() {
        this.setup();
    }

    public MandelInfo(double xm, double ym, double dx, double dy, int rx, int ry, int limitit, boolean hidden) {
        this(BigDecimal.valueOf(xm), BigDecimal.valueOf(ym), BigDecimal.valueOf(dx), BigDecimal.valueOf(dy), rx, ry, limitit, hidden);
    }

    public MandelInfo(BigDecimal xm, BigDecimal ym, BigDecimal dx, BigDecimal dy, int rx, int ry, int limitit, boolean hidden) {
        super(xm, ym, dx, dy, rx, ry, limitit);
        this.setup();
        this.hidden = hidden;
    }

    public MandelInfo(MandelInfo mi) {
        this(mi, mi);
    }

    public MandelInfo(MandelSpec spec, MandelInfo mi) {
        this(spec.getXM(), spec.getYM(), spec.getDX(), spec.getDY(), spec.getRX(), spec.getRY(), spec.getLimitIt(), mi == null ? false : mi.hidden);
        if (mi != null) {
            this.setName(mi.getName());
            this.setLocation(mi.getLocation());
            this.setCreator(mi.getCreator());
            this.setSite(mi.getSite());
            this.setKeywords(mi.getKeywords());
            this.setProperties(mi.getProperties());
            this.setCreationTime(mi.getCreationTime());
        }
    }

    private void setup() {
        this.version = 5;
        this.name = "";
        this.location = "";
        this.creator = null;
        this.site = null;
    }

    public MandelInfo copyFrom(MandelInfo o) {
        this.setInfo(o);
        return this;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public int getMinIt() {
        return this.minit;
    }

    public int getMaxIt() {
        return this.maxit;
    }

    public long getNumIt() {
        return this.numit;
    }

    public int getTime() {
        return this.time;
    }

    public int getEffectiveTime() {
        return this.efftime;
    }

    public long getCreationTime() {
        return this.creattime;
    }

    public long getRasterCreationTime() {
        return this.calctime;
    }

    public long getImageCreationTime() {
        return this.imgtime;
    }

    public String getLocation() {
        return this.location;
    }

    public String getName() {
        return this.name;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getSite() {
        return this.site;
    }

    public Set<String> getKeywords() {
        if (this.keywords == null) {
            this.keywords = new HashSet<String>();
        }
        return new HashSet<String>(this.keywords);
    }

    public long getMCCnt() {
        return this.mccnt;
    }

    public long getMCnt() {
        return this.mcnt;
    }

    public int getUsedLimit() {
        return this.usedlimit;
    }

    public int getTargetSize() {
        return this.getMaxIt() - this.getMinIt() + 2;
    }

    public void setInfo(MandelInfo i) {
        this.setInfo(i, true);
    }

    public void setInfo(MandelInfo i, boolean full) {
        this.setSpec(i);
        this.setHidden(i.isHidden());
        if (full) {
            this.setMinIt(i.getMinIt());
            this.setMaxIt(i.getMaxIt());
            this.setNumIt(i.getNumIt());
            this.setTime(i.getTime());
            this.setEffectiveTime(i.getEffectiveTime());
            this.setMCCnt(i.getMCCnt());
            this.setMCnt(i.getMCnt());
            this.setUsedLimit(i.getUsedLimit());
            this.setCreationTime(i.getCreationTime());
            this.setRasterCreationTime(i.getRasterCreationTime());
            this.setImageCreationTime(i.getImageCreationTime());
        }
        this.setName(i.getName());
        this.setLocation(i.getLocation());
        this.setCreator(i.getCreator());
        this.setSite(i.getSite());
        this.setKeywords(i.getKeywords());
        this.setProperties(i.getProperties());
        this.version = i.version;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public void setMinIt(int minit) {
        this.minit = minit;
    }

    public void setMaxIt(int maxit) {
        this.maxit = maxit;
    }

    public void setNumIt(long numit) {
        this.numit = numit;
    }

    public void setTime(int time) {
        this.time = time;
    }

    public void setEffectiveTime(int efftime) {
        this.efftime = efftime;
    }

    public void setMCCnt(long mccnt) {
        this.mccnt = mccnt;
    }

    public void setMCnt(long mcnt) {
        this.mcnt = mcnt;
    }

    public void setUsedLimit(int usedlimit) {
        this.usedlimit = usedlimit;
    }

    public void setCreationTime(long t) {
        this.creattime = t;
    }

    public void setRasterCreationTime(long t) {
        this.calctime = t;
    }

    public void setImageCreationTime(long t) {
        this.imgtime = t;
    }

    public void setLocation(String location) {
        if (location == null) {
            location = "";
        }
        this.location = location;
    }

    public void setName(String name) {
        if (name == null) {
            name = "";
        }
        this.name = name;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setSite(String site) {
        this.site = site;
    }

    public void setKeywords(Set<String> k) {
        if (this.keywords == null) {
            this.keywords = new HashSet<String>(k);
        } else {
            this.keywords.clear();
            this.keywords.addAll(k);
        }
    }

    public void setProperty(String key, String value) {
        if (value == null) {
            this.removeProperty(key);
        } else {
            if (this.attributes == null) {
                this.attributes = new HashMap<String, String>();
            }
            this.attributes.put(key, value);
            this.version = 5;
        }
    }

    public void removeProperty(String key) {
        if (this.attributes != null) {
            this.attributes.remove(key);
            if (this.attributes.size() == 0) {
                this.attributes = null;
            }
        }
    }

    public String getProperty(String key) {
        if (this.attributes != null) {
            return this.attributes.get(key);
        }
        return null;
    }

    public boolean hasProperty(String key) {
        if (this.attributes != null) {
            return this.attributes.containsKey(key);
        }
        return false;
    }

    public Map<String, String> getProperties() {
        if (this.attributes == null) {
            return null;
        }
        HashMap<String, String> attrs = new HashMap<String, String>();
        for (Map.Entry<String, String> e : this.attributes.entrySet()) {
            attrs.put(e.getKey(), e.getValue());
        }
        return attrs;
    }

    public void setProperties(Map<String, String> props) {
        if (props == null || props.size() == 0) {
            this.attributes = null;
            return;
        }
        HashMap<String, String> attrs = new HashMap<String, String>();
        for (Map.Entry<String, String> e : props.entrySet()) {
            attrs.put(e.getKey(), e.getValue());
        }
        this.version = 5;
        this.attributes = attrs;
    }

    public void clearProperties() {
        this.attributes = null;
    }

    public boolean hasMandelCount() {
        if (this.version >= 2) {
            return true;
        }
        return this.mcnt_set;
    }

    public boolean isSameRefSpec(MandelInfo o) {
        String ref1 = this.getProperty(ATTR_REFCOORD);
        String ref2 = o.getProperty(ATTR_REFCOORD);
        if (ref1 == null || ref2 == null) {
            return ref1 == ref2;
        }
        return ref1.equals(ref2);
    }

    public void updateData(MandelData data) {
        if (this.version == 1 && this.mcnt == 0L && data.getRaster() != null) {
            MandelRaster raster = data.getRaster();
            int rx = raster.getRX();
            int ry = raster.getRY();
            for (int x = 0; x < rx; ++x) {
                for (int y = 0; y < ry; ++y) {
                    if (raster.getData(x, y) != 0) continue;
                    ++this.mcnt;
                }
            }
            this.mcnt_set = true;
        }
    }

    @Override
    public boolean needsVersionUpdate() {
        if (this.attributes == null) {
            return this.version < 4;
        }
        return this.version != 5;
    }

    public void write(DataOutputStream dos) throws IOException {
        this.write(dos, 5);
    }

    public void write(DataOutputStream dos, boolean verbose) throws IOException {
        this.write(dos, 5, verbose);
    }

    public void write(DataOutputStream dos, int v) throws IOException {
        this.write(dos, v, true);
    }

    public void write(DataOutputStream dos, int v, boolean verbose) throws IOException {
        if (v == 5 && this.attributes == null) {
            v = 4;
        }
        if (verbose) {
            System.out.println("  writing info (" + v + ") ...");
        }
        switch (v) {
            case 1: {
                dos.writeInt(v);
                this.writeV1(dos);
                break;
            }
            case 2: {
                dos.writeInt(v);
                this.writeV2(dos);
                break;
            }
            case 3: {
                dos.writeInt(v);
                this.writeV3(dos);
                break;
            }
            case 4: {
                dos.writeInt(v);
                this.writeV4(dos);
                break;
            }
            case 5: {
                dos.writeInt(v);
                this.writeV5(dos);
                break;
            }
            default: {
                throw new IOException("unknown mandel info version " + v);
            }
        }
    }

    private void writeV1(DataOutputStream dos) throws IOException {
        dos.writeDouble(this.getXM().doubleValue());
        dos.writeDouble(this.getYM().doubleValue());
        dos.writeDouble(this.getDX().doubleValue());
        dos.writeDouble(this.getDY().doubleValue());
        dos.writeInt(this.getRX());
        dos.writeInt(this.getRY());
        dos.writeInt(this.getLimitIt());
        dos.writeInt(this.minit);
        dos.writeInt(this.maxit);
        dos.writeLong(this.numit);
        dos.writeInt(this.time);
        dos.writeUTF(this.name);
        dos.writeUTF(this.location);
    }

    private void writeV2(DataOutputStream dos) throws IOException {
        dos.writeUTF(this.getXM().toString());
        dos.writeUTF(this.getYM().toString());
        dos.writeUTF(this.getDX().toString());
        dos.writeUTF(this.getDY().toString());
        dos.writeInt(this.getRX());
        dos.writeInt(this.getRY());
        dos.writeInt(this.getLimitIt());
        dos.writeBoolean(this.hidden);
        dos.writeInt(this.minit);
        dos.writeInt(this.maxit);
        dos.writeLong(this.numit);
        dos.writeInt(this.time);
        dos.writeInt(this.usedlimit);
        dos.writeLong(this.mcnt);
        dos.writeLong(this.mccnt);
        dos.writeUTF(this.name);
        dos.writeUTF(this.location);
    }

    private void writeV3(DataOutputStream dos) throws IOException {
        this.writeV2(dos);
        dos.writeUTF(this.mapWrite(this.creator));
        dos.writeUTF(this.mapWrite(this.site));
    }

    private void writeV4(DataOutputStream dos) throws IOException {
        this.writeV3(dos);
        dos.writeInt(this.efftime);
        dos.writeLong(this.creattime);
        dos.writeLong(this.calctime);
        dos.writeLong(this.imgtime);
        StringBuffer sb = new StringBuffer();
        if (this.keywords != null) {
            String sep = "";
            for (String s : this.keywords) {
                sb.append(sep);
                sb.append(s);
                sep = ",";
            }
        }
        dos.writeUTF(sb.toString());
    }

    private void writeV5(DataOutputStream dos) throws IOException {
        this.writeV4(dos);
        if (this.attributes == null || this.attributes.size() == 0) {
            dos.writeInt(0);
        } else {
            dos.writeInt(this.attributes.size());
            for (String key : this.attributes.keySet()) {
                String value = this.attributes.get(key);
                dos.writeUTF(key);
                dos.writeUTF(value);
            }
        }
    }

    public void read(DataInputStream dis) throws IOException {
        this.read(dis, true);
    }

    public void read(DataInputStream dis, boolean verbose) throws IOException {
        if (verbose) {
            System.out.println("  reading info ...");
        }
        this.version = dis.readInt();
        switch (this.version) {
            case 1: {
                this.readV1(dis);
                break;
            }
            case 2: {
                this.readV2(dis);
                break;
            }
            case 3: {
                this.readV3(dis);
                break;
            }
            case 4: {
                this.readV4(dis);
                break;
            }
            case 5: {
                this.readV5(dis);
                break;
            }
            default: {
                throw new IOException("unknown mandel info version " + this.version);
            }
        }
    }

    private void readV1(DataInputStream dis) throws IOException {
        this.setXM(BigDecimal.valueOf(dis.readDouble()));
        this.setYM(BigDecimal.valueOf(dis.readDouble()));
        this.setDX(BigDecimal.valueOf(dis.readDouble()));
        this.setDY(BigDecimal.valueOf(dis.readDouble()));
        this.setRX(dis.readInt());
        this.setRY(dis.readInt());
        this.setLimitIt(dis.readInt());
        this.minit = dis.readInt();
        this.maxit = dis.readInt();
        this.numit = dis.readLong();
        this.time = dis.readInt();
        this.name = dis.readUTF();
        this.location = dis.readUTF();
    }

    private void readV2(DataInputStream dis) throws IOException {
        this.setXM(new BigDecimal(dis.readUTF()));
        this.setYM(new BigDecimal(dis.readUTF()));
        this.setDX(new BigDecimal(dis.readUTF()));
        this.setDY(new BigDecimal(dis.readUTF()));
        this.setRX(dis.readInt());
        this.setRY(dis.readInt());
        this.setLimitIt(dis.readInt());
        this.hidden = dis.readBoolean();
        this.minit = dis.readInt();
        this.maxit = dis.readInt();
        this.numit = dis.readLong();
        this.time = dis.readInt();
        this.usedlimit = dis.readInt();
        this.mcnt = dis.readLong();
        this.mccnt = dis.readLong();
        this.name = dis.readUTF();
        this.location = dis.readUTF();
    }

    private void readV3(DataInputStream dis) throws IOException {
        this.readV2(dis);
        this.creator = this.mapRead(dis.readUTF());
        this.site = this.mapRead(dis.readUTF());
        this.efftime = this.time;
    }

    private void readV4(DataInputStream dis) throws IOException {
        this.readV3(dis);
        this.efftime = dis.readInt();
        this.creattime = dis.readLong();
        this.calctime = dis.readLong();
        this.imgtime = dis.readLong();
        if (this.keywords == null) {
            this.keywords = new HashSet<String>();
        } else {
            this.keywords.clear();
        }
        StringTokenizer t = new StringTokenizer(dis.readUTF(), ",");
        while (t.hasMoreTokens()) {
            this.keywords.add(t.nextToken());
        }
    }

    private void readV5(DataInputStream dis) throws IOException {
        this.attributes = null;
        this.readV4(dis);
        int n = dis.readInt();
        for (int i = 0; i < n; ++i) {
            String key = dis.readUTF();
            String value = dis.readUTF();
            this.setProperty(key, value);
        }
    }

    private String mapRead(String s) {
        return Utils.isEmpty(s) ? null : s;
    }

    private String mapWrite(String s) {
        return s == null ? "" : s;
    }

    private boolean _false(String reason) {
        System.out.println("mismatch: " + reason);
        return false;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return this._false("class");
        }
        MandelInfo other = (MandelInfo)obj;
        if (!super.equals(obj)) {
            return this._false("spec");
        }
        if (this.version != other.version) {
            return this._false("version");
        }
        if (this.minit != other.minit) {
            return this._false("minit");
        }
        if (this.maxit != other.maxit) {
            return this._false("maxit");
        }
        if (this.numit != other.numit) {
            return this._false("numit");
        }
        if (this.time != other.time) {
            return this._false("time");
        }
        if (this.efftime != other.efftime) {
            return this._false("efftime");
        }
        if (this.creattime != other.creattime) {
            return this._false("creattime");
        }
        if (this.calctime != other.calctime) {
            return this._false("calctime");
        }
        if (this.imgtime != other.imgtime) {
            return this._false("imgtime");
        }
        if (this.usedlimit != other.usedlimit) {
            return this._false("usedlimit");
        }
        if (this.mccnt != other.mccnt) {
            return this._false("mccnt");
        }
        if (this.mcnt != other.mcnt) {
            return this._false("mcnt");
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return this._false("name");
        }
        if (this.location == null ? other.location != null : !this.location.equals(other.location)) {
            return this._false("location");
        }
        if (this.creator == null ? other.creator != null : !this.creator.equals(other.creator)) {
            return this._false("creator");
        }
        if (this.site == null ? other.site != null : !this.site.equals(other.site)) {
            return this._false("site");
        }
        if (!(this.keywords == other.keywords || this.keywords != null && this.keywords.equals(other.keywords))) {
            return this._false("keywords");
        }
        if (!(this.attributes == other.attributes || this.attributes != null && this.attributes.equals(other.attributes))) {
            return this._false("attributes");
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 89 * hash + this.version;
        hash = 89 * hash + this.minit;
        hash = 89 * hash + this.maxit;
        hash = 89 * hash + (int)(this.numit ^ this.numit >>> 32);
        hash = 89 * hash + this.time;
        hash = 89 * hash + this.efftime;
        hash = 89 * hash + (int)(this.creattime ^ this.creattime >>> 32);
        hash = 89 * hash + (int)(this.calctime ^ this.calctime >>> 32);
        hash = 89 * hash + (int)(this.imgtime ^ this.imgtime >>> 32);
        hash = 89 * hash + this.usedlimit;
        hash = 89 * hash + (int)(this.mccnt ^ this.mccnt >>> 32);
        hash = 89 * hash + (int)(this.mcnt ^ this.mcnt >>> 32);
        hash = 89 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 89 * hash + (this.location != null ? this.location.hashCode() : 0);
        hash = 89 * hash + (this.creator != null ? this.creator.hashCode() : 0);
        hash = 89 * hash + (this.site != null ? this.site.hashCode() : 0);
        hash = 89 * hash + (this.keywords != null ? this.keywords.hashCode() : 0);
        hash = 89 * hash + (this.attributes != null ? this.attributes.hashCode() : 0);
        return hash;
    }
}

