/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand;

import com.mandelsoft.mand.MandelData;
import com.mandelsoft.util.IntMatrix;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class MandelRaster
implements MandelData.Part,
IntMatrix {
    private IntMatrix raster;

    public MandelRaster() {
    }

    public MandelRaster(IntMatrix m) {
        this.raster = m;
    }

    public MandelRaster(int rx, int ry) {
        this.raster = new IntMatrix.Memory(rx, ry);
    }

    public IntMatrix getRaster() {
        return this.raster;
    }

    @Override
    public int getRX() {
        return this.raster.getRX();
    }

    @Override
    public int getRY() {
        return this.raster.getRY();
    }

    @Override
    public int getData(int x, int y) {
        return this.raster.getData(x, y);
    }

    @Override
    public void setData(int x, int y, int val) {
        this.raster.setData(x, y, val);
    }

    @Override
    public boolean needsVersionUpdate() {
        return false;
    }

    public void write(DataOutputStream dos) throws IOException {
        this.write(dos, true);
    }

    public void write(DataOutputStream dos, boolean verbose) throws IOException {
        int x = 0;
        int dx = 1;
        int c = 0;
        int v = -1;
        int rx = this.getRX();
        int ry = this.getRY();
        if (verbose) {
            System.out.println("  writing raster (" + rx + "," + ry + ")...");
        }
        dos.writeInt(rx);
        dos.writeInt(ry);
        for (int y = 0; y < ry; ++y) {
            int ix = 0;
            while (ix < rx) {
                int it = this.raster.getData(x, y);
                if (it == v && c < 255) {
                    ++c;
                } else {
                    this.write(dos, c, v);
                    c = 1;
                    v = it;
                }
                ++ix;
                x += dx;
            }
            dx = -dx;
            x += dx;
        }
        this.write(dos, c, v);
    }

    private void write(DataOutputStream dos, int c, int v) throws IOException {
        if (c > 0) {
            dos.writeByte(c);
            dos.writeInt(v);
        }
    }

    void read(DataInputStream dis) throws IOException {
        this.read(dis, true);
    }

    void read(DataInputStream dis, boolean verbose) throws IOException {
        int x = 0;
        int dx = 1;
        int c = 0;
        int v = -1;
        int rx = dis.readInt();
        int ry = dis.readInt();
        if (verbose) {
            System.out.println("  reading raster (" + rx + "," + ry + ")...");
        }
        this.raster = new IntMatrix.Memory(rx, ry);
        for (int y = 0; y < ry; ++y) {
            int ix = 0;
            while (ix < rx) {
                while (c <= 0) {
                    c = dis.readUnsignedByte();
                    v = dis.readInt();
                }
                this.raster.setData(x, y, v);
                --c;
                ++ix;
                x += dx;
            }
            dx = -dx;
            x += dx;
        }
    }
}

