/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.applet;

import com.mandelsoft.mand.IllegalConfigurationException;
import com.mandelsoft.mand.MandelData;
import com.mandelsoft.mand.MandelName;
import com.mandelsoft.mand.QualifiedMandelName;
import com.mandelsoft.mand.cm.ColormapModel;
import com.mandelsoft.mand.image.MandelImage;
import com.mandelsoft.mand.tool.DefaultMandelListTableModel;
import com.mandelsoft.mand.tool.History;
import com.mandelsoft.mand.tool.MandelImagePanel;
import com.mandelsoft.mand.tool.MandelListGaleryPanel;
import com.mandelsoft.mand.tool.MandelListProxyListModelForTable;
import com.mandelsoft.mand.tool.MandelListTableModel;
import com.mandelsoft.mand.tool.MandelWindowAccess;
import com.mandelsoft.mand.tool.ToolEnvironment;
import com.mandelsoft.mand.tool.mapper.MapperModel;
import com.mandelsoft.mand.util.CachedUpstreamColormapSourceFactory;
import com.mandelsoft.mand.util.DefaultMandelList;
import com.mandelsoft.mand.util.MandelListFolder;
import com.mandelsoft.util.Utils;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JApplet;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class GaleryStarter
extends JApplet
implements MandelWindowAccess {
    MandelListGaleryPanel panel;
    ToolEnvironment env;
    Timer timer;
    int maxx;
    int width;
    int height;
    int rows = 1;

    @Override
    public String[][] getParameterInfo() {
        String[][] info = new String[][]{{"datasource", "URL", "a directory containing the config"}, {"list", "list path", "a list to display"}, {"itemwidth", "int", "width of galary items"}, {"itemheight", "int", "height of galary items"}, {"framewidth", "int", "image browser max size"}, {"upstreamcolormap", "bool", "use upstream colormap as default"}, {"ticker", "bool", "start as ticker"}};
        return info;
    }

    @Override
    public void init() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    GaleryStarter.this.createGUI();
                }
            });
        }
        catch (Exception e) {
            System.err.println("createGUI didn't successfully complete: " + e);
            e.printStackTrace(System.err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createGUI() {
        try {
            MandelListTableModel model;
            String[] comps;
            String p_datasource = this.getParameter("datasource");
            String p_listpath = this.getParameter("list");
            String p_maxs = this.getParameter("framewidth");
            String p_width = this.getParameter("itemwidth");
            String p_height = this.getParameter("itemheight");
            String p_upstream = this.getParameter("upstreamcolormap");
            String p_ticker = this.getParameter("ticker");
            URL base = this.getDocumentBase();
            boolean ticker = false;
            boolean upstream = false;
            System.out.println("document base is     " + base);
            System.out.println("data source is       " + p_datasource);
            System.out.println("list is              " + p_listpath);
            System.out.println("max is               " + p_maxs);
            System.out.println("width is             " + p_width);
            System.out.println("height is            " + p_height);
            System.out.println("upstream colormap is " + p_upstream);
            System.out.println("ticker is            " + p_ticker);
            if (p_datasource == null) {
                p_datasource = ".";
            }
            if (p_listpath == null) {
                p_listpath = "favorites";
            }
            ticker = Utils.parseBoolean(p_ticker, false);
            upstream = Utils.parseBoolean(p_upstream, false);
            this.maxx = 400;
            if (p_maxs != null) {
                try {
                    this.maxx = Integer.parseInt(p_maxs);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (p_width != null) {
                try {
                    this.width = Integer.parseInt(p_width);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (p_height != null) {
                try {
                    this.height = Integer.parseInt(p_height);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (this.width == 0) {
                this.width = 6 * this.height / 5;
            }
            if (this.height == 0) {
                this.height = 5 * this.width / 6;
            }
            URL dataURL = new URL(base, p_datasource);
            ToolEnvironment env = new ToolEnvironment(null, dataURL);
            MandelListFolder f = env.getMandelListFolderTreeModel().getRoot();
            for (String comp : comps = p_listpath.split("/")) {
                System.out.println("lookup " + comp);
                if (!comp.isEmpty() && (f = f.getSubFolder(comp)) == null) break;
            }
            if (f == null) {
                this.showStatus("path not found");
                System.out.println("path not found");
                DefaultMandelList l = new DefaultMandelList();
                model = new DefaultMandelListTableModel(l, env.getAllScanner());
            } else {
                model = env.getMandelListFolderTreeModel().getMandelListModel(f);
                this.showStatus("setup done");
                System.out.println("setup done");
            }
            this.setup(env, model, upstream);
            if (ticker) {
                this.timer = new Timer(10000, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        GaleryStarter.this.panel.startTicker();
                    }
                });
                this.timer.setRepeats(false);
                this.timer.start();
            }
        }
        catch (MalformedURLException ex) {
            System.out.println("url failed: " + ex);
            this.showStatus("url failed: " + ex);
        }
        catch (IllegalConfigurationException ic) {
            System.out.println("url failed: " + ic);
            this.showStatus("config failed: " + ic);
        }
        catch (IOException io) {
            System.out.println("initial image failed: " + io);
            this.showStatus("initial image failed: " + io);
        }
    }

    @Override
    public void stop() {
        if (this.panel != null) {
            this.panel.stopTicker();
        }
        if (this.timer != null) {
            this.timer.stop();
        }
    }

    public void setup(ToolEnvironment env, MandelListTableModel model, boolean upstream) throws IOException {
        this.env = env;
        MandelListProxyListModelForTable proxyModel = new MandelListProxyListModelForTable(model);
        if (this.width > 0 && this.height > 0) {
            Dimension d = new Dimension(this.width, this.height);
            this.panel = new MandelListGaleryPanel(proxyModel, this.rows, d);
        } else {
            this.panel = new MandelListGaleryPanel(proxyModel, this.rows);
        }
        this.panel.setMaxFrame(this.maxx);
        MandelImage.Factory factory = new MandelImage.Factory(env.getDefaultColormap());
        proxyModel.setFactory(factory);
        if (upstream) {
            proxyModel.setColormapSourceFactory(new CachedUpstreamColormapSourceFactory(model.getMandelScanner(), env.getDefaultColormap(), env.getColormapCache()));
        }
        this.add(this.panel);
    }

    @Override
    public ColormapModel getColormapModel() {
        return null;
    }

    @Override
    public ToolEnvironment getEnvironment() {
        return this.env;
    }

    @Override
    public Window getMandelWindow() {
        return null;
    }

    @Override
    public MandelData getMandelData() {
        return null;
    }

    @Override
    public MandelImage getMandelImage() {
        return null;
    }

    @Override
    public MandelName getMandelName() {
        return null;
    }

    @Override
    public MapperModel getMapperModel() {
        return null;
    }

    @Override
    public QualifiedMandelName getQualifiedName() {
        return null;
    }

    @Override
    public MandelImagePanel getMandelImagePane() {
        return null;
    }

    @Override
    public History getHistory() {
        return null;
    }
}

