/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.cm;

import com.mandelsoft.mand.cm.ColorComponentAccess;
import com.mandelsoft.mand.cm.Colormap;
import com.mandelsoft.mand.cm.ColormapSource;
import com.mandelsoft.mand.cm.EventSourceSupport;
import com.mandelsoft.mand.cm.InterpolationPoint;
import com.mandelsoft.mand.mapping.Mapping;
import com.mandelsoft.swing.ChangeListenerSupport;
import com.mandelsoft.util.ChangeEvent;
import java.awt.Color;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.event.ChangeListener;

public class ColormapModel
extends EventSourceSupport
implements ColormapSource {
    public static boolean debug = false;
    public static final int RESIZE_PROPORTIONAL = 0;
    public static final int RESIZE_LOCK_IPS = 1;
    public static final int RESIZE_LOCK_COLORS = 2;
    private boolean modifiable;
    private ResizeMode resizemode = ResizeMode.RESIZE_LOCK_IPS;
    private Colormap colormap;
    private InterpolationPoint ips;
    private boolean adjusting;
    private ChangeListenerSupport change = new ChangeListenerSupport();
    private com.mandelsoft.util.ChangeListener listener = new com.mandelsoft.util.ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            if (!ColormapModel.this.isAdjusting()) {
                ColormapModel.this.setupInterpolationPoints();
            }
            ColormapModel.this.change.fireChangeEvent(ColormapModel.this);
        }
    };

    public ColormapModel() {
    }

    public ColormapModel(Colormap cm) {
        if (cm != null) {
            this.setColormap(cm);
        }
    }

    @Override
    public Colormap getColormap() {
        return this.colormap;
    }

    public int getSize() {
        return this.colormap == null ? 0 : this.colormap.getSize();
    }

    public void setModifiable(boolean b) {
        boolean old = this.modifiable;
        this.modifiable = b;
        if (old != b) {
            this.change.fireChangeEvent(this);
        }
    }

    public void setResizeMode(ResizeMode resizemode) {
        if (debug) {
            System.out.println("setting resize mode " + (Object)((Object)resizemode));
        }
        this.resizemode = resizemode;
    }

    public void setAdjusting(boolean adjusting) {
        this.adjusting = adjusting;
    }

    public boolean isAdjusting() {
        return this.adjusting;
    }

    public boolean isModifiable() {
        return this.modifiable;
    }

    public ResizeMode getResizeMode() {
        return this.resizemode;
    }

    public Set<InterpolationPoint> getInterpolationPoints() {
        HashSet<InterpolationPoint> set = new HashSet<InterpolationPoint>();
        for (InterpolationPoint ip = this.ips; ip != null; ip = ip.getNext()) {
            set.add(ip);
        }
        return set;
    }

    public Iterator<InterpolationPoint> interpolationPoints() {
        return new IPIterator();
    }

    public void setColormap(Colormap map) {
        if (this._setColormap(map)) {
            if (map != null) {
                this.setupInterpolationPoints();
            }
            this.change.fireChangeEvent(this);
        }
    }

    private boolean _setColormap(Colormap map) {
        if (this.colormap == map) {
            if (debug) {
                System.out.println("colormap in colormap model unchanged");
            }
            return false;
        }
        if (map == null) {
            if (debug) {
                System.out.println("clear colormap in colormap model");
            }
        } else if (debug) {
            System.out.println("setting colormap in colormap model " + map.getSize());
        }
        if (this.colormap != null) {
            this.colormap.removeChangeListener(this.listener);
        }
        this.colormap = map;
        if (map != null) {
            this.colormap.addChangeListener(this.listener);
        }
        return true;
    }

    private void cleanupInterpolationPoints() {
        for (InterpolationPoint ip = this.ips; ip != null; ip = ip.getNext()) {
            ip.cleanup();
        }
    }

    private void setupInterpolationPoints() {
        this.cleanupInterpolationPoints();
        this.ips = new InterpolationPoint(1, this);
        this.ips.fireInterpolationPointEvent(1);
        this.ips.setFixed(true);
        InterpolationPoint ip = new InterpolationPoint(this.colormap.getSize() - 1, this);
        ip.setFixed(true);
        this.ips.add(ip);
        this.determineInterpolationPoints();
    }

    protected void determineInterpolationPoints() {
        this.handleComponents();
    }

    protected int dir(int diff, int dir) {
        if (diff == 0) {
            return dir;
        }
        return Integer.signum(diff);
    }

    protected boolean sameDir(int diff, int dir) {
        return diff == 0 || dir == 0 || Integer.signum(diff) == dir;
    }

    protected void handleComponent(ColorComponentAccess comp) {
        int index = 1;
        while (index < this.colormap.getSize() - 1) {
            int diff;
            int cur = diff = comp.getComponentValue(this.colormap.getColor(index + 1)) - comp.getComponentValue(this.colormap.getColor(index));
            int dir = this.dir(diff, 0);
            while (diff - 1 <= cur && cur <= diff + 1 && this.sameDir(cur, dir) && ++index < this.colormap.getSize() - 1) {
                dir = this.dir(cur, dir);
                if (debug) {
                    System.out.println("dir=" + dir + " diff=" + diff);
                }
                cur = comp.getComponentValue(this.colormap.getColor(index + 1)) - comp.getComponentValue(this.colormap.getColor(index));
            }
            this.createInterpolationPoint(index);
        }
    }

    protected void handleComponents() {
        CheckState state = new CheckState();
        int index = 1;
        while (index < this.colormap.getSize()) {
            int found = index;
            for (int i = index; i < this.colormap.getSize(); ++i) {
                if (!this.checkInterpolation(index, i, state)) continue;
                found = i;
            }
            this.createInterpolationPoint(found);
            if (found == index) {
                index = found + 1;
                continue;
            }
            index = found;
        }
    }

    private boolean checkInterpolation(int idx1, int idx2, CheckState state) {
        return this._checkInterpolation(idx1, idx2, state);
    }

    private boolean _checkInterpolation(int idx1, int idx2, CheckState state) {
        int rx = idx2 - idx1;
        int dx = Integer.signum(rx);
        state.setup(idx1, idx2);
        for (int i = 0; i != rx; i += dx) {
            int cur = i + idx1;
            if (!state.check(cur, i)) continue;
            return false;
        }
        return true;
    }

    public Color getColor(int i) {
        return this.colormap.getColor(i);
    }

    public InterpolationPoint createInterpolationPoint(int index) {
        InterpolationPoint ip = this.ips;
        while (ip.getIndex() < index) {
            ip = ip.getNext();
        }
        if (ip == null) {
            throw new IllegalArgumentException("index beyond colormap");
        }
        if (ip.getIndex() == index) {
            return ip;
        }
        InterpolationPoint n = new InterpolationPoint(index, this);
        ip.getPrev().add(n);
        return ip;
    }

    public InterpolationPoint getInterpolationPoint(int index) {
        InterpolationPoint ip;
        for (ip = this.ips; ip != null && ip.getIndex() < index; ip = ip.getNext()) {
        }
        if (ip == null || ip.getIndex() != index) {
            return null;
        }
        return ip;
    }

    public void resize(int size) {
        this.resizeI(size, new FactorResize(this.colormap.getSize(), size));
    }

    public void resize(int size, Mapping src, Mapping dst) {
        this.resize(this.resizemode, size, src, dst);
    }

    public void resize(ResizeMode mode, int size, Mapping src, Mapping dst) {
        if (debug) {
            System.out.println("resizemode is " + (Object)((Object)mode));
        }
        switch (mode.ordinal()) {
            case 0: {
                this.resizeI(size);
                break;
            }
            case 1: {
                this.resizeI(size, src, dst);
                break;
            }
            case 2: {
                this.resizeC(size, src, dst);
            }
        }
    }

    public void resizeI(int size) {
        this.resizeI(size, new FactorResize(this.colormap.getSize(), size));
    }

    public void resizeI(int size, Mapping src, Mapping dst) {
        this.resizeI(size, new MappingBasedResize(src, dst));
    }

    private void resizeI(int size, ResizeHandler h) {
        InterpolationPoint ip;
        if (this.colormap == null || size == this.getSize()) {
            return;
        }
        if (debug) {
            System.out.println("resize from " + this.getSize() + " to " + size);
        }
        Colormap old = this.colormap;
        double factor = ((double)size - 2.0) / (double)(old.getSize() - 2);
        if (debug) {
            System.out.println("resize factor " + factor);
        }
        Colormap cm = new Colormap(size);
        cm.startModification();
        cm.setColor(0, old.getColor(0));
        this.setAdjusting(true);
        this._setColormap(cm);
        int last = 0;
        for (ip = this.ips; ip != null; ip = ip.getNext()) {
            int n = ip.getPrev() == null ? 1 : h.getRelocatedIndex(ip.getIndex());
            if (ip.getNext() == null && n != size - 1) {
                if (debug) {
                    System.out.println("^correcting last index " + n + " to " + (size - 1));
                }
                n = size - 1;
            }
            if (n == 0) {
                n = (int)Math.round((double)(ip.getIndex() - 1) * factor + 1.0);
                if (n <= last) {
                    n = last + 1;
                }
                if (debug) {
                    System.out.println("  no mapping found for " + ip.getIndex());
                }
            }
            if (debug) {
                System.out.println("  moving " + ip.getIndex() + " to " + n);
            }
            last = n;
            ip._prepareSetIndex(last);
        }
        for (ip = this.ips; ip != null; ip = ip.getNext()) {
            ip._finishSetIndex(true);
        }
        this.colormap.endModification();
        this.change.fireChangeEvent(this);
        this.setAdjusting(false);
    }

    public void resizeC(int size, Mapping src, Mapping dst) {
        this.resizeC(size, new MappingBasedResize(src, dst));
    }

    private void resizeC(int size, ResizeHandler h) {
        if (this.colormap == null || size == this.getSize()) {
            return;
        }
        if (debug) {
            System.out.println("resize new from " + this.getSize() + " to " + size);
        }
        Colormap old = this.colormap;
        double factor = ((double)size - 2.0) / (double)(old.getSize() - 2);
        if (debug) {
            System.out.println("resize factor " + factor);
        }
        this.cleanupInterpolationPoints();
        Colormap cm = new Colormap(size);
        cm.startModification();
        cm.setColor(0, old.getColor(0));
        this.setAdjusting(true);
        this._setColormap(cm);
        cm.setColor(1, old.getColor(1));
        this.ips = new InterpolationPoint(1, this);
        this.ips.setFixed(true);
        cm.setColor(cm.getSize() - 1, old.getColor(old.getSize() - 1));
        InterpolationPoint ip = new InterpolationPoint(cm.getSize() - 1, this);
        ip.setFixed(true);
        this.ips.add(ip);
        int last = 1;
        for (int c = 2; c < old.getSize() - 1; ++c) {
            int n = h.getRelocatedIndex(c);
            if (n == 0) {
                n = (int)Math.round((double)(c - 1) * factor + 1.0);
                if (n <= last) {
                    n = last + 1;
                }
                if (debug) {
                    System.out.println("  no mapping found for " + c);
                }
            }
            last = n;
            if (debug) {
                System.out.println("  moving index " + c + " to " + n);
            }
            cm.setColor(n, old.getColor(c));
            this.createInterpolationPoint(n);
        }
        for (ip = this.ips; ip != null; ip = ip.getNext()) {
            ip._finishSetIndex(true);
        }
        this.setupInterpolationPoints();
        cm.endModification();
    }

    public void removeChangeListener(ChangeListener h) {
        this.change.removeChangeListener(h);
    }

    public void addChangeListener(ChangeListener h) {
        this.change.addChangeListener(h);
    }

    public static enum ResizeMode {
        RESIZE_PROPORTIONAL("proportional"),
        RESIZE_LOCK_IPS("lock interpolation points"),
        RESIZE_LOCK_COLORS("lock iteration colors");

        private String name;

        private ResizeMode(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    private class IPIterator
    implements Iterator<InterpolationPoint> {
        private InterpolationPoint ip;

        private IPIterator() {
            this.ip = ColormapModel.this.ips;
        }

        @Override
        public boolean hasNext() {
            return this.ip != null;
        }

        @Override
        public InterpolationPoint next() {
            try {
                InterpolationPoint interpolationPoint = this.ip;
                return interpolationPoint;
            }
            finally {
                this.ip = this.ip.getNext();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private class CheckState {
        State red;
        State green;
        State blue;

        private CheckState() {
            this.red = new State(ColorComponentAccess.red);
            this.green = new State(ColorComponentAccess.green);
            this.blue = new State(ColorComponentAccess.blue);
        }

        void setup(int idx1, int idx2) {
            this.red.setup(idx1, idx2);
            this.green.setup(idx1, idx2);
            this.blue.setup(idx1, idx2);
        }

        boolean check(int cur, int i) {
            return this.red.check(cur, i) || this.green.check(cur, i) || this.blue.check(cur, i);
        }
    }

    public static class FactorResize
    implements ResizeHandler {
        private double factor;

        public FactorResize(int src, int dst) {
            this.factor = ((double)dst - 2.0) / (double)(src - 2);
        }

        @Override
        public int getRelocatedIndex(int index) {
            return (int)Math.round((double)(index - 1) * this.factor + 1.0);
        }
    }

    public static interface ResizeHandler {
        public int getRelocatedIndex(int var1);
    }

    public static class MappingBasedResize
    implements ResizeHandler {
        private Mapping dst;
        private Mapping src;

        public MappingBasedResize(Mapping src, Mapping dst) {
            this.dst = dst;
            this.src = src;
        }

        @Override
        public int getRelocatedIndex(int index) {
            return this.dst.getColormapIndex(this.src.getInteration(index, 0, false));
        }
    }

    private class State {
        ColorComponentAccess comp;
        int rx;
        double start;
        double end;
        double dc;

        State(ColorComponentAccess comp) {
            this.comp = comp;
        }

        void setup(int idx1, int idx2) {
            this.rx = idx2 - idx1;
            this.start = this.comp.getComponentValue(ColormapModel.this.getColor(idx1));
            this.end = this.comp.getComponentValue(ColormapModel.this.getColor(idx2));
            this.dc = this.end - this.start;
        }

        boolean check(int cur, int i) {
            int c = (int)(this.start + (double)i * this.dc / (double)this.rx);
            int f = this.comp.getComponentValue(ColormapModel.this.getColor(cur));
            return c - 1 > f || f > c + 1;
        }
    }
}

