/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.image;

import com.mandelsoft.mand.MandelData;
import com.mandelsoft.mand.MandelException;
import com.mandelsoft.mand.MandelInfo;
import com.mandelsoft.mand.MandelRaster;
import com.mandelsoft.mand.cm.Colormap;
import com.mandelsoft.mand.cm.ColormapModel;
import com.mandelsoft.mand.image.ColorMapper;
import com.mandelsoft.mand.image.ImageEventSupport;
import com.mandelsoft.mand.image.ImageListener;
import com.mandelsoft.mand.image.MandelImage;
import com.mandelsoft.mand.image.RasterColorMapper;
import com.mandelsoft.mand.mapping.Mapper;
import com.mandelsoft.mand.mapping.Mapping;
import com.mandelsoft.util.ChangeListener;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;

public class RasterImage
extends BufferedImage
implements MandelImage,
MandelImage.Updatable {
    public static boolean debug = false;
    private WritableRaster raster;
    private ImageEventSupport listeners;
    private MandelData data;
    private ColorMapper colormapper;
    private RasterColorMapper rastermapper;

    public RasterImage(MandelData data) {
        super(data.getInfo().getRX(), data.getInfo().getRY(), 1);
        if (data.getRaster() == null) {
            throw new MandelException("no raster set");
        }
        this.raster = this.getRaster();
        this.listeners = new ImageEventSupport();
        this.data = new MandelData(data);
        this.data.setModified(data.isModified());
        this.colormapper = new ColorMapper(this.getColorModel(), this.data.getColormap(), this.data.getMapping());
        this.rastermapper = new RasterColorMapper(this.colormapper, this.data.getRaster());
        this.colormapper.addChangeListener(new ColorMapper.ChangeHandler(){

            @Override
            public void handle(ColorMapper cm) {
                RasterImage.this.updateImage();
            }
        });
        this.updateImage();
    }

    @Override
    public MandelImage getMandelImage() {
        return this;
    }

    @Override
    public void removeChangeListener(ChangeListener h) {
        this.listeners.removeChangeListener(h);
    }

    @Override
    public void addChangeListener(ChangeListener h) {
        this.listeners.addChangeListener(h);
    }

    @Override
    public void removeImageListener(ImageListener h) {
        this.listeners.removeImageListener(h);
    }

    @Override
    public void addImageListener(ImageListener h) {
        this.listeners.addImageListener(h);
    }

    @Override
    public int getColormapIndex(int x, int y) {
        return this.rastermapper.getColormapIndex(x, y);
    }

    @Override
    public BufferedImage getImage() {
        return this;
    }

    @Override
    public MandelData getMandelData() {
        return this.data;
    }

    @Override
    public boolean isModified() {
        return this.data.isModified();
    }

    @Override
    public MandelRaster getRasterData() {
        return this.data.getRaster();
    }

    @Override
    public MandelInfo getInfo() {
        return this.data.getInfo();
    }

    @Override
    public Colormap getColormap() {
        return this.data.getColormap();
    }

    @Override
    public Mapping getMapping() {
        return this.data.getMapping();
    }

    @Override
    public Mapper getMapper() {
        return this.data.getMapper();
    }

    @Override
    public void setColormap(ColormapModel.ResizeMode mode, Colormap map) {
        if (map != null && this.data.getColormap() != null && this.data.getColormap().getSize() != map.getSize()) {
            this.data.setColormap(mode, map);
            this.colormapper.setData(this.data.getColormap(), this.data.getMapping());
        } else {
            this.data.setColormap(mode, map);
            this.colormapper.setColormap(map);
        }
    }

    @Override
    public Colormap resizeColormap(ColormapModel.ResizeMode mode, int size) {
        Colormap cm = this.data.resizeColormap(mode, size);
        if (cm != null) {
            this.colormapper.setData(this.data.getColormap(), this.data.getMapping());
        }
        return cm;
    }

    public void setMapping(Mapping m) {
        this.data.setMapping(m);
        this.colormapper.setMapping(m);
    }

    @Override
    public void setMapper(ColormapModel.ResizeMode mode, Mapper m) {
        if (debug) {
            System.out.println("Setting mapper " + m);
        }
        this.data.setMapper(mode, m);
        this.colormapper.setData(this.data.getColormap(), this.data.getMapping());
    }

    @Override
    public void updateRaster() {
        this.setMapper(ColormapModel.ResizeMode.RESIZE_LOCK_IPS, this.getMapper());
    }

    private void updateImage() {
        if (this.data.getColormap() != null && this.data.getMapping() != null) {
            if (debug) {
                System.out.println("updating image ...");
            }
            this.listeners.firePrepareEvent();
            for (int y = 0; y < this.getHeight(); ++y) {
                for (int x = 0; x < this.getWidth(); ++x) {
                    this.raster.setDataElements(x, y, this.rastermapper.getPixelDataElements(x, y));
                }
            }
            this.listeners.fireChangeEvent();
        }
    }
}

