/*
 * Decompiled with CFR 0.152.
 */
package com.mandelsoft.mand.mapping;

import com.mandelsoft.mand.MandelRaster;
import com.mandelsoft.mand.mapping.Mapper;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class MapperSupport
implements Mapper {
    private int version = this.getDefaultVersion();

    @Override
    public boolean needsVersionUpdate() {
        return this.version != this.getDefaultVersion();
    }

    @Override
    public void write(DataOutputStream dos) throws IOException {
        this.write(dos, this.getDefaultVersion());
    }

    public void write(DataOutputStream dos, int v) throws IOException {
        if (!this.validVersion(v)) {
            throw new IOException("unknown mapper version " + v);
        }
        dos.writeInt(v);
        this._write(dos, v);
    }

    protected abstract int getDefaultVersion();

    protected abstract boolean validVersion(int var1);

    protected void _write(DataOutputStream dos, int v) throws IOException {
    }

    @Override
    public void read(DataInputStream dis) throws IOException {
        this.version = dis.readInt();
        if (!this.validVersion(this.version)) {
            throw new IOException("unknown mapper version " + this.version + " for " + this.getClass().getName());
        }
        this._read(dis, this.version);
    }

    protected void _read(DataInputStream dis, int v) throws IOException {
    }

    protected static class RasterInfo {
        protected MandelRaster raster;
        protected int minIt;
        protected int maxIt;

        public RasterInfo(MandelRaster r) {
            this.raster = r;
            this.analyseRaster(r);
        }

        public int getMinIt() {
            return this.minIt;
        }

        public int getMaxIt() {
            return this.maxIt;
        }

        public int getSize() {
            return this.maxIt - this.minIt + 1;
        }

        public MandelRaster getRaster() {
            return this.raster;
        }

        protected void analyseRaster(MandelRaster r) {
            this.minIt = 0;
            this.maxIt = 0;
            for (int y = 0; y < r.getRY(); ++y) {
                for (int x = 0; x < r.getRX(); ++x) {
                    int it = r.getData(x, y);
                    if (it > this.maxIt) {
                        this.maxIt = it;
                        if (this.minIt == 0) {
                            this.minIt = this.maxIt;
                        }
                    }
                    if (it >= this.minIt || it <= 0) continue;
                    this.minIt = it;
                }
            }
        }
    }
}

